function cdf_var_type,string
stypes = 'CDF_'+strsplit(/extr,'XXX INT1 CHAR UCHAR INT2 INT4 REAL4 FLOAT DOUBLE REAL8 EPOCH') 
vtypes = [0,1,1,1,2,3,4,4,5,5,5]
type = array_union(string,stypes)
return,(vtypes[type])[0]
end




;+
;NAME:  cdf_info
;FUNCTION:   cdf_info(id)
;PURPOSE:
;  Returns a structure with useful information about a CDF file.
;  In particular the number of file records is returned in this structure.
;INPUT:
;	id:	CDF file ID.
;CREATED BY:	Davin Larson
;LAST MODIFIED:	@(#)cdf_info.pro	1.9 02/11/01
;-

function cdf_info,id0,format=format

if size(/type,id0) eq 7 then id=cdf_open(id0) else id=id0

inq = cdf_inquire(id)
q = !quiet
cdf_control,id,get_filename=fn
nullp = ptr_new()
varinfo_format = {num:0, is_zvar:0, name:'',datatype:'',type:0, $
   depend_0:'', $
;   numattr:-1, $
   numelem:0, recvar:0b, numrec:0l, $
   ndimen:0, d:lonarr(6) , $
   dataptr:ptr_new(), attrptr:ptr_new()  }
   
nv = inq.nvars+inq.nzvars
vinfo = nv gt 0 ? replicate(varinfo_format, nv) : 0
i = 0
num_recs =0
for zvar = 0,1 do begin   ; regular variables first, then zvariables
  nvars = zvar ? inq.nzvars : inq.nvars
  for v = 0,nvars-1 do begin
    !quiet = 1
    cdf_control,id,var=v,get_var_info=info,zvar = zvar
    !quiet = q
    vi = cdf_varinq(id,v,zvar=zvar)
    vinfo[i].num = v
    vinfo[i].is_zvar = zvar
    vinfo[i].name = vi.name
    vinfo[i].datatype = vi.datatype
    vinfo[i].type = cdf_var_type(vi.datatype)
    if vi.name eq 'Epoch' then num_recs = info.maxrec+1
    if vi.datatype eq 'CDF_EPOCH' then num_recs = info.maxrec+1
    vinfo[i].depend_0= cdf_var_atts(id,vi.name,'DEPEND_0',default='')
;    attr = cdf_var_atts(id,vi.name,/names_only)
;    vinfo[i].numattr = n_elements(attr) * keyword_set(attr)
;    attr = cdf_var_atts(id,vi.name)
;    vinfo[i].numattr = n_tags(attr) 
    vinfo[i].numelem = vi.numelem
    nrecs = info.maxrec+1
    recvar = vi.recvar eq 'VARY'
    vinfo[i].numrec = nrecs
    vinfo[i].recvar = recvar
    if zvar then begin
      dimen = [vi.dim]
      ndimen = total(vi.dimvar)
    endif else begin
      dimc = vi.dimvar * inq.dim
      w = where(dimc ne 0,ndimen)
      if ndimen ne 0 then dimen = dimc[w] else dimen=0
    endelse
    if recvar then begin
       dimen = [nrecs,dimen]
       ndimen = ndimen+1
    endif       
    vinfo[i].ndimen = ndimen
    vinfo[i].d =  dimen
    i = i+1
  endfor
endfor

;attribute stuff

if 0 then begin
for a=0,inq.natts-1 do begin
  cdf_control,id,att=a,get_attr_info=ai,get_numattrs=na
  cdf_attinq,id,a,name,scope,maxrent,maxzent
  scp = strmid(scope,0,1)
  enum = 0
  if cdf_attexists(id,a,enum) then begin
     cdf_attget,id,a,enum,value,cdf_type=cdf_type
    print,a,maxrent,maxzent,name,scp,value,format='(i2,i3,i3,a20,a3," ",a60)'
  endif else begin
    print,a,maxrent,maxzent,name,scp,format='(i2,i3,i3,a20,a3)'
  endelse
endfor   
endif

res = create_struct('filename',fn,inq,'num_recs',num_recs,'nv',nv,'vars',vinfo)
if size(/type,id0) eq 7 then cdf_close,id
format='(i3,i2,a16,a12,i4,i4,i3,i6,i5,i6,i3,i3,i3,i3,i3,i3,i3)'
return,res
end
