;+
;PROCEDURE: set_plot_attributes_mom
;PURPOSE: Set the plot attributes for different products
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/21/2006
;
;MODIFICATION HISTORY:
;    09/21/2006: Created
;    02/09/2007: Added _mom to name. Changed ylim.
;    02/28/2007: All attributes are set for all moments (CGM)
;    09/13/2007: Added velocity_bulk_reformed (LBE)
;-
PRO set_plot_attributes_mom, sat, prod, coord
compile_opt strictarrsubs
CASE coord OF
    1: temp_coord = 'INST_COORD'
ENDCASE

;FOR ii = 0, n_elements(prod)-1 DO BEGIN 
;    CASE prod[ii] OF
;        'D': BEGIN 
;            yt = 'SC' + sat + '!CH!U+!N!C n (cm!U-3!N)+!C'
;            name = sat+'_mom_density'
;            ylim, name,  0, 0, 0
;        END
;        'VX': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Vx (km s!U-1!N)+!C'+temp_coord
;            name = sat+'_mom_velocity_inst_x'
;            ylim, name, 0, 0, 0
;        END
;        'VY': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Vy (km s!U-1!N)+!C'+temp_coord
;            name = sat+'_mom_velocity_inst_y'
;            ylim, name, 0, 0, 0
;        END
;        'VZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Vz (km s!U-1!N)+!C'+temp_coord
;            name = sat+'_mom_velocity_inst_z'
;            ylim, name, 0, 0, 0
;        END
;        'VT': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Vt (km s!U-1!N)+!C'+temp_coord
;            name = sat+'_mom_velocity_total'
;            ylim, name, 0, 0, 0
;        END
;        'VXYZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C V (km s!U-1!N)+!C'+temp_coord
;            name = sat+'_mom_velocity_inst_xyz'
;            ylim, name, 0, 0, 0
;        END
;        'TXX': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Txx (eV)'
;            name = sat+'_mom_temp_inst_xx'
;            ylim,    name,  0, 0, 0
;        END
;        'TYY': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Tyy (eV)'
;            name = sat+'_mom_temp_inst_yy'
;            ylim,    name,  0, 0, 0
;        END
;        'TZZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Tzz (eV)'
;            name = sat+'_mom_temp_inst_zz'
;            ylim,    name,  0, 0, 0
;        END
;        'TXXYYZZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Txxyyzz (eV)'
;            name = sat+'_mom_temp_inst_xxyyzz'
;            ylim,    name,  0, 0, 0
;        END
;        'PXX': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Pxx (nPa)'
;            name = sat+'_mom_pressure_inst_xx'
;            ylim,    name,  0, 0, 0
;        END
;        'PYY': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Pyy (nPa)'
;            name = sat+'_mom_pressure_inst_yy'
;            ylim,    name,  0, 0, 0
;        END
;        'PZZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Pzz (nPa)'
;            name = sat+'_mom_pressure_inst_zz'
;            ylim,    name,  0, 0, 0
;        END
;        'PXXYYZZ': BEGIN
;            yt = 'SC' + sat + '!CH!U+!N!C Pxxyyzz (nPa)'
;            name = sat+'_mom_pressure_inst_xxyyzz'
;            ylim,    name,  0, 0, 0
;        END
;    ENDCASE
;          
;    options, name, 'ytitle', yt
;          
;ENDFOR 


yt = 'SC' + sat + '!CH!U+!N!C n (cm!U-3!N)+!C'
name = sat+'_mom_density'
ylim, name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Vx (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_inst_x'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Vy (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_inst_y'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Vz (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_inst_z'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Vt (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_total'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Vt (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_bulk_reformed'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C V (km s!U-1!N)+!C'+temp_coord
name = sat+'_mom_velocity_inst_xyz'
ylim, name, 0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Txx (eV)'
name = sat+'_mom_temp_inst_xx'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Tyy (eV)'
name = sat+'_mom_temp_inst_yy'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Tzz (eV)'
name = sat+'_mom_temp_inst_zz'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Txxyyzz (eV)'
name = sat+'_mom_temp_inst_xxyyzz'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Pxx (nPa)'
name = sat+'_mom_pressure_inst_xx'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Pyy (nPa)'
name = sat+'_mom_pressure_inst_yy'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Pzz (nPa)'
name = sat+'_mom_pressure_inst_zz'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt

yt = 'SC' + sat + '!CH!U+!N!C Pxxyyzz (nPa)'
name = sat+'_mom_pressure_inst_xxyyzz'
ylim,    name,  0, 0, 0
options, name, 'ytitle', yt
          
END 
