;+
;PROCEDURE: set_plot_attributes_hk_daily
;PURPOSE: Set the plot attributes for products
;	 	that are plotted on a daily basis
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/18/2007
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	November 2006	K. Simunac modifies for analog housekeeping
;	18 Jan, 2007	prefixes added for sat A and sat B, labels updated
;       21 July 2007    Added 'ST' to prefixes to match tplot_names (LBE)
;       24 March 2008   Changed limits on mcp_cm_dc
;       23 July  2014   Added Device Code.
;-
PRO set_plot_attributes_hk_daily, sat, prod_hk, inst_coord
compile_opt strictarrsubs
CASE inst_coord OF
    1: inst_string = 'INST_COORD'
ENDCASE 

prefix = ' '
IF (sat EQ 'A') THEN prefix = 'STA_Analog_HK_'
IF (sat EQ 'B') THEN prefix = 'STB_Analog_HK_'

options,'empty','color',0 ;black


FOR ii = 0, n_elements(prod_hk)-1 DO BEGIN 
    CASE prod_hk[ii] OF

	'lrnm_spare': BEGIN
	   yt = sat+' lrnm_spare'
	   name = prefix+'lrnm_spare'
	  ; ylim, name, -1, 1, 0
	END
	'lvc_-12v': BEGIN
	   yt = sat+' LVC -12v [V]'
	   name = prefix+'lvc_-12v'
	   options, name, 'color', 250 ;red
	   ;ylim, name, -15, -10, 0
	END
	'lvc_-5v': BEGIN
	   yt = sat+' LVC -5v [V]'
	   name = prefix+'lvc_-5v'
	   options, name, 'color', 200 ;orange
	   ;ylim, name, -8, 0, 0
	END
	'esa_vm_pos':BEGIN
	   yt = sat+' ESA VM POS [V]'
	   name = prefix+'esa_vm_pos'
	   ;ylim, name, 0, 60, 0
	END
	'dfl_1_vm': BEGIN
	   yt = sat+' DFL_1 VM [V]'
	   name = prefix+'dfl_1_vm'
	   ;ylim, name, 0, 50, 0
	END
	'dfl_1_tap': BEGIN
	   yt = sat+' DFL_1 tap [V]'
	   name = prefix+'dfl_1_tap'
	   ;ylim, name, 0, 50, 0
	END
	'dfl_2_vm':  BEGIN
	   yt = sat+' DFL_2 VM [V]'
	   name = prefix+'dfl_2_vm'
	   options, name, 'color',150 ;green
	   ;ylim, name, 0, 50, 0
	END
	'dfl_2_tap':  BEGIN
	   yt = sat+' DFL_2 tap [V]'
	   name = prefix+'dfl_2_tap'
	   options, name, 'color',150 ;green
	   ;ylim, name, 0, 50, 0
	END
	'lvc_+2.5v_b':  BEGIN
	   yt = sat+' LVC +2.5v_b [V]'
	   name = prefix+'lvc_+2.5v_b';
	   options, name, 'color', 100 ;cyan
	   ;ylim, name, 0, 3, 0
	END
	'pac_cm_dc':  BEGIN
	   yt = sat+' PAC CM DC [mA]'
	   name = prefix+'pac_cm_dc'
	   ylim, name,0,50,0
	END
	'lvc_+12v':  BEGIN
	   yt = sat+' LVC +12v [V]'
	   name = prefix+'lvc_+12v'
	   ;ylim, name, 10, 15, 0
	END
	'lrpm_spare':  BEGIN
	   yt = sat+' lrpm_spare'
	   name = prefix+'lrpm_spare'
	   ;ylim, name, -1, 1, 0
	END
	'lvc_+2.5v_a':  BEGIN
	   yt = sat+' LVC +2.5v_a [V]'
	   name = prefix+'lvc_+2.5v_a'
	   options, name, 'color', 150 ;green
	   ;ylim, name, 0, 3, 0
	END
	'lvc_+5v':  BEGIN
	   yt = sat+' LVC +5v [V]'
	   name = prefix+'lvc_+5v'
	   options, name, 'color', 50 ;blue
	   ;ylim, name, 0, 18, 0
	END
	'adc_avdd':  BEGIN
	   yt = sat+' adc_avdd'
	   name = prefix+'adc_avdd'
	END
	'adc_dvdd':  BEGIN
	   yt = sat+' adc_dvdd'
	   name = prefix+'adc_dvdd'
	END
	'pac_vm':  BEGIN
	   yt = sat+' PAC VM [V]'
	   name = prefix+'pac_vm'
	   options, name, 'ytitle',sat+' PAC VM [V]'
           get_data, name, temp_t, temp_d
           IF max(temp_d, /nan) GT -1.98E4 THEN ylim, name, -2.01E4, -1.90E4 $
             ELSE ylim, name, -2.01E4, -1.99E4
	END
	'cal_vref':  BEGIN
	   yt = sat+' cal_vref [V]'
	   name = prefix+'cal_vref'
	   ;ylim, name, 0, 6, 0
	END
	'pac_cm_ac':  BEGIN
	   yt = sat+' pac_cm_ac'
	   name = prefix+'pac_cm_ac'
	   ylim, name,0,50,0
	END
	'mcp_vm':  BEGIN
	   yt = sat+' MCP VM [V]'
	   name = prefix+'mcp_vm'
	   ylim, name, 0, 4000, 0
	END
	'mcp_cm_dc':  BEGIN
	   yt = sat+' MCP CM DC [mA]'
	   name = prefix+'mcp_cm_dc [mA]'
	   ylim, name, 10, 60, 0
	END
	'mcp_cm_ac':  BEGIN
	   yt = sat+' mcp_cm_ac'
	   name = prefix+'mcp_cm_ac'
	END
	'ssd_cm_dc':  BEGIN
	   yt = sat+' SSD CM DC [mA]'
	   name = prefix+'ssd_cm_dc'
	END
	's_ch_vm':  BEGIN
	   yt = sat+' S ch VM [V]'
	   name = prefix+'s_ch_vm'
	   ylim, name,-20,20,0
	END
	's_ch_vm_tap':  BEGIN
	   yt = sat+' S ch VM tap [V]'
	   name = prefix+'s_ch_vm_tap'
	   ylim, name, -20,20,0
	END
	's_ch_cm_dc':  BEGIN
	   yt = sat+' S ch CM DC [mA]'
	   name = prefix+'s_ch_cm_dc'
	   ylim, name, 0,14,0
	END
	'esa_vm_neg':  BEGIN
	   yt = sat+' ESA VM NEG [V]'
	   name = prefix+'esa_vm_neg'
	   options, name, 'color', 250 ;red
	   ;ylim, name, -60, 0, 0
	END
	'esa_cm_dc':  BEGIN
	   yt = sat+' ESA CM DC [mA]'
	   name = prefix+'esa_cm_dc'
	   ;options,'panel_size',1
	   ylim, name, 0,100,0
	END
	'dfl_1_cm_dc':  BEGIN
	   yt = sat+' DFL_1 CM DC [mA]'
	   name = prefix+'dfl_1_cm_dc'
	END
	'dfl_2_cm_dc':  BEGIN
	   yt = sat+' DFL_2 CM DC [mA]'
	   name = prefix+'dfl_2_cm_dc'
	   options, name, 'color', 150; green
	END
	'lvc_+2.5v_b_imon':  BEGIN
	   yt = sat+' LVC +2.5v_b [mA]'
	   name = prefix+'lvc_+2.5v_b_imon'
	   ;options, name, 'color', 100 ; cyan
	   ylim, name, 0, 600, 0
	END
	'lvc_+12v_imon':  BEGIN
	   yt = sat+' LVC +12v [mA]'
	   name = prefix+'lvc_+12v_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_-12v_imon':  BEGIN
	   yt = sat+' LVC -12v [mA]'
	   name = prefix+'lvc_-12v_imon'
	   ;options, name, 'color', 250 ;red
	   ylim, name, 0, 600, 0
	END
	'lvc_+5v_imon':  BEGIN
	   yt = sat+' LVC +5v [mA]'
	   name = prefix+'lvc_+5v_imon'
	   ;options, name, 'color', 50 ;blue
	   ylim, name, 0, 600, 0
	END
	'lvc_-5v_imon':  BEGIN
	   yt = sat+' LVC -5v [mA]'
	   name = prefix+'lvc_-5v_imon'
	   ;options, name, 'color', 200 ;orange
	   ylim, name, 0, 600, 0
	END
	'lvc_+2.5v_a_imon':  BEGIN
	   yt = sat+' LVC +2.5v_a [mA]'
	   name = prefix+'lvc_+2.5v_a_imon'
	   ;options, name, 'color', 150; green
	   ylim, name, 0, 600, 0
	END
	'ssd_vm':  BEGIN
	   yt = sat+' SSD VM [V]'
	   name = prefix+'ssd_vm'
	   ylim, name, 0, 100, 0
	END
	'adc_lu_flag':  BEGIN
	   yt = sat+' adc_lu_flag'
	   name = prefix+'adc_lu_flag'
	   ;ylim, name, -1,1,0
	END
	'plug_id':  BEGIN
	   yt = sat+' plug_id'
	   name = prefix+'plug_id'
	   ;ylim, name, 0, 20, 0
	END
	'adc_lu_ctr':  BEGIN
	   yt = sat+' adc_lu_ctr'
	   name = prefix+'adc_lu_ctr'
	   ;ylim, name, -1,1,0
	END
	'dac_status':  BEGIN
	   yt = sat+' dac_status'
	   name = prefix+'dac_status'
	   ;ylim, name, -1,1,0
	END
	'adc0_agnd':  BEGIN
	   yt = sat+' adc0_agnd'
	   name = prefix+'adc0_agnd'
	   ;ylim, name, -1, 1, 0
	END
	'adc1_agnd':  BEGIN
	   yt = sat+' adc1_agnd'
	   name = prefix+'adc1_agnd'
	   ;ylim, name, -1, 1, 0
	END
	'ra_e0':  BEGIN
	   yt = sat+' ra_e0'
	   name = prefix+'ra_e0'
	END
	'ra_e1':  BEGIN
	   yt = sat+' ra_e1'
	   name = prefix+'ra_e1'
	END
	'tac0_tsp':  BEGIN
	   yt = sat+' TAC0 [deg C]'
	   name = prefix+'tac0_tsp'
	   ylim, name, -25, 50, 0
	END
	'tac2_tsp':  BEGIN
	   yt = sat+' TAC2 [deg C]'
	   name = prefix+'tac2_tsp'
	   options, name,'color',150; green
	   ylim, name, -25, 50, 0
	END
	'sb0_tsp':  BEGIN
	   yt = sat+' SB0 [deg C]'
	   name = prefix+'sb0_tsp'
	   ;ylim, name, -1, 1, 0
	END
	'sb1_tsp':  BEGIN
	   yt = sat+' SB1 [deg C]'
	   name = prefix+'sb1_tsp'
	   ;ylim, name, -1, 1, 0
	END
	'tof_hv0_tsp':  BEGIN
	   yt = sat+' TOF HV0 [deg C]'
	   name = prefix+'tof_hv0_tsp'
	   ylim, name, -20, 20, 0
	END
	'tof_hv1_tsp':  BEGIN
	   yt = sat+' TOF HV1 [deg C]'
	   name = prefix+'tof_hv1_tsp'
	   options, name, 'color',250; red
	   ylim, name, -20, 20, 0
	END
	's_c_0_tsp':  BEGIN
	   yt = sat+' S_C_0 tsp [deg C]'
	   name = prefix+'s_c_0_tsp'
	   ylim, name, -20, 20, 0
	END
	's_c_1_tsp':  BEGIN
	   yt = sat+' S_C_1 tsp [deg C]'
	   name = prefix+'s_c_1_tsp'
	   options, name, 'color', 250 ;red
	   ylim, name, -20, 20, 0
	END
	'lvc0_tsp':  BEGIN
	   yt = sat+' LVC0 [deg C]'
	   name = prefix+'lvc0_tsp'
	   ylim, name, -20, 20, 0
	END
	'lvc1_tsp':  BEGIN
	   yt = sat+' LVC1 [deg C]'
	   name = prefix+'lvc1_tsp'
	   options, name, 'color', 250 ;red
	   ylim, name, -20, 20, 0
	END
	'adc0_vref':  BEGIN
	   yt = sat+' adc0_vref [V]'
	   name = prefix+'adc0_vref'
	END
	'adc1_vref':  BEGIN
	   yt = sat+' adc1_vref [V]'
	   name = prefix+'adc1_vref'
	END
	'ssd_status':  BEGIN
	   yt = sat+'SSD STATUS'
	   name = prefix+'ssd_status'
	   ;ylim, name, -1, 1, 0
	END
	'ssd_v_pos_analog':  BEGIN
	   yt = sat+' SSD POS ANALOG [V]'
	   name = prefix+'ssd_v_pos_analog'
	   ylim, name, 0,10,0
	END
	'ssd_v_neg_analog':  BEGIN
	   yt = sat+' SSD NEG ANALOG [V]'
	   name = prefix+'ssd_v_neg_analog'
	   ylim, name, -10,0,0
	END
	'ssd_hv_bias':  BEGIN
	   yt = sat+' SSD HV BIAS [V]'
	   name = prefix+'ssd_hv_bias'
	   ylim, name, 0, 120, 0
	END
	'ssd_tc0':  BEGIN
	   yt = sat+'SSD TC0 [deg C]'
	   name = prefix+'ssd_tc0'
	   ylim, name, -20, 20, 0
	END
	'ssd_tc1':  BEGIN
	   yt = sat+' SSD TC1 [deg C]'
	   name = prefix+'ssd_tc1'
	   options, name,'color',250 ; red
	   ylim, name, -20, 20, 0
	END
	'ssd_tc2':  BEGIN
	   yt = sat+' SSD TC2 [deg C]'
	   name = prefix+'ssd_tc2'
	   options, name, 'color',150 ;green
	   ylim, name, -20, 20, 0
	END
	'ssd_v_pos_dig':  BEGIN
	   yt = sat+' SSD V POS DIG [V]'
	   name = prefix+'ssd_v_pos_dig'
	   ylim, name, 0,10,0
	END
	'device_code':  BEGIN
	   yt = sat+' Device Code'
	   name = prefix+'device_code'
	END


    ENDCASE
          
    options, name, 'ytitle', yt
          

ENDFOR 

END 
