; Lorna Ellis
; 05/11/2010
; set_bad_alpha_tem.pro

; This procedure checks for outliers and removes temperature data from
; the pri alphas.

; input  : times_st: array of times as strings
;          temp_k  : alpha temperature values
;          v_th    : alpha thermal vel values
;          sat     : 'A' or 'B'
;          year    : year to check (as int)
;          month   : month to check (as int)
; output : temp_k  : alpha temperature values

PRO set_bad_alpha_tem, times_st, temp_k, v_th, sat, year, month
compile_opt strictarrsubs

CASE sat OF 
    'A': BEGIN 
        CASE year OF 
            2007: BEGIN
                CASE month OF 
                    02: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-02-17/03:02:36' OR $
                                times_st EQ '2007-02-17/04:02:36' OR $
                                times_st EQ '2007-02-17/06:02:36' OR $
                                times_st EQ '2007-02-17/11:02:36' OR $
                                times_st EQ '2007-02-17/12:02:36' OR $
                                times_st EQ '2007-02-17/16:02:36' OR $
                                times_st EQ '2007-02-17/18:02:36' OR $
                                times_st EQ '2007-02-17/19:02:36' OR $
                                times_st EQ '2007-02-18/12:02:36' OR $
                                times_st EQ '2007-02-26/06:04:35' OR $
                                times_st EQ '2007-02-26/07:04:35' OR $
                                times_st EQ '2007-02-27/07:04:35' OR $
                                times_st EQ '2007-02-27/11:04:35' OR $
                                times_st EQ '2007-02-27/15:04:35' OR $
                                times_st EQ '2007-02-27/16:04:35' OR $
                                times_st EQ '2007-02-27/18:04:35' OR $
                                times_st EQ '2007-02-27/20:04:35' OR $
                                times_st EQ '2007-02-27/21:04:35' OR $
                                times_st EQ '2007-02-28/07:04:35' OR $
                                times_st EQ '2007-02-28/08:04:35' OR $
                                times_st EQ '2007-02-28/09:04:35' OR $
                                times_st EQ '2007-02-28/10:04:35' OR $
                                times_st EQ '2007-02-28/11:04:35', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    03: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-03-02/13:01:34' OR $
                                times_st EQ '2007-03-02/15:01:34' OR $
                                times_st EQ '2007-03-02/17:01:34' OR $
                                times_st EQ '2007-03-04/10:01:34' OR $
                                times_st EQ '2007-03-04/13:01:34' OR $
                                times_st EQ '2007-03-05/00:01:34' OR $
                                times_st EQ '2007-03-05/05:01:34' OR $
                                times_st EQ '2007-03-05/13:01:34' OR $
                                times_st EQ '2007-03-06/03:01:34' OR $
                                times_st EQ '2007-03-06/07:01:34' OR $
                                times_st EQ '2007-03-06/09:01:34' OR $
                                times_st EQ '2007-03-06/10:01:34' OR $
                                times_st EQ '2007-03-06/12:01:34' OR $
                                times_st EQ '2007-03-06/14:01:34' OR $
                                times_st EQ '2007-03-06/16:01:34' OR $
                                times_st EQ '2007-03-06/21:01:34' OR $
                                times_st EQ '2007-03-06/23:01:34' OR $
                                times_st EQ '2007-03-07/00:01:34' OR $
                                times_st EQ '2007-03-07/02:01:34' OR $
                                times_st EQ '2007-03-07/03:01:34' OR $
                                times_st EQ '2007-03-07/04:01:34' OR $
                                times_st EQ '2007-03-07/08:01:34' OR $
                                times_st EQ '2007-03-07/10:01:34' OR $
                                times_st EQ '2007-03-07/11:01:34' OR $
                                times_st EQ '2007-03-07/12:01:34' OR $
                                times_st EQ '2007-03-07/17:01:34' OR $
                                times_st EQ '2007-03-12/00:01:33' OR $
                                times_st EQ '2007-03-12/01:01:33' OR $
                                times_st EQ '2007-03-12/12:01:33' OR $
                                times_st EQ '2007-03-12/13:01:33' OR $
                                times_st EQ '2007-03-12/14:01:33' OR $
                                times_st EQ '2007-03-12/15:01:33' OR $
                                times_st EQ '2007-03-12/16:01:33' OR $
                                times_st EQ '2007-03-12/17:01:33' OR $
                                times_st EQ '2007-03-12/18:01:33' OR $
                                times_st EQ '2007-03-12/19:01:33' OR $
                                times_st EQ '2007-03-12/20:01:33' OR $
                                times_st EQ '2007-03-12/21:01:33' OR $
                                times_st EQ '2007-03-12/22:01:33' OR $
                                times_st EQ '2007-03-12/23:01:33' OR $
                                times_st EQ '2007-03-13/01:01:33' OR $
                                times_st EQ '2007-03-13/03:01:33' OR $
                                times_st EQ '2007-03-17/15:01:32' OR $
                                times_st EQ '2007-03-17/18:01:32' OR $
                                times_st EQ '2007-03-18/19:01:31' OR $
                                times_st EQ '2007-03-19/14:01:31' OR $
                                times_st EQ '2007-03-25/04:01:30' OR $
                                times_st EQ '2007-03-25/06:01:30' OR $
                                times_st EQ '2007-03-25/21:01:30' OR $
                                times_st EQ '2007-03-26/03:01:30' OR $
                                times_st EQ '2007-03-26/05:01:30' OR $
                                times_st EQ '2007-03-26/08:01:29' OR $
                                times_st EQ '2007-03-26/13:01:29' OR $
                                times_st EQ '2007-03-26/18:01:29' OR $
                                times_st EQ '2007-03-26/21:01:29' OR $
                                times_st EQ '2007-03-27/04:01:29' OR $
                                times_st EQ '2007-03-27/05:01:29' OR $
                                times_st EQ '2007-03-27/06:01:29' OR $
                                times_st EQ '2007-03-27/07:01:29' OR $
                                times_st EQ '2007-03-27/08:01:29' OR $
                                times_st EQ '2007-03-27/09:01:29' OR $
                                times_st EQ '2007-03-27/13:01:29' OR $
                                times_st EQ '2007-03-27/17:01:29' OR $
                                times_st EQ '2007-03-27/20:01:29' OR $
                                times_st EQ '2007-03-27/21:01:29' OR $
                                times_st EQ '2007-03-27/22:01:29' OR $
                                times_st EQ '2007-03-27/23:01:29' OR $
                                times_st EQ '2007-03-28/00:01:29' OR $
                                times_st EQ '2007-03-28/01:01:29' OR $
                                times_st EQ '2007-03-28/03:01:29' OR $
                                times_st EQ '2007-03-28/05:01:29' OR $
                                times_st EQ '2007-03-28/08:01:29' OR $
                                times_st EQ '2007-03-28/13:01:29' OR $
                                times_st EQ '2007-03-29/23:01:29' OR $
                                times_st EQ '2007-03-30/00:01:29' OR $
                                times_st EQ '2007-03-30/01:01:29' OR $
                                times_st EQ '2007-03-30/04:01:29' OR $
                                times_st EQ '2007-03-30/06:01:29' OR $
                                times_st EQ '2007-03-30/12:01:29' OR $
                                times_st EQ '2007-03-30/13:01:29' OR $
                                times_st EQ '2007-03-30/14:01:29' OR $
                                times_st EQ '2007-03-30/15:01:28', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    04: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-04-01/04:01:28' OR $
                                times_st EQ '2007-04-01/08:01:28' OR $
                                times_st EQ '2007-04-01/09:01:28' OR $
                                times_st EQ '2007-04-01/16:01:28' OR $
                                times_st EQ '2007-04-01/17:01:28' OR $
                                times_st EQ '2007-04-01/18:01:28' OR $
                                times_st EQ '2007-04-01/19:01:28' OR $
                                times_st EQ '2007-04-01/20:01:28' OR $
                                times_st EQ '2007-04-01/21:01:28' OR $
                                times_st EQ '2007-04-01/22:01:28' OR $
                                times_st EQ '2007-04-01/23:01:28' OR $
                                times_st EQ '2007-04-02/00:01:28' OR $
                                times_st EQ '2007-04-02/01:01:28' OR $
                                times_st EQ '2007-04-02/02:01:28' OR $
                                times_st EQ '2007-04-02/04:01:28' OR $
                                times_st EQ '2007-04-02/05:01:28' OR $
                                times_st EQ '2007-04-02/06:01:28' OR $
                                times_st EQ '2007-04-02/07:01:28' OR $
                                times_st EQ '2007-04-02/08:01:28' OR $
                                times_st EQ '2007-04-02/09:01:28' OR $
                                times_st EQ '2007-04-02/10:01:28' OR $
                                times_st EQ '2007-04-02/18:01:28' OR $
                                times_st EQ '2007-04-04/02:01:28' OR $
                                times_st EQ '2007-04-09/06:03:27' OR $
                                times_st EQ '2007-04-09/07:03:27' OR $
                                times_st EQ '2007-04-09/08:03:27' OR $
                                times_st EQ '2007-04-09/11:03:27' OR $
                                times_st EQ '2007-04-09/19:03:27' OR $
                                times_st EQ '2007-04-10/15:03:26' OR $
                                times_st EQ '2007-04-10/16:03:26' OR $
                                times_st EQ '2007-04-10/19:03:26' OR $
                                times_st EQ '2007-04-10/21:03:26' OR $
                                times_st EQ '2007-04-10/22:03:26' OR $
                                times_st EQ '2007-04-10/23:03:26' OR $
                                times_st EQ '2007-04-11/01:03:26' OR $
                                times_st EQ '2007-04-11/14:03:26' OR $
                                times_st EQ '2007-04-11/15:03:26' OR $
                                times_st EQ '2007-04-11/17:03:26' OR $
                                times_st EQ '2007-04-11/18:03:26' OR $
                                times_st EQ '2007-04-11/20:03:26' OR $
                                times_st EQ '2007-04-11/21:03:26' OR $
                                times_st EQ '2007-04-11/22:03:26' OR $
                                times_st EQ '2007-04-11/23:03:26' OR $
                                times_st EQ '2007-04-12/00:03:26' OR $
                                times_st EQ '2007-04-12/03:03:26' OR $
                                times_st EQ '2007-04-12/04:03:26' OR $
                                times_st EQ '2007-04-12/05:03:26' OR $
                                times_st EQ '2007-04-12/06:03:26' OR $
                                times_st EQ '2007-04-12/07:03:26' OR $
                                times_st EQ '2007-04-12/08:03:26' OR $
                                times_st EQ '2007-04-12/09:03:26' OR $
                                times_st EQ '2007-04-12/10:03:26' OR $
                                times_st EQ '2007-04-12/12:03:26' OR $
                                times_st EQ '2007-04-18/03:02:26' OR $
                                times_st EQ '2007-04-22/17:02:26' OR $
                                times_st EQ '2007-04-22/18:02:26' OR $
                                times_st EQ '2007-04-22/19:02:26' OR $
                                times_st EQ '2007-04-23/03:02:26' OR $
                                times_st EQ '2007-04-23/04:02:26' OR $
                                times_st EQ '2007-04-23/06:02:26' OR $
                                times_st EQ '2007-04-23/08:02:26' OR $
                                times_st EQ '2007-04-23/09:02:26' OR $
                                times_st EQ '2007-04-23/12:02:26' OR $
                                times_st EQ '2007-04-23/13:02:26' OR $
                                times_st EQ '2007-04-23/14:02:26' OR $
                                times_st EQ '2007-04-23/15:02:26' OR $
                                times_st EQ '2007-04-23/16:02:26' OR $
                                times_st EQ '2007-04-23/17:02:26' OR $
                                times_st EQ '2007-04-23/19:02:26' OR $
                                times_st EQ '2007-04-23/20:02:26' OR $
                                times_st EQ '2007-04-23/22:02:26' OR $
                                times_st EQ '2007-04-24/19:02:25' OR $
                                times_st EQ '2007-04-24/20:02:25' OR $
                                times_st EQ '2007-04-24/22:02:25' OR $
                                times_st EQ '2007-04-24/23:02:25' OR $
                                times_st EQ '2007-04-25/01:02:25' OR $
                                times_st EQ '2007-04-25/02:02:25' OR $
                                times_st EQ '2007-04-25/14:02:25' OR $
                                times_st EQ '2007-04-25/15:02:25' OR $
                                times_st EQ '2007-04-27/17:03:25' OR $
                                times_st EQ '2007-04-27/18:03:25' OR $
                                times_st EQ '2007-04-27/19:03:25' OR $
                                times_st EQ '2007-04-27/21:03:25' OR $
                                times_st EQ '2007-04-27/22:03:25' OR $
                                times_st EQ '2007-04-27/23:03:25' OR $
                                times_st EQ '2007-04-28/00:03:25' OR $
                                times_st EQ '2007-04-28/02:03:25' OR $
                                times_st EQ '2007-04-28/03:03:25' OR $
                                times_st EQ '2007-04-28/08:03:25' OR $
                                times_st EQ '2007-04-28/09:03:25' OR $
                                times_st EQ '2007-04-28/10:03:25' OR $
                                times_st EQ '2007-04-28/11:03:25' OR $
                                times_st EQ '2007-04-28/12:03:25' OR $
                                times_st EQ '2007-04-28/13:03:25' OR $
                                times_st EQ '2007-04-28/14:03:25' OR $
                                times_st EQ '2007-04-28/15:03:25' OR $
                                times_st EQ '2007-04-28/16:03:25' OR $
                                times_st EQ '2007-04-29/23:03:25' OR $
                                times_st EQ '2007-04-30/01:03:25' OR $
                                times_st EQ '2007-04-30/15:03:25', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    05: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-05-07/15:03:23' OR $
                                times_st EQ '2007-05-07/17:03:23' OR $
                                times_st EQ '2007-05-07/18:03:23' OR $
                                times_st EQ '2007-05-07/19:03:23' OR $
                                times_st EQ '2007-05-07/20:03:23' OR $
                                times_st EQ '2007-05-07/21:03:23' OR $
                                times_st EQ '2007-05-07/23:03:23' OR $
                                times_st EQ '2007-05-08/01:03:23' OR $
                                times_st EQ '2007-05-08/02:03:23' OR $
                                times_st EQ '2007-05-08/03:03:23' OR $
                                times_st EQ '2007-05-08/04:03:23' OR $
                                times_st EQ '2007-05-08/05:03:23' OR $
                                times_st EQ '2007-05-08/06:03:23' OR $
                                times_st EQ '2007-05-08/07:03:23' OR $
                                times_st EQ '2007-05-08/08:03:23' OR $
                                times_st EQ '2007-05-08/09:03:23' OR $
                                times_st EQ '2007-05-08/12:03:23' OR $
                                times_st EQ '2007-05-08/13:03:23' OR $
                                times_st EQ '2007-05-08/14:03:23' OR $
                                times_st EQ '2007-05-08/15:03:23' OR $
                                times_st EQ '2007-05-08/16:03:23' OR $
                                times_st EQ '2007-05-08/17:03:23' OR $
                                times_st EQ '2007-05-08/18:03:23' OR $
                                times_st EQ '2007-05-08/19:03:23' OR $
                                times_st EQ '2007-05-08/20:03:23' OR $
                                times_st EQ '2007-05-11/08:03:23' OR $
                                times_st EQ '2007-05-18/16:03:21' OR $
                                times_st EQ '2007-05-18/17:03:21' OR $
                                times_st EQ '2007-05-18/18:03:21' OR $
                                times_st EQ '2007-05-18/22:03:21' OR $
                                times_st EQ '2007-05-18/23:03:21' OR $
                                times_st EQ '2007-05-19/00:03:21' OR $
                                times_st EQ '2007-05-19/01:03:21' OR $
                                times_st EQ '2007-05-19/02:03:21' OR $
                                times_st EQ '2007-05-19/03:03:21' OR $
                                times_st EQ '2007-05-19/04:03:21' OR $
                                times_st EQ '2007-05-19/05:03:21' OR $
                                times_st EQ '2007-05-19/12:03:21' OR $
                                times_st EQ '2007-05-19/13:03:21' OR $
                                times_st EQ '2007-05-19/16:03:21' OR $
                                times_st EQ '2007-05-19/18:03:21' OR $
                                times_st EQ '2007-05-19/19:03:21' OR $
                                times_st EQ '2007-05-19/20:03:21' OR $
                                times_st EQ '2007-05-22/00:03:21' OR $
                                times_st EQ '2007-05-22/01:03:21' OR $
                                times_st EQ '2007-05-22/03:03:21' OR $
                                times_st EQ '2007-05-23/12:03:21' OR $
                                times_st EQ '2007-05-24/03:00:21' OR $
                                times_st EQ '2007-05-24/10:00:21' OR $
                                times_st EQ '2007-05-24/11:00:21' OR $
                                times_st EQ '2007-05-24/12:00:21' OR $
                                times_st EQ '2007-05-24/13:00:21' OR $
                                times_st EQ '2007-05-24/14:00:21' OR $
                                times_st EQ '2007-05-24/15:00:21' OR $
                                times_st EQ '2007-05-24/16:00:21' OR $
                                times_st EQ '2007-05-24/17:00:21' OR $
                                times_st EQ '2007-05-24/18:00:21' OR $
                                times_st EQ '2007-05-24/19:00:21' OR $
                                times_st EQ '2007-05-24/20:00:21' OR $
                                times_st EQ '2007-05-24/22:00:21' OR $
                                times_st EQ '2007-05-24/23:00:21' OR $
                                times_st EQ '2007-05-25/00:00:21' OR $
                                times_st EQ '2007-05-28/10:00:21', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    06: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-06-02/18:00:20' OR $
                                times_st EQ '2007-06-03/00:00:20' OR $
                                times_st EQ '2007-06-03/05:00:20' OR $
                                times_st EQ '2007-06-03/06:00:20' OR $
                                times_st EQ '2007-06-04/17:00:20' OR $
                                times_st EQ '2007-06-04/18:00:20' OR $
                                times_st EQ '2007-06-04/19:00:20' OR $
                                times_st EQ '2007-06-04/20:00:20' OR $
                                times_st EQ '2007-06-04/21:00:20' OR $
                                times_st EQ '2007-06-04/22:00:20' OR $
                                times_st EQ '2007-06-04/23:00:20' OR $
                                times_st EQ '2007-06-05/00:00:20' OR $
                                times_st EQ '2007-06-08/12:00:20' OR $
                                times_st EQ '2007-06-08/17:00:20' OR $
                                times_st EQ '2007-06-08/18:00:20' OR $
                                times_st EQ '2007-06-09/18:00:19' OR $
                                times_st EQ '2007-06-09/19:00:19' OR $
                                times_st EQ '2007-06-09/22:00:19' OR $
                                times_st EQ '2007-06-09/23:00:19' OR $
                                times_st EQ '2007-06-10/00:00:19' OR $
                                times_st EQ '2007-06-10/01:00:19' OR $
                                times_st EQ '2007-06-10/02:00:19' OR $
                                times_st EQ '2007-06-10/03:00:19' OR $
                                times_st EQ '2007-06-10/04:00:19' OR $
                                times_st EQ '2007-06-10/05:00:19' OR $
                                times_st EQ '2007-06-10/08:00:19' OR $
                                times_st EQ '2007-06-10/10:00:19' OR $
                                times_st EQ '2007-06-10/11:00:19' OR $
                                times_st EQ '2007-06-10/12:00:19' OR $
                                times_st EQ '2007-06-10/19:00:19' OR $
                                times_st EQ '2007-06-10/20:00:19' OR $
                                times_st EQ '2007-06-12/15:00:19' OR $
                                times_st EQ '2007-06-14/10:00:18' OR $
                                times_st EQ '2007-06-14/15:00:18' OR $
                                times_st EQ '2007-06-14/17:00:18' OR $
                                times_st EQ '2007-06-14/18:00:18' OR $
                                times_st EQ '2007-06-14/19:00:18' OR $
                                times_st EQ '2007-06-14/20:00:18' OR $
                                times_st EQ '2007-06-14/21:00:18' OR $
                                times_st EQ '2007-06-14/22:00:18' OR $
                                times_st EQ '2007-06-14/23:00:18' OR $
                                times_st EQ '2007-06-15/00:00:18' OR $
                                times_st EQ '2007-06-15/01:00:18' OR $
                                times_st EQ '2007-06-15/02:00:18' OR $
                                times_st EQ '2007-06-15/03:00:18' OR $
                                times_st EQ '2007-06-15/04:00:18' OR $
                                times_st EQ '2007-06-15/05:00:18' OR $
                                times_st EQ '2007-06-15/06:00:18' OR $
                                times_st EQ '2007-06-15/07:00:18' OR $
                                times_st EQ '2007-06-16/12:00:18' OR $
                                times_st EQ '2007-06-16/13:00:18' OR $
                                times_st EQ '2007-06-18/07:00:18' OR $
                                times_st EQ '2007-06-18/10:00:18' OR $
                                times_st EQ '2007-06-18/11:00:18' OR $
                                times_st EQ '2007-06-18/12:00:18' OR $
                                times_st EQ '2007-06-18/13:00:18' OR $
                                times_st EQ '2007-06-18/22:00:18' OR $
                                times_st EQ '2007-06-19/02:00:18' OR $
                                times_st EQ '2007-06-19/14:00:17' OR $
                                times_st EQ '2007-06-19/21:00:17' OR $
                                times_st EQ '2007-06-19/22:00:17' OR $
                                times_st EQ '2007-06-21/04:00:17' OR $
                                times_st EQ '2007-06-22/00:00:17' OR $
                                times_st EQ '2007-06-22/04:00:17' OR $
                                times_st EQ '2007-06-22/08:00:17' OR $
                                times_st EQ '2007-06-22/17:00:17' OR $
                                times_st EQ '2007-06-22/18:00:17' OR $
                                times_st EQ '2007-06-22/22:00:17' OR $
                                times_st EQ '2007-06-22/23:00:17' OR $
                                times_st EQ '2007-06-23/01:00:17' OR $
                                times_st EQ '2007-06-23/05:00:17' OR $
                                times_st EQ '2007-06-23/07:00:17' OR $
                                times_st EQ '2007-06-23/17:00:17' OR $
                                times_st EQ '2007-06-23/19:00:17' OR $
                                times_st EQ '2007-06-24/02:00:17' OR $
                                times_st EQ '2007-06-24/05:00:17' OR $
                                times_st EQ '2007-06-24/06:00:17' OR $
                                times_st EQ '2007-06-24/08:00:17' OR $
                                times_st EQ '2007-06-25/14:00:17' OR $
                                times_st EQ '2007-06-25/17:00:17' OR $
                                times_st EQ '2007-06-25/18:00:17' OR $
                                times_st EQ '2007-06-25/22:00:16' OR $
                                times_st EQ '2007-06-30/09:04:55' OR $
                                times_st EQ '2007-06-30/10:04:55' OR $
                                times_st EQ '2007-06-30/11:04:55' OR $
                                times_st EQ '2007-06-30/14:04:55' OR $
                                times_st EQ '2007-06-30/15:04:55' OR $
                                times_st EQ '2007-06-30/16:04:55' OR $
                                times_st EQ '2007-06-30/17:04:55' OR $
                                times_st EQ '2007-06-30/18:04:55' OR $
                                times_st EQ '2007-06-30/19:04:55' OR $
                                times_st EQ '2007-06-30/20:04:55', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    07: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-07-01/06:04:55' OR $
                                times_st EQ '2007-07-01/19:04:55' OR $
                                times_st EQ '2007-07-01/20:04:55' OR $
                                times_st EQ '2007-07-01/21:04:55' OR $
                                times_st EQ '2007-07-01/23:04:55' OR $
                                times_st EQ '2007-07-02/01:04:55' OR $
                                times_st EQ '2007-07-02/02:04:55' OR $
                                times_st EQ '2007-07-02/03:04:55' OR $
                                times_st EQ '2007-07-04/13:04:55' OR $
                                times_st EQ '2007-07-04/14:04:55' OR $
                                times_st EQ '2007-07-04/17:04:55' OR $
                                times_st EQ '2007-07-04/18:04:55' OR $
                                times_st EQ '2007-07-04/22:04:55' OR $
                                times_st EQ '2007-07-05/00:04:55' OR $
                                times_st EQ '2007-07-05/03:04:55' OR $
                                times_st EQ '2007-07-05/04:04:55' OR $
                                times_st EQ '2007-07-05/06:04:55' OR $
                                times_st EQ '2007-07-05/07:04:55' OR $
                                times_st EQ '2007-07-05/09:04:55' OR $
                                times_st EQ '2007-07-05/12:04:55' OR $
                                times_st EQ '2007-07-05/13:05:55' OR $
                                times_st EQ '2007-07-05/14:01:55' OR $
                                times_st EQ '2007-07-05/17:01:55' OR $
                                times_st EQ '2007-07-08/04:01:55' OR $
                                times_st EQ '2007-07-08/08:01:55' OR $
                                times_st EQ '2007-07-09/05:01:55' OR $
                                times_st EQ '2007-07-11/13:01:54' OR $
                                times_st EQ '2007-07-11/15:01:54' OR $
                                times_st EQ '2007-07-11/16:01:54' OR $
                                times_st EQ '2007-07-11/17:01:54' OR $
                                times_st EQ '2007-07-11/18:01:54' OR $
                                times_st EQ '2007-07-11/19:01:54' OR $
                                times_st EQ '2007-07-11/20:01:54' OR $
                                times_st EQ '2007-07-11/21:01:54' OR $
                                times_st EQ '2007-07-11/22:01:54' OR $
                                times_st EQ '2007-07-11/23:01:54' OR $
                                times_st EQ '2007-07-12/00:01:54' OR $
                                times_st EQ '2007-07-12/01:01:54' OR $
                                times_st EQ '2007-07-14/22:01:54' OR $
                                times_st EQ '2007-07-15/00:01:54' OR $
                                times_st EQ '2007-07-15/04:01:54' OR $
                                times_st EQ '2007-07-15/07:01:54' OR $
                                times_st EQ '2007-07-15/09:01:54' OR $
                                times_st EQ '2007-07-15/10:01:54' OR $
                                times_st EQ '2007-07-15/11:01:54' OR $
                                times_st EQ '2007-07-15/13:01:54' OR $
                                times_st EQ '2007-07-15/14:01:54' OR $
                                times_st EQ '2007-07-15/18:01:54' OR $
                                times_st EQ '2007-07-15/20:01:54' OR $
                                times_st EQ '2007-07-21/14:01:53' OR $
                                times_st EQ '2007-07-22/00:01:53' OR $
                                times_st EQ '2007-07-22/03:01:53' OR $
                                times_st EQ '2007-07-22/06:01:53' OR $
                                times_st EQ '2007-07-22/15:01:53' OR $
                                times_st EQ '2007-07-22/17:01:53' OR $
                                times_st EQ '2007-07-22/18:01:53' OR $
                                times_st EQ '2007-07-22/19:01:53' OR $
                                times_st EQ '2007-07-22/20:01:53' OR $
                                times_st EQ '2007-07-22/23:01:53' OR $
                                times_st EQ '2007-07-23/01:01:53' OR $
                                times_st EQ '2007-07-23/06:01:53' OR $
                                times_st EQ '2007-07-28/05:01:52' OR $
                                times_st EQ '2007-07-29/10:01:52' OR $
                                times_st EQ '2007-07-29/12:01:52' OR $
                                times_st EQ '2007-07-29/13:01:52' OR $
                                times_st EQ '2007-07-29/14:01:52' OR $
                                times_st EQ '2007-07-29/15:01:52' OR $
                                times_st EQ '2007-07-29/16:01:51' OR $
                                times_st EQ '2007-07-30/00:01:51' OR $
                                times_st EQ '2007-07-30/06:01:51' OR $
                                times_st EQ '2007-07-30/07:01:51' OR $
                                times_st EQ '2007-07-30/08:01:51' OR $
                                times_st EQ '2007-07-30/18:01:51' OR $
                                times_st EQ '2007-07-31/09:01:51' OR $
                                times_st EQ '2007-07-31/10:01:51' OR $
                                times_st EQ '2007-07-31/11:01:51' OR $
                                times_st EQ '2007-07-31/12:01:51' OR $
                                times_st EQ '2007-07-31/13:01:51' OR $
                                times_st EQ '2007-07-31/16:01:51' OR $
                                times_st EQ '2007-07-31/17:01:51' OR $
                                times_st EQ '2007-07-31/18:01:51' OR $
                                times_st EQ '2007-07-31/19:01:51' OR $
                                times_st EQ '2007-07-31/20:01:51' OR $
                                times_st EQ '2007-07-31/22:01:51', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    08: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-08-01/00:01:51' OR $
                                times_st EQ '2007-08-01/01:01:51' OR $
                                times_st EQ '2007-08-01/15:01:51' OR $
                                times_st EQ '2007-08-01/16:01:51' OR $
                                times_st EQ '2007-08-02/13:01:51' OR $
                                times_st EQ '2007-08-02/14:01:51' OR $
                                times_st EQ '2007-08-02/16:01:51' OR $
                                times_st EQ '2007-08-02/17:01:51' OR $
                                times_st EQ '2007-08-02/18:01:51' OR $
                                times_st EQ '2007-08-02/19:01:51' OR $
                                times_st EQ '2007-08-02/20:01:51' OR $
                                times_st EQ '2007-08-04/15:01:50' OR $
                                times_st EQ '2007-08-07/07:01:50' OR $
                                times_st EQ '2007-08-07/08:01:50' OR $
                                times_st EQ '2007-08-07/09:01:50' OR $
                                times_st EQ '2007-08-07/10:01:50' OR $
                                times_st EQ '2007-08-07/13:01:50' OR $
                                times_st EQ '2007-08-07/15:01:50' OR $
                                times_st EQ '2007-08-07/17:01:50' OR $
                                times_st EQ '2007-08-07/21:01:50' OR $
                                times_st EQ '2007-08-07/22:01:50' OR $
                                times_st EQ '2007-08-07/23:01:50' OR $
                                times_st EQ '2007-08-08/00:01:50' OR $
                                times_st EQ '2007-08-08/01:01:50' OR $
                                times_st EQ '2007-08-08/02:01:50' OR $
                                times_st EQ '2007-08-08/03:01:50' OR $
                                times_st EQ '2007-08-08/04:01:50' OR $
                                times_st EQ '2007-08-08/05:01:50' OR $
                                times_st EQ '2007-08-08/06:01:50' OR $
                                times_st EQ '2007-08-08/07:01:50' OR $
                                times_st EQ '2007-08-08/08:01:50' OR $
                                times_st EQ '2007-08-08/09:01:50' OR $
                                times_st EQ '2007-08-08/10:01:50' OR $
                                times_st EQ '2007-08-08/11:01:50' OR $
                                times_st EQ '2007-08-08/12:01:50' OR $
                                times_st EQ '2007-08-08/13:01:50' OR $
                                times_st EQ '2007-08-08/14:01:50' OR $
                                times_st EQ '2007-08-08/15:01:50' OR $
                                times_st EQ '2007-08-08/18:01:50' OR $
                                times_st EQ '2007-08-08/19:01:50' OR $
                                times_st EQ '2007-08-08/20:01:50' OR $
                                times_st EQ '2007-08-10/16:01:49' OR $
                                times_st EQ '2007-08-10/20:01:49' OR $
                                times_st EQ '2007-08-10/21:01:49' OR $
                                times_st EQ '2007-08-10/22:01:49' OR $
                                times_st EQ '2007-08-11/05:01:49' OR $
                                times_st EQ '2007-08-11/06:01:49' OR $
                                times_st EQ '2007-08-11/07:01:49' OR $
                                times_st EQ '2007-08-11/08:01:49' OR $
                                times_st EQ '2007-08-11/09:01:49' OR $
                                times_st EQ '2007-08-11/10:01:49' OR $
                                times_st EQ '2007-08-11/11:01:49' OR $
                                times_st EQ '2007-08-16/20:01:49' OR $
                                times_st EQ '2007-08-16/21:01:49' OR $
                                times_st EQ '2007-08-19/05:03:49' OR $
                                times_st EQ '2007-08-19/06:03:49' OR $
                                times_st EQ '2007-08-19/07:03:49' OR $
                                times_st EQ '2007-08-19/08:03:49' OR $
                                times_st EQ '2007-08-19/09:03:49' OR $
                                times_st EQ '2007-08-19/10:03:49' OR $
                                times_st EQ '2007-08-19/11:03:49' OR $
                                times_st EQ '2007-08-19/12:03:49' OR $
                                times_st EQ '2007-08-19/15:03:49' OR $
                                times_st EQ '2007-08-26/19:03:48' OR $
                                times_st EQ '2007-08-26/20:03:48' OR $
                                times_st EQ '2007-08-26/21:03:48' OR $
                                times_st EQ '2007-08-27/00:03:48' OR $
                                times_st EQ '2007-08-27/08:03:48' OR $
                                times_st EQ '2007-08-27/11:03:48' OR $
                                times_st EQ '2007-08-27/12:03:48' OR $
                                times_st EQ '2007-08-27/16:03:48' OR $
                                times_st EQ '2007-08-27/17:03:48' OR $
                                times_st EQ '2007-08-28/08:03:48' OR $
                                times_st EQ '2007-08-28/18:03:48' OR $
                                times_st EQ '2007-08-29/01:03:48' OR $
                                times_st EQ '2007-08-29/02:03:48' OR $
                                times_st EQ '2007-08-30/07:03:48' OR $
                                times_st EQ '2007-08-30/18:03:48' OR $
                                times_st EQ '2007-08-30/19:03:48', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    09: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-09-01/21:03:47' OR $
                                times_st EQ '2007-09-02/08:03:47' OR $
                                times_st EQ '2007-09-02/16:03:47' OR $
                                times_st EQ '2007-09-02/17:03:47' OR $
                                times_st EQ '2007-09-02/18:03:47' OR $
                                times_st EQ '2007-09-02/19:03:47' OR $
                                times_st EQ '2007-09-02/20:03:47' OR $
                                times_st EQ '2007-09-03/01:03:47' OR $
                                times_st EQ '2007-09-03/02:03:47' OR $
                                times_st EQ '2007-09-03/03:03:47' OR $
                                times_st EQ '2007-09-03/04:03:47' OR $
                                times_st EQ '2007-09-03/05:03:47' OR $
                                times_st EQ '2007-09-03/06:03:47' OR $
                                times_st EQ '2007-09-03/07:03:47' OR $
                                times_st EQ '2007-09-03/08:03:47' OR $
                                times_st EQ '2007-09-03/09:03:47' OR $
                                times_st EQ '2007-09-03/10:03:47' OR $
                                times_st EQ '2007-09-03/11:03:47' OR $
                                times_st EQ '2007-09-03/12:03:47' OR $
                                times_st EQ '2007-09-04/19:03:47' OR $
                                times_st EQ '2007-09-04/20:03:47' OR $
                                times_st EQ '2007-09-04/21:03:47' OR $
                                times_st EQ '2007-09-05/01:03:47' OR $
                                times_st EQ '2007-09-05/05:03:47' OR $
                                times_st EQ '2007-09-05/08:03:47' OR $
                                times_st EQ '2007-09-05/09:03:47' OR $
                                times_st EQ '2007-09-05/11:03:47' OR $
                                times_st EQ '2007-09-05/12:03:47' OR $
                                times_st EQ '2007-09-05/13:03:47' OR $
                                times_st EQ '2007-09-05/19:03:46' OR $
                                times_st EQ '2007-09-05/21:03:46' OR $
                                times_st EQ '2007-09-05/22:03:46' OR $
                                times_st EQ '2007-09-05/23:03:46' OR $
                                times_st EQ '2007-09-06/00:03:46' OR $
                                times_st EQ '2007-09-06/01:03:46' OR $
                                times_st EQ '2007-09-06/03:03:46' OR $
                                times_st EQ '2007-09-06/04:03:46' OR $
                                times_st EQ '2007-09-06/09:03:46' OR $
                                times_st EQ '2007-09-07/21:03:46' OR $
                                times_st EQ '2007-09-07/23:03:46' OR $
                                times_st EQ '2007-09-08/01:03:46' OR $
                                times_st EQ '2007-09-08/07:03:46' OR $
                                times_st EQ '2007-09-08/16:03:46' OR $
                                times_st EQ '2007-09-08/17:03:46' OR $
                                times_st EQ '2007-09-08/18:03:46' OR $
                                times_st EQ '2007-09-08/19:03:46' OR $
                                times_st EQ '2007-09-08/20:03:46' OR $
                                times_st EQ '2007-09-08/21:03:46' OR $
                                times_st EQ '2007-09-08/23:03:46' OR $
                                times_st EQ '2007-09-09/00:03:46' OR $
                                times_st EQ '2007-09-09/01:03:46' OR $
                                times_st EQ '2007-09-15/08:03:45' OR $
                                times_st EQ '2007-09-15/09:03:45' OR $
                                times_st EQ '2007-09-15/10:03:45' OR $
                                times_st EQ '2007-09-15/11:03:45' OR $
                                times_st EQ '2007-09-15/12:03:45' OR $
                                times_st EQ '2007-09-15/13:03:45' OR $
                                times_st EQ '2007-09-15/14:03:45' OR $
                                times_st EQ '2007-09-15/15:03:45' OR $
                                times_st EQ '2007-09-15/16:03:45' OR $
                                times_st EQ '2007-09-15/17:03:45' OR $
                                times_st EQ '2007-09-15/20:03:45' OR $
                                times_st EQ '2007-09-15/21:03:45' OR $
                                times_st EQ '2007-09-15/22:03:45' OR $
                                times_st EQ '2007-09-15/23:03:45' OR $
                                times_st EQ '2007-09-16/04:03:45' OR $
                                times_st EQ '2007-09-21/23:03:44' OR $
                                times_st EQ '2007-09-22/00:03:44' OR $
                                times_st EQ '2007-09-22/10:03:44' OR $
                                times_st EQ '2007-09-23/03:03:44' OR $
                                times_st EQ '2007-09-23/05:03:44' OR $
                                times_st EQ '2007-09-23/06:03:44' OR $
                                times_st EQ '2007-09-23/08:03:44' OR $
                                times_st EQ '2007-09-23/09:03:44' OR $
                                times_st EQ '2007-09-23/10:03:44' OR $
                                times_st EQ '2007-09-23/11:03:44' OR $
                                times_st EQ '2007-09-23/12:03:43' OR $
                                times_st EQ '2007-09-23/13:03:43' OR $
                                times_st EQ '2007-09-23/14:03:43' OR $
                                times_st EQ '2007-09-23/16:03:43' OR $
                                times_st EQ '2007-09-23/18:03:43' OR $
                                times_st EQ '2007-09-23/21:03:43' OR $
                                times_st EQ '2007-09-23/22:03:43' OR $
                                times_st EQ '2007-09-23/23:03:43' OR $
                                times_st EQ '2007-09-26/03:02:43' OR $
                                times_st EQ '2007-09-26/05:02:43' OR $
                                times_st EQ '2007-09-26/06:02:43' OR $
                                times_st EQ '2007-09-29/01:00:43' OR $
                                times_st EQ '2007-09-29/03:00:43' OR $
                                times_st EQ '2007-09-29/09:00:43' OR $
                                times_st EQ '2007-09-29/10:00:43' OR $
                                times_st EQ '2007-09-29/13:00:43' OR $
                                times_st EQ '2007-09-29/14:00:43' OR $
                                times_st EQ '2007-09-29/16:00:43' OR $
                                times_st EQ '2007-09-29/17:00:43' OR $
                                times_st EQ '2007-09-29/18:00:43' OR $
                                times_st EQ '2007-09-29/19:00:43' OR $
                                times_st EQ '2007-09-29/20:00:43' OR $
                                times_st EQ '2007-09-29/22:00:43' OR $
                                times_st EQ '2007-09-30/00:00:43' OR $
                                times_st EQ '2007-09-30/02:00:43' OR $
                                times_st EQ '2007-09-30/03:00:43' OR $
                                times_st EQ '2007-09-30/04:00:43' OR $
                                times_st EQ '2007-09-30/05:00:43' OR $
                                times_st EQ '2007-09-30/06:00:43' OR $
                                times_st EQ '2007-09-30/07:00:43' OR $
                                times_st EQ '2007-09-30/08:00:43' OR $
                                times_st EQ '2007-09-30/09:00:43' OR $
                                times_st EQ '2007-09-30/10:00:43', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    10: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-10-04/06:00:43' OR $
                                times_st EQ '2007-10-04/09:00:43' OR $
                                times_st EQ '2007-10-04/11:00:43' OR $
                                times_st EQ '2007-10-04/12:00:43' OR $
                                times_st EQ '2007-10-04/13:00:43' OR $
                                times_st EQ '2007-10-04/19:00:43' OR $
                                times_st EQ '2007-10-05/00:02:43' OR $
                                times_st EQ '2007-10-05/07:02:43' OR $
                                times_st EQ '2007-10-05/08:02:43' OR $
                                times_st EQ '2007-10-05/14:02:43' OR $
                                times_st EQ '2007-10-05/19:02:43' OR $
                                times_st EQ '2007-10-05/22:02:42' OR $
                                times_st EQ '2007-10-05/23:02:42' OR $
                                times_st EQ '2007-10-06/00:02:42' OR $
                                times_st EQ '2007-10-16/08:02:40' OR $
                                times_st EQ '2007-10-19/02:02:40' OR $
                                times_st EQ '2007-10-19/03:02:40' OR $
                                times_st EQ '2007-10-19/10:02:40' OR $
                                times_st EQ '2007-10-19/11:02:40' OR $
                                times_st EQ '2007-10-19/12:02:40' OR $
                                times_st EQ '2007-10-19/17:02:40' OR $
                                times_st EQ '2007-10-19/18:02:40' OR $
                                times_st EQ '2007-10-20/01:02:40' OR $
                                times_st EQ '2007-10-20/03:02:40' OR $
                                times_st EQ '2007-10-20/04:02:40' OR $
                                times_st EQ '2007-10-20/06:02:40' OR $
                                times_st EQ '2007-10-20/07:02:40' OR $
                                times_st EQ '2007-10-20/11:02:40' OR $
                                times_st EQ '2007-10-20/12:02:40' OR $
                                times_st EQ '2007-10-20/13:02:40' OR $
                                times_st EQ '2007-10-20/17:02:40' OR $
                                times_st EQ '2007-10-20/20:02:39' OR $
                                times_st EQ '2007-10-20/22:02:39' OR $
                                times_st EQ '2007-10-21/06:02:39' OR $
                                times_st EQ '2007-10-21/12:02:39' OR $
                                times_st EQ '2007-10-21/14:02:39' OR $
                                times_st EQ '2007-10-21/18:02:39' OR $
                                times_st EQ '2007-10-21/19:02:39' OR $
                                times_st EQ '2007-10-21/21:02:39' OR $
                                times_st EQ '2007-10-21/22:02:39' OR $
                                times_st EQ '2007-10-22/00:02:39' OR $
                                times_st EQ '2007-10-22/03:02:39' OR $
                                times_st EQ '2007-10-22/05:02:39' OR $
                                times_st EQ '2007-10-22/07:02:39' OR $
                                times_st EQ '2007-10-22/08:02:39' OR $
                                times_st EQ '2007-10-22/09:02:39' OR $
                                times_st EQ '2007-10-22/10:02:39' OR $
                                times_st EQ '2007-10-22/11:02:39' OR $
                                times_st EQ '2007-10-22/12:02:39' OR $
                                times_st EQ '2007-10-22/13:02:39' OR $
                                times_st EQ '2007-10-22/15:02:39' OR $
                                times_st EQ '2007-10-23/04:02:39' OR $
                                times_st EQ '2007-10-24/16:02:39' OR $
                                times_st EQ '2007-10-25/23:02:38' OR $
                                times_st EQ '2007-10-26/02:02:38' OR $
                                times_st EQ '2007-10-26/03:02:38' OR $
                                times_st EQ '2007-10-26/04:02:38' OR $
                                times_st EQ '2007-10-26/05:02:38' OR $
                                times_st EQ '2007-10-26/06:02:38' OR $
                                times_st EQ '2007-10-26/08:02:38' OR $
                                times_st EQ '2007-10-26/09:02:38' OR $
                                times_st EQ '2007-10-26/10:02:38' OR $
                                times_st EQ '2007-10-26/11:02:38' OR $
                                times_st EQ '2007-10-26/12:02:38' OR $
                                times_st EQ '2007-10-26/13:02:38' OR $
                                times_st EQ '2007-10-26/22:02:38' OR $
                                times_st EQ '2007-10-26/23:02:38' OR $
                                times_st EQ '2007-10-27/02:02:38' OR $
                                times_st EQ '2007-10-27/05:02:38' OR $
                                times_st EQ '2007-10-27/08:02:38' OR $
                                times_st EQ '2007-10-27/09:02:38' OR $
                                times_st EQ '2007-10-27/10:02:38' OR $
                                times_st EQ '2007-10-27/11:02:38' OR $
                                times_st EQ '2007-10-27/12:02:38' OR $
                                times_st EQ '2007-10-27/13:02:38' OR $
                                times_st EQ '2007-10-27/14:02:38' OR $
                                times_st EQ '2007-10-27/15:02:38' OR $
                                times_st EQ '2007-10-27/16:02:38' OR $
                                times_st EQ '2007-10-27/21:02:38' OR $
                                times_st EQ '2007-10-27/22:02:38' OR $
                                times_st EQ '2007-10-28/00:02:38' OR $
                                times_st EQ '2007-10-28/01:02:38' OR $
                                times_st EQ '2007-10-28/03:02:38' OR $
                                times_st EQ '2007-10-28/04:02:38' OR $
                                times_st EQ '2007-10-28/21:02:38' OR $
                                times_st EQ '2007-10-29/07:02:38' OR $
                                times_st EQ '2007-10-29/11:02:38' OR $
                                times_st EQ '2007-10-29/13:02:38' OR $
                                times_st EQ '2007-10-29/22:22:38' OR $
                                times_st EQ '2007-10-31/02:02:37' OR $
                                times_st EQ '2007-10-31/03:02:37' OR $
                                times_st EQ '2007-10-31/05:02:37' OR $
                                times_st EQ '2007-10-31/06:02:37' OR $
                                times_st EQ '2007-10-31/23:02:37', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    11: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-11-01/02:02:37' OR $
                                times_st EQ '2007-11-01/04:02:37' OR $
                                times_st EQ '2007-11-01/05:02:37' OR $
                                times_st EQ '2007-11-01/06:02:37' OR $
                                times_st EQ '2007-11-01/22:02:37' OR $
                                times_st EQ '2007-11-01/23:02:37' OR $
                                times_st EQ '2007-11-02/00:02:37' OR $
                                times_st EQ '2007-11-04/10:02:37' OR $
                                times_st EQ '2007-11-04/23:02:37' OR $
                                times_st EQ '2007-11-05/22:02:37' OR $
                                times_st EQ '2007-11-06/07:02:37' OR $
                                times_st EQ '2007-11-06/08:02:37' OR $
                                times_st EQ '2007-11-10/18:00:37' OR $
                                times_st EQ '2007-11-10/20:00:37' OR $
                                times_st EQ '2007-11-10/21:00:37' OR $
                                times_st EQ '2007-11-11/02:00:37' OR $
                                times_st EQ '2007-11-11/03:00:37' OR $
                                times_st EQ '2007-11-11/04:00:37' OR $
                                times_st EQ '2007-11-11/09:00:37' OR $
                                times_st EQ '2007-11-11/10:00:37' OR $
                                times_st EQ '2007-11-11/11:00:37' OR $
                                times_st EQ '2007-11-11/12:00:37' OR $
                                times_st EQ '2007-11-11/13:00:37' OR $
                                times_st EQ '2007-11-11/14:00:37' OR $
                                times_st EQ '2007-11-11/16:00:37' OR $
                                times_st EQ '2007-11-11/17:00:37' OR $
                                times_st EQ '2007-11-11/19:00:37' OR $
                                times_st EQ '2007-11-12/06:00:37' OR $
                                times_st EQ '2007-11-12/08:00:37' OR $
                                times_st EQ '2007-11-12/11:00:37' OR $
                                times_st EQ '2007-11-12/22:00:37' OR $
                                times_st EQ '2007-11-14/04:00:36' OR $
                                times_st EQ '2007-11-14/05:00:36' OR $
                                times_st EQ '2007-11-14/10:00:36' OR $
                                times_st EQ '2007-11-14/11:00:36' OR $
                                times_st EQ '2007-11-14/12:00:36' OR $
                                times_st EQ '2007-11-14/13:00:36' OR $
                                times_st EQ '2007-11-14/14:00:36' OR $
                                times_st EQ '2007-11-14/15:00:36' OR $
                                times_st EQ '2007-11-14/17:00:36' OR $
                                times_st EQ '2007-11-14/18:00:36' OR $
                                times_st EQ '2007-11-14/19:00:36' OR $
                                times_st EQ '2007-11-14/21:00:36' OR $
                                times_st EQ '2007-11-14/22:00:36' OR $
                                times_st EQ '2007-11-15/00:00:36' OR $
                                times_st EQ '2007-11-15/03:00:36' OR $
                                times_st EQ '2007-11-15/04:00:36' OR $
                                times_st EQ '2007-11-15/06:00:36' OR $
                                times_st EQ '2007-11-15/07:00:36' OR $
                                times_st EQ '2007-11-15/08:00:36' OR $
                                times_st EQ '2007-11-15/09:00:36' OR $
                                times_st EQ '2007-11-15/14:00:36' OR $
                                times_st EQ '2007-11-15/15:00:36' OR $
                                times_st EQ '2007-11-17/04:00:36' OR $
                                times_st EQ '2007-11-17/05:00:36' OR $
                                times_st EQ '2007-11-17/06:00:36' OR $
                                times_st EQ '2007-11-17/08:00:36' OR $
                                times_st EQ '2007-11-17/09:00:36' OR $
                                times_st EQ '2007-11-17/10:00:36' OR $
                                times_st EQ '2007-11-17/13:00:36' OR $
                                times_st EQ '2007-11-17/16:00:36' OR $
                                times_st EQ '2007-11-18/11:00:36' OR $
                                times_st EQ '2007-11-18/12:00:36' OR $
                                times_st EQ '2007-11-18/13:00:36' OR $
                                times_st EQ '2007-11-21/04:00:36' OR $
                                times_st EQ '2007-11-21/05:00:36' OR $
                                times_st EQ '2007-11-21/06:00:36' OR $
                                times_st EQ '2007-11-21/07:00:36' OR $
                                times_st EQ '2007-11-21/08:00:36' OR $
                                times_st EQ '2007-11-21/09:00:36' OR $
                                times_st EQ '2007-11-21/10:00:36' OR $
                                times_st EQ '2007-11-21/15:00:36' OR $
                                times_st EQ '2007-11-21/17:00:36' OR $
                                times_st EQ '2007-11-21/18:00:36' OR $
                                times_st EQ '2007-11-21/19:00:36' OR $
                                times_st EQ '2007-11-22/03:00:35' OR $
                                times_st EQ '2007-11-22/04:00:35' OR $
                                times_st EQ '2007-11-22/05:00:35' OR $
                                times_st EQ '2007-11-22/06:00:35' OR $
                                times_st EQ '2007-11-22/09:00:35' OR $
                                times_st EQ '2007-11-22/10:00:35' OR $
                                times_st EQ '2007-11-22/13:00:35' OR $
                                times_st EQ '2007-11-22/21:00:35' OR $
                                times_st EQ '2007-11-22/22:00:35' OR $
                                times_st EQ '2007-11-23/01:00:35' OR $
                                times_st EQ '2007-11-23/07:00:35' OR $
                                times_st EQ '2007-11-25/21:00:35' OR $
                                times_st EQ '2007-11-25/22:00:35' OR $
                                times_st EQ '2007-11-25/23:00:35' OR $
                                times_st EQ '2007-11-26/01:00:35' OR $
                                times_st EQ '2007-11-27/07:00:34' OR $
                                times_st EQ '2007-11-27/08:00:34' OR $
                                times_st EQ '2007-11-27/09:00:34' OR $
                                times_st EQ '2007-11-27/10:00:34' OR $
                                times_st EQ '2007-11-27/11:00:34' OR $
                                times_st EQ '2007-11-27/12:00:34' OR $
                                times_st EQ '2007-11-27/13:00:34' OR $
                                times_st EQ '2007-11-27/16:00:34' OR $
                                times_st EQ '2007-11-28/03:00:34' OR $
                                times_st EQ '2007-11-28/05:00:34' OR $
                                times_st EQ '2007-11-28/06:00:34' OR $
                                times_st EQ '2007-11-28/07:00:34' OR $
                                times_st EQ '2007-11-28/19:00:34', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    12: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-12-01/09:00:33' OR $
                                times_st EQ '2007-12-01/14:00:33' OR $
                                times_st EQ '2007-12-01/20:00:33' OR $
                                times_st EQ '2007-12-12/09:00:31' OR $
                                times_st EQ '2007-12-12/17:00:31' OR $
                                times_st EQ '2007-12-12/19:00:31' OR $
                                times_st EQ '2007-12-12/20:00:31' OR $
                                times_st EQ '2007-12-12/23:00:31' OR $
                                times_st EQ '2007-12-13/00:00:31' OR $
                                times_st EQ '2007-12-13/01:00:31' OR $
                                times_st EQ '2007-12-13/02:00:31' OR $
                                times_st EQ '2007-12-13/04:00:31' OR $
                                times_st EQ '2007-12-13/05:00:31' OR $
                                times_st EQ '2007-12-13/06:00:31' OR $
                                times_st EQ '2007-12-13/07:00:31' OR $
                                times_st EQ '2007-12-14/02:00:31' OR $
                                times_st EQ '2007-12-14/12:00:31' OR $
                                times_st EQ '2007-12-14/17:00:31' OR $
                                times_st EQ '2007-12-14/18:00:31' OR $
                                times_st EQ '2007-12-14/19:00:31' OR $
                                times_st EQ '2007-12-14/20:00:31' OR $
                                times_st EQ '2007-12-14/21:00:31' OR $
                                times_st EQ '2007-12-15/01:00:31' OR $
                                times_st EQ '2007-12-15/15:00:31' OR $
                                times_st EQ '2007-12-15/16:00:31' OR $
                                times_st EQ '2007-12-15/18:00:31' OR $
                                times_st EQ '2007-12-15/21:00:30' OR $
                                times_st EQ '2007-12-16/05:00:30' OR $
                                times_st EQ '2007-12-16/06:00:30' OR $
                                times_st EQ '2007-12-16/08:00:30' OR $
                                times_st EQ '2007-12-16/10:00:30' OR $
                                times_st EQ '2007-12-16/11:00:30' OR $
                                times_st EQ '2007-12-16/12:00:30' OR $
                                times_st EQ '2007-12-16/14:00:30' OR $
                                times_st EQ '2007-12-16/22:00:30' OR $
                                times_st EQ '2007-12-17/00:00:30' OR $
                                times_st EQ '2007-12-17/01:00:30' OR $
                                times_st EQ '2007-12-17/02:00:30' OR $
                                times_st EQ '2007-12-17/05:00:30' OR $
                                times_st EQ '2007-12-19/00:00:30' OR $
                                times_st EQ '2007-12-19/01:00:30' OR $
                                times_st EQ '2007-12-19/02:00:30' OR $
                                times_st EQ '2007-12-19/04:00:30' OR $
                                times_st EQ '2007-12-19/06:00:30' OR $
                                times_st EQ '2007-12-19/08:00:30' OR $
                                times_st EQ '2007-12-20/09:00:30' OR $
                                times_st EQ '2007-12-20/12:00:30' OR $
                                times_st EQ '2007-12-20/13:00:30' OR $
                                times_st EQ '2007-12-20/14:01:30' OR $
                                times_st EQ '2007-12-20/15:02:30' OR $
                                times_st EQ '2007-12-20/16:02:30' OR $
                                times_st EQ '2007-12-20/23:02:30' OR $
                                times_st EQ '2007-12-21/00:02:30' OR $
                                times_st EQ '2007-12-21/01:02:30' OR $
                                times_st EQ '2007-12-21/19:02:30' OR $
                                times_st EQ '2007-12-21/20:02:30' OR $
                                times_st EQ '2007-12-21/21:02:30' OR $
                                times_st EQ '2007-12-22/02:02:30' OR $
                                times_st EQ '2007-12-24/16:02:30' OR $
                                times_st EQ '2007-12-25/04:02:30' OR $
                                times_st EQ '2007-12-25/18:02:30' OR $
                                times_st EQ '2007-12-25/21:02:30' OR $
                                times_st EQ '2007-12-25/23:02:30' OR $
                                times_st EQ '2007-12-26/07:02:30' OR $
                                times_st EQ '2007-12-26/09:02:30' OR $
                                times_st EQ '2007-12-26/15:02:30' OR $
                                times_st EQ '2007-12-26/17:02:30' OR $
                                times_st EQ '2007-12-26/18:02:30' OR $
                                times_st EQ '2007-12-26/19:02:30' OR $
                                times_st EQ '2007-12-26/20:02:30' OR $
                                times_st EQ '2007-12-26/21:02:30' OR $
                                times_st EQ '2007-12-26/22:02:30' OR $
                                times_st EQ '2007-12-26/23:02:30' OR $
                                times_st EQ '2007-12-27/00:02:30' OR $
                                times_st EQ '2007-12-27/01:02:30' OR $
                                times_st EQ '2007-12-27/02:02:30' OR $
                                times_st EQ '2007-12-27/03:02:30' OR $
                                times_st EQ '2007-12-27/05:02:30' OR $
                                times_st EQ '2007-12-27/06:02:30' OR $
                                times_st EQ '2007-12-27/11:02:30' OR $
                                times_st EQ '2007-12-27/13:02:30' OR $
                                times_st EQ '2007-12-27/20:02:30' OR $
                                times_st EQ '2007-12-28/00:02:29' OR $
                                times_st EQ '2007-12-28/05:02:29' OR $
                                times_st EQ '2007-12-28/14:02:29' OR $
                                times_st EQ '2007-12-28/15:02:29' OR $
                                times_st EQ '2007-12-28/18:02:29' OR $
                                times_st EQ '2007-12-28/19:02:29' OR $
                                times_st EQ '2007-12-28/20:02:29' OR $
                                times_st EQ '2007-12-28/21:02:29' OR $
                                times_st EQ '2007-12-28/22:02:29' OR $
                                times_st EQ '2007-12-28/23:02:29' OR $
                                times_st EQ '2007-12-29/00:02:29' OR $
                                times_st EQ '2007-12-29/02:02:29' OR $
                                times_st EQ '2007-12-29/03:02:29' OR $
                                times_st EQ '2007-12-29/04:02:29' OR $
                                times_st EQ '2007-12-29/05:02:29' OR $
                                times_st EQ '2007-12-29/06:02:29' OR $
                                times_st EQ '2007-12-29/07:02:29' OR $
                                times_st EQ '2007-12-29/09:02:29' OR $
                                times_st EQ '2007-12-29/11:02:29' OR $
                                times_st EQ '2007-12-29/12:02:29' OR $
                                times_st EQ '2007-12-30/04:02:29' OR $
                                times_st EQ '2007-12-30/05:02:29' OR $
                                times_st EQ '2007-12-31/15:02:29', $             
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            temp_k[bad_i] = !values.f_nan
                            v_th  [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    ELSE: stop  ; invalid
                ENDCASE
            END 
            ELSE: dummy = dummy ; none set past 2007 yet
        ENDCASE
    END
    ELSE: dummy = dummy ; none yet for B
ENDCASE 
END 
