;+
;PROCEDURE: plot_set_mon_ps
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 10/13/2006
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;    04/16/2008 LBE: Added slash to filename. Changed conversion to.png.
;    07/06/2009 LBE: Changed .0 to -0 for use on guam instead of maui.
;    12/11/2013 LBE: Change to make 2 separate files (due to new version of convert)
;    01/06/2020 LBE: Change upper limit for ra_trig
;    01/10/2020 LBE: Add printout of avg and min ra_trig for black line
;    01/16/2020 LBE: Add printout of avg and min ra_trig for black (NOSSD)
;    01/17/2020 LBE: Change limits for POS 2 and POS 3.
;    05/26/2020 LBE: Add printout of max for rat_trig
;-
PRO plot_set_mon_ps, prod_mon, num_files_a, num_files_b, E_step, HZ,sat, time
compile_opt strictarrsubs

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

prefix_a = 'A_Monitor_Rate_'
prefix_b = 'B_Monitor_Rate_'
fm = ' '

IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

tplot_options,'title',sat+' (black:35-40 keV/q, red:4.3-5 keV/q, green:1.35-1.5 keV/q)'
tplot_options,'ymargin',[6,6]

; Get the time associated with the first file to label plots
; and out put files

start_year=' '
start_month=' '
start_day=' '
start_year=strmid(time,0,4)
start_month=strmid(time,5,2)
start_day=strmid(time,8,2)
ts = time_struct(time)

;  0 black
; 50 blue
;100 cyan
;150 green
;200 orange
;250 red
;255 white

options, fm+'sf0_sci',     'charthick', 4
options, fm+'sfr0_sci',    'charthick', 4
options, fm+'stp0_sci',    'charthick', 4
options, fm+'stop0_sci',   'charthick', 4
options, fm+'ra_trig_sci', 'charthick', 4
options, fm+'ssd_sw_sci',  'charthick', 4
options, fm+'sf2_sci',     'charthick', 4
options, fm+'sfr2_sci',    'charthick', 4
options, fm+'stp2_sci',    'charthick', 4
options, fm+'stop2_sci',   'charthick', 4
options, fm+'pos2_sci',    'charthick', 4
options, fm+'pos3_sci',    'charthick', 4
options, fm+'sf0_sci',     'thick', 4
options, fm+'sfr0_sci',    'thick', 4
options, fm+'stp0_sci',    'thick', 4
options, fm+'stop0_sci',   'thick', 4
options, fm+'ra_trig_sci', 'thick', 4
options, fm+'ssd_sw_sci',  'thick', 4
options, fm+'sf2_sci',     'thick', 4
options, fm+'sfr2_sci',    'thick', 4
options, fm+'stp2_sci',    'thick', 4
options, fm+'stop2_sci',   'thick', 4
options, fm+'pos2_sci',    'thick', 4
options, fm+'pos3_sci',    'thick', 4
options, fm+'sf0_sci',     'xthick', 4
options, fm+'sfr0_sci',    'xthick', 4
options, fm+'stp0_sci',    'xthick', 4
options, fm+'stop0_sci',   'xthick', 4
options, fm+'ra_trig_sci', 'xthick', 4
options, fm+'ssd_sw_sci',  'xthick', 4
options, fm+'sf2_sci',     'xthick', 4
options, fm+'sfr2_sci',    'xthick', 4
options, fm+'stp2_sci',    'xthick', 4
options, fm+'stop2_sci',   'xthick', 4
options, fm+'pos2_sci',    'xthick', 4
options, fm+'pos3_sci',    'xthick', 4 
options, fm+'sf0_sci',     'ythick', 4
options, fm+'sfr0_sci',    'ythick', 4
options, fm+'stp0_sci',    'ythick', 4
options, fm+'stop0_sci',   'ythick', 4
options, fm+'ra_trig_sci', 'ythick', 4
options, fm+'ssd_sw_sci',  'ythick', 4
options, fm+'sf2_sci',     'ythick', 4
options, fm+'sfr2_sci',    'ythick', 4
options, fm+'stp2_sci',    'ythick', 4
options, fm+'stop2_sci',   'ythick', 4
options, fm+'pos2_sci',    'ythick', 4
options, fm+'pos3_sci',    'ythick', 4
IF ((ts[0].year EQ 2019) AND (ts[0].doy GE 358)) THEN BEGIN
   ylim, fm+'ra_trig_sci', 1e1, 1e6, 1
   ylim, fm+'pos2_sci', 1e1, 1e6, 1
   ylim, fm+'pos3_sci', 1e1, 1e6, 1
   ylim, fm+'ssd_sw_sci', 1, 1e5, 1
ENDIF ELSE IF (ts[0].year EQ 2020) THEN BEGIN
   ylim, fm+'ra_trig_sci', 1e1, 1e6, 1
   ylim, fm+'srf0_sci', .01, 100, 1
   ylim, fm+'stp0_sci', .01, 100, 1
   ylim, fm+'pos2_sci', 1e1, 1e6, 1
   ylim, fm+'pos3_sci', 1e1, 1e6, 1
ENDIF 

; SSD 
ThisDevice = !D.Name
SET_PLOT,'PS'
base = getenv('OUT_DIR')+'/'+sat+'_'+start_year+'_'+start_month+'_'+start_day+'_rates_v2_ssd_side'
filename = base+'.ps'
DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
LOADCT, 39, NCOLORS=256
tplot,[fm+'sf0_sci',fm+'sfr0_sci',fm+'stp0_sci',fm+'stop0_sci',fm+'ra_trig_sci',fm+'ssd_sw_sci']
; Added code 1/10/2020 to put daily average and daily minimum
; for black ra_trig line on plots.
get_data, fm+'Monitor_Rate_ra_trig_sci_4', ra_t, ra_d
good_i = where(ra_d gt 0.1, good_c)
if good_c gt 0 then begin
   ra_avg = avg(ra_d[good_i])
   ra_min = min(ra_d[good_i])
   ra_max = max(ra_d[good_i])
   xyouts, .85, .33, 'max: '+strtrim(string(ra_max, format='(I)'), 2), /normal, charthick = 2
   xyouts, .85, .29, 'avg: '+strtrim(string(ra_avg, format='(I)'), 2), /normal, charthick = 2
   xyouts, .85, .25, 'min: '+strtrim(string(ra_min, format='(I)'), 2), /normal, charthick = 2
endif 

CASE sat OF
    'A': IF (TOTAL(error5_mon_a, /NAN) GT 0) THEN tplot, ['A_error5_mon']
    'B': IF (TOTAL(error5_mon_b, /NAN) GT 0) THEN tplot, ['B_error5_mon']
ENDCASE
DEVICE,/Close_File
SET_PLOT,ThisDevice
command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 '+base + '.ps ' + base+'.png'
spawn, command_string
command_string = 'rm -f ' + base+'.ps'
spawn, command_string 

; Non-SSD 
ThisDevice = !D.Name
SET_PLOT,'PS'
base = getenv('OUT_DIR')+'/'+sat+'_'+start_year+'_'+start_month+'_'+start_day+'_rates_v2_nossd_side'
filename = base+'.ps'
DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
LOADCT, 39, NCOLORS=256
; Added code 1/16/2020 to put daily average and daily minimum
; for black top three plots
get_data, fm+'Monitor_Rate_sf2_sci_4', sf2_t, sf2_d
get_data, fm+'Monitor_Rate_sfr2_sci_4', sfr2_t, sfr2_d
get_data, fm+'Monitor_Rate_stp2_sci_4', stp2_t, stp2_d
good_i = where(sf2_t gt 0, good_c)
if good_c gt 0 then begin
   sf2_avg = avg(sf2_d[good_i])
   sf2_min = min(sf2_d[good_i])
   sf2_max = max(sf2_d[good_i])
   xyouts, .88, .88, 'max: '+strtrim(string(sf2_max, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .85, 'avg: '+strtrim(string(sf2_avg, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .82, 'min: '+strtrim(string(sf2_min, format='(I)'), 2), /normal, charthick = 2
   sfr2_avg = avg(sfr2_d[good_i])
   sfr2_min = min(sfr2_d[good_i])
   sfr2_max = max(sfr2_d[good_i])
   xyouts, .88, .75, 'max: '+strtrim(string(sfr2_max, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .72, 'avg: '+strtrim(string(sfr2_avg, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .69, 'min: '+strtrim(string(sfr2_min, format='(I)'), 2), /normal, charthick = 2
   stp2_avg = avg(stp2_d[good_i])
   stp2_min = min(stp2_d[good_i])
   stp2_max = max(stp2_d[good_i])
   xyouts, .88, .60, 'max: '+strtrim(string(stp2_max, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .57, 'avg: '+strtrim(string(stp2_avg, format='(I)'), 2), /normal, charthick = 2
   xyouts, .88, .54, 'min: '+strtrim(string(stp2_min, format='(I)'), 2), /normal, charthick = 2
endif
tplot_options,'ymargin',[6,6]
tplot,[fm+'sf2_sci',fm+'sfr2_sci',fm+'stp2_sci',fm+'stop2_sci',fm+'pos2_sci',fm+'pos3_sci']
CASE sat OF
    'A': IF (TOTAL(error5_mon_a, /NAN) GT 0) THEN tplot, ['A_error5_mon']
    'B': IF (TOTAL(error5_mon_b, /NAN) GT 0) THEN tplot, ['B_error5_mon']
ENDCASE
DEVICE,/Close_File
SET_PLOT,ThisDevice
command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 '+base + '.ps ' + base+'.png'
spawn, command_string
command_string = 'rm -f ' + base+'.ps'
spawn, command_string 

END 
