;+
; PROCEDURE: plot_mag
;
; PURPOSE: plot magnetic field data
;
; INPUT: sc -> Spacecraft number
;
; KEYWORDS: POLAR -> Create r, theta, phi, components
;           GSM   -> transform to GSM coordinate system
;
; CREATED BY: C. Mouikis
;
; MODIFICATION HISTORY:
;     07/13/2010 LBE: Added gse keyword.
;     06/17/2011 LBE: Changed for "tranformed" mag (faster).
;-
PRO plot_mag, sc
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose


FOR ii = 0, N_ELEMENTS(sc)-1 DO BEGIN

    get_transformed_stereo_mag, sc(ii)

ENDFOR



END
