;+
;PROCEDURE: plot_hk
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	November 2006  	K. Simunac modifes for analog housekeeping items
;	18 Jan, 2007	prefixes modified for sat A and sat B
;	02/27/2007 - C. Mouikis:  The S/C descriptor is included in prefix
;	03 July, 2007	calls share1_mon variables	
;       01 June, 2008   LBE: removed tplot_options,'color',255
;-
PRO plot_hk, sat_hk, num_files_a, num_files_b, sat
compile_opt strictarrsubs
COMMON tplot_com1
COMMON share1_mon

;LOADCT, 39, NCOLORS=256
;!P.BACKGROUND = 255

prefix_a = 'STA_Analog_HK_'
prefix_b = 'STB_Analog_HK_'
prod = ' '

FOR ii = 0, n_elements(sat_hk)-1 DO BEGIN 
CASE sat_hk(ii) OF
	
	1: prod = 'lrnm_spare'
	2: prod = 'lvc_-12v'
	3: prod = 'lvc_-5v'
	4: prod = 'esa_vm_pos'
	5: prod = 'dfl_1_vm'
	6: prod = 'dfl_1_tap'
	7: prod = 'dfl_2_vm'
	8: prod = 'dfl_2_tap'
	9: prod = 'lvc_+2.5v_b'
	10: prod = 'pac_cm_dc'
	11: prod = 'lvc_+12v'
	12: prod = 'lrpm_spare'
	13: prod = 'lvc_+2.5v_a'
	14: prod = 'lvc_+5v'
	15: prod = 'adc_avdd'
	16: prod = 'adc_dvdd'
	17: prod = 'pac_vm'
	18: prod = 'cal_vref'
	19: prod = 'pac_cm_ac'
	20: prod = 'mcp_vm'
	21: prod = 'mcp_cm_dc'
	22: prod = 'mcp_cm_ac'
	23: prod = 'ssd_cm_dc'
	24: prod = 's_ch_vm'
	25: prod = 's_ch_vm_tap'
	26: prod = 's_ch_cm_dc'
	27: prod = 'esa_vm_neg'
	28: prod = 'esa_cm_dc'
	29: prod = 'dfl_1_cm_dc'
	30: prod = 'dfl_2_cm_dc'
	31: prod = 'lvc_+2.5v_b_imon'
	32: prod = 'lvc_+12v_imon'
	33: prod = 'lvc_-12v_imon'
	34: prod = 'lvc_+5v_imon'
	35: prod = 'lvc_-5v_imon'
	36: prod = 'lvc_+2.5v_a_imon'
	37: prod = 'ssd_vm'
	38: prod = 'adc_lu_flag'
	39: prod = 'plug_id'
	40: prod = 'adc_lu_ctr'
	41: prod = 'dac_status'
	42: prod = 'adc0_agnd'
	43: prod = 'adc1_agnd'
	44: prod = 'ra_e0'
	45: prod = 'ra_e1'
	46: prod = 'tac0_tsp'
	47: prod = 'tac2_tsp'
	48: prod = 'sb0_tsp'
	49: prod = 'sb1_tsp'
	50: prod = 'tof_hv0_tsp'
	51: prod = 'tof_hv1_tsp'
	52: prod = 's_c_0_tsp'
	53: prod = 's_c_1_tsp'
	54: prod = 'lvc0_tsp'
	55: prod = 'lvc1_tsp'
	56: prod = 'adc0_vref'
	57: prod = 'adc1_vref'
	58: prod = 'ssd_status'
	59: prod = 'ssd_v_pos_analog'
	60: prod = 'ssd_v_neg_analog'
	61: prod = 'ssd_hv_bias'
	62: prod = 'ssd_tc0'
	63: prod = 'ssd_tc1'
	64: prod = 'ssd_tc2'
	65: prod = 'ssd_v_pos_dig'

	ENDCASE


    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
    temp_prod = prod
    IF n_elements(names) EQ 0 THEN names = [prefix+temp_prod] ELSE names = [names, prefix+temp_prod]
ENDFOR

tplot_options, 'color', 0
tplot_options,'title',sat+' Analog Housekeeping'

;IF n_elements(names) GT 0 THEN tplot, names

;!P.BACKGROUND = 0
;tplot_options, 'color', 255

tplot_options,'title',' '

END 
