;+
;PROCEDURE: plot_dig_hk
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	3 July, 2007	calls share1_mon variables
;-
PRO plot_dig_hk, sat_dig_hk, num_files_a, num_files_b, sat
compile_opt strictarrsubs

LOADCT, 39, NCOLORS=256
!P.BACKGROUND = 255

COMMON tplot_com1
COMMON share1_mon
prefix_a = 'A_DIG_HK_'
prefix_b = 'B_DIG_HK_'
prod = ' '

FOR ii = 0, n_elements(sat_dig_hk)-1 DO BEGIN 
CASE sat_dig_hk(ii) OF
	
	 1:  prod_dig_hk = 'dpu_sw_version'                  ; 0 
         2:  prod_dig_hk = 'cmd_rcvd_cnt'                    ; 1
         3:  prod_dig_hk = 'cmd_exec_cnt'                    ; 2
         4:  prod_dig_hk = 'cmd_total_err_cnt'               ; 3
         5:  prod_dig_hk = 'cmd_parity_err_cnt'              ; 4
         6:  prod_dig_hk = 'cmd_frame_err_cnt'               ; 5
         7:  prod_dig_hk = 'cmd_illegal_err_cnt'             ; 6
         8:  prod_dig_hk = 'ic_status_reg'                   ; 7
         9:  prod_dig_hk = 'ic_ctl_reg'                      ; 8
         10:   prod_dig_hk = 'lbc_reset_ctl'                   ; 9
         11:   prod_dig_hk = 'lbc_mode_ctl'                    ; 10
         12:   prod_dig_hk =  'lbc_logic_ctl_a'                ; 11
         13:   prod_dig_hk = 'lbc_logic_ctl_b'                 ; 12
         14:   prod_dig_hk = 'lbc_tac_pwr_ctl'                 ; 13
         15:   prod_dig_hk = 'lbc_reg_seq'                     ; 14
         16:   prod_dig_hk = 'lbc_event_ctl'                   ; 15
         17:   prod_dig_hk = 'lbc_rlim_ch'                     ; 16
         18:   prod_dig_hk = 'lbc_rlim_hi'                     ; 17
         19:   prod_dig_hk = 'lbc_rlim_lo'                     ; 18
         20:   prod_dig_hk =  'lbe_pos_ctrl'                   ; 19
         21:   prod_dig_hk =  'lbe_pos_disable0'               ; 20
         22:   prod_dig_hk = 'lbe_pos_disable2'                ; 21
         23:   prod_dig_hk = 'lbe_tac0_ctrl'                   ; 22
         24:   prod_dig_hk = 'lbe_tac0_dac'                    ; 23
         25:   prod_dig_hk = 'lbe_tac2_ctrl'                   ; 24
         26:   prod_dig_hk = 'lbe_tac2_dac'                    ; 25
         27:   prod_dig_hk = 'lbe_tac0_under_hi'               ; 26
         28:   prod_dig_hk = 'lbe_tac0_under_lo'               ; 27
         29:   prod_dig_hk = 'lbe_tac0_over_hi'                ; 28
         30:   prod_dig_hk = 'lbe_tac0_over_lo'                ; 29
         31:   prod_dig_hk = 'lbe_tac2_under_hi'               ; 30
         32:   prod_dig_hk = 'lbe_tac2_under_lo'               ; 31
         33:   prod_dig_hk = 'lbe_tac2_over_hi'                ; 32
         34:   prod_dig_hk = 'lbe_tac2_over_lo'                ; 33
         35:   prod_dig_hk = 'lbe_ssd_ctrl'                    ; 34
         36:   prod_dig_hk = 'lbe_ssd_cmd_h'                   ; 35
         37:   prod_dig_hk = 'lbe_ssd_cmd_l'                   ; 36
         38:   prod_dig_hk = 'lbe_ssd_dis'                     ; 37
         39:   prod_dig_hk = 'lbe_ssd_under_hi'                ; 38
         40:   prod_dig_hk = 'lbe_ssd_under_lo'                ; 39
         41:   prod_dig_hk = 'lbe_ssd_over_hi'                 ; 40
         42:   prod_dig_hk = 'lbe_ssd_over_lo'                 ; 41
         43:   prod_dig_hk = 'lbe_sel_ctrl'                    ; 42
         44:   prod_dig_hk = 'lbe_trig_mode'                   ; 43
         45:   prod_dig_hk = 'lbe_esa_step'                    ; 44
         46:   prod_dig_hk = 'lbe_defl_step'                   ; 45
         47:   prod_dig_hk = 'lbe_ssd_offset0'                 ; 46
         48:   prod_dig_hk = 'lbe_ssd_offset1'                 ; 47
         49:   prod_dig_hk = 'lbe_ssd_offset2'                 ; 48
         50:   prod_dig_hk = 'lbe_ssd_offset3'                 ; 49
         51:   prod_dig_hk = 'lbe_ssd_offset4'                 ; 50
         52:   prod_dig_hk = 'lbe_ssd_offset5'                 ; 51
         53:   prod_dig_hk = 'lbe_ssd_offset6'                 ; 52
         54:   prod_dig_hk = 'lbe_ssd_offset7'                 ; 53
         55:   prod_dig_hk = 'lbe_stim_enable'                 ; 54
         56:   prod_dig_hk = 'lbe_stim_freq_hi'                ; 55
         57:   prod_dig_hk = 'lbe_stim_freq_lo'                ; 56
         58:   prod_dig_hk = 'lbe_sel0_window'                 ; 57
         59:   prod_dig_hk = 'lbe_sel2_window'                 ; 58
         60:   prod_dig_hk = 'lbe_ssd_offset8'                 ; 59
         61:   prod_dig_hk = 'lbe_ssd_offset9'                 ; 60
         62:   prod_dig_hk = 'lbe_ssd_offset10'                ; 61
         63:   prod_dig_hk = 'lbe_ssd_offset11'                ; 62
         64:   prod_dig_hk = 'lbe_ssd_offset12'                ; 63
         65:   prod_dig_hk = 'lbe_ssd_offset13'                ; 64
         66:   prod_dig_hk = 'lbe_ssd_offset14'                ; 65
         67:   prod_dig_hk = 'lbe_ssd_offset15'                ; 66
         68:   prod_dig_hk = 'lbe_pos_ra'                      ; 67
         69:   prod_dig_hk = 'dacm_pac_mcp_ssd_ctl_mcp_limit'  ; 68
         70:   prod_dig_hk = 'dacm_pac_limit'                  ; 69
         71:   prod_dig_hk = 'dacm_esa_ctl'                    ; 70
         72:   prod_dig_hk = 'dacm_s_ch_ctl'                   ; 71
         73:   prod_dig_hk = 'dacm_dfl_1_ctl'                  ; 72
         74:   prod_dig_hk = 'dacm_dfl_2_ctl'                  ; 73
         75:   prod_dig_hk = 'dacm_control'                    ; 74
         76:   prod_dig_hk = 'dacm_status'                     ; 75
         77:   prod_dig_hk = 'dacm_adc_lu_ctr'                 ; 76
         78:   prod_dig_hk = 'dacm_dfl_1_offset'               ; 77
         79:   prod_dig_hk = 'dacm_dfl_2_offset'               ; 78
         80:   prod_dig_hk = 'dacm_pac_coarse'                 ; 79
         81:   prod_dig_hk = 'dacm_pac_fine'                   ; 80
         82:   prod_dig_hk = 'dacm_pac_cm_fs_coarse'           ; 81
         83:   prod_dig_hk = 'dacm_pac_cm_fs_fine'             ; 82
         84:   prod_dig_hk = 'dacm_mcp_coarse'                 ; 83
         85:   prod_dig_hk = 'dacm_mcp_fine'                   ; 84
         86:   prod_dig_hk = 'dacm_mcp_cm_fs_coarse'           ; 85
         87:   prod_dig_hk = 'dacm_mcp_cm_fs_fine'             ; 86
         88:   prod_dig_hk = 'dacm_ssd_coarse'                 ; 87
         89:   prod_dig_hk = 'dacm_ssd_fine'                   ; 88
         90:   prod_dig_hk = 'dacm_esa_coarse'                 ; 89
         91:   prod_dig_hk = 'dacm_esa_fine'                   ; 90
         92:   prod_dig_hk = 'dacm_s_ch_coarse'                ; 91
         93:   prod_dig_hk = 'dacm_s_ch_fine'                  ; 92
         94:   prod_dig_hk = 'dacm_s_ch_tap_coarse'            ; 93
         95:   prod_dig_hk = 'dacm_s_ch_tap_fine'              ; 94
         96:   prod_dig_hk = 'dacm_dfl_1_coarse'               ; 95
         97:   prod_dig_hk = 'dacm_dfl_1_fine'                 ; 96
         98:   prod_dig_hk = 'dacm_dfl_1_dfine'                ; 97
         99:   prod_dig_hk = 'dacm_dfl_2_coarse'               ; 98
         100:   prod_dig_hk = 'dacm_dfl_2_fine'                 ; 99
         101:   prod_dig_hk = 'dacm_dfl_2_dfine'                ; 100
         102:   prod_dig_hk = 'dacr_pac_mcp_ssd_ctl_mcp_limit'  ; 101
         103:   prod_dig_hk = 'dacr_pac_limit'                  ; 102
         104:   prod_dig_hk = 'dacr_esa_ctl'                    ; 103
         105:   prod_dig_hk = 'dacr_s_ch_ctl'                   ; 104
         106:   prod_dig_hk = 'dacr_dfl_1_ctl'                  ; 105
         107:   prod_dig_hk = 'dacr_dfl_2_ctl'                  ; 106
         108:   prod_dig_hk = 'dacr_control'                    ; 107
         109:   prod_dig_hk = 'dacr_status'                     ; 108
         110:   prod_dig_hk = 'dacr_adc_lu_ctr'                 ; 109
         111:   prod_dig_hk = 'dacr_dfl_1_offset'               ; 110
         112:   prod_dig_hk = 'dacr_dfl_2_offset'               ; 111
         113:   prod_dig_hk = 'dacr_c_pac_coarse'               ; 112
         114:   prod_dig_hk = 'dacr_c_pac_fine'                 ; 113
         115:   prod_dig_hk = 'dacr_c_pac_cm_fs_coarse'         ; 114
         116:   prod_dig_hk = 'dacr_c_pac_cm_fs_fine'           ; 115
         117:   prod_dig_hk = 'dacr_c_mcp_coarse'               ; 116
         118:   prod_dig_hk = 'dacr_c_mcp_fine'                 ; 117
         119:   prod_dig_hk = 'dacr_c_mcp_cm_fs_coarse'         ; 118
         120:   prod_dig_hk = 'dacr_c_mcp_cm_fs_fine'           ; 119
         121:   prod_dig_hk = 'dacr_c_ssd_coarse'               ; 120
         122:   prod_dig_hk = 'dacr_c_ssd_fine'                 ; 121
         123:   prod_dig_hk = 'dacr_c_esa_coarse'               ; 122
         124:   prod_dig_hk = 'dacr_c_esa_fine'                 ; 123
         125:   prod_dig_hk = 'dacr_c_s_ch_coarse'              ; 124
         126:   prod_dig_hk = 'dacr_c_s_ch_fine'                ; 125
         127:   prod_dig_hk = 'dacr_c_s_ch_tap_coarse'          ; 126
         128:   prod_dig_hk = 'dacr_c_s_ch_tap_fine'            ; 127
         129:   prod_dig_hk = 'dacr_dfl_1_coarse'               ; 128
         130:   prod_dig_hk = 'dacr_dfl_1_fine'                 ; 129
         131:   prod_dig_hk = 'dacr_dfl_1_dfine'                ; 130
         132:   prod_dig_hk = 'dacr_dfl_2_coarse'               ; 131
         133:   prod_dig_hk = 'dacr_dfl_2_fine'                 ; 132
         134:   prod_dig_hk = 'dacr_dfl_2_dfine'                ; 133
         135:   prod_dig_hk = 'sw_status1'                      ; 134
         136:   prod_dig_hk = 'sw_hv_ramp_status'               ; 135
         137:   prod_dig_hk = 'sw_hv_enable_status'             ; 136
         138:   prod_dig_hk = 'sw_hv_limit_status'              ; 137
         139:   prod_dig_hk = 'sw_eepromchksum'                 ; 138
         140:   prod_dig_hk = 'hkp_sampletime'                  ; 139
         141:   prod_dig_hk = 'pac_discharge_status'            ; 140
         142:   prod_dig_hk = 'pac_discharge_cnt'               ; 141
         143:   prod_dig_hk = 'pac_discharge_conseccntr'        ; 142
         144:   prod_dig_hk = 'pac_discharge_safe_att'          ; 143
         145:   prod_dig_hk = 'analog_limit_status'             ; 144
         146:   prod_dig_hk = 'analog_lim_pt1_status'           ; 145
         147:   prod_dig_hk = 'analog_lim_pt1_id'               ; 146
         148:   prod_dig_hk = 'analog_lim_pt1_red'              ; 147
         149:   prod_dig_hk = 'analog_lim_pt2_status'           ; 148
         150:   prod_dig_hk = 'analog_lim_pt2_id'               ; 149
         151:   prod_dig_hk = 'analog_lim_pt2_red'              ; 150
         152:   prod_dig_hk = 'analog_lim_pt3_status'           ; 151
         153:   prod_dig_hk = 'analog_lim_pt3_id'               ; 152
         154:   prod_dig_hk = 'analog_lim_pt3_red'              ; 153
         155:   prod_dig_hk = 'analog_lim_pt4_status'           ; 154
         156:   prod_dig_hk = 'analog_lim_pt4_id'               ; 155
         157:   prod_dig_hk = 'analog_lim_pt4_red'              ; 156
         158:   prod_dig_hk = 'analog_lim_pt5_status'           ; 157
         159:   prod_dig_hk = 'analog_lim_pt5_id'               ; 158
         160:   prod_dig_hk = 'analog_lim_pt5_red'              ; 159
         161:   prod_dig_hk = 'analog_lim_pt6_status'           ; 160
         162:   prod_dig_hk = 'analog_lim_pt6_id'               ; 161
         163:   prod_dig_hk = 'analog_lim_pt6_red'              ; 162
         164:   prod_dig_hk = 'analog_lim_pt7_status'           ; 163
         165:   prod_dig_hk = 'analog_lim_pt7_id'               ; 164
         166:   prod_dig_hk = 'analog_lim_pt7_red'              ; 165
         167:   prod_dig_hk = 'analog_lim_pt8_status'           ; 166
         168:   prod_dig_hk = 'analog_lim_pt8_id'               ; 167
         169:   prod_dig_hk = 'analog_lim_pt8_red'              ; 168
         170:   prod_dig_hk = 'analog_lim_pt9_status'           ; 169
         171:   prod_dig_hk = 'analog_lim_pt9_id'               ; 170
         172:   prod_dig_hk = 'analog_lim_pt9_red'              ; 171
         173:   prod_dig_hk = 'analog_lim_pt10_status'          ; 172
         174:   prod_dig_hk = 'analog_lim_pt10_id'              ; 173
         175:   prod_dig_hk = 'analog_lim_pt10_red'             ; 174
         176:   prod_dig_hk = 'analog_lim_pt11_status'          ; 175
         177:   prod_dig_hk = 'analog_lim_pt11_id'              ; 176
         178:   prod_dig_hk = 'analog_lim_pt11_red'             ; 177
         179:   prod_dig_hk = 'analog_lim_pt12_status'          ; 178
         180:   prod_dig_hk = 'analog_lim_pt12_id'              ; 179
         181:   prod_dig_hk = 'analog_lim_pt12_red'             ; 180
         182:   prod_dig_hk = 'analog_lim_pt13_status'          ; 181
         183:   prod_dig_hk = 'analog_lim_pt13_id'              ; 182
         184:   prod_dig_hk = 'analog_lim_pt13_red'             ; 183
         185:   prod_dig_hk = 'analog_lim_pt14_status'          ; 184
         186:   prod_dig_hk = 'analog_lim_pt14_id'              ; 185
         187:   prod_dig_hk = 'analog_lim_pt14_red'             ; 186
         188:   prod_dig_hk = 'analog_lim_pt15_status'          ; 187
         189:   prod_dig_hk = 'analog_lim_pt15_id'              ; 188
         190:   prod_dig_hk = 'analog_lim_pt15_red'             ; 189
         191:   prod_dig_hk = 'opmode'                          ; 190
         192:   prod_dig_hk = 'sw_mode'                         ; 191
         193:   prod_dig_hk = 'proton_mode'                     ; 192
         194:   prod_dig_hk = 'active_supplyid'                 ; 193
         195:   prod_dig_hk = 'supply_coarse_rb'                ; 194
         196:   prod_dig_hk = 'supply_fine_rb'                  ; 195
         197:   prod_dig_hk = 'swmaint_supplystat'              ; 196
         198:   prod_dig_hk = 'swmaint_pac_coarse'              ; 197
         199:   prod_dig_hk = 'swmaint_pac_fine'                ; 198

	ENDCASE


    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
    temp_prod = prod_dig_hk
    IF n_elements(names) EQ 0 THEN names = [prefix+temp_prod] ELSE names = [names, prefix+temp_prod]
ENDFOR

tplot_options,'color',0
tplot_options,'title',sat+' Digital Housekeeping'

IF n_elements(names) GT 0 THEN tplot, names

!P.BACKGROUND = 0
tplot_options, 'color',255

END 
