;+
; PROCEDURE: pla_plot_pos_spec
;
; PURPOSE:
;  To plot plastic energy spectra
;
; INPUT:
;       sat:
;       prod:
;
; KEYWORDS: full_chan : 2=main,1=schan, default=both - use to specify which channel to include 
;           from_full : set if want spectrogram created from full distribution --
;                       necessary if have included running average
;           weights   : Array of floats for running average
;                       Should add to 1. Should have odd # of elements. (ex: [.25, .5, .25])
;           no_defl   : Sum over defl before running ave.
;           accum_min     : Run accumulation rather than average -- running accum,  remove zeros
;           key_eff   : Use position bin efficiencies before finding average.
;           roll_eff  : Use position bin efficiencies based on roll data.
;           accum_time: [num_min_accum, start_time]
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;   05-20-2010: LBE: Added full_chan keyword (for specifying which channel to include)
;                    Added from_full keyword (for when using running average)
;                    Added weights keyword (for when using running average)
;   05-24-2010: LBE: Added no_defl keyword.
;   06-08-2010: LBE: Added accum_min keyword.
;   09-06-2011: LBE: Added bin keyword (to plot by bins rather than degrees).
;   12-16-2011: LBE: Added key_eff keyword.
;   03-16-2012: LBE: Added roll_eff.
;   05-29-2012: LBE: Added accum_time.
;   01-30-2013: LBE: Added erase_gaps keyword.
;-
PRO pla_plot_pos_spec, sprod, units, $
  energy, phi, $
  diagn = diagn, $
  full_chan = full_chan, from_full = from_full, weights = weights, no_defl = no_defl, accum_min = accum_min, $
  bin = bin, key_eff = key_eff, $
  roll_eff = roll_eff, accum_time = accum_time, erase_gaps = erase_gaps
compile_opt strictarrsubs
  
COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

prod_str = ['h_alpha', 'h+peak', 'he++peak', 'he++tcr', $
            'sw_z>2_h', 'sw_z>2_l', 'wap_ssd_tcr', 'wap_ssd_dcr', $
            'wap_no_ssd_dcr', 'sw_priority', 'wap_priority_ssd', 'wap_priority_no_ssd']

get_input_param, sprod, sat, prod, class

prodtmp = prod_str(prod-1)
prod = prodtmp

IF keyword_set(erase_gaps) THEN temp_erase = 1 ELSE temp_erase = 0
; Loop over all sat/product combinations
FOR ii = 0, N_ELEMENTS(prod)-1 DO BEGIN
    
    IF prod(ii) EQ 'h_alpha' OR $
      prod(ii) EQ 'h+peak' OR $
      prod(ii) EQ 'he++peak' OR $
      prod(ii) EQ 'he++tcr' OR $
      prod(ii) EQ 'sw_z>2_h' OR $
      prod(ii) EQ 'sw_z>2_l' OR $
      prod(ii) EQ 'wap_ssd_tcr' OR $
      prod(ii) EQ 'wap_ssd_dcr' OR $
      prod(ii) EQ 'wap_no_ssd_dcr' THEN BEGIN
        
        get_err_no = 0          ; reset error indicator

        IF temp_erase EQ 1 THEN erase_gaps = 1
        get_pla_pos_spec, sat(ii), prod(ii), class(ii), $
                          units, energy, phi, diagn = diagn, full_chan = full_chan, from_full = from_full, $
                          weights = weights, no_defl = no_defl, accum_min = accum_min, bin = bin, key_eff = key_eff, $
                          roll_eff = roll_eff, $
                          accum_time = accum_time, erase_gaps = erase_gaps
        
        prodname = 'pla_' + sat(ii) + '_posspec_' + prod(ii)
        
        IF prod(ii) EQ 'sw_z>2_h' OR prod(ii) EQ 'sw_z>2_l' THEN $
          prodname = prodname + '_cl' + STRING(class(ii)+1, FORMAT = '(i2.2)')
        
    ENDIF ELSE BEGIN
        
        err_msg, 'No DEF data for product: ' + prod(ii)
        
    ENDELSE
    
ENDFOR
END
