;+
; PROCEDURE: pla_plot_en_spec
;
; PURPOSE:
;  To plot plastic energy spectra. This routine can be called from a
;  crib or from the command line.
;
; INPUT:
;       sprod - Spacecraft ('A' or 'B') & product ID.
;
; POSSIBLE PRODUCTS:
; 
; s_valid		s_e_not_req
; s_e_req		s_no_pos
; s_mult_pos		s_no_e
; s_mult_e		ra_sat_a
; ra_sat_b		ra_sat_both
; ssd_sw		ssd_st
; sf0			sfr0
; stp0			ra_trig
; pos1_0		pos1_1
; w_no_pos		w_mult_pos
; w_valid		sf2
; sfr2			stp2
; pos2_0		pos2_1
; pos2_2		pos2_3
; 
; pos2		(pos2_0 + pos2_1 + pos2_2 + pos2_3)
; pos3		(pos3_0 + pos3_1 + pos3_2 + pos3_3)
; pos3_0
; pos3_1
; pos3_2
; pos3_3
; stop0		(sfr0/sf0)
; start0	(sfr0/stp0)
; stop2		(sfr2/sf2)
; start2	(sfr2/stp2)
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;
;-
PRO pla_plot_mon_spec, sat, prod, units
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

; Loop over all sat/product combinations
FOR jj = 0, N_ELEMENTS(sat)-1 DO BEGIN
    FOR ii = 0, N_ELEMENTS(prod)-1 DO BEGIN
        
        get_err_no = 0 & get_err_msg = '' ; reset error indicator
        
        get_pla_mon_spec, sat(jj), prod(ii), units, $
          diagn = diagn
        
        IF get_err_no NE 0 THEN BEGIN
            err_msg, 'No data for product: ' + prod(ii)
        ENDIF
        
    ENDFOR
ENDFOR

END
