;+
;PROCEDURE: pl_plot_set_mon_from_crib
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic analog housekeeping using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_mon: Array of monitor rates wanted for sat A
;              sat_b_mon: Array of monitor rates wanted for sat B
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
;
;LAST MODIFICATION: 09/11/2006
;
;MODIFICATION HISTORY:
;    09/11/2006 Adapted from C. Mouikis's plot_obmom_from_crib
;
;	November 2006:  K. Simunac adapts to plot monitor rates
;    05/07/2015: LBE: Add nodisplay keyword
;-

PRO check_prod_mon, prod_mon
; in: string with product abbreviation
SWITCH prod_mon OF 
	's_valid':	;0
	's_e_not_req':	;1
	's_e_req':	;2
	's_no_pos':	;3
	's_mult_pos':	;4 
	's_no_e':	;5
	's_mult_e':	;6
	'ra_sat_a':	;7
	'ra_sat_b':	;8
	'ra_sat_both':	;9
	'ssd_sw':	;10
	'ssd_st':	;11
	'sf0':	;12
	'sfr0':	;13
	'stp0':	;14
	'ra_trig':	;15
	'pos1_0':	;16
	'pos1_1':	;17
	'w_no_pos':	;18
	'w_mult_pos':	;19
	'w_valid':	;20
	'sf2':	;21
	'sfr2':	;22
	'stp2':	;23
	'pos2_0':	;24
	'pos2_1':	;25
	'pos2_2':	;26
	'pos2_3':	;27
	'pos3_0':	;28
	'pos3_1':	;29
	'pos3_2':	;30
	'pos3_3':	;31
	'stop0':
	'start0':
	'stop2':
	'start2': 
	'pos1': 
	'pos2': 
	'pos3':   BREAK 
    ELSE: BEGIN 
        print, 'Invalid element in monitor rates array: ', prod_mon
        stop
    ENDELSE
ENDSWITCH
END 


PRO check_mon_array, mon_array, a_mon_array, b_mon_array, sat
; in: mon_array -- array from crib sheet
; out: a_mon_array,b_mon_array -- same as mon array, but divided by satellite
FOR ii = 0, N_ELEMENTS(mon_array)-1 DO BEGIN
    temp_st = mon_array[ii]
    IF sat EQ 'A' THEN BEGIN 
        prod_mon = temp_st
        IF n_elements(a_mon_array) EQ 0 THEN a_mon_array = [prod_mon] ELSE a_mon_array = [a_mon_array, prod_mon]
        check_prod_mon, prod_mon
    ENDIF ELSE BEGIN 
        IF sat EQ 'B' THEN BEGIN 
            prod_mon = temp_st
            IF n_elements(b_mon_array) EQ 0 THEN b_mon_array = [prod_mon] ELSE b_mon_array = [b_mon_array, prod_mon]
            check_prod_mon, prod_mon
        ENDIF ELSE BEGIN 
            print, 'Invalid element in mon array: ', mon_array[ii]
            stop
        ENDELSE   
    ENDELSE 
ENDFOR  
END


PRO pl_plot_set_mon_from_crib, sat_mon, E_step,HZ,sat,time,$
                          INST_COORD=INST_COORD, nodisplay = nodisplay

  COMMON get_error, get_err_no, get_err_msg, default_verbose

  check_mon_array, sat_mon, sat_a_mon, sat_b_mon, sat

  ; Figure out which files we need to read from
  seek_files, 'A', 'science', files_a
  seek_files, 'B', 'science', files_b
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_mon) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_mon) GT 0 THEN print, "No files found for spacecraft B"

 ; Read data
	IF num_a_valid_files GT 0 AND n_elements(sat_a_mon) GT 0 THEN pl_read_cdf_general, 'A', files_a, sat_a_mon, 1, E_step, 'set_monitor_rates', 1
  	IF num_b_valid_files GT 0 AND n_elements(sat_b_mon) GT 0 THEN pl_read_cdf_general, 'B', files_b, sat_b_mon, 1, E_step, 'set_monitor_rates', 1

 ; Put in tplot structures
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mon) GT 0 THEN make_tplot_struct_mon, 'A', sat_a_mon, HZ, E_step, 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mon) GT 0 THEN make_tplot_struct_mon, 'B', sat_b_mon, HZ, E_step, 1

  ; Set plot attributes
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mon) GT 0 THEN set_plot_attributes_set_mon, sat_mon, E_step, HZ, 'A'
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mon) GT 0 THEN set_plot_attributes_set_mon, sat_mon, E_step, HZ, 'B'

  ; Make the plots
  IF keyword_set(nodisplay) NE 1 THEN BEGIN 
      IF (num_a_valid_files GT 0 AND n_elements(sat_a_mon) GT 0) $
        OR (num_b_valid_files GT 0 AND n_elements(sat_b_mon) GT 0) THEN $
        plot_set_mon_ps, sat_mon, num_a_valid_files, num_b_valid_files, E_step, HZ, sat, time
  ENDIF 
END
