;+
;PROCEDURE: pl_plot_l2obmom
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic OB moments using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_mom: Array of moments wanted for sat A
;              sat_b_mom: Array of moments wanted for sat B
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/11/2006
;
;MODIFICATION HISTORY:
;    09/11/2006 Adjusted from C. Mouikis's plot_obmom_from_crib
;    02/09/2007 Changed set_plot_attributes to set_plot_attributes_mom
;
;    02/28/2007: The PS output option is taken out (C. Mouikis)	
;    03/28/2007: Added check for empty files (LBE)
;    02/06/2008: Changed from l2mom to l2obmom (LBE)
;    07/15/2010: Added omit_non_switch keyword, and streamlined
;    11/05/2010: Added order keyword (1=only prelim, 2=valid first, 3=prelim first) -- default is valid only
;    02/21/2011: Fixed omit_non_switch with new L2.
;-
PRO pl_plot_l2obmom, sats, $
                     omit_non_SWITCH = omit_non_SWITCH,  $
                     new_name = new_name, order = order
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

satchk = WHERE(sats NE 'A' AND sats NE 'B', csatchk)
IF csatchk GT 0 THEN BEGIN
    err_msg, 'Input string error: SC description string'
ENDIF

IF keyword_set(order) EQ 0 THEN order = 0

; Loop over all sats combinations
FOR ii = 0, N_ELEMENTS(sats)-1 DO BEGIN

    sat = sats[ii]

    get_err_no = 0 & get_err_msg = '' ; reset error indicator
    
    get_pla_l2obmom, sat, order = order

    IF get_err_no NE 0 THEN BEGIN
        err_msg, 'No data for product for '+sat
    ENDIF

    IF keyword_set(omit_non_SWITCH) THEN BEGIN
        get_schan_esa1, sat

        varstr        = sat + '_l2_obmom_'
        err           = varstr+'error'
        look_up_vel   = varstr+'look_up_vel'
        svalid_ratrig = varstr+'svalid_ratrig'
        ra_eff        = varstr+'ra_eff'
        pri0          = varstr+'pri0_ratio'
        vel_sdev      = varstr+'velocity_sdev'
        poor          = varstr+'error_poor_stats'
        den           = varstr+'density'
        vel           = varstr+'bulk_speed'
        v_x_inst      = varstr+'vx_inst'
        v_y_inst      = varstr+'vy_inst'
        v_z_inst      = varstr+'vz_inst'
        ns_inst       = varstr+'ns_inst'
        ew_inst       = varstr+'ew_inst'
        tem           = varstr+'temperature'
        tem_xy_inst   = varstr+'temperature_xy_inst'
        tem_xz_inst   = varstr+'temperature_xz_inst'
        tem_yy_inst   = varstr+'temperature_yy_inst'
        tem_yz_inst   = varstr+'temperature_yz_inst'
        tem_zz_inst   = varstr+'temperature_zz_inst'
        pr_xx_inst    = varstr+'pressure_xx_inst'
        pr_xy_inst    = varstr+'pressure_xy_inst'
        pr_xz_inst    = varstr+'pressure_xz_inst'
        pr_yy_inst    = varstr+'pressure_yy_inst'
        pr_yz_inst    = varstr+'pressure_yz_inst'
        pr_zz_inst    = varstr+'pressure_zz_inst'
        fl_x_inst     = varstr+'energy_flux_x_inst'
        fl_y_inst     = varstr+'energy_flux_y_inst'
        fl_z_inst     = varstr+'energy_flux_z_inst'
        vel_spcrft    = varstr+'bulk_speed_spcrft'
        v_x_spcrft    = varstr+'vx_spcrft'
        v_y_spcrft    = varstr+'vy_spcrft'
        v_z_spcrft    = varstr+'vz_spcrft'
        ns_spcrft     = varstr+'ns_spcrft'
        ew_spcrft     = varstr+'ew_spcrft'
        vel_hertn     = varstr+'bulk_speed_hertn'
        v_r_hertn     = varstr+'vr_hertn'
        v_t_hertn     = varstr+'vt_hertn'
        v_n_hertn     = varstr+'vn_hertn'
        ns_hertn      = varstr+'ns_hertn'
        ew_hertn      = varstr+'ew_hertn'
        vel_rtn       = varstr+'bulk_speed_rtn'
        v_r_rtn       = varstr+'vr_rtn'
        v_t_rtn       = varstr+'vt_rtn'
        v_n_rtn       = varstr+'vn_rtn'
        ns_rtn        = varstr+'ns_rtn'
        ew_rtn        = varstr+'ew_rtn'
        schan         = sat+'_schan1_esa'
        err1          = sat+'_error1'

        get_data, err,           err_t,           err_d 
        get_data, look_up_vel,   look_up_vel_t,   look_up_vel_d
        get_data, svalid_ratrig, svalid_ratrig_t, svalid_ratrig_d 
        get_data, ra_eff,        ra_eff_t,        ra_eff_d 
        get_data, pri0,          pri0_t,          pri0_d 
        get_data, vel_sdev,      vel_sdev_t,      vel_sdev_d 
        get_data, poor,          poor_t,          poor_d 
        get_data, den,           den_t,           den_d 
        get_data, vel,           vel_t,           vel_d 
        get_data, v_x_inst,      v_x_inst_t,      v_x_inst_d 
        get_data, v_y_inst,      v_y_inst_t,      v_y_inst_d 
        get_data, v_z_inst,      v_z_inst_t,      v_z_inst_d 
        get_data, ns_inst,       ns_inst_t,       ns_inst_d 
        get_data, ew_inst,       ew_inst_t,       ew_inst_d 
        get_data, tem,           tem_t,           tem_d 
        get_data, tem_xy_inst,   tem_xy_inst_t,   tem_xy_inst_d 
        get_data, tem_xz_inst,   tem_xz_inst_t,   tem_xz_inst_d 
        get_data, tem_yy_inst,   tem_yy_inst_t,   tem_yy_inst_d 
        get_data, tem_yz_inst,   tem_yz_inst_t,   tem_yz_inst_d 
        get_data, tem_zz_inst,   tem_zz_inst_t,   tem_zz_inst_d 
        get_data, pr_xx_inst,    pr_xx_inst_t,    pr_xx_inst_d 
        get_data, pr_xy_inst,    pr_xy_inst_t,    pr_xy_inst_d 
        get_data, pr_xz_inst,    pr_xz_inst_t,    pr_xz_inst_d 
        get_data, pr_yy_inst,    pr_yy_inst_t,    pr_yy_inst_d 
        get_data, pr_yz_inst,    pr_yz_inst_t,    pr_yz_inst_d 
        get_data, pr_zz_inst,    pr_zz_inst_t,    pr_zz_inst_d 
        get_data, fl_x_inst,     fl_x_inst_t,     fl_x_inst_d 
        get_data, fl_y_inst,     fl_y_inst_t,     fl_y_inst_d 
        get_data, fl_z_inst,     fl_z_inst_t,     fl_z_inst_d 
        get_data, vel_spcrft,    vel_spcrft_t,    vel_spcrft_d 
        get_data, v_x_spcrft,    v_x_spcrft_t,    v_x_spcrft_d 
        get_data, v_y_spcrft,    v_y_spcrft_t,    v_y_spcrft_d 
        get_data, v_z_spcrft,    v_z_spcrft_t,    v_z_spcrft_d 
        get_data, ns_spcrft,     ns_spcrft_t,     ns_spcrft_d 
        get_data, ew_spcrft,     ew_spcrft_t,     ew_spcrft_d 
        get_data, vel_hertn,     vel_hertn_t,     vel_hertn_d 
        get_data, v_r_hertn,     v_r_hertn_t,     v_r_hertn_d 
        get_data, v_t_hertn,     v_t_hertn_t,     v_t_hertn_d 
        get_data, v_n_hertn,     v_n_hertn_t,     v_n_hertn_d 
        get_data, ns_hertn,      ns_hertn_t,      ns_hertn_d 
        get_data, ew_hertn,      ew_hertn_t,      ew_hertn_d 
        get_data, vel_rtn,       vel_rtn_t,       vel_rtn_d 
        get_data, v_r_rtn,       v_r_rtn_t,       v_r_rtn_d 
        get_data, v_t_rtn,       v_t_rtn_t,       v_t_rtn_d 
        get_data, v_n_rtn,       v_n_rtn_t,       v_n_rtn_d 
        get_data, ns_rtn,        ns_rtn_t,        ns_rtn_d 
        get_data, ew_rtn,        ew_rtn_t,        ew_rtn_d 
        get_data, schan,         schan_t,         schan_d 
        get_data, err1,          err1_t,          err1_d 

        IF array_equal(vel_sdev_t,       den_t) NE 1 THEN stop      
        IF array_equal(poor_t,           den_t) NE 1 THEN stop          
        IF array_equal(den_t,            den_t) NE 1 THEN stop           
        IF array_equal(vel_t,            den_t) NE 1 THEN stop      
        IF array_equal(tem_t,            den_t) NE 1 THEN stop   
        IF array_equal(v_r_hertn_t,      den_t) NE 1 THEN stop     
        IF array_equal(v_t_hertn_t,      den_t) NE 1 THEN stop     
        IF array_equal(v_n_hertn_t,      den_t) NE 1 THEN stop     
        IF array_equal(ns_hertn_t,       den_t) NE 1 THEN stop      
        IF array_equal(ew_hertn_t,       den_t) NE 1 THEN stop      
        IF array_equal(v_r_rtn_t,        den_t) NE 1 THEN stop       
        IF array_equal(v_t_rtn_t,        den_t) NE 1 THEN stop       
        IF array_equal(v_n_rtn_t,        den_t) NE 1 THEN stop       
        IF array_equal(ns_rtn_t,         den_t) NE 1 THEN stop       
        IF array_equal(ew_rtn_t,         den_t) NE 1 THEN stop       
        IF array_equal(schan_t,         err1_t) NE 1 THEN stop       

        IF order GT 0 AND n_elements(err_t) GT 1 THEN BEGIN ; only in prelim data
            IF array_equal(err_t,           den_t) NE 1 THEN stop   
            IF array_equal(look_up_vel_t,   den_t) NE 1 THEN stop   
            IF array_equal(svalid_ratrig_t, den_t) NE 1 THEN stop 
            IF array_equal(ra_eff_t,        den_t) NE 1 THEN stop 
            IF array_equal(pri0_t,          den_t) NE 1 THEN stop       
            IF array_equal(v_x_inst_t,      den_t) NE 1 THEN stop      
            IF array_equal(v_y_inst_t,      den_t) NE 1 THEN stop      
            IF array_equal(v_z_inst_t,      den_t) NE 1 THEN stop      
            IF array_equal(ns_inst_t,       den_t) NE 1 THEN stop       
            IF array_equal(ew_inst_t,       den_t) NE 1 THEN stop       
            IF array_equal(tem_xy_inst_t,   den_t) NE 1 THEN stop   
            IF array_equal(tem_xz_inst_t,   den_t) NE 1 THEN stop   
            IF array_equal(tem_yy_inst_t,   den_t) NE 1 THEN stop   
            IF array_equal(tem_yz_inst_t,   den_t) NE 1 THEN stop   
            IF array_equal(tem_zz_inst_t,   den_t) NE 1 THEN stop   
            IF array_equal(pr_xx_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(pr_xy_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(pr_xz_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(pr_yy_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(pr_yz_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(pr_zz_inst_t,    den_t) NE 1 THEN stop    
            IF array_equal(fl_x_inst_t,     den_t) NE 1 THEN stop     
            IF array_equal(fl_y_inst_t,     den_t) NE 1 THEN stop     
            IF array_equal(fl_z_inst_t,     den_t) NE 1 THEN stop     
            IF array_equal(vel_spcrft_t,    den_t) NE 1 THEN stop    
            IF array_equal(v_x_spcrft_t,    den_t) NE 1 THEN stop   
            IF array_equal(v_y_spcrft_t,    den_t) NE 1 THEN stop    
            IF array_equal(v_z_spcrft_t,    den_t) NE 1 THEN stop    
            IF array_equal(ns_spcrft_t,     den_t) NE 1 THEN stop     
            IF array_equal(ew_spcrft_t,     den_t) NE 1 THEN stop     
            IF array_equal(vel_hertn_t,     den_t) NE 1 THEN stop     
            IF array_equal(vel_rtn_t,       den_t) NE 1 THEN stop       
        ENDIF 

        FOR jj = 0L, n_elements(den_t)-1 DO BEGIN 
            wanted_i = where(schan_t EQ den_t[jj], count)
            IF count EQ 0 THEN bad = 1 ELSE bad = 0
            IF count GT 0 THEN BEGIN
                bad_i = where(err1_d[wanted_i] EQ 1, count)
                IF count GT 0 THEN bad = 1
                bad_i = where(err1_d[wanted_i] EQ 0 AND $
                              (schan_d[wanted_i] EQ 0 OR schan_d[wanted_i] EQ 128), count)
                IF count GT 0 THEN bad = 1
            ENDIF
            IF bad EQ 1 THEN BEGIN 
                vel_sdev_d      [jj] = !values.f_nan      
                poor_d          [jj] = !values.f_nan          
                den_d           [jj] = !values.f_nan           
                vel_d           [jj] = !values.f_nan      
                tem_d           [jj] = !values.f_nan   
                v_r_hertn_d     [jj] = !values.f_nan     
                v_t_hertn_d     [jj] = !values.f_nan     
                v_n_hertn_d     [jj] = !values.f_nan     
                ns_hertn_d      [jj] = !values.f_nan      
                ew_hertn_d      [jj] = !values.f_nan      
                v_r_rtn_d       [jj] = !values.f_nan       
                v_t_rtn_d       [jj] = !values.f_nan       
                v_n_rtn_d       [jj] = !values.f_nan       
                ns_rtn_d        [jj] = !values.f_nan       
                ew_rtn_d        [jj] = !values.f_nan       
                IF order GT 0 AND n_elements(err_t) GT 1 THEN BEGIN ; only in prelim data
                    err_d           [jj] = !values.f_nan   
                    look_up_vel_d   [jj] = !values.f_nan   
                    svalid_ratrig_d [jj] = !values.f_nan 
                    ra_eff_d        [jj] = !values.f_nan 
                    pri0_d          [jj] = !values.f_nan       
                    v_x_inst_d      [jj] = !values.f_nan      
                    v_y_inst_d      [jj] = !values.f_nan      
                    v_z_inst_d      [jj] = !values.f_nan      
                    ns_inst_d       [jj] = !values.f_nan       
                    ew_inst_d       [jj] = !values.f_nan       
                    tem_xy_inst_d   [jj] = !values.f_nan   
                    tem_xz_inst_d   [jj] = !values.f_nan   
                    tem_yy_inst_d   [jj] = !values.f_nan   
                    tem_yz_inst_d   [jj] = !values.f_nan   
                    tem_zz_inst_d   [jj] = !values.f_nan   
                    pr_xx_inst_d    [jj] = !values.f_nan    
                    pr_xy_inst_d    [jj] = !values.f_nan    
                    pr_xz_inst_d    [jj] = !values.f_nan    
                    pr_yy_inst_d    [jj] = !values.f_nan    
                    pr_yz_inst_d    [jj] = !values.f_nan    
                    pr_zz_inst_d    [jj] = !values.f_nan    
                    fl_x_inst_d     [jj] = !values.f_nan     
                    fl_y_inst_d     [jj] = !values.f_nan     
                    fl_z_inst_d     [jj] = !values.f_nan     
                    vel_spcrft_d    [jj] = !values.f_nan    
                    v_x_spcrft_d    [jj] = !values.f_nan   
                    v_y_spcrft_d    [jj] = !values.f_nan    
                    v_z_spcrft_d    [jj] = !values.f_nan    
                    ns_spcrft_d     [jj] = !values.f_nan     
                    ew_spcrft_d     [jj] = !values.f_nan     
                    vel_hertn_d     [jj] = !values.f_nan     
                    vel_rtn_d       [jj] = !values.f_nan       
                ENDIF 
            ENDIF 
        ENDFOR 
        
        IF keyword_set(new_name) THEN BEGIN 
            vel_sdev      = varstr+'velocity_sdev_omit_non_switch'
            poor          = varstr+'error_poor_stats_omit_non_switch'
            den           = varstr+'density_omit_non_switch'
            vel           = varstr+'bulk_speedomit_non_switch'
            tem           = varstr+'temperature_omit_non_switch'
            v_r_hertn     = varstr+'vr_hertn_omit_non_switch'
            v_t_hertn     = varstr+'vt_hertn_omit_non_switch'
            v_n_hertn     = varstr+'vn_hertn_omit_non_switch'
            ns_hertn      = varstr+'ns_hertn_omit_non_switch'
            ew_hertn      = varstr+'ew_hertn_omit_non_switch'
            v_r_rtn       = varstr+'vr_rtn_omit_non_switch'
            v_t_rtn       = varstr+'vt_rtn_omit_non_switch'
            v_n_rtn       = varstr+'vn_rtn_omit_non_switch'
            ns_rtn        = varstr+'ns_rtn_omit_non_switch'
            ew_rtn        = varstr+'ew_rtn_omit_non_switch'
            IF order GT 0 AND n_elements(err_t) GT 1 THEN BEGIN ; only in prelim data
                err           = varstr+'error_omit_non_switch'
                look_up_vel   = varstr+'look_up_vel_omit_non_switch'
                svalid_ratrig = varstr+'svalid_ratrig_omit_non_switch'
                ra_eff        = varstr+'ra_eff_omit_non_switch'
                pri0          = varstr+'pri0_ratio_omit_non_switch'
                v_x_inst      = varstr+'vx_inst_omit_non_switch'
                v_y_inst      = varstr+'vy_inst_omit_non_switch'
                v_z_inst      = varstr+'vz_inst_omit_non_switch'
                ns_inst       = varstr+'ns_inst_omit_non_switch'
                ew_inst       = varstr+'ew_inst_omit_non_switch'
                tem_xy_inst   = varstr+'temperature_xy_inst_omit_non_switch'
                tem_xz_inst   = varstr+'temperature_xz_inst_omit_non_switch'
                tem_yy_inst   = varstr+'temperature_yy_inst_omit_non_switch'
                tem_yz_inst   = varstr+'temperature_yz_inst_omit_non_switch'
                tem_zz_inst   = varstr+'temperature_zz_inst_omit_non_switch'
                pr_xx_inst    = varstr+'pressure_xx_inst_omit_non_switch'
                pr_xy_inst    = varstr+'pressure_xy_inst_omit_non_switch'
                pr_xz_inst    = varstr+'pressure_xz_inst_omit_non_switch'
                pr_yy_inst    = varstr+'pressure_yy_inst_omit_non_switch'
                pr_yz_inst    = varstr+'pressure_yz_inst_omit_non_switch'
                pr_zz_inst    = varstr+'pressure_zz_inst_omit_non_switch'
                fl_x_inst     = varstr+'energy_flux_x_inst_omit_non_switch'
                fl_y_inst     = varstr+'energy_flux_y_inst_omit_non_switch'
                fl_z_inst     = varstr+'energy_flux_z_inst_omit_non_switch'
                vel_spcrft    = varstr+'bulk_speed_spcrft_omit_non_switch'
                v_x_spcrft    = varstr+'vx_spcrft_omit_non_switch'
                v_y_spcrft    = varstr+'vy_spcrft_omit_non_switch'
                v_z_spcrft    = varstr+'vz_spcrft_omit_non_switch'
                ns_spcrft     = varstr+'ns_spcrft_omit_non_switch'
                ew_spcrft     = varstr+'ew_spcrft_omit_non_switch'
                vel_hertn     = varstr+'bulk_speed_hertn_omit_non_switch'
                vel_rtn       = varstr+'bulk_speed_rtn_omit_non_switch'
            ENDIF 
        ENDIF 
        store_data, vel_sdev,      data = {x:     vel_sdev_t, y:     vel_sdev_d} 
        store_data, poor,          data = {x:         poor_t, y:         poor_d} 
        store_data, den,           data = {x:          den_t, y:          den_d} 
        store_data, vel,           data = {x:          vel_t, y:          vel_d} 
        store_data, tem,           data = {x:          tem_t, y:          tem_d} 
        store_data, v_r_hertn,     data = {x:    v_r_hertn_t, y:    v_r_hertn_d} 
        store_data, v_t_hertn,     data = {x:    v_t_hertn_t, y:    v_t_hertn_d} 
        store_data, v_n_hertn,     data = {x:    v_n_hertn_t, y:    v_n_hertn_d} 
        store_data, ns_hertn,      data = {x:     ns_hertn_t, y:     ns_hertn_d} 
        store_data, ew_hertn,      data = {x:     ew_hertn_t, y:     ew_hertn_d} 
        store_data, v_r_rtn,       data = {x:      v_r_rtn_t, y:      v_r_rtn_d} 
        store_data, v_t_rtn,       data = {x:      v_t_rtn_t, y:      v_t_rtn_d} 
        store_data, v_n_rtn,       data = {x:      v_n_rtn_t, y:      v_n_rtn_d} 
        store_data, ns_rtn,        data = {x:       ns_rtn_t, y:       ns_rtn_d} 
        store_data, ew_rtn,        data = {x:       ew_rtn_t, y:       ew_rtn_d} 
        IF order GT 0 AND n_elements(err_t) GT 1 THEN BEGIN ; only in prelim data
            store_data, err,           data = {x:          err_t, y:          err_d} 
            store_data, look_up_vel,   data = {x:  look_up_vel_t, y:  look_up_vel_d}
            store_data, svalid_ratrig, data = {x:svalid_ratrig_t, y:svalid_ratrig_d} 
            store_data, ra_eff,        data = {x:       ra_eff_t, y:       ra_eff_d} 
            store_data, pri0,          data = {x:         pri0_t, y:         pri0_d} 
            store_data, v_x_inst,      data = {x:     v_x_inst_t, y:     v_x_inst_d} 
            store_data, v_y_inst,      data = {x:     v_y_inst_t, y:     v_y_inst_d} 
            store_data, v_z_inst,      data = {x:     v_z_inst_t, y:     v_z_inst_d} 
            store_data, ns_inst,       data = {x:      ns_inst_t, y:      ns_inst_d} 
            store_data, ew_inst,       data = {x:      ew_inst_t, y:      ew_inst_d} 
            store_data, tem_xy_inst,   data = {x:  tem_xy_inst_t, y:  tem_xy_inst_d} 
            store_data, tem_xz_inst,   data = {x:  tem_xz_inst_t, y:  tem_xz_inst_d} 
            store_data, tem_yy_inst,   data = {x:  tem_yy_inst_t, y:  tem_yy_inst_d} 
            store_data, tem_yz_inst,   data = {x:  tem_yz_inst_t, y:  tem_yz_inst_d} 
            store_data, tem_zz_inst,   data = {x:  tem_zz_inst_t, y:  tem_zz_inst_d} 
            store_data, pr_xx_inst,    data = {x:   pr_xx_inst_t, y:   pr_xx_inst_d} 
            store_data, pr_xy_inst,    data = {x:   pr_xy_inst_t, y:   pr_xy_inst_d} 
            store_data, pr_xz_inst,    data = {x:   pr_xz_inst_t, y:   pr_xz_inst_d} 
            store_data, pr_yy_inst,    data = {x:   pr_yy_inst_t, y:   pr_yy_inst_d} 
            store_data, pr_yz_inst,    data = {x:   pr_yz_inst_t, y:   pr_yz_inst_d} 
            store_data, pr_zz_inst,    data = {x:   pr_zz_inst_t, y:   pr_zz_inst_d} 
            store_data, fl_x_inst,     data = {x:    fl_x_inst_t, y:    fl_x_inst_d} 
            store_data, fl_y_inst,     data = {x:    fl_y_inst_t, y:    fl_y_inst_d} 
            store_data, fl_z_inst,     data = {x:    fl_z_inst_t, y:    fl_z_inst_d} 
            store_data, vel_spcrft,    data = {x:   vel_spcrft_t, y:   vel_spcrft_d} 
            store_data, v_x_spcrft,    data = {x:   v_x_spcrft_t, y:   v_x_spcrft_d} 
            store_data, v_y_spcrft,    data = {x:   v_y_spcrft_t, y:   v_y_spcrft_d} 
            store_data, v_z_spcrft,    data = {x:   v_z_spcrft_t, y:   v_z_spcrft_d} 
            store_data, ns_spcrft,     data = {x:    ns_spcrft_t, y:    ns_spcrft_d} 
            store_data, ew_spcrft,     data = {x:    ew_spcrft_t, y:    ew_spcrft_d} 
            store_data, vel_hertn,     data = {x:    vel_hertn_t, y:    vel_hertn_d} 
            store_data, vel_rtn,       data = {x:      vel_rtn_t, y:      vel_rtn_d} 
        ENDIF 
    ENDIF 

ENDFOR


END
