;+
;PROCEDURE: pl_plot_browse_mom
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic browse moments using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_mom: Array of moments wanted for sat A
;              sat_b_mom: Array of moments wanted for sat B
;
;CREATED BY: C. Mouikis
;
;LAST MODIFICATION: 09/20/2007
;
;MODIFICATION HISTORY:
;
;-
PRO pl_plot_browse_mom, sat_moment, HELP = HELP
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

IF KEYWORD_SET(HELP) THEN BEGIN
    PRINT, '- sat_moment: example "A_D"'
    PRINT, '- help = help: show procedure inputs'
    RETURN
ENDIF

sat = STRMID(sat_moment, 0, 1)
mom = STRMID(sat_moment, 2, 1)

satchk = WHERE(sat NE 'A' AND sat NE 'B', csatchk)
IF csatchk GT 0 THEN BEGIN
    err_msg, 'Input string error: SC description string'
ENDIF

momchk = WHERE(mom NE 'D' AND mom NE 'V', cmomchk)
IF cmomchk GT 0 THEN BEGIN
    err_msg, 'Input string error: Moment description string'
ENDIF

; Loop over all sat_moment combinations
FOR ii = 0, N_ELEMENTS(sat_moment)-1 DO BEGIN
    
    get_err_no = 0 & get_err_msg = '' ; reset error indicator
    
    get_pla_browse_mom, sat(ii), mom(ii)
    
    IF get_err_no NE 0 THEN BEGIN
        err_msg, 'No data for product: ' + mom(ii)
    ENDIF
    
ENDFOR


END
