;+
;PROCEDURE: pl_full_rate_peak_from_crib
;
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
; 	Modified by K. Simunac to call procedures for finding peaks in
;	full resolution rate data
;
;	Most recent modification:  18 January, 2008
;-


PRO pl_full_rate_peak_from_crib, sat, time, output_dir, INST_COORD=INST_COORD
compile_opt strictarrsubs

  COMMON get_error, get_err_no, get_err_msg, default_verbose
 
  IF sat EQ 'A' THEN sat_a_rate = ['sf0','ra_trig']
  IF sat EQ 'B' THEN sat_b_rate = ['sf0','ra_trig']

 
  ; Figure out which files we need to read from
  seek_files, 'A', 'science', files_a
  seek_files, 'B', 'science', files_b
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_rate) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_rate) GT 0 THEN print, "No files found for spacecraft B"

 ; Read data, make calculations and plots
  IF num_a_valid_files GT 0 AND n_elements(sat_a_rate) GT 0 THEN $
	find_peak, 'A', files_a, 1, time, output_dir
  IF num_b_valid_files GT 0 AND n_elements(sat_b_rate) GT 0 THEN $
	find_peak, 'B', files_b, 1, time, output_dir

close, /all
END
