; Lorna Ellis
; 04/04/2012
; pl_calc_ew_proton_swx.pro

; This procedure creates Stereo Angle and velocity component
; data in HERTN and RTN. It must be run in the SolarSoft environment. 
; It assumes that calc_proton_bulk.pro has been run so the tplot
; variables exist.

; This version uses the angle from the SW Z>2 L Class 0 without any
; weighting or running average. It uses main channel data and the
; position ratios from Wenyuan.

PRO pl_calc_ew_proton_swz, sat
compile_opt strictarrsubs

; Load the data
;----------------------------------------------------------------
; Kristin's data
stereo_bulk_vel    = 'speed'
stereo_ns          = 'north_south'
num_cycles_10min_v = 'cycles_10min_v'
num_cycles_1hr_v   = 'cycles_1hr_v'
get_data, stereo_bulk_vel,    stereo_bulk_vel_t,    stereo_bulk_vel_d
get_data, stereo_ns,          stereo_ns_t,          stereo_ns_d
get_data, num_cycles_10min_v, num_cycles_10min_v_t, num_cycles_10min_v_d
get_data, num_cycles_1hr_v,   num_cycles_1hr_v_t,   num_cycles_1hr_v_d

; expand timespan by 5 minutes to get beginning of day
get_timespan, ts
start_time = ts[0]-300
stop_time  = ts[1]      ; go forward 5 minutes
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds
ew_toni = 'east_west'
units = 'Counts'
energy = [10, 99900]        ; eV
theta = [-90, 90]
;get_pla_pos_spec, sat, 'sw_z>2_l', 0, units, energy, theta, full_chan = 2;, /roll_eff  ; main only
get_pla_pos_spec, sat, 'sw_z>2_l', 0, units, energy, theta, full_chan = 2, /calib ; main only
temp_string = 'pla_'+sat+'_posspec_sw_z>2_l_cl00_av_phi'
get_data, temp_string, av_phi_t, av_phi_d
get_pla_pos_spec, sat, 'sw_z>2_l', 0, units, energy, theta, full_chan = 2 ; main only
temp_string = 'pla_'+sat+'_posspec_sw_z>2_l_cl00'
get_data, temp_string, swz_t, swz_d
; find uncertainty
uncertainty_d = dblarr(n_elements(swz_t))
FOR jj = 0L, n_elements(swz_t)-1 DO BEGIN 
    max_count = max(swz_d[jj, *], /nan)
    IF max_count LT 2 OR finite(max_count) EQ 0 THEN BEGIN
        av_phi_d     [jj] = !values.f_nan ; throw out when insufficient counts
        uncertainty_d[jj] = !values.f_nan
    ENDIF ELSE BEGIN 
        uncertainty_d[jj] = 100D / sqrt(double(max_count)) ; as percent
    ENDELSE 
ENDFOR 
swz_d = total(swz_d, 2,  /nan)
temp_i = where(swz_d LT 6, count) ; throw out data where insufficient counts
IF count GT 0 THEN av_phi_d[temp_i] = !values.f_nan
ew_source_flag_d = intarr(n_elements(av_phi_t), 2) ; [-1=error (don't know peak or schan), 0=main, 1=schan, 2=mixed],[1=missed peak]
ew_source_flag_d[*, *] = 0 ; temporary
;ew_source_flag_d[*] = -1
;temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_s_chan_esa'
;get_data, temp_string, av_phi_t, schan_i
;temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_peak_esa'
;get_data, temp_string, av_phi_t, peak_i
; set whether from main or schan
;temp_i = where(peak_i EQ -1 OR schan_i EQ -1, count)
;IF count GT 0 THEN av_phi_d[temp_i] = !values.f_nan ; don't know peak of schan switch
;temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i LT (peak_i-5), count) ; in schan
;IF count GT 0 THEN ew_source_flag_d[temp_i, 0] = 1           
;temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i GE (peak_i-5) AND schan_i LE (peak_i+4), count) ; mixed
;IF count GT 0 THEN ew_source_flag_d[temp_i, 0] = 2           
;temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i GT (peak_i+4), count) ; in main
;IF count GT 0 THEN BEGIN
;    ew_source_flag_d[temp_i, 0] = 0
    ; commented out next line now that using run_ave (5/19/2010)
    ;IF array_equal(finite(av_phi_d[temp_i]), 0) NE 1 THEN stop ; should all be NaN
;ENDIF 
; set if we miss the peak
;FOR ii = 0, n_elements(peak_i)-2 DO BEGIN 
;    IF peak_i[ii] NE -1 AND peak_i[ii+1] NE -1 THEN $
;      IF ((peak_i[ii+1] - peak_i[ii]) LT 5 AND (peak_i[ii+1] - peak_i[ii]) GT -6) OR  $
;        (peak_i[ii+1] LT  10 AND peak_i[ii] LT   5) OR $
;        (peak_i[ii+1] GT 117 AND peak_i[ii] GT 123) $
;        THEN ew_source_flag_d[ii, 1] = 0 ELSE ew_source_flag_d[ii, 1] = 1
;ENDFOR 

; return to old timespan
get_timespan, ts
start_time = ts[0]+300
stop_time  = ts[1]      ; go back 5 minutes
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds

; line up times -- only take data where have both times
get_timespan, timespan
timespan_st = time_struct(timespan)
IF timespan_st[0].year EQ timespan_st[1].year THEN num_days = timespan_st[1].doy-timespan_st[0].doy ELSE BEGIN
    CASE 1 OF 
        timespan_st[0].year EQ 2007 AND timespan_st[1].year EQ 2008: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2008 AND timespan_st[1].year EQ 2009: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2009 AND timespan_st[1].year EQ 2010: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2010 AND timespan_st[1].year EQ 2011: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2011 AND timespan_st[1].year EQ 2012: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2012 AND timespan_st[1].year EQ 2013: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2013 AND timespan_st[1].year EQ 2014: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2014 AND timespan_st[1].year EQ 2015: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2015 AND timespan_st[1].year EQ 2016: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2016 AND timespan_st[1].year EQ 2017: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2017 AND timespan_st[1].year EQ 2018: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2018 AND timespan_st[1].year EQ 2019: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2019 AND timespan_st[1].year EQ 2020: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2020 AND timespan_st[1].year EQ 2021: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        ELSE: stop
    ENDCASE
ENDELSE 
new_t                 = dblarr(1441L*num_days)
new_stereo_bulk_vel_d = dblarr(1441L*num_days)
new_stereo_ns_d       = dblarr(1441L*num_days)
new_av_phi_d          = dblarr(1441L*num_days)
new_uncertainty_d     = dblarr(1441L*num_days)
new_ew_source_flag_d  = intarr(1441L*num_days, 2)
new_av_phi_d     [*] = !values.f_nan
new_uncertainty_d[*] = !values.f_nan
ks_i  = 0L
phi_i = 0L
new_i = 0L
av_phi_t =av_phi_t - 150 ; timestamp was at center of 5 minutes
IF (n_elements(stereo_bulk_vel_t) GT 1 OR stereo_bulk_vel_t[0] NE 0) AND $ ; skip if no valid data
  (n_elements(av_phi_t) GT 1 OR av_phi_t[0] NE -150) THEN BEGIN 
    WHILE ks_i LT n_elements(stereo_bulk_vel_t) DO BEGIN
        IF phi_i LT n_elements(av_phi_t) THEN BEGIN 
            IF av_phi_t[phi_i] GE stereo_bulk_vel_t[ks_i] AND av_phi_t[phi_i] LT stereo_bulk_vel_t[ks_i]+60 $
              THEN BEGIN        ; in same minute
                new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
                new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
                new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
                new_ew_source_flag_d [new_i, *] = ew_source_flag_d [phi_i, *]
                IF new_i+4 LT n_elements(new_t) THEN BEGIN 
                    new_av_phi_d     [new_i:new_i+4] = av_phi_d     [phi_i] 
                    new_uncertainty_d[new_i:new_i+4] = uncertainty_d[phi_i]
                ENDIF ELSE BEGIN 
                  new_av_phi_d     [new_i:n_elements(new_t)-1] = av_phi_d     [phi_i]
                  new_uncertainty_d[new_i:n_elements(new_t)-1] = uncertainty_d[phi_i]
              ENDELSE 
                ks_i  = ks_i  + 1
                phi_i = phi_i + 1
                new_i = new_i + 1
            ENDIF ELSE IF av_phi_t[phi_i] LT stereo_bulk_vel_t[ks_i] THEN BEGIN ; skip ks
                phi_i = phi_i + 1
            ENDIF ELSE BEGIN    ; skip av_phi
                new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
                new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
                new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
                new_ew_source_flag_d [new_i, *] = [-1, -1]
                ks_i  = ks_i  + 1
                new_i = new_i + 1
            ENDELSE 
         ENDIF ELSE BEGIN        ; no more phi
            new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
            new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
            new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
            new_ew_source_flag_d [new_i, *] = [-1, -1]
            ks_i  = ks_i  + 1
            new_i = new_i + 1
        ENDELSE 
    ENDWHILE 
    new_t             = new_t                [0:new_i-1]
    stereo_bulk_vel_d = new_stereo_bulk_vel_d[0:new_i-1]
    stereo_ns_d       = new_stereo_ns_d      [0:new_i-1]
    av_phi_d          = new_av_phi_d         [0:new_i-1]
    uncertainty_d     = new_uncertainty_d    [0:new_i-1]
    ew_source_flag_d  = new_ew_source_flag_d [0:new_i-1, *]
    ew_roll_d         = av_phi_d
    uncertainty       = 'uncertainty'
    ew_source_flag    = 'ew_source_flag'
    store_data, uncertainty,    data = {x:new_t, y:uncertainty_d}
    store_data, ew_source_flag, data = {x:new_t, y:ew_source_flag_d}

    bad_i = where(finite(av_phi_d) EQ 0, bad_count)
    IF bad_count GT 0 THEN ew_roll_d[bad_i] = !values.f_nan
    bad_i = where(finite(stereo_bulk_vel_d) EQ 0, bad_count) 
    IF bad_count GT 0 THEN ew_roll_d[bad_i] = !values.f_nan
    bad_i = where(finite(stereo_ns_d)       EQ 0, bad_count) 
    IF bad_count GT 0 THEN ew_roll_d[bad_i] = !values.f_nan

    ew_inst = 'stereo_ew_inst'
    stereo_ew_inst_d = ew_roll_d
    store_data, ew_inst, data = {x: new_t, y: ew_roll_d}

; Unflip ns_instr so coordinate transformation will work
    IF sat EQ 'B' THEN BEGIN
        stereo_ns_d = -1.0 * stereo_ns_d
        ew_roll_d   = -1.0 * ew_roll_d
    ENDIF 

; Turn angles into coordinates
    vx_inst = stereo_bulk_vel_d * cos(stereo_ns_d * !pi / 180) * cos(ew_roll_d * !pi / 180)
    vy_inst = stereo_bulk_vel_d * cos(stereo_ns_d * !pi / 180) * sin(ew_roll_d * !pi / 180)
    vz_inst = stereo_bulk_vel_d * sin(stereo_ns_d * !pi / 180)

; Change to spacecraft coordinates
    stereo_vel_d = dblarr(3, n_elements(stereo_ns_d))
    stereo_vel_d[0, *] = (-1.0) * vx_inst
    stereo_vel_d[1, *] = vz_inst
    stereo_vel_d[2, *] = (-1.0) * vy_inst

; Put in HERTN
    num_records = n_elements(new_t)
    temp_time = time_string(new_t)
    strput, temp_time, 'T', 10  ; change time string format for SolarSoft
    stereo_vel_hertn_d = dblarr(3, num_records)
    cmat_hertn = get_stereo_cmat(temp_time, sat, system = 'hertn')
    FOR ii = 0, num_records-1 DO BEGIN
        temp_vel = reform(stereo_vel_d[*, ii])
        temp_cmat = reform(cmat_hertn[*, *, ii])
        stereo_vel_hertn_d[*, ii] = temp_cmat # temp_vel
    ENDFOR 
; Put in RTN
    stereo_vel_rtn_d = dblarr(3, num_records)
    cmat_rtn = get_stereo_cmat(temp_time, sat, system = 'rtn')
    FOR ii = 0, num_records-1 DO BEGIN
        temp_vel = reform(stereo_vel_d[*, ii])
        temp_cmat = reform(cmat_rtn[*, *, ii])
        stereo_vel_rtn_d[*, ii] = temp_cmat # temp_vel
    ENDFOR 
 ; Put in GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN
        stereo_vel_gse_d = dblarr(3, num_records)
        cmat_gse = get_stereo_cmat(temp_time, sat, system = 'gse')
        FOR ii = 0, num_records-1 DO BEGIN
            temp_vel = reform(stereo_vel_d[*, ii])
            temp_cmat = reform(cmat_gse[*, *, ii])
            stereo_vel_gse_d[*, ii] = temp_cmat # temp_vel
        ENDFOR 
    ENDIF 

; Add abberration
; HERTN
    state = get_stereo_coord(temp_time, sat, system = 'hci')
    spcrft_vel = state[3:5, *]
    convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'hertn', spacecraft = sat
    stereo_vel_hertn_d = stereo_vel_hertn_d + spcrft_vel
; RTN
    state = get_stereo_coord(temp_time, sat, system = 'hci')
    spcrft_vel = state[3:5, *]
    convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'rtn', spacecraft = sat, /ignore_origin
    stereo_vel_rtn_d = stereo_vel_rtn_d + spcrft_vel
 ; GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN
        state = get_stereo_coord(temp_time, sat, system = 'hci')
        spcrft_vel = state[3:5, *]
        convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'gse', spacecraft = sat, /ignore_origin
        stereo_vel_gse_d = stereo_vel_gse_d + spcrft_vel
    ENDIF 

; Create flow angles and bulk vel from HERTN data
    temp_vr = reform(stereo_vel_hertn_d[0, *])
    temp_vt = reform(stereo_vel_hertn_d[1, *])
    temp_vn = reform(stereo_vel_hertn_d[2, *])
    stereo_ew_hertn_d = atan(temp_vt / temp_vr) * 180 / !pi
    stereo_ns_hertn_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
; Create flow angles and bulk vel from RTN data
    temp_vr = reform(stereo_vel_rtn_d[0, *])
    temp_vt = reform(stereo_vel_rtn_d[1, *])
    temp_vn = reform(stereo_vel_rtn_d[2, *])
    stereo_ew_rtn_d = atan(temp_vt / temp_vr) * 180 / !pi
    stereo_ns_rtn_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
; Create flow angles and bulk vel from GSE data
    IF keyword_set(gse) EQ 1 THEN BEGIN    
        temp_vr = reform(stereo_vel_gse_d[0, *])
        temp_vt = reform(stereo_vel_gse_d[1, *])
        temp_vn = reform(stereo_vel_gse_d[2, *])
        stereo_ew_gse_d = atan(temp_vt / temp_vr) * 180 / !pi
        stereo_ns_gse_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
    ENDIF 

; Store data
; HERTN
    stereo_vr_hertn = 'stereo_vr_hertn'
    stereo_vt_hertn = 'stereo_vt_hertn'
    stereo_vn_hertn = 'stereo_vn_hertn'
    stereo_ew_hertn = 'stereo_ew_hertn'
    stereo_ns_hertn = 'stereo_ns_hertn'
    stereo_vr_hertn_d = reform(stereo_vel_hertn_d[0, *])
    stereo_vt_hertn_d = reform(stereo_vel_hertn_d[1, *])
    stereo_vn_hertn_d = reform(stereo_vel_hertn_d[2, *])
    store_data, stereo_vr_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[0, *])}
    store_data, stereo_vt_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[1, *])}
    store_data, stereo_vn_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[2, *])}
    store_data, stereo_ew_hertn, data = {x:new_t, y:stereo_ew_hertn_d}
    store_data, stereo_ns_hertn, data = {x:new_t, y:stereo_ns_hertn_d}
; RTN
    stereo_vr_rtn = 'stereo_vr_rtn'
    stereo_vt_rtn = 'stereo_vt_rtn'
    stereo_vn_rtn = 'stereo_vn_rtn'
    stereo_ew_rtn = 'stereo_ew_rtn'
    stereo_ns_rtn = 'stereo_ns_rtn'
    stereo_vr_rtn_d = reform(stereo_vel_rtn_d[0, *])
    stereo_vt_rtn_d = reform(stereo_vel_rtn_d[1, *])
    stereo_vn_rtn_d = reform(stereo_vel_rtn_d[2, *])
    store_data, stereo_vr_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[0, *])}
    store_data, stereo_vt_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[1, *])}
    store_data, stereo_vn_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[2, *])}
    store_data, stereo_ew_rtn,    data = {x:new_t, y:stereo_ew_rtn_d}
    store_data, stereo_ns_rtn,    data = {x:new_t, y:stereo_ns_rtn_d}
; GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN    
        stereo_vr_gse = 'stereo_vr_gse'
        stereo_vt_gse = 'stereo_vt_gse'
        stereo_vn_gse = 'stereo_vn_gse'
        stereo_ew_gse = 'stereo_ew_gse'
        stereo_ns_gse = 'stereo_ns_gse'
        stereo_vr_gse_d = reform(stereo_vel_gse_d[0, *])
        stereo_vt_gse_d = reform(stereo_vel_gse_d[1, *])
        stereo_vn_gse_d = reform(stereo_vel_gse_d[2, *])
        store_data, stereo_vr_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[0, *])}
        store_data, stereo_vt_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[1, *])}
        store_data, stereo_vn_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[2, *])}
        store_data, stereo_ew_gse,    data = {x:new_t, y:stereo_ew_gse_d}
        store_data, stereo_ns_gse,    data = {x:new_t, y:stereo_ns_gse_d}
    ENDIF 

; calculate 10 min averages
    new_st = time_struct(new_t)
    start_year = timespan_st[0].year
    start_doy = timespan_st[0].doy
    num_records = num_days*24*6
    num_count_10min             = 'num_in_ave_10min'
    ew_source_flag_10min        = 'ew_source_flag_10min'
    uncertainty_10min           = 'uncertainty_10min'
    stereo_ew_inst_10min        = 'stereo_ew_inst_10min'
    stereo_vr_hertn_10min       = 'stereo_vr_hertn_10min'
    stereo_vt_hertn_10min       = 'stereo_vt_hertn_10min'
    stereo_vn_hertn_10min       = 'stereo_vn_hertn_10min'
    stereo_ew_hertn_10min       = 'stereo_ew_hertn_10min'
    stereo_ns_hertn_10min       = 'stereo_ns_hertn_10min'
    stereo_vr_rtn_10min         = 'stereo_vr_rtn_10min'
    stereo_vt_rtn_10min         = 'stereo_vt_rtn_10min'
    stereo_vn_rtn_10min         = 'stereo_vn_rtn_10min'
    stereo_ew_rtn_10min         = 'stereo_ew_rtn_10min'
    stereo_ns_rtn_10min         = 'stereo_ns_rtn_10min'
    ten_min_t                       = dblarr(num_records)
    ten_min_ew_source_flag_d        = intarr(num_records, 2)
    ten_min_uncertainty_d           = dblarr(num_records)
    ten_min_stereo_ew_inst_d        = dblarr(num_records) 
    ten_min_stereo_vr_hertn_d       = dblarr(num_records)
    ten_min_stereo_vt_hertn_d       = dblarr(num_records)
    ten_min_stereo_vn_hertn_d       = dblarr(num_records)
    ten_min_stereo_ew_hertn_d       = dblarr(num_records) 
    ten_min_stereo_ns_hertn_d       = dblarr(num_records)
    ten_min_stereo_vr_rtn_d         = dblarr(num_records)
    ten_min_stereo_vt_rtn_d         = dblarr(num_records)
    ten_min_stereo_vn_rtn_d         = dblarr(num_records)
    ten_min_stereo_ew_rtn_d         = dblarr(num_records)
    ten_min_stereo_ns_rtn_d         = dblarr(num_records)
    ten_min_num_count_d             = dblarr(num_records)
    ten_min_ew_source_flag_d[*]        = -1
    ten_min_uncertainty_d[*]           = !values.f_nan
    ten_min_stereo_ew_inst_d[*]        = !values.f_nan 
    ten_min_stereo_vr_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vt_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vn_hertn_d[*]       = !values.f_nan
    ten_min_stereo_ew_hertn_d[*]       = !values.f_nan 
    ten_min_stereo_ns_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vr_rtn_d[*]         = !values.f_nan
    ten_min_stereo_vt_rtn_d[*]         = !values.f_nan
    ten_min_stereo_vn_rtn_d[*]         = !values.f_nan
    ten_min_stereo_ew_rtn_d[*]         = !values.f_nan
    ten_min_stereo_ns_rtn_d[*]         = !values.f_nan
    ten_min_num_count_d[*]             = 0
    ten_min_i = 0               ; index into ten_min products
    FOR ii = 0, num_days-1 DO BEGIN ; days 
        FOR jj = 0, 23 DO BEGIN ; hours
            FOR kk = 0, 5 DO BEGIN ; minutes
                wanted_i = where(new_st.year EQ start_year AND new_st.doy EQ (ii+start_doy) AND $
                                 new_st.hour EQ jj AND new_st.min GE (kk*10) AND new_st.min LT ((kk+1)*10), count)
                have_data = 1
                IF count GT 0 THEN BEGIN ; have times
                    ;doy_to_month_date, start_year, (ii+start_doy), month, date
                    ;ten_min_t[ten_min_i] = time_double(string(start_year, format = '(I4.4)')+'-'+$
                    ;                                   string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+$
                    ;                                   '/'+string(jj, format = '(I2.2)')+':'+string((kk*10), format = '(I2.2)')+':00')
                    IF array_equal(ew_source_flag_d[wanted_i, 0], 0) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 2) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 2 $
                              ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], -1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = -1 $
                                   ELSE ten_min_ew_source_flag_d[ten_min_i, 0] = 3
                    IF array_equal(ew_source_flag_d[wanted_i, 1], 0) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], 1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], -1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = -1 $
                              ELSE ten_min_ew_source_flag_d[ten_min_i, 1] = 2
                    ten_min_uncertainty_d[ten_min_i] = max(uncertainty_d[wanted_i], /nan)
                    new_t_i              = where(finite(new_t               [wanted_i]) EQ 1, new_t_count)
                    stereo_ew_inst_i     = where(finite(stereo_ew_inst_d    [wanted_i]) EQ 1, stereo_ew_inst_count)
                    stereo_vr_hertn_i    = where(finite(stereo_vr_hertn_d   [wanted_i]) EQ 1, stereo_vr_hertn_count)
                    stereo_vt_hertn_i    = where(finite(stereo_vt_hertn_d   [wanted_i]) EQ 1, stereo_vt_hertn_count)
                    stereo_vn_hertn_i    = where(finite(stereo_vn_hertn_d   [wanted_i]) EQ 1, stereo_vn_hertn_count)
                    stereo_ew_hertn_i    = where(finite(stereo_ew_hertn_d   [wanted_i]) EQ 1, stereo_ew_hertn_count)
                    stereo_ns_hertn_i    = where(finite(stereo_ns_hertn_d   [wanted_i]) EQ 1, stereo_ns_hertn_count)
                    stereo_vr_rtn_i      = where(finite(stereo_vr_rtn_d     [wanted_i]) EQ 1, stereo_vr_rtn_count)
                    stereo_vt_rtn_i      = where(finite(stereo_vt_rtn_d     [wanted_i]) EQ 1, stereo_vt_rtn_count)
                    stereo_vn_rtn_i      = where(finite(stereo_vn_rtn_d     [wanted_i]) EQ 1, stereo_vn_rtn_count)
                    stereo_ew_rtn_i      = where(finite(stereo_ew_rtn_d     [wanted_i]) EQ 1, stereo_ew_rtn_count)
                    stereo_ns_rtn_i      = where(finite(stereo_ns_rtn_d     [wanted_i]) EQ 1, stereo_ns_rtn_count)
                    IF stereo_vr_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vr_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_rtn_count   NE stereo_ew_inst_count THEN stop
                    ten_min_t                      [ten_min_i] = new_t                      [wanted_i[new_t_i[0]      ]]
                    IF stereo_ew_inst_count EQ 0 THEN $
                      ten_min_stereo_ew_inst_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_inst_count EQ 1 THEN $
                      ten_min_stereo_ew_inst_d     [ten_min_i] = stereo_ew_inst_d          [wanted_i[stereo_ew_inst_i]] ELSE BEGIN 
                        mom_ew_inst                            = moment(stereo_ew_inst_d   [wanted_i], /nan)
                        ten_min_stereo_ew_inst_d   [ten_min_i] = mom_ew_inst               [0]
                    ENDELSE 
                    IF stereo_vr_hertn_count EQ 0 THEN $
                      ten_min_stereo_vr_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vr_hertn_count EQ 1 THEN $
                      ten_min_stereo_vr_hertn_d     [ten_min_i] = stereo_vr_hertn_d          [wanted_i[stereo_vr_hertn_i]] ELSE BEGIN 
                        mom_vr_hertn                            = moment(stereo_vr_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vr_hertn_d   [ten_min_i] = mom_vr_hertn               [0]
                    ENDELSE 
                    IF stereo_vt_hertn_count EQ 0 THEN $
                      ten_min_stereo_vt_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vt_hertn_count EQ 1 THEN $
                      ten_min_stereo_vt_hertn_d     [ten_min_i] = stereo_vt_hertn_d          [wanted_i[stereo_vt_hertn_i]] ELSE BEGIN 
                        mom_vt_hertn                            = moment(stereo_vt_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vt_hertn_d   [ten_min_i] = mom_vt_hertn               [0]
                    ENDELSE 
                    IF stereo_vn_hertn_count EQ 0 THEN $
                      ten_min_stereo_vn_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vn_hertn_count EQ 1 THEN $
                      ten_min_stereo_vn_hertn_d     [ten_min_i] = stereo_vn_hertn_d          [wanted_i[stereo_vn_hertn_i]] ELSE BEGIN 
                        mom_vn_hertn                            = moment(stereo_vn_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vn_hertn_d   [ten_min_i] = mom_vn_hertn               [0]
                    ENDELSE 
                    IF stereo_ew_hertn_count EQ 0 THEN $
                      ten_min_stereo_ew_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_hertn_count EQ 1 THEN $
                      ten_min_stereo_ew_hertn_d     [ten_min_i] = stereo_ew_hertn_d          [wanted_i[stereo_ew_hertn_i]] ELSE BEGIN 
                        mom_ew_hertn                            = moment(stereo_ew_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_ew_hertn_d   [ten_min_i] = mom_ew_hertn               [0]
                    ENDELSE 
                    IF stereo_ns_hertn_count EQ 0 THEN $
                      ten_min_stereo_ns_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ns_hertn_count EQ 1 THEN $
                      ten_min_stereo_ns_hertn_d     [ten_min_i] = stereo_ns_hertn_d          [wanted_i[stereo_ns_hertn_i]] ELSE BEGIN 
                        mom_ns_hertn                            = moment(stereo_ns_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_ns_hertn_d   [ten_min_i] = mom_ns_hertn               [0]
                    ENDELSE 
                    IF stereo_vr_rtn_count EQ 0 THEN $
                      ten_min_stereo_vr_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vr_rtn_count EQ 1 THEN $
                      ten_min_stereo_vr_rtn_d       [ten_min_i] = stereo_vr_rtn_d            [wanted_i[stereo_vr_rtn_i]] ELSE BEGIN 
                        mom_vr_rtn                              = moment(stereo_vr_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vr_rtn_d     [ten_min_i] = mom_vr_rtn                 [0]
                    ENDELSE 
                    IF stereo_vt_rtn_count EQ 0 THEN $
                      ten_min_stereo_vt_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vt_rtn_count EQ 1 THEN $
                      ten_min_stereo_vt_rtn_d       [ten_min_i] = stereo_vt_rtn_d            [wanted_i[stereo_vt_rtn_i]] ELSE BEGIN 
                        mom_vt_rtn                              = moment(stereo_vt_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vt_rtn_d     [ten_min_i] = mom_vt_rtn                 [0]
                    ENDELSE 
                    IF stereo_vn_rtn_count EQ 0 THEN $
                      ten_min_stereo_vn_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vn_rtn_count EQ 1 THEN $
                      ten_min_stereo_vn_rtn_d       [ten_min_i] = stereo_vn_rtn_d            [wanted_i[stereo_vn_rtn_i]] ELSE BEGIN 
                        mom_vn_rtn                              = moment(stereo_vn_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vn_rtn_d     [ten_min_i] = mom_vn_rtn                 [0]
                    ENDELSE 
                    IF stereo_ew_rtn_count EQ 0 THEN $
                      ten_min_stereo_ew_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_rtn_count EQ 1 THEN $
                      ten_min_stereo_ew_rtn_d       [ten_min_i] = stereo_ew_rtn_d            [wanted_i[stereo_ew_rtn_i]] ELSE BEGIN 
                        mom_ew_rtn                              = moment(stereo_ew_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_ew_rtn_d     [ten_min_i] = mom_ew_rtn                 [0]
                    ENDELSE 
                    IF stereo_ns_rtn_count EQ 0 THEN $
                      ten_min_stereo_ns_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ns_rtn_count EQ 1 THEN $
                      ten_min_stereo_ns_rtn_d       [ten_min_i] = stereo_ns_rtn_d            [wanted_i[stereo_ns_rtn_i]] ELSE BEGIN 
                        mom_ns_rtn                              = moment(stereo_ns_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_ns_rtn_d     [ten_min_i] = mom_ns_rtn                 [0]
                    ENDELSE 
                    ten_min_num_count_d             [ten_min_i] = stereo_ew_hertn_count
                    ten_min_i = ten_min_i + 1
                ENDIF 
            ENDFOR
        ENDFOR
    ENDFOR 
    IF ten_min_i LT num_records THEN BEGIN 
        ten_min_t                       = ten_min_t                      [0:ten_min_i-1]
        ten_min_ew_source_flag_d        = ten_min_ew_source_flag_d       [0:ten_min_i-1, *]
        ten_min_uncertainty_d           = ten_min_uncertainty_d          [0:ten_min_i-1]
        ten_min_num_count_d             = ten_min_num_count_d            [0:ten_min_i-1]
        ten_min_stereo_ew_inst_d        = ten_min_stereo_ew_inst_d       [0:ten_min_i-1]
        ten_min_stereo_vr_hertn_d       = ten_min_stereo_vr_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vt_hertn_d       = ten_min_stereo_vt_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vn_hertn_d       = ten_min_stereo_vn_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_ew_hertn_d       = ten_min_stereo_ew_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_ns_hertn_d       = ten_min_stereo_ns_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vr_rtn_d         = ten_min_stereo_vr_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_vt_rtn_d         = ten_min_stereo_vt_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_vn_rtn_d         = ten_min_stereo_vn_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_ew_rtn_d         = ten_min_stereo_ew_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_ns_rtn_d         = ten_min_stereo_ns_rtn_d        [0:ten_min_i-1]
    ENDIF 
    store_data, num_count_10min,             data = {x:ten_min_t, y:ten_min_num_count_d}
    store_data, ew_source_flag_10min,        data = {x:ten_min_t, y:ten_min_ew_source_flag_d}
    store_data, uncertainty_10min,           data = {x:ten_min_t, y:ten_min_uncertainty_d}
    store_data, stereo_ew_inst_10min,        data = {x:ten_min_t, y:ten_min_stereo_ew_inst_d}
    store_data, stereo_vr_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vr_hertn_d}
    store_data, stereo_vt_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vt_hertn_d}
    store_data, stereo_vn_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vn_hertn_d}
    store_data, stereo_ew_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_ew_hertn_d}
    store_data, stereo_ns_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_ns_hertn_d}
    store_data, stereo_vr_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vr_rtn_d}
    store_data, stereo_vt_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vt_rtn_d}
    store_data, stereo_vn_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vn_rtn_d}
    store_data, stereo_ew_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_ew_rtn_d}
    store_data, stereo_ns_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_ns_rtn_d}

; calculate 1 hr averages
    num_records = num_days*24
    num_count_1hr             = 'num_in_ave_1hr'
    ew_source_flag_1hr        = 'ew_source_flag_1hr'
    uncertainty_1hr           = 'uncertainty_1hr'
    stereo_ew_inst_1hr        = 'stereo_ew_inst_1hr'
    stereo_vr_hertn_1hr       = 'stereo_vr_hertn_1hr'
    stereo_vt_hertn_1hr       = 'stereo_vt_hertn_1hr'
    stereo_vn_hertn_1hr       = 'stereo_vn_hertn_1hr'
    stereo_ew_hertn_1hr       = 'stereo_ew_hertn_1hr'
    stereo_ns_hertn_1hr       = 'stereo_ns_hertn_1hr'
    stereo_vr_rtn_1hr         = 'stereo_vr_rtn_1hr'
    stereo_vt_rtn_1hr         = 'stereo_vt_rtn_1hr'
    stereo_vn_rtn_1hr         = 'stereo_vn_rtn_1hr'
    stereo_ew_rtn_1hr         = 'stereo_ew_rtn_1hr'
    stereo_ns_rtn_1hr         = 'stereo_ns_rtn_1hr'
    hour_t                       = dblarr(num_records)
    hour_ew_source_flag_d        = intarr(num_records, 2) ; source, flag-if-miss-peak
    hour_uncertainty_d           = dblarr(num_records)
    hour_stereo_ew_inst_d        = dblarr(num_records) 
    hour_stereo_vr_hertn_d       = dblarr(num_records)
    hour_stereo_vt_hertn_d       = dblarr(num_records)
    hour_stereo_vn_hertn_d       = dblarr(num_records)
    hour_stereo_ew_hertn_d       = dblarr(num_records) 
    hour_stereo_ns_hertn_d       = dblarr(num_records)
    hour_stereo_vr_rtn_d         = dblarr(num_records)
    hour_stereo_vt_rtn_d         = dblarr(num_records)
    hour_stereo_vn_rtn_d         = dblarr(num_records)
    hour_stereo_ew_rtn_d         = dblarr(num_records)
    hour_stereo_ns_rtn_d         = dblarr(num_records)
    hour_num_count_d             = dblarr(num_records)
    hour_ew_source_flag_d[*]        = -1
    hour_uncertainty_d[*]           = !values.f_nan
    hour_stereo_ew_inst_d[*]        = !values.f_nan 
    hour_stereo_vr_hertn_d[*]       = !values.f_nan
    hour_stereo_vt_hertn_d[*]       = !values.f_nan
    hour_stereo_vn_hertn_d[*]       = !values.f_nan
    hour_stereo_ew_hertn_d[*]       = !values.f_nan 
    hour_stereo_ns_hertn_d[*]       = !values.f_nan
    hour_stereo_vr_rtn_d[*]         = !values.f_nan
    hour_stereo_vt_rtn_d[*]         = !values.f_nan
    hour_stereo_vn_rtn_d[*]         = !values.f_nan
    hour_stereo_ew_rtn_d[*]         = !values.f_nan
    hour_stereo_ns_rtn_d[*]         = !values.f_nan
    hour_num_count_d[*]             = 0
    hour_i = 0                  ; index into hour products
    FOR ii = 0, num_days-1 DO BEGIN ; days 
        FOR jj = 0, 23 DO BEGIN ; hours
            wanted_i = where(new_st.year EQ start_year AND new_st.doy EQ (ii+start_doy) AND $
                             new_st.hour EQ jj, count)
            have_data = 1
            IF count GT 0 THEN BEGIN ; have times
                ;doy_to_month_date, start_year, (ii+start_doy), month, date
                ;hour_t[hour_i] = time_double(string(start_year, format = '(I4.4)')+$
                ;                             '-'+string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+$
                ;                             '/'+string(jj, format = '(I2.2)')+':00:00')
                IF count GT 0 THEN BEGIN ; have valid data
                    IF array_equal(ew_source_flag_d[wanted_i, 0], 0) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 2) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 2 $
                              ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], -1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = -1 $
                                   ELSE hour_ew_source_flag_d[hour_i, 0] = 3
                    IF array_equal(ew_source_flag_d[wanted_i, 1], 0) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], 1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], -1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = -1 $
                              ELSE hour_ew_source_flag_d[hour_i, 1] = 2
                    hour_uncertainty_d[hour_i] = max(uncertainty_d[wanted_i], /nan)
                    new_t_i              = where(finite(new_t               [wanted_i]) EQ 1, new_t_count)
                    stereo_ew_inst_i     = where(finite(stereo_ew_inst_d    [wanted_i]) EQ 1, stereo_ew_inst_count)
                    stereo_vr_hertn_i    = where(finite(stereo_vr_hertn_d   [wanted_i]) EQ 1, stereo_vr_hertn_count)
                    stereo_vt_hertn_i    = where(finite(stereo_vt_hertn_d   [wanted_i]) EQ 1, stereo_vt_hertn_count)
                    stereo_vn_hertn_i    = where(finite(stereo_vn_hertn_d   [wanted_i]) EQ 1, stereo_vn_hertn_count)
                    stereo_ew_hertn_i    = where(finite(stereo_ew_hertn_d   [wanted_i]) EQ 1, stereo_ew_hertn_count)
                    stereo_ns_hertn_i    = where(finite(stereo_ns_hertn_d   [wanted_i]) EQ 1, stereo_ns_hertn_count)
                    stereo_vr_rtn_i      = where(finite(stereo_vr_rtn_d     [wanted_i]) EQ 1, stereo_vr_rtn_count)
                    stereo_vt_rtn_i      = where(finite(stereo_vt_rtn_d     [wanted_i]) EQ 1, stereo_vt_rtn_count)
                    stereo_vn_rtn_i      = where(finite(stereo_vn_rtn_d     [wanted_i]) EQ 1, stereo_vn_rtn_count)
                    stereo_ew_rtn_i      = where(finite(stereo_ew_rtn_d     [wanted_i]) EQ 1, stereo_ew_rtn_count)
                    stereo_ns_rtn_i      = where(finite(stereo_ns_rtn_d     [wanted_i]) EQ 1, stereo_ns_rtn_count)
                    IF stereo_vr_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vr_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_rtn_count   NE stereo_ew_inst_count THEN stop
                    hour_t                       [hour_i] = new_t                      [wanted_i[new_t_i[0]      ]]
                    IF stereo_ew_inst_count EQ 0 THEN $
                      hour_stereo_ew_inst_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_inst_count EQ 1 THEN $
                      hour_stereo_ew_inst_d      [hour_i] = stereo_ew_inst_d           [wanted_i[stereo_ew_inst_i]] ELSE BEGIN 
                        mom_ew_inst                       = moment(stereo_ew_inst_d    [wanted_i], /nan)
                        hour_stereo_ew_inst_d    [hour_i] = mom_ew_inst                [0]
                    ENDELSE 
                    IF stereo_vr_hertn_count EQ 0 THEN $
                      hour_stereo_vr_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vr_hertn_count EQ 1 THEN $
                      hour_stereo_vr_hertn_d     [hour_i] = stereo_vr_hertn_d          [wanted_i[stereo_vr_hertn_i]] ELSE BEGIN 
                        mom_vr_hertn                      = moment(stereo_vr_hertn_d   [wanted_i], /nan)
                        hour_stereo_vr_hertn_d   [hour_i] = mom_vr_hertn               [0]
                    ENDELSE 
                    IF stereo_vt_hertn_count EQ 0 THEN $
                      hour_stereo_vt_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vt_hertn_count EQ 1 THEN $
                      hour_stereo_vt_hertn_d     [hour_i] = stereo_vt_hertn_d          [wanted_i[stereo_vt_hertn_i]] ELSE BEGIN 
                        mom_vt_hertn                      = moment(stereo_vt_hertn_d   [wanted_i], /nan)
                        hour_stereo_vt_hertn_d   [hour_i] = mom_vt_hertn               [0]
                    ENDELSE 
                    IF stereo_vn_hertn_count EQ 0 THEN $
                      hour_stereo_vn_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vn_hertn_count EQ 1 THEN $
                      hour_stereo_vn_hertn_d     [hour_i] = stereo_vn_hertn_d          [wanted_i[stereo_vn_hertn_i]] ELSE BEGIN 
                        mom_vn_hertn                      = moment(stereo_vn_hertn_d   [wanted_i], /nan)
                        hour_stereo_vn_hertn_d   [hour_i] = mom_vn_hertn               [0]
                    ENDELSE 
                    IF stereo_ew_hertn_count EQ 0 THEN $
                      hour_stereo_ew_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_hertn_count EQ 1 THEN $
                      hour_stereo_ew_hertn_d     [hour_i] = stereo_ew_hertn_d          [wanted_i[stereo_ew_hertn_i]] ELSE BEGIN 
                        mom_ew_hertn                      = moment(stereo_ew_hertn_d   [wanted_i], /nan)
                        hour_stereo_ew_hertn_d   [hour_i] = mom_ew_hertn               [0]
                    ENDELSE 
                    IF stereo_ns_hertn_count EQ 0 THEN $
                      hour_stereo_ns_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ns_hertn_count EQ 1 THEN $
                      hour_stereo_ns_hertn_d     [hour_i] = stereo_ns_hertn_d          [wanted_i[stereo_ns_hertn_i]] ELSE BEGIN 
                        mom_ns_hertn                      = moment(stereo_ns_hertn_d   [wanted_i], /nan)
                        hour_stereo_ns_hertn_d   [hour_i] = mom_ns_hertn               [0]
                    ENDELSE 
                    IF stereo_vr_rtn_count EQ 0 THEN $
                      hour_stereo_vr_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vr_rtn_count EQ 1 THEN $
                      hour_stereo_vr_rtn_d       [hour_i] = stereo_vr_rtn_d            [wanted_i[stereo_vr_rtn_i]] ELSE BEGIN 
                        mom_vr_rtn                        = moment(stereo_vr_rtn_d     [wanted_i], /nan)
                        hour_stereo_vr_rtn_d     [hour_i] = mom_vr_rtn                 [0]
                    ENDELSE 
                    IF stereo_vt_rtn_count EQ 0 THEN $
                      hour_stereo_vt_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vt_rtn_count EQ 1 THEN $
                      hour_stereo_vt_rtn_d       [hour_i] = stereo_vt_rtn_d            [wanted_i[stereo_vt_rtn_i]] ELSE BEGIN 
                        mom_vt_rtn                        = moment(stereo_vt_rtn_d     [wanted_i], /nan)
                        hour_stereo_vt_rtn_d     [hour_i] = mom_vt_rtn                 [0]
                    ENDELSE 
                    IF stereo_vn_rtn_count EQ 0 THEN $
                      hour_stereo_vn_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vn_rtn_count EQ 1 THEN $
                      hour_stereo_vn_rtn_d       [hour_i] = stereo_vn_rtn_d            [wanted_i[stereo_vn_rtn_i]] ELSE BEGIN 
                        mom_vn_rtn                        = moment(stereo_vn_rtn_d     [wanted_i], /nan)
                        hour_stereo_vn_rtn_d     [hour_i] = mom_vn_rtn                 [0]
                    ENDELSE 
                    IF stereo_ew_rtn_count EQ 0 THEN $
                      hour_stereo_ew_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_rtn_count EQ 1 THEN $
                      hour_stereo_ew_rtn_d       [hour_i] = stereo_ew_rtn_d            [wanted_i[stereo_ew_rtn_i]] ELSE BEGIN 
                        mom_ew_rtn                        = moment(stereo_ew_rtn_d     [wanted_i], /nan)
                        hour_stereo_ew_rtn_d     [hour_i] = mom_ew_rtn                 [0]
                    ENDELSE 
                    IF stereo_ns_rtn_count EQ 0 THEN $
                      hour_stereo_ns_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ns_rtn_count EQ 1 THEN $
                      hour_stereo_ns_rtn_d       [hour_i] = stereo_ns_rtn_d            [wanted_i[stereo_ns_rtn_i]] ELSE BEGIN 
                        mom_ns_rtn                        = moment(stereo_ns_rtn_d     [wanted_i], /nan)
                        hour_stereo_ns_rtn_d     [hour_i] = mom_ns_rtn                 [0]
                    ENDELSE 
                    hour_num_count_d            [hour_i] = stereo_ew_inst_count
                ENDIF 
                hour_i = hour_i + 1
            ENDIF 
        ENDFOR 
    ENDFOR 
    IF hour_i LT num_records THEN BEGIN 
        hour_t                       = hour_t                      [0:hour_i-1]
        hour_ew_source_flag_d        = hour_ew_source_flag_d       [0:hour_i-1, *]
        hour_uncertainty_d           = hour_uncertainty_d          [0:hour_i-1]
        hour_num_count_d             = hour_num_count_d            [0:hour_i-1]
        hour_stereo_ew_inst_d        = hour_stereo_ew_inst_d       [0:hour_i-1]
        hour_stereo_vr_hertn_d       = hour_stereo_vr_hertn_d      [0:hour_i-1]
        hour_stereo_vt_hertn_d       = hour_stereo_vt_hertn_d      [0:hour_i-1]
        hour_stereo_vn_hertn_d       = hour_stereo_vn_hertn_d      [0:hour_i-1]
        hour_stereo_ew_hertn_d       = hour_stereo_ew_hertn_d      [0:hour_i-1]
        hour_stereo_ns_hertn_d       = hour_stereo_ns_hertn_d      [0:hour_i-1]
        hour_stereo_vr_rtn_d         = hour_stereo_vr_rtn_d        [0:hour_i-1]
        hour_stereo_vt_rtn_d         = hour_stereo_vt_rtn_d        [0:hour_i-1]
        hour_stereo_vn_rtn_d         = hour_stereo_vn_rtn_d        [0:hour_i-1]
        hour_stereo_ew_rtn_d         = hour_stereo_ew_rtn_d        [0:hour_i-1]
        hour_stereo_ns_rtn_d         = hour_stereo_ns_rtn_d        [0:hour_i-1]
    ENDIF 
    store_data, num_count_1hr,             data = {x:hour_t, y:hour_num_count_d}
    store_data, ew_source_flag_1hr,        data = {x:hour_t, y:hour_ew_source_flag_d}
    store_data, uncertainty_1hr,           data = {x:hour_t, y:hour_uncertainty_d}
    store_data, stereo_ew_inst_1hr,        data = {x:hour_t, y:hour_stereo_ew_inst_d}
    store_data, stereo_vr_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vr_hertn_d}
    store_data, stereo_vt_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vt_hertn_d}
    store_data, stereo_vn_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vn_hertn_d}
    store_data, stereo_ew_hertn_1hr,       data = {x:hour_t, y:hour_stereo_ew_hertn_d}
    store_data, stereo_ns_hertn_1hr,       data = {x:hour_t, y:hour_stereo_ns_hertn_d}
    store_data, stereo_vr_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vr_rtn_d}
    store_data, stereo_vt_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vt_rtn_d}
    store_data, stereo_vn_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vn_rtn_d}
    store_data, stereo_ew_rtn_1hr,         data = {x:hour_t, y:hour_stereo_ew_rtn_d}
    store_data, stereo_ns_rtn_1hr,         data = {x:hour_t, y:hour_stereo_ns_rtn_d}
ENDIF 
END 
