; Lorna Ellis
; 02/22/2009
; pl_calc_ew_proton.pro

; This procedure creates Stereo Angle and velocity component
; data in HERTN and RTN. It must be run in the SolarSoft environment. 
; It assumes that calc_proton_bulk.pro has been run so the tplot
; variables exist.

; 03/09/2009 Put in blank record when have bulk vel but no av_phi.
; 03/12/2009 Check for no valid data. Update for 2009.
; 03/17/2009 Added cos(ns) term when creating vx and vy.
; 03/18/2009 Added ew_inst
; 03/25/2009 Changed checks on averaging.
; 04/15/2009 Added gse flag (prints ascii files in gse).
; 05/07/2009 Keep NaN after smoothing.
; 05/12/2009 Fixed bug in getting components (108->180)
; 06/25/2009 Make default for num_count 0, not NaN
; 07/20/2009 Check for no valid H+ peak data.
; 08/13/2009 Do matrix multiply record by record.
; 09/10/2009 Added temporal offset for 4/2009 - 9/2009
; 09/14/2009 Changed so keep fill values so have error codes.
; 09/23/2009 Take out E/W data when missing N/S data.
; 09/29/2009 Check for -1 in ew_source_flag 1 hr.
; 10/23/2009 Unflip ns_inst on B.
; 11/24/2009 Update offsets through 9/30/2009.
; 12/23/2009 Fix bug when run out of phi.
; 12/23/2009 Update offsets through 10/31/2009.
; 03/11/2010 Update offsets through 01/31/2010.
; 03/18/2010 Changed offsets for 10/2009 back to old (because already public).
; 04/12/2010 Changed offsets for Feb. 2010 (note changes for Jan, for next release).
; 04/16/2010 Add N/S roll correction for B and 2007 offsets for B.
;            Try different smoothing for B.
; 05/12/2010 Update offsets for A.
; 05/19/2010 Take out "smooth" call and use run_ave instead.
; 05/24/2010 Change call to pla_plot_pos_spec
; 06/08/2010 Use /accum when checking num counts.
; 06/30/2010 Update E/W offset for A.
; 07/09/2010 Make 3-pt-av for A and 7-pt-av for B.
; 09/09/2010 Fix bug with /nan in max_count for uncertainty.
; 10/11/2010 Update E/W offset for A.
; 10/20/2010 Changed E/W offset for 10/2009.
; 01/14/2011 Update E/W offset for A.
; 01/18/2011 Fixed bug in E/W offset for A.
; 03/14/2011 Update E/W offset for A.
; 04/11/2011 Update E/W offset for A.
; 06/13/2011 Update E/W offset for A.
; 09/13/2011 Update E/W offset for A.
; 12/20/2011 Added key_eff keyword
; 12/22/2011 Don't use offset when have key_eff keyword.
; 01/23/2012 Added E/W offset for A.
; 01/27/2012 Subracted 4.4 for test case.
; 01/30/2012 Changed to addition for 4.4 for test case.
; 03/22/2012 Update E/W offset for A.
; 04/12/2012 Update E/W offset for A.
; 05/17/2012 Update E/W offset for A.
; 09/04/2012 Change 4.7 to 5 for offset for key_eff A 2008-.
; 10/15/2012 Update for new A algorithm.
; 11/26/2012 Update for new B algorithm.
; 04/08/2013 Added .3 offset for B. (to put negative in HERTN)
; 04/10/2013 Changed so .3 offest for B is not used for 2007.
; 12/01/2014 Changed doubles to floats.
; 01/04/2021 Add offsets through 2030.

PRO pl_calc_ew_proton, sat, gse = gse, key_eff = key_eff
compile_opt strictarrsubs

euler = 2.71828

; Load the data
;----------------------------------------------------------------
; Kristin's data
stereo_bulk_vel    = 'speed'
stereo_ns          = 'north_south'
num_cycles_10min_v = 'cycles_10min_v'
num_cycles_1hr_v   = 'cycles_1hr_v'
get_data, stereo_bulk_vel,    stereo_bulk_vel_t,    stereo_bulk_vel_d
get_data, stereo_ns,          stereo_ns_t,          stereo_ns_d
get_data, num_cycles_10min_v, num_cycles_10min_v_t, num_cycles_10min_v_d
get_data, num_cycles_1hr_v,   num_cycles_1hr_v_t,   num_cycles_1hr_v_d

; Toni's algorithm
; expand timespan by 5 minutes (only need one) to get peak flag
get_timespan, ts
start_time = ts[0]
stop_time = ts[1]+300       ; go forward 5 minutes
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds
ew_toni = 'east_west'
a_toni = 0
b_toni = 0
amp_toni = 11.25
fullscale_toni = 19.6875
IF sat EQ 'A' THEN prod = ['A02'] ELSE prod = ['B02']    
units = 'Counts'
energy = [10, 99900]        ; eV
phi    = [-90, 90]
;weights = [.1111, .2222, .3334, .2222, .1111]
IF sat EQ 'A' THEN weights = [.25, .5, .25] $
  ELSE weights = [.0625, .125, .1875, .25, .1875, .125, .0625]
;weights = [.04, .08, .12, .16, .2, .16, .12, .08, .04]
;pla_plot_pos_spec, prod, units, energy, phi
;temp_string =
;'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_av_phi_schan_only'
IF sat EQ 'A' OR start_time GE time_double('2008-01-01') THEN $
  pla_plot_pos_spec, prod, units, energy, phi, /from_full, weights = weights, full_chan = 1, /no_defl, /key_eff $ ; schan only
ELSE $ ; 2007 for STB only -- old version
  pla_plot_pos_spec, prod, units, energy, phi, /from_full, weights = weights, full_chan = 1, /no_defl ; schan only
temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_av_phi_schan_only_from_full'
get_data, temp_string, av_phi_t, av_phi_d

;weights = [.2, .2, .2, .2, .2]
IF sat EQ 'A' THEN weights = [.3333, .3334, .3333] $
  ELSE weights = [.1428, .1428, .1428, .1428, .1428, .1428, .1428]
;weights = [.1111, .1111, .1111, .1111, .1111, .1111, .1111, .1111, .1111]
;pla_plot_pos_spec, prod, units, energy, phi
;temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_schan_only' ; was _schan_only before had full_chan
pla_plot_pos_spec, prod, units, energy, phi, /from_full, weights = weights, full_chan = 1, /no_defl, /accum_min; schan only
temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_from_full' ; was _schan_only before had full_chan
get_data, temp_string, hpeak_schan_t, hpeak_schan_d
; find uncertainty
uncertainty_d = fltarr(n_elements(hpeak_schan_t))
FOR jj = 0L, n_elements(hpeak_schan_t)-1 DO BEGIN 
    max_count = max(hpeak_schan_d[jj, *], /nan)
    IF max_count LT 2 OR finite(max_count) EQ 0 THEN BEGIN
        av_phi_d[jj] = !values.f_nan ; throw out when insufficient counts
        uncertainty_d[jj] = !values.f_nan
    ENDIF ELSE BEGIN 
        uncertainty_d[jj] = 100D / sqrt(double(max_count)) ; as percent
    ENDELSE 
ENDFOR 

hpeak_schan_d = total(hpeak_schan_d, 2,  /nan)
temp_i = where(hpeak_schan_d LT 6, count) ; throw out data where insufficient counts
IF count GT 0 THEN av_phi_d[temp_i] = !values.f_nan

ew_source_flag_d = intarr(n_elements(av_phi_t), 2) ; [-1=error (don't know peak or schan), 0=main, 1=schan, 2=mixed],[1=missed peak]
ew_source_flag_d[*] = -1
temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_s_chan_esa'
get_data, temp_string, av_phi_t, schan_i
temp_string = 'ST'+sat+'_PLA_POSSPEC_00190_90750_COUNTS_H+PEAK_peak_esa'
get_data, temp_string, av_phi_t, peak_i
; set whether from main or schan
temp_i = where(peak_i EQ -1 OR schan_i EQ -1, count)
IF count GT 0 THEN av_phi_d[temp_i] = !values.f_nan ; don't know peak of schan switch
temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i LT (peak_i-5), count) ; in schan
IF count GT 0 THEN ew_source_flag_d[temp_i, 0] = 1           
temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i GE (peak_i-5) AND schan_i LE (peak_i+4), count) ; mixed
IF count GT 0 THEN ew_source_flag_d[temp_i, 0] = 2           
temp_i = where(peak_i NE -1 AND schan_i NE -1 AND schan_i GT (peak_i+4), count) ; in main
IF count GT 0 THEN BEGIN
    ew_source_flag_d[temp_i, 0] = 0
    ; commented out next line now that using run_ave (5/19/2010)
    ;IF array_equal(finite(av_phi_d[temp_i]), 0) NE 1 THEN stop ; should all be NaN
ENDIF 
; set if we miss the peak
FOR ii = 0, n_elements(peak_i)-2 DO BEGIN 
    IF peak_i[ii] NE -1 AND peak_i[ii+1] NE -1 THEN $
      IF ((peak_i[ii+1] - peak_i[ii]) LT 5 AND (peak_i[ii+1] - peak_i[ii]) GT -6) OR  $
        (peak_i[ii+1] LT  10 AND peak_i[ii] LT   5) OR $
        (peak_i[ii+1] GT 117 AND peak_i[ii] GT 123) $
        THEN ew_source_flag_d[ii, 1] = 0 ELSE ew_source_flag_d[ii, 1] = 1
ENDFOR 

; return to old timespan
get_timespan, ts
start_time = ts[0]
stop_time = ts[1]-300       ; go back 5 minutes
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds

; line up times -- only take data where have both times
get_timespan, timespan
timespan_st = time_struct(timespan)
IF timespan_st[0].year EQ timespan_st[1].year THEN num_days = timespan_st[1].doy-timespan_st[0].doy ELSE BEGIN
    CASE 1 OF 
        timespan_st[0].year EQ 2007 AND timespan_st[1].year EQ 2008: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2008 AND timespan_st[1].year EQ 2009: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2009 AND timespan_st[1].year EQ 2010: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2010 AND timespan_st[1].year EQ 2011: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2011 AND timespan_st[1].year EQ 2012: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2012 AND timespan_st[1].year EQ 2013: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2013 AND timespan_st[1].year EQ 2014: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2014 AND timespan_st[1].year EQ 2015: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2015 AND timespan_st[1].year EQ 2016: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2016 AND timespan_st[1].year EQ 2017: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        timespan_st[0].year EQ 2017 AND timespan_st[1].year EQ 2018: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2018 AND timespan_st[1].year EQ 2019: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2019 AND timespan_st[1].year EQ 2020: num_days = timespan_st[1].doy-timespan_st[0].doy + 365 
        timespan_st[0].year EQ 2020 AND timespan_st[1].year EQ 2021: num_days = timespan_st[1].doy-timespan_st[0].doy + 366 
        ELSE: stop
    ENDCASE
ENDELSE 
new_t                 = dblarr(1441L*num_days)
new_stereo_bulk_vel_d = fltarr(1441L*num_days)
new_stereo_ns_d       = fltarr(1441L*num_days)
new_av_phi_d          = fltarr(1441L*num_days)
new_uncertainty_d     = fltarr(1441L*num_days)
new_ew_source_flag_d  = intarr(1441L*num_days, 2)
ks_i  = 0L
phi_i = 0L
new_i = 0L
av_phi_t =av_phi_t - 30 ; timestamp was at center of 1 minute
IF (n_elements(stereo_bulk_vel_t) GT 1 OR stereo_bulk_vel_t[0] NE 0) AND $ ; skip if no valid data
  (n_elements(av_phi_t) GT 1 OR av_phi_t[0] NE -30) THEN BEGIN 
    WHILE ks_i LT n_elements(stereo_bulk_vel_t) DO BEGIN
        IF phi_i LT n_elements(av_phi_t) THEN BEGIN 
            IF av_phi_t[phi_i] GE stereo_bulk_vel_t[ks_i] AND av_phi_t[phi_i] LT stereo_bulk_vel_t[ks_i]+60 $
              THEN BEGIN        ; in same minute
                new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
                new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
                new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
                new_av_phi_d         [new_i]    = av_phi_d         [phi_i]
                new_uncertainty_d    [new_i]    = uncertainty_d    [phi_i]
                new_ew_source_flag_d [new_i, *] = ew_source_flag_d [phi_i, *]
                ks_i  = ks_i  + 1
                phi_i = phi_i + 1
                new_i = new_i + 1
            ENDIF ELSE IF av_phi_t[phi_i] LT stereo_bulk_vel_t[ks_i] THEN BEGIN ; skip ks
                phi_i = phi_i + 1
            ENDIF ELSE BEGIN    ; skip av_phi
                new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
                new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
                new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
                new_av_phi_d         [new_i]    = !values.f_nan
                new_uncertainty_d    [new_i]    = !values.f_nan
                new_ew_source_flag_d [new_i, *] = [-1, -1]
                ks_i  = ks_i  + 1
                new_i = new_i + 1
            ENDELSE 
        ENDIF ELSE BEGIN        ; no more phi
            new_t                [new_i]    = stereo_bulk_vel_t[ks_i]
            new_stereo_bulk_vel_d[new_i]    = stereo_bulk_vel_d[ks_i]
            new_stereo_ns_d      [new_i]    = stereo_ns_d      [ks_i]
            new_av_phi_d         [new_i]    = !values.f_nan
            new_uncertainty_d    [new_i]    = !values.f_nan
            new_ew_source_flag_d [new_i, *] = [-1, -1]
            ks_i  = ks_i  + 1
            new_i = new_i + 1
        ENDELSE 
    ENDWHILE 
    new_t             = new_t                [0:new_i-1]
    stereo_bulk_vel_d = new_stereo_bulk_vel_d[0:new_i-1]
    stereo_ns_d       = new_stereo_ns_d      [0:new_i-1]
    av_phi_d          = new_av_phi_d         [0:new_i-1]
    uncertainty_d     = new_uncertainty_d    [0:new_i-1]
    ew_source_flag_d  = new_ew_source_flag_d [0:new_i-1, *]
    ew_toni_d = (amp_toni*(sinh((av_phi_d/fullscale_toni))))
    ew_sinh = 'ew_sinh'
    uncertainty = 'uncertainty'
    ew_source_flag = 'ew_source_flag'
    store_data, uncertainty,    data = {x:new_t, y:uncertainty_d}
    store_data, ew_source_flag, data = {x:new_t, y:ew_source_flag_d}

; smooth
    ;IF sat EQ 'A' THEN ew_toni_d = smooth(ew_toni_d, 3, /edge_truncate, /nan) $
    ;  ELSE ew_toni_d = smooth(ew_toni_d, 7, /edge_truncate, /nan)
    bad_i = where(finite(av_phi_d) EQ 0, bad_count)
    IF bad_count GT 0 THEN ew_toni_d[bad_i] = !values.f_nan
    bad_i = where(finite(stereo_bulk_vel_d) EQ 0, bad_count) 
    IF bad_count GT 0 THEN ew_toni_d[bad_i] = !values.f_nan
    bad_i = where(finite(stereo_ns_d)       EQ 0, bad_count) 
    IF bad_count GT 0 THEN ew_toni_d[bad_i] = !values.f_nan
    store_data, ew_sinh, data = {x:new_t, y:ew_toni_d}

; add temporal offset
    time_struct = time_struct(new_t)
    temp_year = time_struct.year
    temp_doy = time_struct.doy
    indices = where(temp_year EQ 2008, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365
    indices = where(temp_year EQ 2009, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366
    indices = where(temp_year EQ 2010, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365
    indices = where(temp_year EQ 2011, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365
    indices = where(temp_year EQ 2012, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365
    indices = where(temp_year EQ 2013, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366
    indices = where(temp_year EQ 2014, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365
    indices = where(temp_year EQ 2015, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365
    indices = where(temp_year EQ 2016, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365
    indices = where(temp_year EQ 2017, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366
    indices = where(temp_year EQ 2018, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365
    indices = where(temp_year EQ 2019, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365
    indices = where(temp_year EQ 2020, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365
    indices = where(temp_year GT 2020, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366
    indices = where(temp_year GT 2021, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365
    indices = where(temp_year GT 2022, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365
    indices = where(temp_year GT 2023, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365
    indices = where(temp_year GT 2024, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+365
    indices = where(temp_year GT 2025, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365
    indices = where(temp_year GT 2026, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365+365
    indices = where(temp_year GT 2027, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365+365+365
    indices = where(temp_year GT 2028, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365+365+365+366
    indices = where(temp_year GT 2029, count)
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365+365+365+366+365
    indices = where(temp_year GT 2030, count) 
    IF count GT 0 THEN temp_doy[indices] = temp_doy+365+366+365+365+365+366+365+365+365+366+365+365+365+$
                                           366+365+365+365+366+365+365+365+366+365
    indices = where(temp_year GT 2031, count) ; NOTE: Only good through 2030
    IF count GT 0 THEN stop
    temp_doy = double(temp_doy)

    IF sat EQ 'A' THEN BEGIN 
        IF start_time LE time_double('2008-01-01') THEN BEGIN ; trying 2007
            ew_temporal_offset = 1.5
        ;ew_toni_d[*] = ew_toni_d[*] + ew_temporal_offset
        ; this bit with vel offset added on 05/13/2013 as a temporary attempt
            indices = where (temp_doy LT 97, count) ; 01/01/2007 - 04/06/2007
            IF count GT 0 THEN BEGIN 
                ew_vel_offset      = (-1.04160E-04*(stereo_bulk_vel_d[indices]^2)) $
                                     + (1.12090E-01*(stereo_bulk_vel_d[indices])) - 1.63447E01
                                ;ew_toni_d[indices] = ew_vel_offset - ew_toni_d[indices]
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices]
            ENDIF 
            indices = where (temp_doy GE 97 AND temp_doy LT 121, count) ; 04/07/2007 - 4/30/2007
            IF count GT 0 THEN BEGIN 
                ew_vel_offset      = (0.02 * stereo_bulk_vel_d[indices])
                                ;ew_toni_d[indices] = ew_vel_offset - ew_toni_d[indices]
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices]
            ENDIF 
            indices = where (temp_doy GE 121 AND temp_doy LT 366, count) ; 05/01/2007 - 12/31/2007
            IF count GT 0 THEN BEGIN
                ew_vel_offset      = (0.02 * stereo_bulk_vel_d[indices])
                                ;ew_toni_d[indices] = ew_vel_offset - ew_toni_d[indices]
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices]
            ENDIF 
        ENDIF ELSE BEGIN 
           ew_temporal_offset = 1.5
           ew_toni_d[*] = ew_toni_d[*] + ew_temporal_offset
        ENDELSE 
     Endif  ELSE BEGIN 
        IF start_time GE time_double('2008-01-01') THEN BEGIN 
            indices = where(temp_doy LT 366, count) ; 2007 -- shouldn't be here
            IF count GT 0 THEN stop
            indices = where(temp_doy GE 366 AND temp_doy LT 950, count) ; 01/01/2008 - 08/06/2009
            IF count GT 0 THEN BEGIN 
                ew_temporal_offset = 2.43
                ew_toni_d[indices] = ew_temporal_offset - ew_toni_d[indices] ; this takes care of flip
                eq_protons         = (stereo_bulk_vel_d[indices]/437.8)^2
                ew_adj             = 2.2356 * eq_protons - 0.6799
                ew_toni_d[indices] = ew_toni_d[indices] + ew_adj
                ew_temp2_offset    = (-7.838E-4 * temp_doy[indices]) + 2.328E-1
                ew_toni_d[indices] = ew_toni_d[indices] + ew_temp2_offset
            ENDIF 
            indices = where(temp_doy GE 950, count) ; 08/07/2009 - 
            IF count GT 0 THEN BEGIN 
                ew_temporal_offset = 2.43
                ew_toni_d[indices] = ew_temporal_offset - ew_toni_d[indices] ; this takes care of flip
                eq_protons         = (stereo_bulk_vel_d[indices]/437.8)^2
                ew_adj             = 4.3208 * alog(eq_protons) + 4.1345
                temp_i             = where(ew_adj LT 0, new_count)
                IF new_count GT 0 THEN ew_adj[temp_i] = 0
                ew_toni_d[indices] = ew_toni_d[indices] + ew_adj
                ew_temp2_offset    = 0.05821 * (euler^(0.00152 * temp_doy[indices]))
                ew_toni_d[indices] = ew_toni_d[indices] + ew_temp2_offset
            ENDIF 
            ew_stb_20130408_offset = 0.3
            ew_toni_d = ew_toni_d + ew_stb_20130408_offset
        ENDIF ELSE BEGIN ; keep this for 2007 for STB!!!!
            indices = where (temp_doy LT 97, count) ; 01/01/2007 - 04/06/2007
            IF count GT 0 THEN BEGIN 
                ew_vel_offset      = (-1.04160E-04*(stereo_bulk_vel_d[indices]^2)) $
                                     + (1.12090E-01*(stereo_bulk_vel_d[indices])) - 1.63447E01
                ew_temporal_offset = 0
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices] ; this takes care of flip
                ew_temp2_offset    = (-7.838E-4 * temp_doy[indices]) + 2.328E-1
                ew_toni_d[indices] = ew_toni_d[indices] + ew_temp2_offset
            ENDIF 
            indices = where (temp_doy GE 97 AND temp_doy LT 121, count) ; 04/07/2007 - 4/30/2007
            IF count GT 0 THEN BEGIN 
                ew_vel_offset      = (0.02 * stereo_bulk_vel_d[indices])
                ew_temporal_offset = (-0.00074927*(temp_doy[indices]^2)) $
                                     - (0.025417*(temp_doy[indices])) + 8.0658
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices] ; this takes care of flip
                ew_temp2_offset    = (-7.838E-4 * temp_doy[indices]) + 2.328E-1
                ew_toni_d[indices] = ew_toni_d[indices] + ew_temp2_offset
            ENDIF 
            indices = where (temp_doy GE 121, count) ; 05/01/2007 
            IF count GT 0 THEN BEGIN 
                ew_vel_offset      = (0.02 * stereo_bulk_vel_d[indices])
                ew_temporal_offset = (-2.0613E-08 *(temp_doy[indices]^4)) $
                                     + (1.8326E-05*(temp_doy[indices]^3)) $
                                     - (5.8564E-03*(temp_doy[indices]^2)) $
                                     + (8.2148E-01*(temp_doy[indices])) - 4.7375E01
                ew_toni_d[indices] = ew_vel_offset + ew_temporal_offset - ew_toni_d[indices] ; this takes care of flip
                ew_temp2_offset    = (-7.838E-4 * temp_doy[indices]) + 2.328E-1
                ew_toni_d[indices] = ew_toni_d[indices] + ew_temp2_offset
            ENDIF 
        ENDELSE 
    ENDELSE 
    ew_inst = 'stereo_ew_inst'
    stereo_ew_inst_d = ew_toni_d
    store_data, ew_inst, data = {x: new_t, y: ew_toni_d}

; Unflip ns_instr so coordinate transformation will work
    IF sat EQ 'B' THEN BEGIN
        stereo_ns_d = -1.0 * stereo_ns_d
        ew_toni_d   = -1.0 * ew_toni_d
    ENDIF 

; Turn angles into coordinates
    vx_inst = stereo_bulk_vel_d * cos(stereo_ns_d * !pi / 180) * cos(ew_toni_d * !pi / 180)
    vy_inst = stereo_bulk_vel_d * cos(stereo_ns_d * !pi / 180) * sin(ew_toni_d * !pi / 180)
    vz_inst = stereo_bulk_vel_d * sin(stereo_ns_d * !pi / 180)

; Change to spacecraft coordinates
    stereo_vel_d = fltarr(3, n_elements(stereo_ns_d))
    stereo_vel_d[0, *] = (-1.0) * vx_inst
    stereo_vel_d[1, *] = vz_inst
    stereo_vel_d[2, *] = (-1.0) * vy_inst

; Put in HERTN
    num_records = n_elements(new_t)
    temp_time = time_string(new_t)
    strput, temp_time, 'T', 10  ; change time string format for SolarSoft
    stereo_vel_hertn_d = fltarr(3, num_records)
    cmat_hertn = get_stereo_cmat(temp_time, sat, system = 'hertn')
    FOR ii = 0, num_records-1 DO BEGIN
        temp_vel = reform(stereo_vel_d[*, ii])
        temp_cmat = reform(cmat_hertn[*, *, ii])
        stereo_vel_hertn_d[*, ii] = temp_cmat # temp_vel
    ENDFOR 
; Put in RTN
    stereo_vel_rtn_d = fltarr(3, num_records)
    cmat_rtn = get_stereo_cmat(temp_time, sat, system = 'rtn')
    FOR ii = 0, num_records-1 DO BEGIN
        temp_vel = reform(stereo_vel_d[*, ii])
        temp_cmat = reform(cmat_rtn[*, *, ii])
        stereo_vel_rtn_d[*, ii] = temp_cmat # temp_vel
    ENDFOR 
 ; Put in GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN
        stereo_vel_gse_d = fltarr(3, num_records)
        cmat_gse = get_stereo_cmat(temp_time, sat, system = 'gse')
        FOR ii = 0, num_records-1 DO BEGIN
            temp_vel = reform(stereo_vel_d[*, ii])
            temp_cmat = reform(cmat_gse[*, *, ii])
            stereo_vel_gse_d[*, ii] = temp_cmat # temp_vel
        ENDFOR 
    ENDIF 

; Add abberration
; HERTN
    state = get_stereo_coord(temp_time, sat, system = 'hci')
    spcrft_vel = state[3:5, *]
    convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'hertn', spacecraft = sat
    stereo_vel_hertn_d = stereo_vel_hertn_d + spcrft_vel
; RTN
    state = get_stereo_coord(temp_time, sat, system = 'hci')
    spcrft_vel = state[3:5, *]
    convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'rtn', spacecraft = sat, /ignore_origin
    stereo_vel_rtn_d = stereo_vel_rtn_d + spcrft_vel
 ; GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN
        state = get_stereo_coord(temp_time, sat, system = 'hci')
        spcrft_vel = state[3:5, *]
        convert_stereo_coord, temp_time, spcrft_vel, 'hci', 'gse', spacecraft = sat, /ignore_origin
        stereo_vel_gse_d = stereo_vel_gse_d + spcrft_vel
    ENDIF 

; Create flow angles and bulk vel from HERTN data
    temp_vr = reform(stereo_vel_hertn_d[0, *])
    temp_vt = reform(stereo_vel_hertn_d[1, *])
    temp_vn = reform(stereo_vel_hertn_d[2, *])
    stereo_ew_hertn_d = atan(temp_vt / temp_vr) * 180 / !pi
    stereo_ns_hertn_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
; Create flow angles and bulk vel from RTN data
    temp_vr = reform(stereo_vel_rtn_d[0, *])
    temp_vt = reform(stereo_vel_rtn_d[1, *])
    temp_vn = reform(stereo_vel_rtn_d[2, *])
    stereo_ew_rtn_d = atan(temp_vt / temp_vr) * 180 / !pi
    stereo_ns_rtn_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
; Create flow angles and bulk vel from GSE data
    IF keyword_set(gse) EQ 1 THEN BEGIN    
        temp_vr = reform(stereo_vel_gse_d[0, *])
        temp_vt = reform(stereo_vel_gse_d[1, *])
        temp_vn = reform(stereo_vel_gse_d[2, *])
        stereo_ew_gse_d = atan(temp_vt / temp_vr) * 180 / !pi
        stereo_ns_gse_d = atan(temp_vn / sqrt((temp_vr^2)+(temp_vt^2))) * 180 / !pi
    ENDIF 

; Store data
; HERTN
    stereo_vr_hertn = 'stereo_vr_hertn'
    stereo_vt_hertn = 'stereo_vt_hertn'
    stereo_vn_hertn = 'stereo_vn_hertn'
    stereo_ew_hertn = 'stereo_ew_hertn'
    stereo_ns_hertn = 'stereo_ns_hertn'
    stereo_vr_hertn_d = reform(stereo_vel_hertn_d[0, *])
    stereo_vt_hertn_d = reform(stereo_vel_hertn_d[1, *])
    stereo_vn_hertn_d = reform(stereo_vel_hertn_d[2, *])
    store_data, stereo_vr_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[0, *])}
    store_data, stereo_vt_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[1, *])}
    store_data, stereo_vn_hertn, data = {x:new_t, y:reform(stereo_vel_hertn_d[2, *])}
    store_data, stereo_ew_hertn, data = {x:new_t, y:stereo_ew_hertn_d}
    store_data, stereo_ns_hertn, data = {x:new_t, y:stereo_ns_hertn_d}
; RTN
    stereo_vr_rtn = 'stereo_vr_rtn'
    stereo_vt_rtn = 'stereo_vt_rtn'
    stereo_vn_rtn = 'stereo_vn_rtn'
    stereo_ew_rtn = 'stereo_ew_rtn'
    stereo_ns_rtn = 'stereo_ns_rtn'
    stereo_vr_rtn_d = reform(stereo_vel_rtn_d[0, *])
    stereo_vt_rtn_d = reform(stereo_vel_rtn_d[1, *])
    stereo_vn_rtn_d = reform(stereo_vel_rtn_d[2, *])
    store_data, stereo_vr_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[0, *])}
    store_data, stereo_vt_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[1, *])}
    store_data, stereo_vn_rtn,    data = {x:new_t, y:reform(stereo_vel_rtn_d[2, *])}
    store_data, stereo_ew_rtn,    data = {x:new_t, y:stereo_ew_rtn_d}
    store_data, stereo_ns_rtn,    data = {x:new_t, y:stereo_ns_rtn_d}
; GSE
    IF keyword_set(gse) EQ 1 THEN BEGIN    
        stereo_vr_gse = 'stereo_vr_gse'
        stereo_vt_gse = 'stereo_vt_gse'
        stereo_vn_gse = 'stereo_vn_gse'
        stereo_ew_gse = 'stereo_ew_gse'
        stereo_ns_gse = 'stereo_ns_gse'
        stereo_vr_gse_d = reform(stereo_vel_gse_d[0, *])
        stereo_vt_gse_d = reform(stereo_vel_gse_d[1, *])
        stereo_vn_gse_d = reform(stereo_vel_gse_d[2, *])
        store_data, stereo_vr_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[0, *])}
        store_data, stereo_vt_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[1, *])}
        store_data, stereo_vn_gse,    data = {x:new_t, y:reform(stereo_vel_gse_d[2, *])}
        store_data, stereo_ew_gse,    data = {x:new_t, y:stereo_ew_gse_d}
        store_data, stereo_ns_gse,    data = {x:new_t, y:stereo_ns_gse_d}
    ENDIF 

; calculate 10 min averages
    new_st = time_struct(new_t)
    start_year = timespan_st[0].year
    start_doy = timespan_st[0].doy
    num_records = num_days*24*6
    num_count_10min             = 'num_in_ave_10min'
    ew_source_flag_10min        = 'ew_source_flag_10min'
    uncertainty_10min           = 'uncertainty_10min'
    stereo_ew_inst_10min        = 'stereo_ew_inst_10min'
    stereo_vr_hertn_10min       = 'stereo_vr_hertn_10min'
    stereo_vt_hertn_10min       = 'stereo_vt_hertn_10min'
    stereo_vn_hertn_10min       = 'stereo_vn_hertn_10min'
    stereo_ew_hertn_10min       = 'stereo_ew_hertn_10min'
    stereo_ns_hertn_10min       = 'stereo_ns_hertn_10min'
    stereo_vr_rtn_10min         = 'stereo_vr_rtn_10min'
    stereo_vt_rtn_10min         = 'stereo_vt_rtn_10min'
    stereo_vn_rtn_10min         = 'stereo_vn_rtn_10min'
    stereo_ew_rtn_10min         = 'stereo_ew_rtn_10min'
    stereo_ns_rtn_10min         = 'stereo_ns_rtn_10min'
    ten_min_t                       = dblarr(num_records)
    ten_min_ew_source_flag_d        = intarr(num_records, 2)
    ten_min_uncertainty_d           = fltarr(num_records)
    ten_min_stereo_ew_inst_d        = fltarr(num_records) 
    ten_min_stereo_vr_hertn_d       = fltarr(num_records)
    ten_min_stereo_vt_hertn_d       = fltarr(num_records)
    ten_min_stereo_vn_hertn_d       = fltarr(num_records)
    ten_min_stereo_ew_hertn_d       = fltarr(num_records) 
    ten_min_stereo_ns_hertn_d       = fltarr(num_records)
    ten_min_stereo_vr_rtn_d         = fltarr(num_records)
    ten_min_stereo_vt_rtn_d         = fltarr(num_records)
    ten_min_stereo_vn_rtn_d         = fltarr(num_records)
    ten_min_stereo_ew_rtn_d         = fltarr(num_records)
    ten_min_stereo_ns_rtn_d         = fltarr(num_records)
    ten_min_num_count_d             = fltarr(num_records)
    ten_min_ew_source_flag_d[*]        = -1
    ten_min_uncertainty_d[*]           = !values.f_nan
    ten_min_stereo_ew_inst_d[*]        = !values.f_nan 
    ten_min_stereo_vr_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vt_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vn_hertn_d[*]       = !values.f_nan
    ten_min_stereo_ew_hertn_d[*]       = !values.f_nan 
    ten_min_stereo_ns_hertn_d[*]       = !values.f_nan
    ten_min_stereo_vr_rtn_d[*]         = !values.f_nan
    ten_min_stereo_vt_rtn_d[*]         = !values.f_nan
    ten_min_stereo_vn_rtn_d[*]         = !values.f_nan
    ten_min_stereo_ew_rtn_d[*]         = !values.f_nan
    ten_min_stereo_ns_rtn_d[*]         = !values.f_nan
    ten_min_num_count_d[*]             = 0
    ten_min_i = 0               ; index into ten_min products
    FOR ii = 0, num_days-1 DO BEGIN ; days 
        FOR jj = 0, 23 DO BEGIN ; hours
            FOR kk = 0, 5 DO BEGIN ; minutes
                wanted_i = where(new_st.year EQ start_year AND new_st.doy EQ (ii+start_doy) AND $
                                 new_st.hour EQ jj AND new_st.min GE (kk*10) AND new_st.min LT ((kk+1)*10), count)
                have_data = 1
                IF count GT 0 THEN BEGIN ; have times
                    ;doy_to_month_date, start_year, (ii+start_doy), month, date
                    ;ten_min_t[ten_min_i] = time_double(string(start_year, format = '(I4.4)')+'-'+$
                    ;                                   string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+$
                    ;                                   '/'+string(jj, format = '(I2.2)')+':'+string((kk*10), format = '(I2.2)')+':00')
                    IF array_equal(ew_source_flag_d[wanted_i, 0], 0) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 2) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = 2 $
                              ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], -1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 0] = -1 $
                                   ELSE ten_min_ew_source_flag_d[ten_min_i, 0] = 3
                    IF array_equal(ew_source_flag_d[wanted_i, 1], 0) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], 1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], -1) EQ 1 THEN ten_min_ew_source_flag_d[ten_min_i, 1] = -1 $
                              ELSE ten_min_ew_source_flag_d[ten_min_i, 1] = 2
                    ten_min_uncertainty_d[ten_min_i] = max(uncertainty_d[wanted_i], /nan)
                    new_t_i              = where(finite(new_t               [wanted_i]) EQ 1, new_t_count)
                    stereo_ew_inst_i     = where(finite(stereo_ew_inst_d    [wanted_i]) EQ 1, stereo_ew_inst_count)
                    stereo_vr_hertn_i    = where(finite(stereo_vr_hertn_d   [wanted_i]) EQ 1, stereo_vr_hertn_count)
                    stereo_vt_hertn_i    = where(finite(stereo_vt_hertn_d   [wanted_i]) EQ 1, stereo_vt_hertn_count)
                    stereo_vn_hertn_i    = where(finite(stereo_vn_hertn_d   [wanted_i]) EQ 1, stereo_vn_hertn_count)
                    stereo_ew_hertn_i    = where(finite(stereo_ew_hertn_d   [wanted_i]) EQ 1, stereo_ew_hertn_count)
                    stereo_ns_hertn_i    = where(finite(stereo_ns_hertn_d   [wanted_i]) EQ 1, stereo_ns_hertn_count)
                    stereo_vr_rtn_i      = where(finite(stereo_vr_rtn_d     [wanted_i]) EQ 1, stereo_vr_rtn_count)
                    stereo_vt_rtn_i      = where(finite(stereo_vt_rtn_d     [wanted_i]) EQ 1, stereo_vt_rtn_count)
                    stereo_vn_rtn_i      = where(finite(stereo_vn_rtn_d     [wanted_i]) EQ 1, stereo_vn_rtn_count)
                    stereo_ew_rtn_i      = where(finite(stereo_ew_rtn_d     [wanted_i]) EQ 1, stereo_ew_rtn_count)
                    stereo_ns_rtn_i      = where(finite(stereo_ns_rtn_d     [wanted_i]) EQ 1, stereo_ns_rtn_count)
                    IF stereo_vr_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vr_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_rtn_count   NE stereo_ew_inst_count THEN stop
                    ten_min_t                      [ten_min_i] = new_t                      [wanted_i[new_t_i[0]      ]]
                    IF stereo_ew_inst_count EQ 0 THEN $
                      ten_min_stereo_ew_inst_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_inst_count EQ 1 THEN $
                      ten_min_stereo_ew_inst_d     [ten_min_i] = stereo_ew_inst_d          [wanted_i[stereo_ew_inst_i]] ELSE BEGIN 
                        mom_ew_inst                            = moment(stereo_ew_inst_d   [wanted_i], /nan)
                        ten_min_stereo_ew_inst_d   [ten_min_i] = mom_ew_inst               [0]
                    ENDELSE 
                    IF stereo_vr_hertn_count EQ 0 THEN $
                      ten_min_stereo_vr_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vr_hertn_count EQ 1 THEN $
                      ten_min_stereo_vr_hertn_d     [ten_min_i] = stereo_vr_hertn_d          [wanted_i[stereo_vr_hertn_i]] ELSE BEGIN 
                        mom_vr_hertn                            = moment(stereo_vr_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vr_hertn_d   [ten_min_i] = mom_vr_hertn               [0]
                    ENDELSE 
                    IF stereo_vt_hertn_count EQ 0 THEN $
                      ten_min_stereo_vt_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vt_hertn_count EQ 1 THEN $
                      ten_min_stereo_vt_hertn_d     [ten_min_i] = stereo_vt_hertn_d          [wanted_i[stereo_vt_hertn_i]] ELSE BEGIN 
                        mom_vt_hertn                            = moment(stereo_vt_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vt_hertn_d   [ten_min_i] = mom_vt_hertn               [0]
                    ENDELSE 
                    IF stereo_vn_hertn_count EQ 0 THEN $
                      ten_min_stereo_vn_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vn_hertn_count EQ 1 THEN $
                      ten_min_stereo_vn_hertn_d     [ten_min_i] = stereo_vn_hertn_d          [wanted_i[stereo_vn_hertn_i]] ELSE BEGIN 
                        mom_vn_hertn                            = moment(stereo_vn_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_vn_hertn_d   [ten_min_i] = mom_vn_hertn               [0]
                    ENDELSE 
                    IF stereo_ew_hertn_count EQ 0 THEN $
                      ten_min_stereo_ew_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_hertn_count EQ 1 THEN $
                      ten_min_stereo_ew_hertn_d     [ten_min_i] = stereo_ew_hertn_d          [wanted_i[stereo_ew_hertn_i]] ELSE BEGIN 
                        mom_ew_hertn                            = moment(stereo_ew_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_ew_hertn_d   [ten_min_i] = mom_ew_hertn               [0]
                    ENDELSE 
                    IF stereo_ns_hertn_count EQ 0 THEN $
                      ten_min_stereo_ns_hertn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ns_hertn_count EQ 1 THEN $
                      ten_min_stereo_ns_hertn_d     [ten_min_i] = stereo_ns_hertn_d          [wanted_i[stereo_ns_hertn_i]] ELSE BEGIN 
                        mom_ns_hertn                            = moment(stereo_ns_hertn_d   [wanted_i], /nan)
                        ten_min_stereo_ns_hertn_d   [ten_min_i] = mom_ns_hertn               [0]
                    ENDELSE 
                    IF stereo_vr_rtn_count EQ 0 THEN $
                      ten_min_stereo_vr_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vr_rtn_count EQ 1 THEN $
                      ten_min_stereo_vr_rtn_d       [ten_min_i] = stereo_vr_rtn_d            [wanted_i[stereo_vr_rtn_i]] ELSE BEGIN 
                        mom_vr_rtn                              = moment(stereo_vr_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vr_rtn_d     [ten_min_i] = mom_vr_rtn                 [0]
                    ENDELSE 
                    IF stereo_vt_rtn_count EQ 0 THEN $
                      ten_min_stereo_vt_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vt_rtn_count EQ 1 THEN $
                      ten_min_stereo_vt_rtn_d       [ten_min_i] = stereo_vt_rtn_d            [wanted_i[stereo_vt_rtn_i]] ELSE BEGIN 
                        mom_vt_rtn                              = moment(stereo_vt_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vt_rtn_d     [ten_min_i] = mom_vt_rtn                 [0]
                    ENDELSE 
                    IF stereo_vn_rtn_count EQ 0 THEN $
                      ten_min_stereo_vn_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_vn_rtn_count EQ 1 THEN $
                      ten_min_stereo_vn_rtn_d       [ten_min_i] = stereo_vn_rtn_d            [wanted_i[stereo_vn_rtn_i]] ELSE BEGIN 
                        mom_vn_rtn                              = moment(stereo_vn_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_vn_rtn_d     [ten_min_i] = mom_vn_rtn                 [0]
                    ENDELSE 
                    IF stereo_ew_rtn_count EQ 0 THEN $
                      ten_min_stereo_ew_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ew_rtn_count EQ 1 THEN $
                      ten_min_stereo_ew_rtn_d       [ten_min_i] = stereo_ew_rtn_d            [wanted_i[stereo_ew_rtn_i]] ELSE BEGIN 
                        mom_ew_rtn                              = moment(stereo_ew_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_ew_rtn_d     [ten_min_i] = mom_ew_rtn                 [0]
                    ENDELSE 
                    IF stereo_ns_rtn_count EQ 0 THEN $
                      ten_min_stereo_ns_rtn_d     [ten_min_i] = !values.f_nan $
                    ELSE IF stereo_ns_rtn_count EQ 1 THEN $
                      ten_min_stereo_ns_rtn_d       [ten_min_i] = stereo_ns_rtn_d            [wanted_i[stereo_ns_rtn_i]] ELSE BEGIN 
                        mom_ns_rtn                              = moment(stereo_ns_rtn_d     [wanted_i], /nan)
                        ten_min_stereo_ns_rtn_d     [ten_min_i] = mom_ns_rtn                 [0]
                    ENDELSE 
                    ten_min_num_count_d             [ten_min_i] = stereo_ew_hertn_count
                    ten_min_i = ten_min_i + 1
                ENDIF 
            ENDFOR
        ENDFOR
    ENDFOR 
    IF ten_min_i LT num_records THEN BEGIN 
        ten_min_t                       = ten_min_t                      [0:ten_min_i-1]
        ten_min_ew_source_flag_d        = ten_min_ew_source_flag_d       [0:ten_min_i-1, *]
        ten_min_uncertainty_d           = ten_min_uncertainty_d          [0:ten_min_i-1]
        ten_min_num_count_d             = ten_min_num_count_d            [0:ten_min_i-1]
        ten_min_stereo_ew_inst_d        = ten_min_stereo_ew_inst_d       [0:ten_min_i-1]
        ten_min_stereo_vr_hertn_d       = ten_min_stereo_vr_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vt_hertn_d       = ten_min_stereo_vt_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vn_hertn_d       = ten_min_stereo_vn_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_ew_hertn_d       = ten_min_stereo_ew_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_ns_hertn_d       = ten_min_stereo_ns_hertn_d      [0:ten_min_i-1]
        ten_min_stereo_vr_rtn_d         = ten_min_stereo_vr_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_vt_rtn_d         = ten_min_stereo_vt_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_vn_rtn_d         = ten_min_stereo_vn_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_ew_rtn_d         = ten_min_stereo_ew_rtn_d        [0:ten_min_i-1]
        ten_min_stereo_ns_rtn_d         = ten_min_stereo_ns_rtn_d        [0:ten_min_i-1]
    ENDIF 
    store_data, num_count_10min,             data = {x:ten_min_t, y:ten_min_num_count_d}
    store_data, ew_source_flag_10min,        data = {x:ten_min_t, y:ten_min_ew_source_flag_d}
    store_data, uncertainty_10min,           data = {x:ten_min_t, y:ten_min_uncertainty_d}
    store_data, stereo_ew_inst_10min,        data = {x:ten_min_t, y:ten_min_stereo_ew_inst_d}
    store_data, stereo_vr_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vr_hertn_d}
    store_data, stereo_vt_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vt_hertn_d}
    store_data, stereo_vn_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_vn_hertn_d}
    store_data, stereo_ew_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_ew_hertn_d}
    store_data, stereo_ns_hertn_10min,       data = {x:ten_min_t, y:ten_min_stereo_ns_hertn_d}
    store_data, stereo_vr_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vr_rtn_d}
    store_data, stereo_vt_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vt_rtn_d}
    store_data, stereo_vn_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_vn_rtn_d}
    store_data, stereo_ew_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_ew_rtn_d}
    store_data, stereo_ns_rtn_10min,         data = {x:ten_min_t, y:ten_min_stereo_ns_rtn_d}

; calculate 1 hr averages
    num_records = num_days*24
    num_count_1hr             = 'num_in_ave_1hr'
    ew_source_flag_1hr        = 'ew_source_flag_1hr'
    uncertainty_1hr           = 'uncertainty_1hr'
    stereo_ew_inst_1hr        = 'stereo_ew_inst_1hr'
    stereo_vr_hertn_1hr       = 'stereo_vr_hertn_1hr'
    stereo_vt_hertn_1hr       = 'stereo_vt_hertn_1hr'
    stereo_vn_hertn_1hr       = 'stereo_vn_hertn_1hr'
    stereo_ew_hertn_1hr       = 'stereo_ew_hertn_1hr'
    stereo_ns_hertn_1hr       = 'stereo_ns_hertn_1hr'
    stereo_vr_rtn_1hr         = 'stereo_vr_rtn_1hr'
    stereo_vt_rtn_1hr         = 'stereo_vt_rtn_1hr'
    stereo_vn_rtn_1hr         = 'stereo_vn_rtn_1hr'
    stereo_ew_rtn_1hr         = 'stereo_ew_rtn_1hr'
    stereo_ns_rtn_1hr         = 'stereo_ns_rtn_1hr'
    hour_t                       = dblarr(num_records)
    hour_ew_source_flag_d        = intarr(num_records, 2) ; source, flag-if-miss-peak
    hour_uncertainty_d           = fltarr(num_records)
    hour_stereo_ew_inst_d        = fltarr(num_records) 
    hour_stereo_vr_hertn_d       = fltarr(num_records)
    hour_stereo_vt_hertn_d       = fltarr(num_records)
    hour_stereo_vn_hertn_d       = fltarr(num_records)
    hour_stereo_ew_hertn_d       = fltarr(num_records) 
    hour_stereo_ns_hertn_d       = fltarr(num_records)
    hour_stereo_vr_rtn_d         = fltarr(num_records)
    hour_stereo_vt_rtn_d         = fltarr(num_records)
    hour_stereo_vn_rtn_d         = fltarr(num_records)
    hour_stereo_ew_rtn_d         = fltarr(num_records)
    hour_stereo_ns_rtn_d         = fltarr(num_records)
    hour_num_count_d             = fltarr(num_records)
    hour_ew_source_flag_d[*]        = -1
    hour_uncertainty_d[*]           = !values.f_nan
    hour_stereo_ew_inst_d[*]        = !values.f_nan 
    hour_stereo_vr_hertn_d[*]       = !values.f_nan
    hour_stereo_vt_hertn_d[*]       = !values.f_nan
    hour_stereo_vn_hertn_d[*]       = !values.f_nan
    hour_stereo_ew_hertn_d[*]       = !values.f_nan 
    hour_stereo_ns_hertn_d[*]       = !values.f_nan
    hour_stereo_vr_rtn_d[*]         = !values.f_nan
    hour_stereo_vt_rtn_d[*]         = !values.f_nan
    hour_stereo_vn_rtn_d[*]         = !values.f_nan
    hour_stereo_ew_rtn_d[*]         = !values.f_nan
    hour_stereo_ns_rtn_d[*]         = !values.f_nan
    hour_num_count_d[*]             = 0
    hour_i = 0                  ; index into hour products
    FOR ii = 0, num_days-1 DO BEGIN ; days 
        FOR jj = 0, 23 DO BEGIN ; hours
            wanted_i = where(new_st.year EQ start_year AND new_st.doy EQ (ii+start_doy) AND $
                             new_st.hour EQ jj, count)
            have_data = 1
            IF count GT 0 THEN BEGIN ; have times
                ;doy_to_month_date, start_year, (ii+start_doy), month, date
                ;hour_t[hour_i] = time_double(string(start_year, format = '(I4.4)')+$
                ;                             '-'+string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+$
                ;                             '/'+string(jj, format = '(I2.2)')+':00:00')
                IF count GT 0 THEN BEGIN ; have valid data
                    IF array_equal(ew_source_flag_d[wanted_i, 0], 0) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], 2) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = 2 $
                              ELSE IF array_equal(ew_source_flag_d[wanted_i, 0], -1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 0] = -1 $
                                   ELSE hour_ew_source_flag_d[hour_i, 0] = 3
                    IF array_equal(ew_source_flag_d[wanted_i, 1], 0) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = 0 $
                    ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], 1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = 1 $
                         ELSE IF array_equal(ew_source_flag_d[wanted_i, 1], -1) EQ 1 THEN hour_ew_source_flag_d[hour_i, 1] = -1 $
                              ELSE hour_ew_source_flag_d[hour_i, 1] = 2
                    hour_uncertainty_d[hour_i] = max(uncertainty_d[wanted_i], /nan)
                    new_t_i              = where(finite(new_t               [wanted_i]) EQ 1, new_t_count)
                    stereo_ew_inst_i     = where(finite(stereo_ew_inst_d    [wanted_i]) EQ 1, stereo_ew_inst_count)
                    stereo_vr_hertn_i    = where(finite(stereo_vr_hertn_d   [wanted_i]) EQ 1, stereo_vr_hertn_count)
                    stereo_vt_hertn_i    = where(finite(stereo_vt_hertn_d   [wanted_i]) EQ 1, stereo_vt_hertn_count)
                    stereo_vn_hertn_i    = where(finite(stereo_vn_hertn_d   [wanted_i]) EQ 1, stereo_vn_hertn_count)
                    stereo_ew_hertn_i    = where(finite(stereo_ew_hertn_d   [wanted_i]) EQ 1, stereo_ew_hertn_count)
                    stereo_ns_hertn_i    = where(finite(stereo_ns_hertn_d   [wanted_i]) EQ 1, stereo_ns_hertn_count)
                    stereo_vr_rtn_i      = where(finite(stereo_vr_rtn_d     [wanted_i]) EQ 1, stereo_vr_rtn_count)
                    stereo_vt_rtn_i      = where(finite(stereo_vt_rtn_d     [wanted_i]) EQ 1, stereo_vt_rtn_count)
                    stereo_vn_rtn_i      = where(finite(stereo_vn_rtn_d     [wanted_i]) EQ 1, stereo_vn_rtn_count)
                    stereo_ew_rtn_i      = where(finite(stereo_ew_rtn_d     [wanted_i]) EQ 1, stereo_ew_rtn_count)
                    stereo_ns_rtn_i      = where(finite(stereo_ns_rtn_d     [wanted_i]) EQ 1, stereo_ns_rtn_count)
                    IF stereo_vr_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_hertn_count NE stereo_ew_inst_count THEN stop
                    IF stereo_vr_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vt_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_vn_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ew_rtn_count   NE stereo_ew_inst_count THEN stop
                    IF stereo_ns_rtn_count   NE stereo_ew_inst_count THEN stop
                    hour_t                       [hour_i] = new_t                      [wanted_i[new_t_i[0]      ]]
                    IF stereo_ew_inst_count EQ 0 THEN $
                      hour_stereo_ew_inst_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_inst_count EQ 1 THEN $
                      hour_stereo_ew_inst_d      [hour_i] = stereo_ew_inst_d           [wanted_i[stereo_ew_inst_i]] ELSE BEGIN 
                        mom_ew_inst                       = moment(stereo_ew_inst_d    [wanted_i], /nan)
                        hour_stereo_ew_inst_d    [hour_i] = mom_ew_inst                [0]
                    ENDELSE 
                    IF stereo_vr_hertn_count EQ 0 THEN $
                      hour_stereo_vr_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vr_hertn_count EQ 1 THEN $
                      hour_stereo_vr_hertn_d     [hour_i] = stereo_vr_hertn_d          [wanted_i[stereo_vr_hertn_i]] ELSE BEGIN 
                        mom_vr_hertn                      = moment(stereo_vr_hertn_d   [wanted_i], /nan)
                        hour_stereo_vr_hertn_d   [hour_i] = mom_vr_hertn               [0]
                    ENDELSE 
                    IF stereo_vt_hertn_count EQ 0 THEN $
                      hour_stereo_vt_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vt_hertn_count EQ 1 THEN $
                      hour_stereo_vt_hertn_d     [hour_i] = stereo_vt_hertn_d          [wanted_i[stereo_vt_hertn_i]] ELSE BEGIN 
                        mom_vt_hertn                      = moment(stereo_vt_hertn_d   [wanted_i], /nan)
                        hour_stereo_vt_hertn_d   [hour_i] = mom_vt_hertn               [0]
                    ENDELSE 
                    IF stereo_vn_hertn_count EQ 0 THEN $
                      hour_stereo_vn_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vn_hertn_count EQ 1 THEN $
                      hour_stereo_vn_hertn_d     [hour_i] = stereo_vn_hertn_d          [wanted_i[stereo_vn_hertn_i]] ELSE BEGIN 
                        mom_vn_hertn                      = moment(stereo_vn_hertn_d   [wanted_i], /nan)
                        hour_stereo_vn_hertn_d   [hour_i] = mom_vn_hertn               [0]
                    ENDELSE 
                    IF stereo_ew_hertn_count EQ 0 THEN $
                      hour_stereo_ew_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_hertn_count EQ 1 THEN $
                      hour_stereo_ew_hertn_d     [hour_i] = stereo_ew_hertn_d          [wanted_i[stereo_ew_hertn_i]] ELSE BEGIN 
                        mom_ew_hertn                      = moment(stereo_ew_hertn_d   [wanted_i], /nan)
                        hour_stereo_ew_hertn_d   [hour_i] = mom_ew_hertn               [0]
                    ENDELSE 
                    IF stereo_ns_hertn_count EQ 0 THEN $
                      hour_stereo_ns_hertn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ns_hertn_count EQ 1 THEN $
                      hour_stereo_ns_hertn_d     [hour_i] = stereo_ns_hertn_d          [wanted_i[stereo_ns_hertn_i]] ELSE BEGIN 
                        mom_ns_hertn                      = moment(stereo_ns_hertn_d   [wanted_i], /nan)
                        hour_stereo_ns_hertn_d   [hour_i] = mom_ns_hertn               [0]
                    ENDELSE 
                    IF stereo_vr_rtn_count EQ 0 THEN $
                      hour_stereo_vr_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vr_rtn_count EQ 1 THEN $
                      hour_stereo_vr_rtn_d       [hour_i] = stereo_vr_rtn_d            [wanted_i[stereo_vr_rtn_i]] ELSE BEGIN 
                        mom_vr_rtn                        = moment(stereo_vr_rtn_d     [wanted_i], /nan)
                        hour_stereo_vr_rtn_d     [hour_i] = mom_vr_rtn                 [0]
                    ENDELSE 
                    IF stereo_vt_rtn_count EQ 0 THEN $
                      hour_stereo_vt_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vt_rtn_count EQ 1 THEN $
                      hour_stereo_vt_rtn_d       [hour_i] = stereo_vt_rtn_d            [wanted_i[stereo_vt_rtn_i]] ELSE BEGIN 
                        mom_vt_rtn                        = moment(stereo_vt_rtn_d     [wanted_i], /nan)
                        hour_stereo_vt_rtn_d     [hour_i] = mom_vt_rtn                 [0]
                    ENDELSE 
                    IF stereo_vn_rtn_count EQ 0 THEN $
                      hour_stereo_vn_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_vn_rtn_count EQ 1 THEN $
                      hour_stereo_vn_rtn_d       [hour_i] = stereo_vn_rtn_d            [wanted_i[stereo_vn_rtn_i]] ELSE BEGIN 
                        mom_vn_rtn                        = moment(stereo_vn_rtn_d     [wanted_i], /nan)
                        hour_stereo_vn_rtn_d     [hour_i] = mom_vn_rtn                 [0]
                    ENDELSE 
                    IF stereo_ew_rtn_count EQ 0 THEN $
                      hour_stereo_ew_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ew_rtn_count EQ 1 THEN $
                      hour_stereo_ew_rtn_d       [hour_i] = stereo_ew_rtn_d            [wanted_i[stereo_ew_rtn_i]] ELSE BEGIN 
                        mom_ew_rtn                        = moment(stereo_ew_rtn_d     [wanted_i], /nan)
                        hour_stereo_ew_rtn_d     [hour_i] = mom_ew_rtn                 [0]
                    ENDELSE 
                    IF stereo_ns_rtn_count EQ 0 THEN $
                      hour_stereo_ns_rtn_d      [hour_i] = !values.f_nan $
                    ELSE IF stereo_ns_rtn_count EQ 1 THEN $
                      hour_stereo_ns_rtn_d       [hour_i] = stereo_ns_rtn_d            [wanted_i[stereo_ns_rtn_i]] ELSE BEGIN 
                        mom_ns_rtn                        = moment(stereo_ns_rtn_d     [wanted_i], /nan)
                        hour_stereo_ns_rtn_d     [hour_i] = mom_ns_rtn                 [0]
                    ENDELSE 
                    hour_num_count_d            [hour_i] = stereo_ew_inst_count
                ENDIF 
                hour_i = hour_i + 1
            ENDIF 
        ENDFOR 
    ENDFOR 
    IF hour_i LT num_records THEN BEGIN 
        hour_t                       = hour_t                      [0:hour_i-1]
        hour_ew_source_flag_d        = hour_ew_source_flag_d       [0:hour_i-1, *]
        hour_uncertainty_d           = hour_uncertainty_d          [0:hour_i-1]
        hour_num_count_d             = hour_num_count_d            [0:hour_i-1]
        hour_stereo_ew_inst_d        = hour_stereo_ew_inst_d       [0:hour_i-1]
        hour_stereo_vr_hertn_d       = hour_stereo_vr_hertn_d      [0:hour_i-1]
        hour_stereo_vt_hertn_d       = hour_stereo_vt_hertn_d      [0:hour_i-1]
        hour_stereo_vn_hertn_d       = hour_stereo_vn_hertn_d      [0:hour_i-1]
        hour_stereo_ew_hertn_d       = hour_stereo_ew_hertn_d      [0:hour_i-1]
        hour_stereo_ns_hertn_d       = hour_stereo_ns_hertn_d      [0:hour_i-1]
        hour_stereo_vr_rtn_d         = hour_stereo_vr_rtn_d        [0:hour_i-1]
        hour_stereo_vt_rtn_d         = hour_stereo_vt_rtn_d        [0:hour_i-1]
        hour_stereo_vn_rtn_d         = hour_stereo_vn_rtn_d        [0:hour_i-1]
        hour_stereo_ew_rtn_d         = hour_stereo_ew_rtn_d        [0:hour_i-1]
        hour_stereo_ns_rtn_d         = hour_stereo_ns_rtn_d        [0:hour_i-1]
    ENDIF 
    store_data, num_count_1hr,             data = {x:hour_t, y:hour_num_count_d}
    store_data, ew_source_flag_1hr,        data = {x:hour_t, y:hour_ew_source_flag_d}
    store_data, uncertainty_1hr,           data = {x:hour_t, y:hour_uncertainty_d}
    store_data, stereo_ew_inst_1hr,        data = {x:hour_t, y:hour_stereo_ew_inst_d}
    store_data, stereo_vr_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vr_hertn_d}
    store_data, stereo_vt_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vt_hertn_d}
    store_data, stereo_vn_hertn_1hr,       data = {x:hour_t, y:hour_stereo_vn_hertn_d}
    store_data, stereo_ew_hertn_1hr,       data = {x:hour_t, y:hour_stereo_ew_hertn_d}
    store_data, stereo_ns_hertn_1hr,       data = {x:hour_t, y:hour_stereo_ns_hertn_d}
    store_data, stereo_vr_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vr_rtn_d}
    store_data, stereo_vt_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vt_rtn_d}
    store_data, stereo_vn_rtn_1hr,         data = {x:hour_t, y:hour_stereo_vn_rtn_d}
    store_data, stereo_ew_rtn_1hr,         data = {x:hour_t, y:hour_stereo_ew_rtn_d}
    store_data, stereo_ns_rtn_1hr,         data = {x:hour_t, y:hour_stereo_ns_rtn_d}
ENDIF 
END 
