;+
; PROCEDURE: pl_calc_alpha_katelyn
; PURPOSE:
;  This creates tplot variables for alpha distributions.
;
; INPUT
; PARAMETERS: sats     : Array of sats wanted ('A' or 'B' or both)
;             sources  : 00: SW-all                 : h_alpha
;                        01: SW-H(D)                : h+peak
;                        02: SW-alpha(D)            : he++peak
;                        03: SW-alpha(T)            : he++trc
;                        04: SW PHA PRIORITY RATES  : sw_priority_00
;                        05: SW PHA PRIORITY RATES  : sw_priority_01
;         
;             functions: 00: f(v) = 70*EXP(.000003*v/SQRT(2))
;                        01: Kristin's Efficiency table
;                        02: f(v) = 120/((-6.30369334716773E-19*(v^3))-(8.63692363656727E-13*(v^2))+(5.9564934852831E-7*v)+(6.59619620444739E-1))
;             ave_time : time (in minutes) over which to create alpha products
;
; CREATED BY: L. Ellis
;
; MODIFICATION HISTORY:
;    06/15/2009: LBE: Created
;    07/21/2009: LBE: Added background subtraction.
;    07/22/2009: LBE: Made background subtraction an option.
;    07/23/2009: LBE: Look for negative numbers in dist.
;    07/24/2009: LBE: Add fit to proton spillover peak.
;    07/27/2009: LBE: Check for good_i gt 3 for gaussfit
;    07/27/2009: LBE: Added proton_sub keyword.
;    07/30/2009: LBE: Changes so only subtract if flag not set.
;    08/06/2009: LBE: Check if temp_schan_esa eq 128.
;

PRO pl_calc_alpha_katelyn, sats, sources, functions, ave_time, toni_files = toni_files, bkgd_sub = bkgd_sub, proton_sub = proton_sub

FOR ii = 0, n_elements(sats)-1 DO BEGIN
    sat = sats[ii]
    
    ; schan energy table
    IF keyword_set(toni_files) THEN ESA_file_s = '~/splat/splat_user/Cribs/Alphas/schan_esa_table_20090527.txt' $
      ELSE ESA_file_s = '~/splat/splat_user/Cribs/Alphas/leakage_energy_per_charge.txt'
    openr, in_lun, ESA_file_s, /GET_LUN
    line = " "
    alpha_vel_table_s = fltarr(128)
    readf, in_lun, line         ; read past first line
    FOR i = 0, 127 DO BEGIN
        readf, in_lun, line
        parts = STRSPLIT(line, /EXTRACT)
        IF sat EQ 'A' THEN BEGIN
            IF keyword_set(toni_files) THEN alpha_vel_table_s[i] = 439.28*1000*sqrt(float(parts[1])*2/4.0026) $ ; convert E/Q to V (m/s)
            ELSE alpha_vel_table_s[i] = float(parts[1])/sqrt(2) ; convert proton V (m/s) to alpha V (m/s)
        ENDIF ELSE alpha_vel_table_s[i] = float(parts[3])/sqrt(2) ; convert proton V (m/s) to alpha V (m/s)
    ENDFOR
    close, in_lun
    free_lun, in_lun
    ; main energy table
    IF keyword_set(toni_files) THEN BEGIN 
        ESA_file_m = '~/splat/splat_user/Cribs/Alphas/main_esa_table_20090527.txt' 
        openr, in_lun, ESA_file_m, /GET_LUN
        line = " "
        alpha_vel_table_m = fltarr(128)
        readf, in_lun, line     ; read past first line
        FOR i = 0, 127 DO BEGIN 
            readf, in_lun, line
            parts = STRSPLIT(line, /EXTRACT)
            IF sat EQ 'A' THEN alpha_vel_table_m[i] = 439.28*1000*sqrt(float(parts[1])*2/4.0026) $ ; convert E/Q to V (m/s)
            ELSE stop           ; this assumes A!!!!    
        ENDFOR
        close, in_lun
        free_lun, in_lun
    ENDIF ELSE alpha_vel_table_m = alpha_vel_table_s


    FOR jj = 0, n_elements(sources)-1 DO BEGIN 
        mon_spec_prod = ['s_valid', 'ra_trig']
        pla_plot_mon_spec, sat, mon_spec_prod, 'counts'
        source = sources[jj]
        ; Load Level 1 data
        IF source GE 0 AND source LE 3 THEN en_spec_prod = [sat+string(source+1, format = '(I2.2)')] ELSE $
          IF source EQ 4 THEN en_spec_prod = [sat+'10/0'] ELSE $
          IF source EQ 5 THEN en_spec_prod = [sat+'10/1'] ELSE BEGIN 
            print, 'invalid source'
            stop
        ENDELSE 
        IF keyword_set(bkgd_sub) THEN BEGIN 
            IF source EQ 5 THEN BEGIN ; assuming sw pri 1 at the moment
                dat = get_pla_sw_priority(sat, 1)
                dat = convert_plastic_units(dat, 'c/s')
                var1 = 'ST'+sat+'_PLA_C/S_SW_PRIORITY_01'
                store_data, var1, data = {x: dat.time, y: dat.data}
                get_data, var1, pri_t, pri_d
                background = (pri_d[*, 0, *]+pri_d[*, 15, *]) / 2
                temp_pri_d = pri_d
                FOR kk = 0, 15 DO BEGIN 
                    pri_d[*, kk, *] = pri_d[*, kk, *] - background
                ENDFOR 
                norm =  dat.nposition * dat.ndeflection
                zdata = TOTAL(REFORM(pri_d(*, *, *)), 2, /NaN) / norm
                var = 'ST'+sat+'_PLA_ENSPEC_C/S_SW_PRIORITY_01_bkgd'
                store_data, var, data = {x: pri_t, y: zdata}
            ENDIF ELSE stop     ; need to add code here for other arrays
        ENDIF 
        pla_plot_en_spec, en_spec_prod, 'C/S', diagn = 0, nodisplay = 1

        ; Adjust reduced dist to 128 arrays (and multiply by schan factor?)
        IF source LE 3 THEN adjust_reduced_dist, 'STA_PLA_ENSPEC_C/S_H_ALPHA', 1

        ; Adjust schan based on function
        FOR kk = 0, n_elements(functions)-1 DO BEGIN
            func = functions[kk]

            CASE source OF
                0: var = 'ST'+sat+'_PLA_ENSPEC_C/S_H_ALPHA'
                1: var = 'ST'+sat+'_PLA_ENSPEC_C/S_H+PEAK'
                2: var = 'ST'+sat+'_PLA_ENSPEC_C/S_HE++PEAK'
                3: var = 'ST'+sat+'_PLA_ENSPEC_C/S_H'
                4: var = 'ST'+sat+'_PLA_ENSPEC_C/S_SW_PRIORITY_00'
                5: var = 'ST'+sat+'_PLA_ENSPEC_C/S_SW_PRIORITY_01'
            ENDCASE 
            var_bkgd       = var+'_bkgd'
            var_schan_only = var+'_schan_only'
            var_main_only  = var+'_main_only'
            IF keyword_set(bkgd_sub) THEN var_wanted = var_bkgd ELSE var_wanted = var
            adjust_alpha_schan_katelyn, var_wanted,     func, alpha_vel_table_s
            adjust_alpha_schan_katelyn, var_schan_only, func, alpha_vel_table_s
            adjust_alpha_schan_katelyn, var_main_only,  func, alpha_vel_table_s

            ; adjust alpha dist
            var_flux            = var_wanted    +'_alpha_flux'
            var_schan_only_flux = var_schan_only+'_alpha_flux'
            var_main_only_flux  = var_main_only +'_alpha_flux'
            schan_esa = var+'_s_chan_esa'
            get_data, schan_esa, schan_t, schan_esa_d
            schan_esa_d = float(schan_esa_d)
            temp_i = where(schan_esa_d EQ -1, count)
            IF count GT 0 THEN BEGIN
                schan_esa_d[temp_i] = !values.f_nan
                store_data, schan_esa, data = {x:schan_t, y:schan_esa_d}
            ENDIF 

            average_tplot_variable, var_flux, (ave_time*60) 
            average_tplot_variable, var_schan_only_flux, (ave_time*60)
            average_tplot_variable, var_main_only_flux,  (ave_time*60)
            average_tplot_variable, schan_esa,           (ave_time*60)

            get_data, var_flux, flux_t, flux_d
            get_data, var_schan_only_flux, flux_t, flux_schan_only_d
            get_data, var_main_only_flux, flux_t, flux_main_only_d
            get_data, schan_esa, schan_t, schan_esa_d

 
            ; put time back to beginning of interval
            flux_t = flux_t - (ave_time*30)
            store_data, var_flux,            data = {x:flux_t, y:flux_d}
            store_data, var_schan_only_flux, data = {x:flux_t, y:flux_schan_only_d}
            store_data, var_main_only_flux,  data = {x:flux_t, y:flux_main_only_d}
            store_data, schan_esa,           data = {x:flux_t, y:schan_esa_d}

            new_flux_d = flux_d/7.1E-8 ; m^2 sr eV/eV (divide by main channel geometric factor)
            new_flux_schan_only_d = flux_schan_only_d/7.1E-8 
            new_flux_main_only_d = flux_main_only_d/7.1E-8 
            new_flux_d = new_flux_d / .8 ; RA_TRIG efficiency
            new_flux_schan_only_d = new_flux_schan_only_d / .8
            new_flux_main_only_d = new_flux_main_only_d / .8
            FOR mm = 0L, n_elements(flux_t)-1 DO BEGIN
                ; new_flux_d[mm, *] = 0.0218*0.7854*new_flux_d[mm, *]/(alpha_vel_table^2)
                IF finite(schan_esa_d[mm]) EQ 1 THEN BEGIN 
                    temp_schan_esa = round(schan_esa_d[mm])
                    new_flux_d[mm, 0:temp_schan_esa-1] = $
                      0.0218*0.7854*new_flux_d[mm, 0:temp_schan_esa-1]/(alpha_vel_table_m[0:temp_schan_esa-1]^2)
                    IF temp_schan_esa LT 128 THEN new_flux_d[mm, temp_schan_esa:127] = $
                      0.0218*0.7854*new_flux_d[mm, temp_schan_esa:127]/(alpha_vel_table_s[temp_schan_esa:127]^2)
                    new_flux_schan_only_d[mm, *] = 0.0218*0.7854*new_flux_schan_only_d[mm, *]/(alpha_vel_table_s^2)
                    new_flux_main_only_d[mm, *] = 0.0218*0.7854*new_flux_main_only_d[mm, *]/(alpha_vel_table_m^2)
                ENDIF ELSE BEGIN
                    new_flux_d           [mm, *] = !values.f_nan
                    new_flux_schan_only_d[mm, *] = !values.f_nan
                    new_flux_main_only_d [mm, *] = !values.f_nan
                ENDELSE 
            ENDFOR 

            ; find alpha peak and proton spillover peak via proton velocity
            pl_plot_l2_1dmax, sat, order = 3
            proton_vel = sat+'_l2_1dmax_proton_bulk_speed'
            get_data, proton_vel, proton_t, proton_vel_d
            proton_spill_vel_d = proton_vel_d / (sqrt(2)) ; put in alpha space
            alpha_peak_i  = lonarr(n_elements(flux_t))
            proton_peak_i = lonarr(n_elements(flux_t))
            FOR mm = 0L, n_elements(flux_t)-1 DO BEGIN
                wanted_i = where(proton_t GE flux_t[mm] AND proton_t LT flux_t[mm]+(ave_time*60), count)
                IF count GT 0 THEN BEGIN
                    IF count GT 1 THEN BEGIN 
                        mom = moment(proton_vel_d[wanted_i], /nan)
                        proton_vel = mom[0] * 1000 ; change from km/s to m/s
                        mom = moment(proton_spill_vel_d[wanted_i], /nan)
                        proton_spill_vel = mom[0] * 1000 ; change from km/s to m/s
                    ENDIF ELSE proton_vel = proton_vel_d[wanted_i] * 1000
                    ; need to check both tables (Main and s) and where each peak falls
                    ; Alphas
                    diff_m = abs(alpha_vel_table_m-proton_vel) 
                    diff_s = abs(alpha_vel_table_s-proton_vel) 
                    peak_value_m = min(diff_m, temp_alpha_peak_i_m)
                    peak_value_s = min(diff_s, temp_alpha_peak_i_s)
                    temp_schan_esa = round(schan_esa_d[mm])
                    IF temp_alpha_peak_i_m LT temp_schan_esa AND temp_alpha_peak_i_s LT temp_schan_esa THEN $
                      alpha_peak_i[mm] = temp_alpha_peak_i_m $
                    ELSE IF temp_alpha_peak_i_m GE temp_schan_esa AND temp_alpha_peak_i_s GE temp_schan_esa THEN $
                      alpha_peak_i[mm] = temp_alpha_peak_i_s $
                         ELSE alpha_peak_i[mm] = temp_alpha_peak_i_m ; random choice between main and s
                    ; Proton spillover
                    diff_m = abs(alpha_vel_table_m-proton_spill_vel) 
                    diff_s = abs(alpha_vel_table_s-proton_spill_vel) 
                    peak_value_m = min(diff_m, temp_proton_peak_i_m)
                    peak_value_s = min(diff_s, temp_proton_peak_i_s)
                    temp_schan_esa = round(schan_esa_d[mm])
                    IF temp_proton_peak_i_m LT temp_schan_esa AND temp_proton_peak_i_s LT temp_schan_esa THEN $
                      proton_peak_i[mm] = temp_proton_peak_i_m $
                    ELSE IF temp_proton_peak_i_m GE temp_schan_esa AND temp_proton_peak_i_s GE temp_schan_esa THEN $
                      proton_peak_i[mm] = temp_proton_peak_i_s $
                         ELSE proton_peak_i[mm] = temp_proton_peak_i_m ; random choice between main and s
                ENDIF ELSE  new_flux_d[mm, *] = !values.f_nan
            ENDFOR 

            ; adjust by ratio -- divide all esa of counts by ratio at peak
            ; Create svalid/ratrig ratio
            get_data, 's_valid_counts_norm_science', svalid_t, svalid_d;, svalid_v
            get_data, 'ra_trig_counts_norm_science', ratrig_t, ratrig_d;, ratrig_v
            IF array_equal(svalid_t, ratrig_t) NE 1 THEN stop ; We don't expect this to happen!!!!
            replace_mon_norm_overflow, svalid_d
            replace_mon_norm_overflow, ratrig_d
            FOR mm = 0L, n_elements(flux_t)-1 DO BEGIN 
                wanted_i = where(ratrig_t GE (flux_t[mm]) AND ratrig_t LT (flux_t[mm]+(ave_time*60)), wanted_count) 
                IF wanted_count GT 1 THEN BEGIN
                    IF alpha_peak_i[mm] LT 0 OR alpha_peak_i[mm] GT 127 THEN BEGIN
                        print, "invalid entry for esa"
                        stop
                    ENDIF
                    svalid_m = moment(svalid_d[wanted_i, alpha_peak_i[mm]/4])
                    ratrig_m = moment(ratrig_d[wanted_i, alpha_peak_i[mm]/4])
                    ratio = svalid_m[0]/ratrig_m[0]
                    new_flux_d[mm, *] = new_flux_d[mm, *] / ratio
                    new_flux_schan_only_d[mm, *] = new_flux_schan_only_d[mm, *] / ratio
                    new_flux_main_only_d[mm, *] = new_flux_main_only_d[mm, *] / ratio
                ENDIF ELSE IF count EQ 1 THEN BEGIN 
                    IF alpha_peak_i[mm] LT 0 OR alpha_peak_i[mm] GT 127 THEN BEGIN
                        print, "invalid entry for esa"
                        stop
                    ENDIF
                    ratio = svalid_m[wanted_i]/ratrig_m[wanted_i]
                    new_flux_d[mm, *] = new_flux_d[mm, *] / ratio
                    new_flux_schan_only_d[mm, *] = new_flux_schan_only_d[mm, *] / ratio
                    new_flux_main_only_d[mm, *] = new_flux_main_only_d[mm, *] / ratio
                ENDIF 
            ENDFOR 
            alpha_dist = sat+'_alpha_dist'
            store_data, alpha_dist, data = {x:flux_t, y:new_flux_d}
            alpha_dist = sat+'_alpha_dist_schan_only'
            store_data, alpha_dist, data = {x:flux_t, y:new_flux_schan_only_d}
            alpha_dist = sat+'_alpha_dist_main_only'
            store_data, alpha_dist, data = {x:flux_t, y:new_flux_main_only_d}
            alpha_peak_esa = sat+'_alpha_expected_peak_esa'
            store_data, alpha_peak_esa, data = {x:flux_t, y:alpha_peak_i}

            ; To make it easier for IDL to get a good fit to the curve, multiply the distribution by
            ; 1e5.  Remember to divide the density by this factor later on!
            dist               = new_flux_d
            dist_schan_only    = new_flux_schan_only_d
            dist_main_only     = new_flux_main_only_d
            dist               = dist*(1.0E5)
            dist_schan_only    = dist_schan_only*(1.0E5)
            dist_main_only     = dist_main_only*(1.0E5)
            coeff              = dblarr(3)   ; A matrix in which to store the fit coefficients 
            coeff_schan_only   = dblarr(3)  
            coeff_main_only    = dblarr(3)
            density            = dblarr(n_elements(flux_t))
            density_schan_only = dblarr(n_elements(flux_t))
            density_main_only  = dblarr(n_elements(flux_t))
            avg_v              = dblarr(n_elements(flux_t))
            avg_v_schan_only   = dblarr(n_elements(flux_t))
            avg_v_main_only    = dblarr(n_elements(flux_t))
            temp_k             = dblarr(n_elements(flux_t))
            temp_k_schan_only  = dblarr(n_elements(flux_t))
            temp_k_main_only   = dblarr(n_elements(flux_t))
            v_th               = dblarr(n_elements(flux_t))
            v_th_schan_only    = dblarr(n_elements(flux_t))
            v_th_main_only     = dblarr(n_elements(flux_t))
            katelyn_dist       = dblarr(n_elements(flux_t), 128) ; 17 elements in fit at each time
            katelyn_fit        = dblarr(n_elements(flux_t), 128) ; 17 elements in fit at each time
            proton_dist        = dblarr(n_elements(flux_t), 128)
            proton_fit         = dblarr(n_elements(flux_t), 128)
            proton_fit_full    = dblarr(n_elements(flux_t), 128)
            proton_chisq       = dblarr(n_elements(flux_t))
	    chisq	       = dblarr(n_elements(flux_t))
	    alpha_flag         = dblarr(n_elements(flux_t))
	    proton_flag        = dblarr(n_elements(flux_t))
	    katelyn_dist[*]    = !values.f_nan
	    katelyn_fit[*]     = !values.f_nan
	    proton_dist[*]     = !values.f_nan
	    proton_fit[*]      = !values.f_nan
            proton_fit_full[*] = !values.f_nan
            FOR mm = 0L, n_elements(flux_t)-1 DO BEGIN 
                ; Proton Spillover
                valid = 1
                IF (proton_peak_i[mm] GE 4) AND (proton_peak_i[mm] LE 121) THEN BEGIN
                    k = proton_peak_i[mm]-4
                    m = proton_peak_i[mm]+6  
                ENDIF ELSE IF proton_peak_i[mm] GE 4 THEN BEGIN
                    k = proton_peak_i[mm]-4	
                    m = 127
                ENDIF ELSE BEGIN  ; peak lt 4
                    k = 0	
                    m = proton_peak_i[mm]+6
                ENDELSE 
                proton_dist[mm, k:m] = dist[mm, k:m]
                temp_schan_esa = round(schan_esa_d[mm])
		bad_i = where(dist eq 0, count)
		if count gt 0 then dist[bad_i] = !values.f_nan
                temp_dist = reform(dist[mm, k:m])
                temp_alpha_vel_table = alpha_vel_table_s[k:m]
                temp_proton_fit = dblarr(m-k+1)
                temp_proton_fit[*] = !values.f_nan
                bad_i = where(finite(temp_dist) eq 0 OR temp_dist LT 0, bad_count, $
                              complement = good_i, ncomplement = good_count)
                if bad_count gt 0 and good_count gt 3 then begin
                    temp_dist_a = temp_dist[good_i]
                    temp_alpha_vel_table_a = temp_alpha_vel_table[good_i]
                    print, mm
                    FIT_MATRIX = GAUSSFIT(double(temp_alpha_vel_table_a), temp_dist_a, coeff, $
                                          nterms = 3, measure_errors = SQRT(temp_dist_a), chisq = temp_chisq) 
                    temp_proton_fit[good_i] = fit_matrix
                    proton_fit[mm, k:m] = temp_proton_fit
                                ;stop
                endif else if good_count gt 3 then begin
                    FIT_MATRIX = GAUSSFIT(double(alpha_vel_table_s[k:m]), reform(dist[mm, k:m]), coeff, $
                                          nterms = 3, measure_errors = SQRT(reform(dist[mm, k:m])), chisq = temp_chisq)
                    proton_fit[mm, k:m] = fit_matrix
                endif else BEGIN
                    print, "not enough valid data at time index", mm
                    coeff[*] = !values.f_nan
                    temp_chisq = !values.f_nan
                ENDELSE 
                x = alpha_vel_table_s
                z = (x - coeff[1]) / coeff[2]
                proton_fit_full[mm, *] = coeff[0] * (2.71827^((-1.0*(z^2))/2))
                proton_chisq[mm] = temp_chisq 
		IF coeff[1] GT alpha_vel_table_s[k] THEN BEGIN
			proton_flag[mm] = 1
		ENDIF ELSE IF coeff[1] LT alpha_vel_table_s[m] THEN BEGIN
			proton_flag[mm] = 1
		ENDIF ELSE BEGIN
			proton_flag[mm] = 0     
		ENDELSE          

                ; Alphas
                IF keyword_set(proton_sub) AND proton_flag[mm] EQ 0 THEN dist[mm, *] = dist[mm, *] - proton_fit_full[mm, *]
                valid = 1
                ;IF (alpha_peak_i[mm] LT 119) AND (alpha_peak_i[mm] GE 4) THEN BEGIN
                IF (alpha_peak_i[mm] GE 12) AND (alpha_peak_i[mm] LE 121) THEN BEGIN
                    k = alpha_peak_i[mm]-12
                    m = alpha_peak_i[mm]+6  
                ENDIF ELSE IF alpha_peak_i[mm] GE 4 THEN BEGIN
                    k = alpha_peak_i[mm]-12	
                    m = 127
                ENDIF ELSE BEGIN  ; peak lt 4
                    k = 0	
                    m = alpha_peak_i[mm]+6
                ENDELSE 
		katelyn_dist[mm, k:m] =dist[mm, k:m]
                temp_schan_esa = round(schan_esa_d[mm])
		bad_i = where(dist eq 0, count)
		if count gt 0 then dist[bad_i] = !values.f_nan
		temp_dist=reform(dist[mm, k:m])
		temp_alpha_vel_table = alpha_vel_table_s[k:m]
		temp_katelyn_fit = dblarr(m-k+1)
		temp_katelyn_fit[*] = !values.f_nan
		bad_i=where(finite(temp_dist) eq 0 OR temp_dist LT 0, bad_count, $
                            complement = good_i, ncomplement = good_count)
                if bad_count gt 0 and good_count gt 3 then begin
                    temp_dist_a = temp_dist[good_i]
                    temp_alpha_vel_table_a = temp_alpha_vel_table[good_i]
                    print, mm
                    FIT_MATRIX = GAUSSFIT(double(temp_alpha_vel_table_a), temp_dist_a, coeff, $
                                          nterms = 3, measure_errors = SQRT(temp_dist_a), chisq = temp_chisq) 
                    temp_katelyn_fit[good_i] = fit_matrix
                    katelyn_fit[mm, k:m] = temp_katelyn_fit
                    ;stop
                endif else if good_count gt 3 then begin
                    FIT_MATRIX = GAUSSFIT(double(alpha_vel_table_s[k:m]), reform(dist[mm, k:m]), coeff, $
                                          nterms = 3, measure_errors = SQRT(reform(dist[mm, k:m])), chisq = temp_chisq)
                    katelyn_fit[mm, k:m] = fit_matrix
                    ;stop
                endif else BEGIN
                    print, "not enough valid data at time index", mm
                    coeff[*] = !values.f_nan
                    temp_chisq = !values.f_nan
                ENDELSE 
                chisq[mm] = temp_chisq                  
                    ; katelyn_fit[mm, k:m] =fit_matrix
                density[mm] = coeff[0]*((2*!PI)^(0.5))*coeff[2]*1.0E-11 ; 1/cc
                IF coeff[1] GT alpha_vel_table_s[k] THEN BEGIN
                    alpha_flag[mm] = 1
		ENDIF ELSE IF coeff[1] LT alpha_vel_table_s[m] THEN BEGIN
		    alpha_flag[mm] = 1
                ENDIF ELSE BEGIN
                    alpha_flag[mm] = 0
                ENDELSE
	;stop
                avg_v[mm] = coeff[1]*1.0E-3 ; km/s
                temp_k[mm] = (coeff[2]^2)*(1.67E-27)/(1.38E-23) ;deg K
                v_th[mm] = SQRT(2)*(coeff[2])*1.0E-3 ; km/s
                bad_i = where(finite(coeff) EQ 0, bad_count)
                IF bad_count GT 0 THEN BEGIN
                    density[mm] = !values.f_nan
                    avg_v[mm]   = !values.f_nan
                    temp_k[mm]  = !values.f_nan
                    v_th[mm]    = !values.f_nan
                ENDIF 
                    ; schan only
                FIT_MATRIX = GAUSSFIT(double(alpha_vel_table_s[k:m]), reform(dist_schan_only[mm, k:m]), $
                                      coeff_schan_only, $
                                      nterms = 3, measure_errors = SQRT(reform(dist_schan_only[mm, k:m])), $
                                      chisq = temp_chisq)
                density_schan_only[mm] = coeff_schan_only[0]*((2*!PI)^(0.5))*coeff_schan_only[2]*1.0E-11 ; 1/cc
                avg_v_schan_only[mm] = coeff_schan_only[1]*1.0E-3 ; km/s
                temp_k_schan_only[mm] = (coeff_schan_only[2]^2)*(1.67E-27)/(1.38E-23) ;deg K
                v_th_schan_only[mm] = SQRT(2)*(coeff_schan_only[2])*1.0E-3 ; km/s
                bad_i = where(finite(coeff_schan_only) EQ 0, bad_count)
                IF bad_count GT 0 THEN BEGIN
                    density_schan_only[mm] = !values.f_nan
                    avg_v_schan_only[mm]   = !values.f_nan
                    temp_k_schan_only[mm]  = !values.f_nan
                    v_th_schan_only[mm]    = !values.f_nan
                ENDIF 
                    ; main only
                FIT_MATRIX = GAUSSFIT(double(alpha_vel_table_m[k:m]), reform(dist_main_only[mm, k:m]), $
                                      coeff_main_only, $
                                      nterms = 3, measure_errors = SQRT(reform(dist_main_only[mm, k:m])), $
                                      chisq = temp_chisq)
                density_main_only[mm] = coeff_main_only[0]*((2*!PI)^(0.5))*coeff_main_only[2]*1.0E-11 ; 1/cc
                avg_v_main_only[mm] = coeff_main_only[1]*1.0E-3 ; km/s
                temp_k_main_only[mm] = (coeff_main_only[2]^2)*(1.67E-27)/(1.38E-23) ;deg K
                v_th_main_only[mm] = SQRT(2)*(coeff_main_only[2])*1.0E-3 ; km/s
                bad_i = where(finite(coeff_main_only) EQ 0, bad_count)
                IF bad_count GT 0 THEN BEGIN
                    density_main_only[mm] = !values.f_nan
                    avg_v_main_only[mm]   = !values.f_nan
                    temp_k_main_only[mm]  = !values.f_nan
                    v_th_main_only[mm]    = !values.f_nan
                ENDIF 
            ENDFOR 
            ;density = density * 32 ; LBE added for checking
            store_data, 'proton_dist',     data = {x:flux_t, y:proton_dist}
            store_data, 'proton_fit',      data = {x:flux_t, y:proton_fit}
            store_data, 'proton_fit_full', data = {x:flux_t, y:proton_fit_full}
            store_data, 'katelyn_dist',    data = {x:flux_t, y:katelyn_dist}
            store_data, 'katelyn_fit',     data = {x:flux_t, y:katelyn_fit}
            temp_time = flux_t[0]
            store_data, 'vel_table',       data = {x:temp_time, y:alpha_vel_table_s}
            store_data, 'density',         data = {x:flux_t, y:density}
            store_data, 'velocity',        data = {x:flux_t, y:avg_v}
            store_data, 'temperature',     data = {x:flux_t, y:temp_k}
            store_data, 'thermal_vel',     data = {x:flux_t, y:v_th}
            store_data, 'dist_schan_only', data = {x:flux_t, y: dist_schan_only}
            store_data, 'dist_main_only',  data = {x:flux_t, y: dist_main_only}
            store_data, 'chisq',           data = {x:flux_t, y: chisq}
            store_data, 'proton_chisq',    data = {x:flux_t, y: proton_chisq}
            store_data, 'alpha_flag',    data = {x:flux_t, y:alpha_flag}
	    store_data, 'proton_flag', data = {x:flux_t, y:proton_flag}
        ENDFOR 
    ENDFOR 
    store_data, ['s_valid_counts_norm_science', 'ra_trig_counts_norm_science'], /DEL
ENDFOR  

END
