;+
;PROCEDURE: pl_calc_alpha_bulk_from_crib
;
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
; 	Modified by K. Simunac to call procedures for processing
;	full resolution rate data
;
;	Most recent modification:  01 November, 2010
;       01 November 2010: KDCS  created
;-


PRO pl_calc_alpha_bulk_from_crib, sat, time, num_days, table_location, INST_COORD=INST_COORD


COMMON get_error, get_err_no, get_err_msg, default_verbose
COMMON share1_high_res
COMMON com_high_res

; expand timespan by an hour on each end
get_timespan, ts
start_time = ts[0]-3600  ; go back an hour
stop_time = ts[1]+3600
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds

IF sat EQ 'A' THEN BEGIN
	
	sat_a_rate = ['sf0','ra_trig']
	
	; Figure out which files we need to read from
	 seek_files, 'A', 'science', files_a
	 dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
	 IF num_a_valid_files EQ 0 THEN print, "No files found for spacecraft A"

	; Read data, make calculations and plots
	IF num_a_valid_files GT 0 THEN BEGIN
		pl_read_cdf_high_res,'A',files_a, 1, time
	ENDIF

  	IF num_a_valid_files GT 0 AND (total(sf0_a_full, /nan) GT 0 OR total(ra_trig_a_full, /nan) GT 0) THEN BEGIN
		calc_alpha_bulk, 'A', files_a, 1, time, num_days, table_location
 	 ENDIF


ENDIF ELSE BEGIN

	sat_b_rate = ['sf0','ra_trig']

	; Figure out which files we need to read from
	 seek_files, 'B', 'science', files_b
  	 dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  	 IF num_b_valid_files EQ 0 THEN print, "No files found for spacecraft B"

	 ; Read data, make calculations and plots
  	IF num_b_valid_files GT 0 THEN BEGIN
		pl_read_cdf_high_res,'B',files_b, 1, time
	ENDIF

  	IF num_b_valid_files GT 0 AND (total(sf0_b_full, /nan) GT 0 OR total(ra_trig_b_full, /nan) GT 0) THEN BEGIN
		calc_alpha_bulk, 'B', files_b, 1, time, num_days, table_location
  	ENDIF

ENDELSE

close, /all

; return to original timespan
get_timespan, ts
start_time = ts[0]+3600  ; go back an hour
stop_time = ts[1]-3600
num_sec = stop_time-start_time+1
timespan, start_time, num_sec, /seconds

PRINT, 'Program Complete'
END
