;+
;PROCEDURE: make_tplot_struct_mon
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/12/2007
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	November, 2006:  K. Simunac modified for monitor rates products
;	12 Jan, 2007:  modified variable and program names to avoid confusion
;-

PRO make_tplot_struct_mon, sat, prod_mon, HZ, E_step, NO_ENG
compile_opt strictarrsubs
COMMON tplot_com1
mon_finished = 0
FOR ii = 0, n_elements(prod_mon)-1 DO BEGIN 
    SWITCH prod_mon[ii] OF 

	's_valid':	;0
	's_e_not_req':	;1
	's_e_req':	;2
	's_no_pos':	;3
	's_mult_pos':	;4
	's_no_e':	;5
	's_mult_e':	;6
	'ra_sat_a':	;7
	'ra_sat_b':	;8
	'ra_sat_both':	;9
	'ssd_sw':	;10
	'ssd_st':	;11
	'sf0':	;12
	'sfr0':	;13
	'stp0':	;14
	'ra_trig':	;15
	'pos1_0':	;16
	'pos1_1':	;17
	'w_no_pos':	;18
	'w_mult_pos':	;19
	'w_valid':	;20
	'sf2':	;21
	'sfr2':	;22
	'stp2':	;23
	'pos2_0':	;24
	'pos2_1':	;25
	'pos2_2':	;26
	'pos2_3':	;27
	'pos3_0':	;28
	'pos3_1':	;29
	'pos3_2':	;30
	'pos3_3':  	;31
	'stop0':
	'start0':
	'stop2':
	'start2':  BEGIN
	
            IF (mon_finished EQ 0) AND (NO_ENG EQ 0) THEN BEGIN 
                make_mon_struct, HZ, sat, prod_mon, E_step
                mon_finished = 1
            ENDIF ELSE BEGIN
		IF (mon_finished EQ 0) AND (NO_ENG EQ 1) THEN BEGIN
			make_mon_struct_no_eng, HZ, sat, prod_mon, E_step
			mon_finished = 1
		ENDIF
	    ENDELSE
            BREAK 
        END 
    ENDSWITCH 
ENDFOR 
END 
