; 02/19/2010 LBE -- created

PRO get_pla_l2_alphas, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'l2_alphas_prelim', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'error'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_err, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'fit_flag'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_fit, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'channel_flag'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_chn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'red_chi_sq'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_chi, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_den, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_bulk_speed_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vel_inst, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_bulk_speed_inertial'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vel_inert, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_temperature'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_tem, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_thermal_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_vth, rec_count = epochinfo.maxrec+1, /zvariable
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                err             = REFORM(cdf_err)
                fit             = REFORM(cdf_fit)
                chn             = REFORM(cdf_chn)
                chi             = REFORM(cdf_chi)
                den             = REFORM(cdf_den)
                vel_inst        = REFORM(cdf_vel_inst)
                vel_inert       = REFORM(cdf_vel_inert)
                tem             = REFORM(cdf_tem)
                vth             = REFORM(cdf_vth)
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                err             = [err,             REFORM(            cdf_err       )]
                fit             = [fit,             REFORM(            cdf_fit       )]
                chn             = [chn,             REFORM(            cdf_chn       )]
                chi             = [chi,             REFORM(            cdf_chi       )]
                den             = [den,             REFORM(            cdf_den       )]
                vel_inst        = [vel_inst,        REFORM(            cdf_vel_inst  )]
                vel_inert       = [vel_inert,       REFORM(            cdf_vel_inert )]
                tem             = [tem,             REFORM(            cdf_tem       )]
                vth             = [vth,             REFORM(            cdf_vth       )]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

get_timespan, ts
wanted_i = where(converted_epoch GE ts[0] AND converted_epoch LE ts[1], wanted_count)
IF wanted_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[wanted_i]
    err       = err      [wanted_i]
    fit       = fit      [wanted_i]
    chn       = chn      [wanted_i]
    chi       = chi      [wanted_i]
    den       = den      [wanted_i]
    vel_inst  = vel_inst [wanted_i]
    vel_inert = vel_inert[wanted_i]
    tem       = tem      [wanted_i]
    vth       = vth      [wanted_i]
ENDIF ELSE BEGIN 
    print, 'no data in timespan'
    return
ENDELSE 

bad_chi_i       = where(chi       LT -1e+30, bad_chi_c)
bad_den_i       = where(den       LT -1e+30, bad_den_c)
bad_vel_inst_i  = where(vel_inst  LT -1e+30, bad_vel_inst_c)
bad_vel_inert_i = where(vel_inert LT -1e+30, bad_vel_inert_c)
bad_tem_i       = where(tem       LT -1e+30, bad_tem_c)
bad_vth_i       = where(vth       LT -1e+30, bad_vth_c)
IF bad_chi_c       GT 0 THEN chi      [bad_chi_i] = !values.f_nan
IF bad_den_c       GT 0 THEN den      [bad_den_i] = !values.f_nan
IF bad_vel_inst_c  GT 0 THEN vel_inst [bad_vel_inst_i] = !values.f_nan
IF bad_vel_inert_c GT 0 THEN vel_inert[bad_vel_inert_i] = !values.f_nan
IF bad_tem_c       GT 0 THEN tem      [bad_tem_i] = !values.f_nan
IF bad_vth_c       GT 0 THEN vth      [bad_vth_i] = !values.f_nan

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_alphas_'

store_data, varstr+'error', $
            data = {x:converted_epoch, y:err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'error flag'}
store_data, varstr+'fit_flag', $
            data = {x:converted_epoch, y:fit}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'fit flag'}
store_data, varstr+'channel_flag', $
            data = {x:converted_epoch, y:chn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'channel flag'}
store_data, varstr+'density', $
            data = {x:converted_epoch, y:den}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'density [1/cc]'}
store_data, varstr+'bulk_speed_inst', $
            data = {x:converted_epoch, y:vel_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'bulk speed inst. [km/s]'}
store_data, varstr+'bulk_speed_inertial', $
            data = {x:converted_epoch, y:vel_inert}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'bulk speed inertial [km/s]'}
store_data, varstr+'temperature', $
            data = {x:converted_epoch, y:tem}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'temperature [K]'}
store_data, varstr+'therm_vel', $
            data = {x:converted_epoch, y:vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'thermal velocity [km/s]'}
store_data, varstr+'chi_sq', $
            data = {x:converted_epoch, y:chi}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'reduced chi^2'}

END
