; 10/26/2010 LBE -- created
; 11/29/2010 LBE -- added ten_min option

PRO get_pla_l2_alpha_ra, sat, ten_min = ten_min
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

IF keyword_set(ten_min) THEN $
  seek_files, sat, 'l2_alpha_ra_10min', filesfound, browse = browse $
            ELSE $
  seek_files, sat, 'l2_alpha_ra',       filesfound, browse = browse

iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_density'
            cdf_varget, cdf_id, prod_name, cdf_den, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_bulk_speed'
            cdf_varget, cdf_id, prod_name, cdf_vel, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'alpha_thermal_speed'
            cdf_varget, cdf_id, prod_name, cdf_vth, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'Na_Np'
            cdf_varget, cdf_id, prod_name, cdf_nap, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Va_Vp'
            cdf_varget, cdf_id, prod_name, cdf_vap, rec_count = epochinfo.maxrec+1, /zvariable
            
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                den             = REFORM(cdf_den)
                vel             = REFORM(cdf_vel)
                vth             = REFORM(cdf_vth)
                nap             = REFORM(cdf_nap)
                vap             = REFORM(cdf_vap)
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                den             = [den,             REFORM(            cdf_den       )]
                vel             = [vel,             REFORM(            cdf_vel       )]
                vth             = [vth,             REFORM(            cdf_vth       )]
                nap             = [nap,             REFORM(            cdf_nap       )]
                vap             = [vap,             REFORM(            cdf_vap       )]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

get_timespan, ts
wanted_i = where(converted_epoch GE ts[0] AND converted_epoch LE ts[1], wanted_count)
IF wanted_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[wanted_i]
    den       = den      [wanted_i]
    vel       = vel      [wanted_i]
    vth       = vth      [wanted_i]
    nap       = nap      [wanted_i]
    vap       = vap      [wanted_i]
ENDIF ELSE BEGIN 
    print, 'no data in timespan'
    return
ENDELSE 

bad_den_i = where(den LT -1e+30, bad_den_c)
bad_vel_i = where(vel LT -1e+30, bad_vel_c)
bad_vth_i = where(vth LT -1e+30, bad_vth_c)
bad_nap_i = where(nap LT -1e+30, bad_nap_c)
bad_vap_i = where(vap LT -1e+30, bad_vap_c)
IF bad_den_c GT 0 THEN den[bad_den_i] = !values.f_nan
IF bad_vel_c GT 0 THEN vel[bad_vel_i] = !values.f_nan
IF bad_vth_c GT 0 THEN vth[bad_vth_i] = !values.f_nan
IF bad_nap_c GT 0 THEN nap[bad_nap_i] = !values.f_nan
IF bad_vap_c GT 0 THEN vap[bad_vap_i] = !values.f_nan

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_alpha_ra_'
IF keyword_set(ten_min) THEN varstr = varstr+'10min_'

store_data, varstr+'density', $
            data = {x:converted_epoch, y:den}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'density [1/cc]'}
store_data, varstr+'bulk_speed', $
            data = {x:converted_epoch, y:vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'bulk speed inst. [km/s]'}
store_data, varstr+'therm_vel', $
            data = {x:converted_epoch, y:vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'thermal velocity [km/s]'}
store_data, varstr+'Na_Np', $
            data = {x:converted_epoch, y:nap}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Na/Np'}
store_data, varstr+'Va_Vp', $
            data = {x:converted_epoch, y:vap}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Va-Vp'}

END
