; 04/15/2014 LBE: Created

PRO get_pla_l2_1dmax_5min, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'l2_1dmax_5min', filesfound
valid_i = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF
filesfound = filesfound[valid_i]

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'error'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_error, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Reduced_Chi2'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_red_chi2, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_number_density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_density, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_bulk_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_bulk_speed, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_temperature'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_temperature, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_thermal_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_thermal_speed, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_n_s_flow_angle_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_n_s_flow_angle_inst, rec_count = epochinfo.maxrec+1, /zvariable
                        
            IF ifwd EQ 0 THEN BEGIN
                IF epochinfo.maxrec EQ 0 THEN BEGIN ; only one record
                    converted_epoch             = REFORM(time_double(epoch, /epoch))
                    error                       = cdf_error
                    red_chi2                    = cdf_red_chi2
                    proton_density              = cdf_proton_density
                    proton_bulk_speed           = cdf_proton_bulk_speed
                    proton_temperature          = cdf_proton_temperature
                    proton_thermal_speed        = cdf_proton_thermal_speed
                    proton_n_s_flow_angle_inst  = cdf_proton_n_s_flow_angle_inst
                ENDIF ELSE BEGIN
                    converted_epoch             = REFORM(time_double(epoch, /epoch))
                    error                       = TRANSPOSE(cdf_error)
                    red_chi2                    = TRANSPOSE(cdf_red_chi2)
                    proton_density              = TRANSPOSE(cdf_proton_density)
                    proton_bulk_speed           = TRANSPOSE(cdf_proton_bulk_speed)
                    proton_temperature          = TRANSPOSE(cdf_proton_temperature)
                    proton_thermal_speed        = TRANSPOSE(cdf_proton_thermal_speed)
                    proton_n_s_flow_angle_inst  = TRANSPOSE(cdf_proton_n_s_flow_angle_inst)
                ENDELSE 
            ENDIF ELSE BEGIN
                IF epochinfo.maxrec EQ 0 THEN BEGIN ; only one record
                    converted_epoch             = [converted_epoch,             REFORM(time_double(epoch, /epoch))]
                    error                       = [error,                       cdf_error]
                    red_chi2                    = [red_chi2,                    cdf_red_chi2]
                    proton_density              = [proton_density,              cdf_proton_density]
                    proton_bulk_speed           = [proton_bulk_speed,           cdf_proton_bulk_speed]
                    proton_temperature          = [proton_temperature,          cdf_proton_temperature]
                    proton_thermal_speed        = [proton_thermal_speed,        cdf_proton_thermal_speed]
                    proton_n_s_flow_angle_inst  = [proton_n_s_flow_angle_inst,  cdf_proton_n_s_flow_angle_inst]
                ENDIF ELSE BEGIN
                    converted_epoch             = [converted_epoch,             REFORM(time_double(epoch, /epoch))]
                    error                       = [error,                       TRANSPOSE(cdf_error)]
                    red_chi2                    = [red_chi2,                    TRANSPOSE(cdf_red_chi2)]
                    proton_density              = [proton_density,              TRANSPOSE(cdf_proton_density)]
                    proton_bulk_speed           = [proton_bulk_speed,           TRANSPOSE(cdf_proton_bulk_speed)]
                    proton_temperature          = [proton_temperature,          TRANSPOSE(cdf_proton_temperature)]
                    proton_thermal_speed        = [proton_thermal_speed,        TRANSPOSE(cdf_proton_thermal_speed)]
                    proton_n_s_flow_angle_inst  = [proton_n_s_flow_angle_inst,  TRANSPOSE(cdf_proton_n_s_flow_angle_inst)]
                ENDELSE 
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

; limit by timerange
get_timespan, tt
bad_i = where(converted_epoch LT tt[0] OR converted_epoch GT tt[1], bad_count, complement = good_i, ncomplement = good_count)
IF good_count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF ELSE IF bad_count GT 0 THEN BEGIN
    converted_epoch              = converted_epoch             [good_i]
    error                        = error                       [good_i]
    red_chi2                     = red_chi2                    [good_i]
    proton_density               = proton_density              [good_i]
    proton_bulk_speed            = proton_bulk_speed           [good_i]
    proton_temperature           = proton_temperature          [good_i]
    proton_thermal_speed         = proton_thermal_speed        [good_i]
    proton_n_s_flow_angle_inst   = proton_n_s_flow_angle_inst  [good_i]
ENDIF 

; Check fill values
error         = float(error)
chkind = WHERE(error EQ -1, cchkind)
IF cchkind GT 0 THEN error(chkind) = !VALUES.F_NAN
chkind = WHERE(red_chi2 EQ -1e+31, cchkind)
IF cchkind GT 0 THEN red_chi2(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_density EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_density(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_bulk_speed EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_bulk_speed(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_temperature EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_temperature(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_thermal_speed EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_thermal_speed(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_n_s_flow_angle_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_n_s_flow_angle_inst(chkind) = !VALUES.F_NAN

; Add empty spots in arrays so don't get lines across plots
epoch_st = time_string(converted_epoch)
num_gap = 0
FOR ii = 0L, n_elements(converted_epoch)-2 DO BEGIN
    IF converted_epoch[ii+1] GT converted_epoch[ii]+600 THEN BEGIN ; allow 10 minutes break
        IF num_gap EQ 0 THEN gap_i = [ii] ELSE gap_i = [gap_i, ii]
        num_gap = num_gap + 1
    ENDIF
ENDFOR 
new_i = 0
IF num_gap GT 0 THEN BEGIN
    temp_converted_epoch             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_error                       = fltarr(n_elements(converted_epoch)+num_gap)
    temp_red_chi2                    = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_density              = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_bulk_speed           = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_temperature          = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_thermal_speed        = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_n_s_flow_angle_inst  = fltarr(n_elements(converted_epoch)+num_gap)
    FOR ii = -1, num_gap-1 DO BEGIN 
        CASE ii OF
            -1: BEGIN 
                start_i  = 0         
                stop_i   = gap_i[0] 
                num_good = gap_i[0] + 1
            END
            (num_gap - 1): BEGIN
                start_i  = gap_i[ii]+1
                stop_i   = n_elements(converted_epoch) - 1                
                num_good = n_elements(converted_epoch) - 1 - gap_i[ii] 
            END
            ELSE: BEGIN
                start_i  = gap_i[ii] + 1
                stop_i   = gap_i[ii+1]
                num_good = gap_i[ii+1] - gap_i[ii] 
            END
        ENDCASE 
        temp_converted_epoch            [new_i:(new_i+num_good-1)]    = converted_epoch            [start_i:stop_i]
        temp_error                      [new_i:(new_i+num_good-1)]    = error                      [start_i:stop_i]
        temp_red_chi2                   [new_i:(new_i+num_good-1)]    = red_chi2                   [start_i:stop_i]
        temp_proton_density             [new_i:(new_i+num_good-1)]    = proton_density             [start_i:stop_i]
        temp_proton_bulk_speed          [new_i:(new_i+num_good-1)]    = proton_bulk_speed          [start_i:stop_i]
        temp_proton_temperature         [new_i:(new_i+num_good-1)]    = proton_temperature         [start_i:stop_i]
        temp_proton_thermal_speed       [new_i:(new_i+num_good-1)]    = proton_thermal_speed       [start_i:stop_i]
        temp_proton_n_s_flow_angle_inst [new_i:(new_i+num_good-1)]    = proton_n_s_flow_angle_inst [start_i:stop_i]
        new_i = new_i + num_good
        IF ii LT num_gap-1 THEN BEGIN  
            temp_converted_epoch            [new_i]    = temp_converted_epoch[new_i-1]+60 ; add minute
            temp_error                      [new_i]    = !values.f_nan
            temp_red_chi2                   [new_i]    = !values.f_nan
            temp_proton_density             [new_i]    = !values.f_nan
            temp_proton_bulk_speed          [new_i]    = !values.f_nan
            temp_proton_temperature         [new_i]    = !values.f_nan
            temp_proton_thermal_speed       [new_i]    = !values.f_nan
            temp_proton_n_s_flow_angle_inst [new_i]    = !values.f_nan
            new_i = new_i + 1
        ENDIF 
    ENDFOR
    converted_epoch             = temp_converted_epoch            
    error                       = temp_error                      
    red_chi2                    = temp_red_chi2                   
    proton_density              = temp_proton_density             
    proton_bulk_speed           = temp_proton_bulk_speed          
    proton_temperature          = temp_proton_temperature         
    proton_thermal_speed        = temp_proton_thermal_speed       
    proton_n_s_flow_angle_inst  = temp_proton_n_s_flow_angle_inst
ENDIF 

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_1dmax_5min_'

store_data, varstr+'error', $
            data = {x:converted_epoch, y:error}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'error flag'}
store_data, varstr+'red_chi2', $
            data = {x:converted_epoch, y:red_chi2}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'reduced chi!U2!N'}
store_data, varstr+'proton_density', $
            data = {x:converted_epoch, y:proton_density}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'n (cm!U-3!N)'}
store_data, varstr+'proton_bulk_speed', $
            data = {x:converted_epoch, y:proton_bulk_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V (km s!U-1!N)!C!CHERTN'}
store_data, varstr+'proton_temperature', $
            data = {x:converted_epoch, y:proton_temperature}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'T (K)'}
store_data, varstr+'proton_thermal_speed', $
            data = {x:converted_epoch, y:proton_thermal_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Thermal Speed (km/s)'}
store_data, varstr+'proton_n_s_flow_angle_inst', $
            data = {x:converted_epoch, y:proton_n_s_flow_angle_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S (deg)!C!Cinst.'}

END
