; 10/31/2008 LBE: Created
; 02/11/2008 LBE: Changed error, caution, and flag to floats. Limit by timespan.
; 03/09/2009 LBE: added order flag (1=only prelim, 2=valid first, 3=prelim first) -- default is valid only
; 03/13/2009 LBE: Added HERTN and RTN to proton_bulk_speed.
; 03/16/2009 LBE: Added check for only one record.
; 03/19/2009 LBE: Removed HERTN and RTN from proton_bulk_speed.
;                 Add blank values when time gaps.
; 04/10/2009 LBE: Added _inst for NS and EW.
; 05/28/2009 LBE: Fixed bug with strlen.
; 06/11/2009 LBE: Fixed typo in filesfound
; 07/01/2011 LBE: Check for name change of RedChiSq in newer CDFs.
; 12/21/2011 LBE: Added order=4 for test data.
; 04/14/2011 LBE: Added order=5 for more test data.
; 08/24/2012 LBE: Added carrington rotation.
; 05/08/2013 LBE: Chane from doubles to floats.
; 03/10/2017 LBE: Update for V10 of protons.
; 08/22/2017 LBE: Add version variable. Fix bug when reading old files.
; 12/06/2017 LBE: Fixed bug with mixing prelim and valid.
; 10/19/2020 LBE: Add internal_valid; so order 2 = (valid, internal, prelim)
;                 order=3 (prelim, valid, internal)

PRO get_pla_l2_1dmax, sat, browse = browse, order = order
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

IF keyword_set(order) EQ 0 THEN order = 0
; combine valid and internal valid
if (order ne 1) and (order ne 4) and (order ne 5) then begin
   seek_files, sat, 'l2_1dmax_valid', filesfound_valid, browse = browse
   valid_i = WHERE(filesfound_valid NE '',  valid_count)
   seek_files, sat, 'l2_1dmax_internal', filesfound_internal, browse = browse
   internal_i = WHERE(filesfound_internal NE '',  internal_count)
   if internal_count gt 0 then begin
      if valid_count gt 0 then begin
         valid_dates    = long(strmid(filesfound_valid   [valid_i   ],76,8))
         internal_dates = long(strmid(filesfound_internal[internal_i],85,8))
         inter = intersect(valid_dates, internal_dates)
         if (n_elements(inter) gt 1) or (typename(inter) ne 'INT') then begin
            print, "Error: Shouldn't be here!"
            stop
         endif
         filesfound_valid = [filesfound_valid[valid_i], filesfound_internal[internal_i]]
         valid_count = valid_count + internal_count
      endif else begin
         filesfound_valid = filesfound_internal[internal_i]
         valid_count = internal_count
      endelse 
   endif
   ;; case where internal_count eq 0 already dealt with
endif

; now get files we want
IF order EQ 5 THEN BEGIN 
   seek_files, sat, 'l2_1dmax_test2', filesfound, browse = browse
   iff = WHERE(filesfound NE '',  ciff)
ENDIF ELSE IF order EQ 4 THEN BEGIN 
   seek_files, sat, 'l2_1dmax_test', filesfound, browse = browse
   iff = WHERE(filesfound NE '',  ciff)
ENDIF ELSE IF order EQ 0 THEN BEGIN
   filesfound = filesfound_valid
   iff = WHERE(filesfound NE '',  ciff)
ENDIF ELSE IF order EQ 1 THEN BEGIN 
   seek_files, sat, 'l2_1dmax_prelim', filesfound, browse = browse
   iff = WHERE(filesfound NE '',  ciff)
ENDIF ELSE IF order EQ 2 OR order EQ 3 THEN BEGIN
   ;; don't seek for valid here because did it above
   valid_i = WHERE(filesfound_valid NE '',  valid_count)
   seek_files, sat, 'l2_1dmax_prelim', filesfound_prelim, browse = browse
   prelim_i = WHERE(filesfound_prelim NE '',  prelim_count)
   IF valid_count GT 0 AND prelim_count GT 0 THEN BEGIN
      valid_len  = strlen(filesfound_valid [ valid_i[0]])
      prelim_len = strlen(filesfound_prelim[prelim_i[0]])
      valid_sub  = strmid(filesfound_valid [ valid_i], valid_len-38,30)
      prelim_sub = strmid(filesfound_prelim[prelim_i],prelim_len-38,30)
      IF array_equal(valid_sub, prelim_sub) EQ 1 THEN BEGIN ; same 
         IF order EQ 2 THEN BEGIN 
            filesfound = filesfound_valid
            ciff = valid_count
         ENDIF ELSE BEGIN 
            filesfound = filesfound_prelim
            ciff = prelim_count
         ENDELSE 
      ENDIF ELSE BEGIN
         iv = 0L                ; index into valid
         ip = 0L                ; index into prelim
         in = 0L                ; index into new
         filesfound = strarr(valid_count+prelim_count)
         WHILE iv LT valid_count AND ip LT prelim_count DO BEGIN
            version_v = fix(strmid(filesfound_valid [ valid_i[iv]], strlen(filesfound_valid [ valid_i[iv]])-6, 2))
            version_p = fix(strmid(filesfound_prelim[prelim_i[ip]], strlen(filesfound_prelim[prelim_i[ip]])-6, 2))
            IF version_v LT 4 THEN iv = iv + 1     ; skip versions less than 4 (different filenames)
            IF version_p LT 4 THEN ip = ip + 1     ; skip versions less than 4 (different filenames)
            IF version_v GE 4 AND version_p GE 4 THEN BEGIN 
               year_v      = fix(strmid(filesfound_valid [ valid_i[iv]], strlen(filesfound_valid [ valid_i[iv]])-16, 4))
               year_p      = fix(strmid(filesfound_prelim[prelim_i[ip]], strlen(filesfound_prelim[prelim_i[ip]])-16, 4))
               monthdate_v = fix(strmid(filesfound_valid [ valid_i[iv]], strlen(filesfound_valid [ valid_i[iv]])-12, 4))
               monthdate_p = fix(strmid(filesfound_prelim[prelim_i[ip]], strlen(filesfound_prelim[prelim_i[ip]])-12, 4))
               IF year_p LT year_v OR (year_p EQ year_v AND monthdate_p LT monthdate_v) THEN BEGIN ; prelim earlier
                  filesfound[in] = filesfound_prelim[prelim_i[ip]]
                  in = in + 1
                  ip = ip + 1
               ENDIF ELSE IF year_p GT year_v OR (year_p EQ year_v AND monthdate_p GT monthdate_v) THEN BEGIN ; valid earlier
                  filesfound[in] = filesfound_valid[valid_i[iv]]
                  in = in + 1
                  iv = iv + 1
               ENDIF ELSE BEGIN ; same date
                  IF version_p GT version_v THEN filesfound[in] = filesfound_prelim[prelim_i[ip]] $
                  ELSE IF version_v GT version_p THEN filesfound[in] = filesfound_valid[valid_i[iv]] $
                  ELSE IF order EQ 2 THEN filesfound[in] = filesfound_valid[valid_i[iv]] $
                  ELSE filesfound[in] = filesfound_prelim[prelim_i[ip]] 
                  in = in + 1
                  iv = iv + 1
                  ip = ip + 1
               ENDELSE 
            ENDIF 
         ENDWHILE 
         WHILE iv LT valid_count DO BEGIN ; fill in valid count
            version_v = fix(strmid(filesfound_valid[valid_i[iv]], strlen(filesfound_valid[valid_i[iv]])-6, 2))
            IF version_v GE 4 THEN BEGIN
               filesfound[in] = filesfound_valid[valid_i[iv]] 
               in = in + 1
            ENDIF 
            iv = iv + 1
         ENDWHILE 
         WHILE ip LT prelim_count DO BEGIN ; fill in prelim count
            version_p = fix(strmid(filesfound_prelim[prelim_i[ip]], strlen(filesfound_prelim[prelim_i[ip]])-6, 2))
            IF version_p GE 4 THEN BEGIN
               filesfound[in] = filesfound_prelim[prelim_i[ip]] 
               in = in + 1
            ENDIF 
            ip = ip + 1
         ENDWHILE 
         ciff = in
      ENDELSE 
   ENDIF ELSE IF valid_count GT 0 THEN BEGIN 
      filesfound = filesfound_valid
      ciff = valid_count
   ENDIF ELSE IF prelim_count GT 0 THEN BEGIN
      filesfound = filesfound_prelim
      ciff = prelim_count
   ENDIF ELSE BEGIN             ; no valid
      filesfound = filesfound_valid
      ciff = 0
   ENDELSE 
ENDIF ELSE BEGIN
   print, 'invalid order'
   stop
ENDELSE 

IF ciff EQ 0 THEN BEGIN
   get_err_no =  1
   get_err_msg =  'No files found'
   RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN

           cdf_version = fltarr(epochinfo.maxrec+1)
           cdf_version[*] = float(strmid(filesfound[jj],strlen(filesfound[jj])-6,2))

           cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'error'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_error, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'caution'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_caution, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'attitude_flag'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_attitude_flag, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'Reduced_Chi2'
            old_cdf = cdf_varnum(cdf_id, prod_name) ; check for name change in new CDFs
            IF old_cdf EQ -1 THEN prod_name = 'Reduced_Chi2'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_red_chi2, rec_count = epochinfo.maxrec+1, /zvariable

            if (((fix(strmid(filesfound[jj], strlen(filesfound[jj])-6,2)) le 5) and $
                 (strmid(filesfound[jj],strlen(filesfound[jj])-58,9) eq 'Non_valid')) or $
                ((fix(strmid(filesfound[jj], strlen(filesfound[jj])-6,2)) le 9) and $
                 (strmid(filesfound[jj],strlen(filesfound[jj])-54,5) eq 'Valid'))) and $
               (strpos(filesfound[jj], "Internal") eq -1) then begin
               prod_name = 'stat_uncertainty_angle'
               cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
               cdf_varget, cdf_id, prod_name, cdf_uncertainty, rec_count = epochinfo.maxrec+1, /zvariable
            endif else begin
               prod_name = 'e_w_stat_uncertainty'
               cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
               cdf_varget, cdf_id, prod_name, cdf_uncertainty, rec_count = epochinfo.maxrec+1, /zvariable
            endelse 
               
            prod_name = 'proton_number_density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_density, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_bulk_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_bulk_speed, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_temperature'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_temperature, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_thermal_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_thermal_speed, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_n_s_flow_angle_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_n_s_flow_angle_inst, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_e_w_flow_angle_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_e_w_flow_angle_inst, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_n_s_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_n_s_flow_angle_hertn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_e_w_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_e_w_flow_angle_hertn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vr_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vr_hertn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vt_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vt_hertn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vn_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vn_hertn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_n_s_flow_angle_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_n_s_flow_angle_rtn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_e_w_flow_angle_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_e_w_flow_angle_rtn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vr_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vr_rtn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vt_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vt_rtn, rec_count = epochinfo.maxrec+1, /zvariable
                        
            prod_name = 'proton_Vn_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_proton_vn_rtn, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'carrington_rotation'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_carr_rot, rec_count = epochinfo.maxrec+1, /zvariable
                        
            IF ifwd EQ 0 THEN BEGIN
                IF epochinfo.maxrec EQ 0 THEN BEGIN ; only one record
                    converted_epoch             = REFORM(time_double(epoch, /epoch))
                    version                     = cdf_version
                    error                       = cdf_error
                    caution                     = cdf_caution
                    attitude_flag               = cdf_attitude_flag
                    red_chi2                    = cdf_red_chi2
                    uncertainty                 = cdf_uncertainty
                    proton_density              = cdf_proton_density
                    proton_bulk_speed           = cdf_proton_bulk_speed
                    proton_temperature          = cdf_proton_temperature
                    proton_thermal_speed        = cdf_proton_thermal_speed
                    proton_n_s_flow_angle_inst  = cdf_proton_n_s_flow_angle_inst
                    proton_e_w_flow_angle_inst  = cdf_proton_e_w_flow_angle_inst
                    proton_n_s_flow_angle_hertn = cdf_proton_n_s_flow_angle_hertn
                    proton_e_w_flow_angle_hertn = cdf_proton_e_w_flow_angle_hertn
                    proton_vr_hertn             = cdf_proton_vr_hertn
                    proton_vt_hertn             = cdf_proton_vt_hertn
                    proton_vn_hertn             = cdf_proton_vn_hertn
                    proton_n_s_flow_angle_rtn   = cdf_proton_n_s_flow_angle_rtn
                    proton_e_w_flow_angle_rtn   = cdf_proton_e_w_flow_angle_rtn
                    proton_vr_rtn               = cdf_proton_vr_rtn
                    proton_vt_rtn               = cdf_proton_vt_rtn
                    proton_vn_rtn               = cdf_proton_vn_rtn
                    carr_rot                    = cdf_carr_rot
                ENDIF ELSE BEGIN
                    converted_epoch             = REFORM(time_double(epoch, /epoch))
                    version                     = cdf_version
                    error                       = TRANSPOSE(cdf_error)
                    caution                     = TRANSPOSE(cdf_caution)
                    attitude_flag               = TRANSPOSE(cdf_attitude_flag)
                    red_chi2                    = TRANSPOSE(cdf_red_chi2)
                    uncertainty                 = TRANSPOSE(cdf_uncertainty)
                    proton_density              = TRANSPOSE(cdf_proton_density)
                    proton_bulk_speed           = TRANSPOSE(cdf_proton_bulk_speed)
                    proton_temperature          = TRANSPOSE(cdf_proton_temperature)
                    proton_thermal_speed        = TRANSPOSE(cdf_proton_thermal_speed)
                    proton_n_s_flow_angle_inst  = TRANSPOSE(cdf_proton_n_s_flow_angle_inst)
                    proton_e_w_flow_angle_inst  = TRANSPOSE(cdf_proton_e_w_flow_angle_inst)
                    proton_n_s_flow_angle_hertn = TRANSPOSE(cdf_proton_n_s_flow_angle_hertn)
                    proton_e_w_flow_angle_hertn = TRANSPOSE(cdf_proton_e_w_flow_angle_hertn)
                    proton_vr_hertn             = TRANSPOSE(cdf_proton_vr_hertn)
                    proton_vt_hertn             = TRANSPOSE(cdf_proton_vt_hertn)
                    proton_vn_hertn             = TRANSPOSE(cdf_proton_vn_hertn)
                    proton_n_s_flow_angle_rtn   = TRANSPOSE(cdf_proton_n_s_flow_angle_rtn)
                    proton_e_w_flow_angle_rtn   = TRANSPOSE(cdf_proton_e_w_flow_angle_rtn)
                    proton_vr_rtn               = TRANSPOSE(cdf_proton_vr_rtn)
                    proton_vt_rtn               = TRANSPOSE(cdf_proton_vt_rtn)
                    proton_vn_rtn               = TRANSPOSE(cdf_proton_vn_rtn)
                    carr_rot                    = TRANSPOSE(cdf_carr_rot)
                ENDELSE 
            ENDIF ELSE BEGIN
                IF epochinfo.maxrec EQ 0 THEN BEGIN ; only one record
                    converted_epoch             = [converted_epoch,             REFORM(time_double(epoch, /epoch))]
                    version                     = [version,                     cdf_version]
                    error                       = [error,                       cdf_error]
                    caution                     = [caution,                     cdf_caution]
                    attitude_flag               = [attitude_flag,               reform(cdf_attitude_flag, 1, 3)]
                    red_chi2                    = [red_chi2,                    cdf_red_chi2]
                    uncertainty                 = [uncertainty,                 cdf_uncertainty]
                    proton_density              = [proton_density,              cdf_proton_density]
                    proton_bulk_speed           = [proton_bulk_speed,           cdf_proton_bulk_speed]
                    proton_temperature          = [proton_temperature,          cdf_proton_temperature]
                    proton_thermal_speed        = [proton_thermal_speed,        cdf_proton_thermal_speed]
                    proton_n_s_flow_angle_inst  = [proton_n_s_flow_angle_inst,  cdf_proton_n_s_flow_angle_inst]
                    proton_e_w_flow_angle_inst  = [proton_e_w_flow_angle_inst,  cdf_proton_e_w_flow_angle_inst]
                    proton_n_s_flow_angle_hertn = [proton_n_s_flow_angle_hertn, cdf_proton_n_s_flow_angle_hertn]
                    proton_e_w_flow_angle_hertn = [proton_e_w_flow_angle_hertn, cdf_proton_e_w_flow_angle_hertn]
                    proton_vr_hertn             = [proton_vr_hertn,             cdf_proton_vr_hertn]
                    proton_vt_hertn             = [proton_vt_hertn,             cdf_proton_vt_hertn]
                    proton_vn_hertn             = [proton_vn_hertn,             cdf_proton_vn_hertn]
                    proton_n_s_flow_angle_rtn   = [proton_n_s_flow_angle_rtn,   cdf_proton_n_s_flow_angle_rtn]
                    proton_e_w_flow_angle_rtn   = [proton_e_w_flow_angle_rtn,   cdf_proton_e_w_flow_angle_rtn]
                    proton_vr_rtn               = [proton_vr_rtn,               cdf_proton_vr_rtn]
                    proton_vt_rtn               = [proton_vt_rtn,               cdf_proton_vt_rtn]
                    proton_vn_rtn               = [proton_vn_rtn,               cdf_proton_vn_rtn]
                    carr_rot                    = [carr_rot,                    cdf_carr_rot]
                ENDIF ELSE BEGIN
                    converted_epoch             = [converted_epoch,             REFORM(time_double(epoch, /epoch))]
                    version                     = [version,                     cdf_version]
                    error                       = [error,                       TRANSPOSE(cdf_error)]
                    caution                     = [caution,                     TRANSPOSE(cdf_caution)]
                    attitude_flag               = [attitude_flag,               TRANSPOSE(cdf_attitude_flag)]
                    red_chi2                    = [red_chi2,                    TRANSPOSE(cdf_red_chi2)]
                    uncertainty                 = [uncertainty,                 TRANSPOSE(cdf_uncertainty)]
                    proton_density              = [proton_density,              TRANSPOSE(cdf_proton_density)]
                    proton_bulk_speed           = [proton_bulk_speed,           TRANSPOSE(cdf_proton_bulk_speed)]
                    proton_temperature          = [proton_temperature,          TRANSPOSE(cdf_proton_temperature)]
                    proton_thermal_speed        = [proton_thermal_speed,        TRANSPOSE(cdf_proton_thermal_speed)]
                    proton_n_s_flow_angle_inst  = [proton_n_s_flow_angle_inst,  TRANSPOSE(cdf_proton_n_s_flow_angle_inst)]
                    proton_e_w_flow_angle_inst  = [proton_e_w_flow_angle_inst,  TRANSPOSE(cdf_proton_e_w_flow_angle_inst)]
                    proton_n_s_flow_angle_hertn = [proton_n_s_flow_angle_hertn, TRANSPOSE(cdf_proton_n_s_flow_angle_hertn)]
                    proton_e_w_flow_angle_hertn = [proton_e_w_flow_angle_hertn, TRANSPOSE(cdf_proton_e_w_flow_angle_hertn)]
                    proton_vr_hertn             = [proton_vr_hertn,             TRANSPOSE(cdf_proton_vr_hertn)]
                    proton_vt_hertn             = [proton_vt_hertn,             TRANSPOSE(cdf_proton_vt_hertn)]
                    proton_vn_hertn             = [proton_vn_hertn,             TRANSPOSE(cdf_proton_vn_hertn)]
                    proton_n_s_flow_angle_rtn   = [proton_n_s_flow_angle_rtn,   TRANSPOSE(cdf_proton_n_s_flow_angle_rtn)]
                    proton_e_w_flow_angle_rtn   = [proton_e_w_flow_angle_rtn,   TRANSPOSE(cdf_proton_e_w_flow_angle_rtn)]
                    proton_vr_rtn               = [proton_vr_rtn,               TRANSPOSE(cdf_proton_vr_rtn)]
                    proton_vt_rtn               = [proton_vt_rtn,               TRANSPOSE(cdf_proton_vt_rtn)]
                    proton_vn_rtn               = [proton_vn_rtn,               TRANSPOSE(cdf_proton_vn_rtn)]
                    carr_rot                    = [carr_rot,                    TRANSPOSE(cdf_carr_rot)]
                ENDELSE 
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

; change to floats
red_chi2                    = float(red_chi2)
uncertainty                 = float(uncertainty)
proton_density              = float(proton_density)
proton_bulk_speed           = float(proton_bulk_speed)
proton_temperature          = float(proton_temperature)
proton_thermal_speed        = float(proton_thermal_speed)
proton_n_s_flow_angle_inst  = float(proton_n_s_flow_angle_inst)
proton_e_w_flow_angle_inst  = float(proton_e_w_flow_angle_inst)
proton_n_s_flow_angle_hertn = float(proton_n_s_flow_angle_hertn)
proton_e_w_flow_angle_hertn = float(proton_e_w_flow_angle_hertn)
proton_vr_hertn             = float(proton_vr_hertn)
proton_vt_hertn             = float(proton_vt_hertn)
proton_vn_hertn             = float(proton_vn_hertn)
proton_n_s_flow_angle_rtn   = float(proton_n_s_flow_angle_rtn)
proton_e_w_flow_angle_rtn   = float(proton_e_w_flow_angle_rtn)
proton_vr_rtn               = float(proton_vr_rtn)
proton_vt_rtn               = float(proton_vt_rtn)
proton_vn_rtn               = float(proton_vn_rtn)
carr_rot                    = float(carr_rot)

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

; limit by timerange
get_timespan, tt
bad_i = where(converted_epoch LT tt[0] OR converted_epoch GT tt[1], bad_count, complement = good_i, ncomplement = good_count)
IF good_count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF ELSE IF bad_count GT 0 THEN BEGIN
    converted_epoch              = converted_epoch             [good_i]
    version                      = version                     [good_i]
    error                        = error                       [good_i]
    caution                      = caution                     [good_i]
    attitude_flag                = attitude_flag               [good_i, *]
    red_chi2                     = red_chi2                    [good_i]
    uncertainty                  = uncertainty                 [good_i]
    proton_density               = proton_density              [good_i]
    proton_bulk_speed            = proton_bulk_speed           [good_i]
    proton_temperature           = proton_temperature          [good_i]
    proton_thermal_speed         = proton_thermal_speed        [good_i]
    proton_n_s_flow_angle_inst   = proton_n_s_flow_angle_inst  [good_i]
    proton_e_w_flow_angle_inst   = proton_e_w_flow_angle_inst  [good_i]
    proton_n_s_flow_angle_hertn  = proton_n_s_flow_angle_hertn [good_i]
    proton_e_w_flow_angle_hertn  = proton_e_w_flow_angle_hertn [good_i]
    proton_vr_hertn              = proton_vr_hertn             [good_i]
    proton_vt_hertn              = proton_vt_hertn             [good_i]
    proton_vn_hertn              = proton_vn_hertn             [good_i]
    proton_n_s_flow_angle_rtn    = proton_n_s_flow_angle_rtn   [good_i]
    proton_e_w_flow_angle_rtn    = proton_e_w_flow_angle_rtn   [good_i]
    proton_vr_rtn                = proton_vr_rtn               [good_i]
    proton_vt_rtn                = proton_vt_rtn               [good_i]
    proton_vn_rtn                = proton_vn_rtn               [good_i]
    carr_rot                     = carr_rot                    [good_i]
ENDIF 

; Check fill values
error         = float(error)
caution       = float(caution)
attitude_flag = float(attitude_flag)
chkind = WHERE(error EQ -1, cchkind)
IF cchkind GT 0 THEN error(chkind) = !VALUES.F_NAN
chkind = WHERE(caution EQ -1, cchkind)
IF cchkind GT 0 THEN caution(chkind) = !VALUES.F_NAN
chkind = WHERE(attitude_flag EQ -1, cchkind)
IF cchkind GT 0 THEN attitude_flag(chkind) = !VALUES.F_NAN
chkind = WHERE(red_chi2 EQ -1e+31, cchkind)
IF cchkind GT 0 THEN red_chi2(chkind) = !VALUES.F_NAN
chkind = WHERE(uncertainty EQ -1e+31, cchkind)
IF cchkind GT 0 THEN uncertainty(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_density EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_density(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_bulk_speed EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_bulk_speed(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_temperature EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_temperature(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_thermal_speed EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_thermal_speed(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_n_s_flow_angle_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_n_s_flow_angle_inst(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_e_w_flow_angle_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_e_w_flow_angle_inst(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_n_s_flow_angle_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_n_s_flow_angle_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_e_w_flow_angle_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_e_w_flow_angle_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vr_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vr_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vt_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vt_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vn_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vn_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_n_s_flow_angle_rtn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_n_s_flow_angle_rtn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_e_w_flow_angle_rtn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_e_w_flow_angle_rtn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vr_rtn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vr_rtn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vt_rtn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vt_rtn(chkind) = !VALUES.F_NAN
chkind = WHERE(proton_vn_rtn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN proton_vn_rtn(chkind) = !VALUES.F_NAN
chkind = WHERE(carr_rot EQ -1e+31, cchkind)
IF cchkind GT 0 THEN carr_rot(chkind) = !VALUES.F_NAN

; Add empty spots in arrays so don't get lines across plots
epoch_st = time_string(converted_epoch)
num_gap = 0
FOR ii = 0L, n_elements(converted_epoch)-2 DO BEGIN
    IF converted_epoch[ii+1] GT converted_epoch[ii]+120 THEN BEGIN ; allow 2 minutes break
        IF num_gap EQ 0 THEN gap_i = [ii] ELSE gap_i = [gap_i, ii]
        num_gap = num_gap + 1
    ENDIF
ENDFOR 
IF num_gap GT 0 THEN BEGIN
    temp_converted_epoch             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_version                     = fltarr(n_elements(converted_epoch)+num_gap)
    temp_error                       = fltarr(n_elements(converted_epoch)+num_gap)
    temp_caution                     = fltarr(n_elements(converted_epoch)+num_gap)
    temp_attitude_flag               = fltarr(n_elements(converted_epoch)+num_gap, 3)
    temp_red_chi2                    = fltarr(n_elements(converted_epoch)+num_gap)
    temp_uncertainty                 = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_density              = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_bulk_speed           = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_temperature          = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_thermal_speed        = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_n_s_flow_angle_inst  = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_e_w_flow_angle_inst  = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_n_s_flow_angle_hertn = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_e_w_flow_angle_hertn = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vr_hertn             = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vt_hertn             = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vn_hertn             = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_n_s_flow_angle_rtn   = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_e_w_flow_angle_rtn   = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vr_rtn               = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vt_rtn               = fltarr(n_elements(converted_epoch)+num_gap)
    temp_proton_vn_rtn               = fltarr(n_elements(converted_epoch)+num_gap)
    temp_carr_rot                    = fltarr(n_elements(converted_epoch)+num_gap)
    new_i = 0
    FOR ii = -1, num_gap-1 DO BEGIN 
        CASE ii OF
            -1: BEGIN 
                start_i  = 0         
                stop_i   = gap_i[0] 
                num_good = gap_i[0] + 1
            END
            (num_gap - 1): BEGIN
                start_i  = gap_i[ii]+1
                stop_i   = n_elements(converted_epoch) - 1                
                num_good = n_elements(converted_epoch) - 1 - gap_i[ii] 
            END
            ELSE: BEGIN
                start_i  = gap_i[ii] + 1
                stop_i   = gap_i[ii+1]
                num_good = gap_i[ii+1] - gap_i[ii] 
            END
        ENDCASE 
        temp_converted_epoch            [new_i:(new_i+num_good-1)]    = converted_epoch            [start_i:stop_i]
        temp_version                    [new_i:(new_i+num_good-1)]    = version                    [start_i:stop_i]
        temp_error                      [new_i:(new_i+num_good-1)]    = error                      [start_i:stop_i]
        temp_caution                    [new_i:(new_i+num_good-1)]    = caution                    [start_i:stop_i]
        temp_attitude_flag              [new_i:(new_i+num_good-1), *] = attitude_flag              [start_i:stop_i, *]
        temp_red_chi2                   [new_i:(new_i+num_good-1)]    = red_chi2                   [start_i:stop_i]
        temp_uncertainty                [new_i:(new_i+num_good-1)]    = uncertainty                [start_i:stop_i]
        temp_proton_density             [new_i:(new_i+num_good-1)]    = proton_density             [start_i:stop_i]
        temp_proton_bulk_speed          [new_i:(new_i+num_good-1)]    = proton_bulk_speed          [start_i:stop_i]
        temp_proton_temperature         [new_i:(new_i+num_good-1)]    = proton_temperature         [start_i:stop_i]
        temp_proton_thermal_speed       [new_i:(new_i+num_good-1)]    = proton_thermal_speed       [start_i:stop_i]
        temp_proton_n_s_flow_angle_inst [new_i:(new_i+num_good-1)]    = proton_n_s_flow_angle_inst [start_i:stop_i]
        temp_proton_e_w_flow_angle_inst [new_i:(new_i+num_good-1)]    = proton_e_w_flow_angle_inst [start_i:stop_i]
        temp_proton_n_s_flow_angle_hertn[new_i:(new_i+num_good-1)]    = proton_n_s_flow_angle_hertn[start_i:stop_i]
        temp_proton_e_w_flow_angle_hertn[new_i:(new_i+num_good-1)]    = proton_e_w_flow_angle_hertn[start_i:stop_i]
        temp_proton_vr_hertn            [new_i:(new_i+num_good-1)]    = proton_vr_hertn            [start_i:stop_i]
        temp_proton_vt_hertn            [new_i:(new_i+num_good-1)]    = proton_vt_hertn            [start_i:stop_i]
        temp_proton_vn_hertn            [new_i:(new_i+num_good-1)]    = proton_vn_hertn            [start_i:stop_i]
        temp_proton_n_s_flow_angle_rtn  [new_i:(new_i+num_good-1)]    = proton_n_s_flow_angle_rtn  [start_i:stop_i]
        temp_proton_e_w_flow_angle_rtn  [new_i:(new_i+num_good-1)]    = proton_e_w_flow_angle_rtn  [start_i:stop_i]
        temp_proton_vr_rtn              [new_i:(new_i+num_good-1)]    = proton_vr_rtn              [start_i:stop_i]
        temp_proton_vt_rtn              [new_i:(new_i+num_good-1)]    = proton_vt_rtn              [start_i:stop_i]
        temp_proton_vn_rtn              [new_i:(new_i+num_good-1)]    = proton_vn_rtn              [start_i:stop_i]
        temp_carr_rot                   [new_i:(new_i+num_good-1)]    = carr_rot                   [start_i:stop_i]
        new_i = new_i + num_good
        IF ii LT num_gap-1 THEN BEGIN  
            temp_converted_epoch            [new_i]    = temp_converted_epoch[new_i-1]+60 ; add minute
            temp_version                    [new_i]    = !values.f_nan
            temp_error                      [new_i]    = !values.f_nan
            temp_caution                    [new_i]    = !values.f_nan
            temp_attitude_flag              [new_i, *] = !values.f_nan
            temp_red_chi2                   [new_i]    = !values.f_nan
            temp_uncertainty                [new_i]    = !values.f_nan
            temp_proton_density             [new_i]    = !values.f_nan
            temp_proton_bulk_speed          [new_i]    = !values.f_nan
            temp_proton_temperature         [new_i]    = !values.f_nan
            temp_proton_thermal_speed       [new_i]    = !values.f_nan
            temp_proton_n_s_flow_angle_inst [new_i]    = !values.f_nan
            temp_proton_e_w_flow_angle_inst [new_i]    = !values.f_nan
            temp_proton_n_s_flow_angle_hertn[new_i]    = !values.f_nan
            temp_proton_e_w_flow_angle_hertn[new_i]    = !values.f_nan
            temp_proton_vr_hertn            [new_i]    = !values.f_nan
            temp_proton_vt_hertn            [new_i]    = !values.f_nan
            temp_proton_vn_hertn            [new_i]    = !values.f_nan
            temp_proton_n_s_flow_angle_rtn  [new_i]    = !values.f_nan
            temp_proton_e_w_flow_angle_rtn  [new_i]    = !values.f_nan
            temp_proton_vr_rtn              [new_i]    = !values.f_nan
            temp_proton_vt_rtn              [new_i]    = !values.f_nan
            temp_proton_vn_rtn              [new_i]    = !values.f_nan
            temp_carr_rot                   [new_i]    = !values.f_nan
            new_i = new_i + 1
        ENDIF 
    ENDFOR
    converted_epoch             = temp_converted_epoch            
    version                     = temp_version
    error                       = temp_error                      
    caution                     = temp_caution                    
    attitude_flag               = temp_attitude_flag        
    red_chi2                    = temp_red_chi2                   
    uncertainty                 = temp_uncertainty                
    proton_density              = temp_proton_density             
    proton_bulk_speed           = temp_proton_bulk_speed          
    proton_temperature          = temp_proton_temperature         
    proton_thermal_speed        = temp_proton_thermal_speed       
    proton_n_s_flow_angle_inst  = temp_proton_n_s_flow_angle_inst
    proton_e_w_flow_angle_inst  = temp_proton_e_w_flow_angle_inst
    proton_n_s_flow_angle_hertn = temp_proton_n_s_flow_angle_hertn
    proton_e_w_flow_angle_hertn = temp_proton_e_w_flow_angle_hertn
    proton_vr_hertn             = temp_proton_vr_hertn            
    proton_vt_hertn             = temp_proton_vt_hertn            
    proton_vn_hertn             = temp_proton_vn_hertn            
    proton_n_s_flow_angle_rtn   = temp_proton_n_s_flow_angle_rtn  
    proton_e_w_flow_angle_rtn   = temp_proton_e_w_flow_angle_rtn  
    proton_vr_rtn               = temp_proton_vr_rtn              
    proton_vt_rtn               = temp_proton_vt_rtn              
    proton_vn_rtn               = temp_proton_vn_rtn              
    carr_rot                    = temp_carr_rot              
ENDIF 

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_1dmax_'
IF order EQ 4 THEN varstr = varstr + 'test_'
IF order EQ 5 THEN varstr = varstr + 'test2_'

store_data, varstr+'error', $
            data = {x:converted_epoch, y:error}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'error flag'}
store_data, varstr+'caution', $
            data = {x:converted_epoch, y:caution}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'caution: density method'}
store_data, varstr+'attitude_flag', $
            data = {x:converted_epoch, y:attitude_flag}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'attitude flag!C!CFlow angle_hertn not in s/c orientation.'}
store_data, varstr+'red_chi2', $
            data = {x:converted_epoch, y:red_chi2}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'reduced chi!U2!N'}
store_data, varstr+'uncertainty', $
            data = {x:converted_epoch, y:uncertainty}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'uncertainty'}
store_data, varstr+'version', $
            data = {x:converted_epoch, y:version}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'version'}
store_data, varstr+'proton_density', $
            data = {x:converted_epoch, y:proton_density}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'n (cm!U-3!N)'}
store_data, varstr+'proton_bulk_speed', $
            data = {x:converted_epoch, y:proton_bulk_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V (km s!U-1!N)!C!CHERTN'}
store_data, varstr+'proton_temperature', $
            data = {x:converted_epoch, y:proton_temperature}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'T (K)'}
store_data, varstr+'proton_thermal_speed', $
            data = {x:converted_epoch, y:proton_thermal_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Thermal Speed (km/s)'}
store_data, varstr+'proton_n_s_flow_angle_inst', $
            data = {x:converted_epoch, y:proton_n_s_flow_angle_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S (deg)!C!Cinst.'}
store_data, varstr+'proton_e_w_flow_angle_inst', $
            data = {x:converted_epoch, y:proton_e_w_flow_angle_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W (deg)!C!Cinst.'}
store_data, varstr+'proton_n_s_flow_angle_hertn', $
            data = {x:converted_epoch, y:proton_n_s_flow_angle_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S (deg)!C!CHERTN'}
store_data, varstr+'proton_e_w_flow_angle_hertn', $
            data = {x:converted_epoch, y:proton_e_w_flow_angle_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W (deg)!C!CHERTN'}
store_data, varstr+'proton_vr_hertn', $
            data = {x:converted_epoch, y:proton_vr_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vr (km/s)!C!CHERTN'}
store_data, varstr+'proton_vt_hertn', $
            data = {x:converted_epoch, y:proton_vt_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vt (km/s)!C!CHERTN'}
store_data, varstr+'proton_vn_hertn', $
            data = {x:converted_epoch, y:proton_vn_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vn (km/s)!C!CHERTN'}
store_data, varstr+'proton_n_s_flow_angle_rtn', $
            data = {x:converted_epoch, y:proton_n_s_flow_angle_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S (deg)!C!CRTN'}
store_data, varstr+'proton_e_w_flow_angle_rtn', $
            data = {x:converted_epoch, y:proton_e_w_flow_angle_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W (deg)!C!CRTN'}
store_data, varstr+'proton_vr_rtn', $
            data = {x:converted_epoch, y:proton_vr_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vr (km/s)!C!CRTN'}
store_data, varstr+'proton_vt_rtn', $
            data = {x:converted_epoch, y:proton_vt_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vt (km/s)!C!CRTN'}
store_data, varstr+'proton_vn_rtn', $
            data = {x:converted_epoch, y:proton_vn_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Vn (km/s)!C!CRTN'}
store_data, varstr+'carrington_rotation', $
            data = {x:converted_epoch, y:carr_rot}

END
