;+
; PROCEDURE: get_pla_hk
;
; PURPOSE: to get the product related data and create the
;          corresponding  tplot variable. 
;
; INPUT: sat   - S/C id - 'A' or 'B'
;        prods - strarr -- products
;
; OUTPUT: the output is provided via the tplot variables.
;
; CREATED BY: L. Ellis
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;     04/29/2014: LBE: Created from get_pla_mon_full
;     11/03/2011: LBE: Change loop variable to long.
;     02/20/2012: LBE: Fix when schan eq -1.
;     05/27/2015: LBE: Add code to remove analog data when device code=0.
;-

PRO get_pla_hk, sat, prods
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

seek_files, sat, 'hk', filesfound
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

num_prod = n_elements(prods)
;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
epoch_versions = intarr(num_prod) ; 0=analog, 1=digital
FOR prod_i = 0, num_prod-1 DO BEGIN 
    prod = prods[prod_i]
    CASE prod OF
        'adc_avdd_eng'        : epoch_versions[prod_i] = 0
        'adc_avdd_raw'        : epoch_versions[prod_i] = 0
        'adc_dvdd_eng'        : epoch_versions[prod_i] = 0
        'adc_dvdd_raw'        : epoch_versions[prod_i] = 0
        'adc_lu_ctr_raw'      : epoch_versions[prod_i] = 0                                      
        'adc_lu_flag_raw'     : epoch_versions[prod_i] = 0                                     
        'adc0_agnd_eng'       : epoch_versions[prod_i] = 0                                       
        'adc0_agnd_raw'       : epoch_versions[prod_i] = 0                                       
        'adc0_vref_eng'       : epoch_versions[prod_i] = 0                                      
        'adc0_vref_raw'       : epoch_versions[prod_i] = 0                                      
        'adc1_agnd_eng'       : epoch_versions[prod_i] = 0                                      
        'adc1_agnd_raw'       : epoch_versions[prod_i] = 0                                      
        'adc1_vref_eng'       : epoch_versions[prod_i] = 0                                      
        'adc1_vref_raw'       : epoch_versions[prod_i] = 0                                      
        'block_id'            : epoch_versions[prod_i] = 0
        'cal_vref_eng'        : epoch_versions[prod_i] = 0
        'cal_vref_raw'        : epoch_versions[prod_i] = 0
        'coarse_pointing_raw' : epoch_versions[prod_i] = 0                                 
        'dac_status_raw'      : epoch_versions[prod_i] = 0                                      
        'esa_cm_dc_eng'       : epoch_versions[prod_i] = 0
        'esa_cm_dc_raw'       : epoch_versions[prod_i] = 0
        'esa_vm_neg_eng'      : epoch_versions[prod_i] = 0
        'esa_vm_neg_raw'      : epoch_versions[prod_i] = 0
        'esa_vm_pos_eng'      : epoch_versions[prod_i] = 0
        'esa_vm_pos_raw'      : epoch_versions[prod_i] = 0
        'device_code'         : epoch_versions[prod_i] = 0
        'dfl_1_cm_dc_eng'     : epoch_versions[prod_i] = 0
        'dfl_1_cm_dc_raw'     : epoch_versions[prod_i] = 0
        'dfl_1_vm_eng'        : epoch_versions[prod_i] = 0
        'dfl_1_vm_raw'        : epoch_versions[prod_i] = 0
        'dfl_1_tap_eng'       : epoch_versions[prod_i] = 0
        'dfl_1_tap_raw'       : epoch_versions[prod_i] = 0
        'dfl_2_cm_dc_eng'     : epoch_versions[prod_i] = 0
        'dfl_2_cm_dc_raw'     : epoch_versions[prod_i] = 0
        'dfl_2_vm_eng'        : epoch_versions[prod_i] = 0
        'dfl_2_vm_raw'        : epoch_versions[prod_i] = 0
        'dfl_2_tap_eng'       : epoch_versions[prod_i] = 0
        'dfl_2_tap_raw'       : epoch_versions[prod_i] = 0
        'lrnm_spare_eng'      : epoch_versions[prod_i] = 0
        'lrnm_spare_raw'      : epoch_versions[prod_i] = 0
        'lrpm_spare_eng'      : epoch_versions[prod_i] = 0
        'lrpm_spare_raw'      : epoch_versions[prod_i] = 0
        'lvc_-5v_eng'         : epoch_versions[prod_i] = 0
        'lvc_-5v_raw'         : epoch_versions[prod_i] = 0
        'lvc_-5v_imon_eng'    : epoch_versions[prod_i] = 0                                    
        'lvc_-5v_imon_raw'    : epoch_versions[prod_i] = 0                                    
        'lvc_-12v_eng'        : epoch_versions[prod_i] = 0
        'lvc_-12v_raw'        : epoch_versions[prod_i] = 0
        'lvc_-12v_imon_eng'   : epoch_versions[prod_i] = 0
        'lvc_-12v_imon_raw'   : epoch_versions[prod_i] = 0
        'lvc_+2.5v_a_eng'     : epoch_versions[prod_i] = 0
        'lvc_+2.5v_a_raw'     : epoch_versions[prod_i] = 0
        'lvc_+2.5v_a_imon_eng': epoch_versions[prod_i] = 0                                
        'lvc_+2.5v_a_imon_raw': epoch_versions[prod_i] = 0                                
        'lvc_+2.5v_b_eng'     : epoch_versions[prod_i] = 0
        'lvc_+2.5v_b_raw'     : epoch_versions[prod_i] = 0
        'lvc_+2.5v_b_imon_eng': epoch_versions[prod_i] = 0
        'lvc_+2.5v_b_imon_raw': epoch_versions[prod_i] = 0
        'lvc_+5v_eng'         : epoch_versions[prod_i] = 0
        'lvc_+5v_raw'         : epoch_versions[prod_i] = 0
        'lvc_+5v_imon_eng'    : epoch_versions[prod_i] = 0                                    
        'lvc_+5v_imon_raw'    : epoch_versions[prod_i] = 0                                    
        'lvc_+12v_eng'        : epoch_versions[prod_i] = 0
        'lvc_+12v_raw'        : epoch_versions[prod_i] = 0
        'lvc_+12v_imon_eng'   : epoch_versions[prod_i] = 0
        'lvc_+12v_imon_raw'   : epoch_versions[prod_i] = 0
        'lvc0_tsp_eng'        : epoch_versions[prod_i] = 0                                        
        'lvc0_tsp_raw'        : epoch_versions[prod_i] = 0                                        
        'lvc1_tsp_eng'        : epoch_versions[prod_i] = 0                                       
        'lvc1_tsp_raw'        : epoch_versions[prod_i] = 0                                       
        'mcp_cm_ac_raw'       : epoch_versions[prod_i] = 0
        'mcp_cm_dc_eng'       : epoch_versions[prod_i] = 0
        'mcp_cm_dc_raw'       : epoch_versions[prod_i] = 0
        'mcp_vm_eng'          : epoch_versions[prod_i] = 0
        'mcp_vm_raw'          : epoch_versions[prod_i] = 0
        'pac_cm_ac_raw'       : epoch_versions[prod_i] = 0
        'pac_cm_dc_eng'       : epoch_versions[prod_i] = 0
        'pac_cm_dc_raw'       : epoch_versions[prod_i] = 0
        'pac_vm_eng'          : epoch_versions[prod_i] = 0
        'pac_vm_raw'          : epoch_versions[prod_i] = 0
        'plug_id_raw'         : epoch_versions[prod_i] = 0                                        
        'power_warning_raw'   : epoch_versions[prod_i] = 0                                   
        'ra_e0_eng'           : epoch_versions[prod_i] = 0                                          
        'ra_e0_raw'           : epoch_versions[prod_i] = 0                                          
        'ra_e1_eng'           : epoch_versions[prod_i] = 0                                          
        'ra_e1_raw'           : epoch_versions[prod_i] = 0                                          
        's_c_0_tsp_eng'       : epoch_versions[prod_i] = 0                                      
        's_c_0_tsp_raw'       : epoch_versions[prod_i] = 0                                      
        's_c_1_tsp_eng'       : epoch_versions[prod_i] = 0                                       
        's_c_1_tsp_raw'       : epoch_versions[prod_i] = 0                                       
        's_ch_cm_dc_eng'      : epoch_versions[prod_i] = 0
        's_ch_cm_dc_raw'      : epoch_versions[prod_i] = 0
        's_ch_vm_eng'         : epoch_versions[prod_i] = 0
        's_ch_vm_raw'         : epoch_versions[prod_i] = 0
        's_ch_vm_tap_eng'     : epoch_versions[prod_i] = 0
        's_ch_vm_tap_raw'     : epoch_versions[prod_i] = 0
        'sb0_tsp_eng'         : epoch_versions[prod_i] = 0                                        
        'sb0_tsp_raw'         : epoch_versions[prod_i] = 0                                        
        'sb1_tsp_eng'         : epoch_versions[prod_i] = 0                                        
        'sb1_tsp_raw'         : epoch_versions[prod_i] = 0                                        
        'ssd_cm_dc_eng'       : epoch_versions[prod_i] = 0
        'ssd_cm_dc_raw'       : epoch_versions[prod_i] = 0
        'ssd_hv_bias_eng'     : epoch_versions[prod_i] = 0                                     
        'ssd_hv_bias_raw'     : epoch_versions[prod_i] = 0                                     
        'ssd_status_raw'      : epoch_versions[prod_i] = 0                                      
        'ssd_tc0_eng'         : epoch_versions[prod_i] = 0                                        
        'ssd_tc0_raw'         : epoch_versions[prod_i] = 0                                        
        'ssd_tc1_eng'         : epoch_versions[prod_i] = 0                                        
        'ssd_tc1_raw'         : epoch_versions[prod_i] = 0                                        
        'ssd_tc2_eng'         : epoch_versions[prod_i] = 0                                        
        'ssd_tc2_raw'         : epoch_versions[prod_i] = 0                                        
        'ssd_v_neg_analog_eng': epoch_versions[prod_i] = 0                                
        'ssd_v_neg_analog_raw': epoch_versions[prod_i] = 0                                
        'ssd_v_pos_analog_eng': epoch_versions[prod_i] = 0                                
        'ssd_v_pos_analog_raw': epoch_versions[prod_i] = 0                                
        'ssd_v_pos_dig_eng'   : epoch_versions[prod_i] = 0                                   
        'ssd_v_pos_dig_raw'   : epoch_versions[prod_i] = 0                                   
        'ssd_vm_eng'          : epoch_versions[prod_i] = 0                                         
        'ssd_vm_raw'          : epoch_versions[prod_i] = 0                                         
        'tac0_tsp_eng'        : epoch_versions[prod_i] = 0                                       
        'tac0_tsp_raw'        : epoch_versions[prod_i] = 0                                       
        'tac2_tsp_eng'        : epoch_versions[prod_i] = 0                                       
        'tac2_tsp_raw'        : epoch_versions[prod_i] = 0                                       
        'tof_hv0_tsp_eng'     : epoch_versions[prod_i] = 0                                     
        'tof_hv0_tsp_raw'     : epoch_versions[prod_i] = 0                                     
        'tof_hv1_tsp_eng'     : epoch_versions[prod_i] = 0                                     
        'tof_hv1_tsp_raw'     : epoch_versions[prod_i] = 0                                     
        'thruster_warning_raw': epoch_versions[prod_i] = 0                                   

        'active_supplyid'               : epoch_versions[prod_i] = 1                                     
        'analog_lim_pt1_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt1_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt1_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt2_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt2_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt2_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt3_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt3_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt3_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt4_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt4_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt4_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt5_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt5_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt5_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt6_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt6_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt6_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt7_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt7_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt7_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt8_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt8_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt8_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt9_id'             : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt9_red'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt9_status'         : epoch_versions[prod_i] = 1                               
        'analog_lim_pt10_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt10_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt10_status'        : epoch_versions[prod_i] = 1                               
        'analog_lim_pt11_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt11_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt11_status'        : epoch_versions[prod_i] = 1                               
        'analog_lim_pt12_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt12_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt12_status'        : epoch_versions[prod_i] = 1                               
        'analog_lim_pt13_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt13_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt13_status'        : epoch_versions[prod_i] = 1                               
        'analog_lim_pt14_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt14_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt14_status'        : epoch_versions[prod_i] = 1                               
        'analog_lim_pt15_id'            : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt15_red'           : epoch_versions[prod_i] = 1                                   
        'analog_lim_pt15_status'        : epoch_versions[prod_i] = 1                               
        'analog_limit_status'           : epoch_versions[prod_i] = 1                                 
        'apid315_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid316_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid317_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid318_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid319_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid319_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31a_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31a_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31b_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31b_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31c_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31c_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31d_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31d_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31e_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31e_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid31f_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid31f_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid320_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid320_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid321_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid321_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid322_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid322_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid323_accum'                 : epoch_versions[prod_i] = 1                                       
        'apid323_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid324_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid325_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid326_disabled'              : epoch_versions[prod_i] = 1                                     
        'apid327_disabled'              : epoch_versions[prod_i] = 1                                     
        'cmd_exec_cnt'                  : epoch_versions[prod_i] = 1                                        
        'cmd_frame_err_cnt'             : epoch_versions[prod_i] = 1                                   
        'cmd_illegal_err_cnt'           : epoch_versions[prod_i] = 1                                 
        'cmd_rcvd_cnt'                  : epoch_versions[prod_i] = 1                                        
        'cmd_parity_err_cnt'            : epoch_versions[prod_i] = 1                                  
        'cmd_total_err_cnt'             : epoch_versions[prod_i] = 1                                   
        'dacm_adc_lu_ctr'               : epoch_versions[prod_i] = 1                                     
        'dacm_control'                  : epoch_versions[prod_i] = 1                                        
        'dacm_esa_coarse'               : epoch_versions[prod_i] = 1                                     
        'dacm_esa_ctl'                  : epoch_versions[prod_i] = 1                                        
        'dacm_esa_fine'                 : epoch_versions[prod_i] = 1                                       
        'dacm_dfl_1_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacm_dfl_1_ctl'                : epoch_versions[prod_i] = 1                                      
        'dacm_dfl_1_dfine'              : epoch_versions[prod_i] = 1                                    
        'dacm_dfl_1_fine'               : epoch_versions[prod_i] = 1                                     
        'dacm_dfl_1_offset'             : epoch_versions[prod_i] = 1                                   
        'dacm_dfl_2_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacm_dfl_2_ctl'                : epoch_versions[prod_i] = 1                                      
        'dacm_dfl_2_dfine'              : epoch_versions[prod_i] = 1                                       
        'dacm_dfl_2_fine'               : epoch_versions[prod_i] = 1                                     
        'dacm_dfl_2_offset'             : epoch_versions[prod_i] = 1                                   
        'dacm_mcp_cm_fs_coarse'         : epoch_versions[prod_i] = 1                               
        'dacm_mcp_cm_fs_fine'           : epoch_versions[prod_i] = 1                                 
        'dacm_mcp_fine'                 : epoch_versions[prod_i] = 1                                       
        'dacm_mcp_coarse'               : epoch_versions[prod_i] = 1                                     
        'dacm_pac_cm_fs_coarse'         : epoch_versions[prod_i] = 1                               
        'dacm_pac_cm_fs_fine'           : epoch_versions[prod_i] = 1                                 
        'dacm_pac_coarse'               : epoch_versions[prod_i] = 1                                     
        'dacm_pac_fine'                 : epoch_versions[prod_i] = 1                                       
        'dacm_pac_limit'                : epoch_versions[prod_i] = 1                                      
        'dacm_pac_mcp_ssd_ctl_mcp_limit': epoch_versions[prod_i] = 1                      
        'dacm_s_ch_coarse'              : epoch_versions[prod_i] = 1                                    
        'dacm_s_ch_ctl'                 : epoch_versions[prod_i] = 1                                       
        'dacm_s_ch_fine'                : epoch_versions[prod_i] = 1                                      
        'dacm_s_ch_tap_coarse'          : epoch_versions[prod_i] = 1                                
        'dacm_s_ch_tap_fine'            : epoch_versions[prod_i] = 1                                  
        'dacm_ssd_coarse'               : epoch_versions[prod_i] = 1                                     
        'dacm_ssd_fine'                 : epoch_versions[prod_i] = 1                                       
        'dacm_status'                   : epoch_versions[prod_i] = 1                                         
        'dacr_adc_lu_ctr'               : epoch_versions[prod_i] = 1                                     
        'dacr_c_esa_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_c_esa_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_c_mcp_cm_fs_coarse'       : epoch_versions[prod_i] = 1                             
        'dacr_c_mcp_cm_fs_fine'         : epoch_versions[prod_i] = 1                               
        'dacr_c_mcp_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_c_mcp_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_c_pac_cm_fs_coarse'       : epoch_versions[prod_i] = 1                             
        'dacr_c_pac_cm_fs_fine'         : epoch_versions[prod_i] = 1                               
        'dacr_c_pac_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_c_pac_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_c_s_ch_coarse'            : epoch_versions[prod_i] = 1                                  
        'dacr_c_s_ch_fine'              : epoch_versions[prod_i] = 1                                    
        'dacr_c_s_ch_tap_coarse'        : epoch_versions[prod_i] = 1                              
        'dacr_c_s_ch_tap_fine'          : epoch_versions[prod_i] = 1                                
        'dacr_c_ssd_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_c_ssd_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_control'                  : epoch_versions[prod_i] = 1                                        
        'dacr_dfl_1_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_dfl_1_ctl'                : epoch_versions[prod_i] = 1                                      
        'dacr_dfl_1_dfine'              : epoch_versions[prod_i] = 1                                    
        'dacr_dfl_1_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_dfl_1_offset'             : epoch_versions[prod_i] = 1                                   
        'dacr_dfl_2_coarse'             : epoch_versions[prod_i] = 1                                   
        'dacr_dfl_2_ctl'                : epoch_versions[prod_i] = 1                                      
        'dacr_dfl_2_dfine'              : epoch_versions[prod_i] = 1                                    
        'dacr_dfl_2_fine'               : epoch_versions[prod_i] = 1                                     
        'dacr_dfl_2_offset'             : epoch_versions[prod_i] = 1                                   
        'dacr_esa_ctl'                  : epoch_versions[prod_i] = 1                                        
        'dacr_pac_limit'                : epoch_versions[prod_i] = 1                                      
        'dacr_pac_mcp_ssd_ctl_mcp_limit': epoch_versions[prod_i] = 1                      
        'dacr_s_ch_ctl'                 : epoch_versions[prod_i] = 1                                       
        'dacr_status'                   : epoch_versions[prod_i] = 1                                         
        'dpu_sw_version'                : epoch_versions[prod_i] = 1                                     
        'hkp_sampletime'                : epoch_versions[prod_i] = 1                                      
        'ic_ctl_reg'                    : epoch_versions[prod_i] = 1                                          
        'ic_status_reg'                 : epoch_versions[prod_i] = 1                                       
        'lbc_event_ctl'                 : epoch_versions[prod_i] = 1                                       
        'lbc_logic_ctl_a'               : epoch_versions[prod_i] = 1                                     
        'lbc_logic_ctl_b'               : epoch_versions[prod_i] = 1                                     
        'lbc_mode_ctl'                  : epoch_versions[prod_i] = 1                                        
        'lbc_reg_seq'                   : epoch_versions[prod_i] = 1                                         
        'lbc_reset_ctl'                 : epoch_versions[prod_i] = 1                                       
        'lbc_rlim_ch'                   : epoch_versions[prod_i] = 1                                         
        'lbc_rlim_hi'                   : epoch_versions[prod_i] = 1                                         
        'lbc_rlim_lo'                   : epoch_versions[prod_i] = 1                                         
        'lbc_tac_pwr_ctl'               : epoch_versions[prod_i] = 1                                     
        'lbe_defl_step'                 : epoch_versions[prod_i] = 1                                       
        'lbe_esa_step'                  : epoch_versions[prod_i] = 1                                        
        'lbe_pos_ctrl'                  : epoch_versions[prod_i] = 1                                        
        'lbe_pos_disable0'              : epoch_versions[prod_i] = 1                                    
        'lbe_pos_disable2'              : epoch_versions[prod_i] = 1                                    
        'lbe_pos_ra'                    : epoch_versions[prod_i] = 1                                          
        'lbe_sel_ctrl'                  : epoch_versions[prod_i] = 1                                        
        'lbe_sel0_window'               : epoch_versions[prod_i] = 1                                     
        'lbe_sel2_window'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_cmd_h'                 : epoch_versions[prod_i] = 1                                       
        'lbe_ssd_cmd_l'                 : epoch_versions[prod_i] = 1                                       
        'lbe_ssd_ctrl'                  : epoch_versions[prod_i] = 1                                        
        'lbe_ssd_dis'                   : epoch_versions[prod_i] = 1                                         
        'lbe_ssd_offset0'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset1'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset2'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset3'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset4'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset5'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset6'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset7'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset8'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset9'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_offset10'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_offset11'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_offset12'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_offset13'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_offset14'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_offset15'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_over_hi'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_over_lo'               : epoch_versions[prod_i] = 1                                     
        'lbe_ssd_under_hi'              : epoch_versions[prod_i] = 1                                    
        'lbe_ssd_under_lo'              : epoch_versions[prod_i] = 1                                    
        'lbe_stim_enable'               : epoch_versions[prod_i] = 1                                     
        'lbe_stim_freq_hi'              : epoch_versions[prod_i] = 1                                    
        'lbe_stim_freq_lo'              : epoch_versions[prod_i] = 1                                    
        'lbe_tac0_ctrl'                 : epoch_versions[prod_i] = 1                                       
        'lbe_tac0_dac'                  : epoch_versions[prod_i] = 1                                        
        'lbe_tac0_over_hi'              : epoch_versions[prod_i] = 1                                    
        'lbe_tac0_over_lo'              : epoch_versions[prod_i] = 1                                    
        'lbe_tac0_under_hi'             : epoch_versions[prod_i] = 1                                   
        'lbe_tac0_under_lo'             : epoch_versions[prod_i] = 1                                   
        'lbe_tac2_ctrl'                 : epoch_versions[prod_i] = 1                                       
        'lbe_tac2_dac'                  : epoch_versions[prod_i] = 1                                        
        'lbe_tac2_over_hi'              : epoch_versions[prod_i] = 1                                    
        'lbe_tac2_over_lo'              : epoch_versions[prod_i] = 1                                    
        'lbe_tac2_under_hi'             : epoch_versions[prod_i] = 1                                   
        'lbe_tac2_under_lo'             : epoch_versions[prod_i] = 1                                   
        'opmode'                        : epoch_versions[prod_i] = 1                                              
        'lbe_trig_mode'                 : epoch_versions[prod_i] = 1                                       
        'pac_discharge_cnt'             : epoch_versions[prod_i] = 1                                   
        'pac_discharge_conseccntr'      : epoch_versions[prod_i] = 1                            
        'pac_discharge_safe_att'        : epoch_versions[prod_i] = 1                              
        'pac_discharge_status'          : epoch_versions[prod_i] = 1                                
        'proton_mode'                   : epoch_versions[prod_i] = 1                                         
        'supply_coarse_rb'              : epoch_versions[prod_i] = 1                                    
        'supply_fine_rb'                : epoch_versions[prod_i] = 1                                      
        'sw_eepromchksum'               : epoch_versions[prod_i] = 1                                     
        'sw_hv_enable_status'           : epoch_versions[prod_i] = 1                                 
        'sw_hv_limit_status'            : epoch_versions[prod_i] = 1                                  
        'sw_hv_ramp_status'             : epoch_versions[prod_i] = 1                                   
        'sw_mode'                       : epoch_versions[prod_i] = 1                                             
        'sw_status1'                    : epoch_versions[prod_i] = 1                                          
        'swmaint_pac_coarse'            : epoch_versions[prod_i] = 1                                  
        'swmaint_pac_fine'              : epoch_versions[prod_i] = 1                                    
        'swmaint_supplystat'            : epoch_versions[prod_i] = 1                                  
    ENDCASE 
ENDFOR 

get_timespan, tt
check = where(epoch_versions EQ 0, have_analog)
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN
    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))
        epoch_a = 'epoch_analog'
        epoch_d = 'epoch_digital'
        device  = 'device_code'
        cdf_control, cdf_id, get_var_info = epochinfo_a, var = epoch_a,  /zvariable
        cdf_control, cdf_id, get_var_info = epochinfo_d, var = epoch_d, /zvariable

        have_a = 1
        have_d = 1
        IF epochinfo_a.maxrec GE 0 THEN BEGIN
            cdf_varget, cdf_id, epoch_a, epoch_a_d, rec_count = epochinfo_a.maxrec+1, /zvariable
            cdf_varget, cdf_id,  device,  device_d, rec_count = epochinfo_a.maxrec+1, /zvariable
            epoch_a_d_conv = time_double(reform(epoch_a_d), /epoch)
            good_a_i = where(epoch_a_d_conv GE tt[0] AND epoch_a_d_conv LE tt[1], good_a_c, ncomplement = bad_a_c)
            IF bad_a_c GT 0 THEN BEGIN 
                IF good_a_c GT 0 THEN BEGIN 
                    epoch_a_d_conv = epoch_a_d_conv[good_a_i] 
                    device_d       =  device_d     [good_a_i]
                ENDIF ELSE have_a = 0
            ENDIF 
            bad_dev_i = where(device_d EQ 0, bad_dev_c) ; needs to be after cut timespan
        ENDIF ELSE have_a = 0
        IF epochinfo_d.maxrec GE 0 THEN BEGIN
            cdf_varget, cdf_id, epoch_d, epoch_d_d, rec_count = epochinfo_d.maxrec+1, /zvariable
            epoch_d_d_conv = time_double(reform(epoch_d_d), /epoch)
            good_d_i = where(epoch_d_d_conv GE tt[0] AND epoch_d_d_conv LE tt[1], good_d_c, ncomplement = bad_d_c)
            IF bad_d_c GT 0 THEN BEGIN 
                IF good_d_c GT 0 THEN epoch_d_d_conv = epoch_d_d_conv[good_d_i] ELSE have_d = 0
            ENDIF 
        ENDIF ELSE have_d = 0
        FOR prod_i = 0, num_prod-1 DO BEGIN 
            prod_n  = prods[prod_i]
            tplot_n = 'ST'+sat
            IF epoch_versions[prod_i] EQ 0 THEN tplot_n = tplot_n+'_Analog' ELSE tplot_n = tplot_n+'_Digital'
            tplot_n = tplot_n+'_HK_'+prod_n
            have_data = 0
            IF epoch_versions[prod_i] EQ 0 AND have_a EQ 1 THEN BEGIN
                epoch     = epoch_a_d_conv
                num_epoch = epochinfo_a.maxrec+1 
                have_data = 1
            ENDIF ELSE IF epoch_versions[prod_i] EQ 1 AND have_d EQ 1 THEN BEGIN 
                epoch     = epoch_d_d_conv
                num_epoch = epochinfo_d.maxrec+1
                have_data = 1
            ENDIF 
            IF have_data EQ 1 THEN BEGIN 
                cdf_varget, cdf_id, prod_n, cdf_data, rec_count = num_epoch, /zvariable
                cdf_data = float(reform(cdf_data))
                bad_i = where(finite(cdf_data) EQ 0, bad_count)
                IF bad_count GT 0 THEN cdf_data[bad_i] = !values.f_nan
                IF epoch_versions[prod_i] EQ 0 AND bad_a_c   GT 0 THEN cdf_data = cdf_data[good_a_i]
                IF epoch_versions[prod_i] EQ 1 AND bad_d_c   GT 0 THEN cdf_data = cdf_data[good_d_i]
                IF epoch_versions[prod_i] EQ 0 AND bad_dev_c GT 0 THEN cdf_data[bad_dev_i] = !values.f_nan
                IF jj GT 0 THEN BEGIN
                    get_data, tplot_n, times, temp_data
                    times     = [    times, epoch   ]
                    temp_data = [temp_data, cdf_data]
                ENDIF ELSE BEGIN 
                    times     = epoch
                    temp_data = cdf_data
                ENDELSE
                FOR ii = 0L, n_elements(times)-2 DO BEGIN
                    IF times[ii+1]-times[ii] GT 60 THEN BEGIN
                        times     = [    times[0:ii], !values.f_nan,     times[ii+1:n_elements(    times)-1]]
                        temp_data = [temp_data[0:ii], !values.f_nan, temp_data[ii+1:n_elements(temp_data)-1]]
                    ENDIF
                ENDFOR 
                store_data, tplot_n, data = {x:times, y:temp_data}
            ENDIF 
        ENDFOR 
        cdf_close, cdf_id
    ENDIF
ENDFOR

END
