;+
; PROCEDURE: get_pla_en_spec_line
;
; PURPOSE:
;
; INPUT:
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;     06/13/2017 LBE: Add call to make plot.
;
;-
PRO get_pla_en_spec_line, sat, prod, class, units, energy, diagn=diagn
compile_opt strictarrsubs  
  
COMMON get_error, get_err_no, get_err_msg, default_verbose

dat = get_pla_data(sat, prod, class)
IF get_err_no NE 0 THEN RETURN
  
;------------------------------------------------------------------
; Convert Units
;------------------------------------------------------------------
IF STRUPCASE(units) NE 'COUNTS' THEN BEGIN
    dat = convert_plastic_units(dat, units)
ENDIF
;------------------------------------------------------------------

ytitle = 'ST' + STRUPCASE(sat) +'/PLA' + '!C!C'

; !!!! Be carefull: NaN data when totaled give zero.
    
IF dat.units_name EQ 'Counts' THEN norm = 1. ELSE norm =  dat.nposition * dat.ndeflection

erangestr = STRING(energy(0),  FORMAT = '(i5.5)') + '_' + STRING(energy(1),  FORMAT = '(i5.5)')
prodname = 'ST' + sat + '_PLA_ENSPEC_LINE_' + erangestr + '_' + STRUPCASE(units) + '_' + STRUPCASE(prod)

IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN
    
    zdata = TOTAL(TOTAL(dat.data, 2, /NaN), 2, /NaN) / norm
    ytitle =  ytitle + prod

ENDIF

IF prod EQ 'sw_z>2_h' THEN BEGIN

    zdata = TOTAL(TOTAL(dat.data(*, *, *, *), 2, /NaN), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
    
ENDIF

IF prod EQ 'sw_z>2_l' THEN BEGIN
    
    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF
  
IF prod EQ 'sw_priority' THEN BEGIN

    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'wap_ssd_tcr' OR prod EQ 'wap_ssd_dcr' OR prod EQ 'wap_no_ssd_dcr' THEN BEGIN

    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'wap_priority_ssd' OR prod EQ 'wap_priority_no_ssd' THEN BEGIN

    zdata = dat.data / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'class' THEN BEGIN
    
    zdata =   TOTAL(TOTAL(dat.data, 2, /NaN), 2, /NaN) / norm
    ytitle = ytitle + prod + '!C!CEnergy (keV)'

ENDIF


;------------------------------------------------------------------
; Sum over specified energy range
;------------------------------------------------------------------
yarr = FLTARR(N_ELEMENTS(dat.time))
FOR ii = 0, N_ELEMENTS(dat.time)-1 DO BEGIN
    
    en = REFORM(dat.energy(ii, *))*1.e3
    ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
    
    IF cien GT 0 THEN BEGIN
        yarr(ii) = TOTAL(zdata(ii, ien),  /NaN)
    ENDIF ELSE BEGIN
        err_msg, 'No data in energy range selected'
        RETURN
    ENDELSE
    
ENDFOR

;------------------------------------------------------------------
; Save line spectra in tplot variables
;------------------------------------------------------------------
erangestr = STRING(energy(0)/1e3,  FORMAT = '(f5.2)') + '-' + STRING(energy(1)/1e3,  FORMAT = '(f5.2)')
ytitle = ytitle + '!C!C' + erangestr + ' (keV)!C!C' + STRUPCASE(dat.units_name)

store_data, prodname, data = {x:REFORM(dat.time), y:yarr}, $
            dlim = {panel_size:1, $
                    ylog:1, $
                    yrange:[0.1, 1e3], $
                    ytitle:ytitle $
                   }
tplot_var = prodname
tplot, tplot_var,  add_var = 999 ; add panel to the bottom of the plot

IF KEYWORD_SET(diagn) THEN BEGIN
    
    IF prod EQ 'h_alpha' OR $
      prod EQ 'h+peak' OR $
      prod EQ 'he++peak' OR $
      prod EQ 'he++tcr' THEN BEGIN
        
        store_data, prodname+'_s_chan', data = {x:REFORM(dat.time), y:dat.s_chan}, $
                    dlim = {panel_size:1, $
                            ylog:1, $
                            yrange:[0.1, 10] $
                           }
        
    ENDIF
    
ENDIF


END
