;+
; PROCEDURE: get_pla_def_spec
;
; PURPOSE:
;
; INPUT:
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;   05-14-2007: CM
;               Even if the energy range for a particular time step does not
;               have data, all time steps are checked instead of
;               exiting. The time steps with no data in the energy
;               range are filled with NaN
;   12-06-2007: LBE: Made loop variables longs so can accomodate a month of data.
;   09-02-2011: LBE: Added variables for schan only and main only.
;                    Added bin keyword (to plot by bins rather than degrees)
;   09-08-2011: LBE: Check for if only one energy bin found in reduced dist.
;   12-01-2011: LBE: Check for missing SChan info.
;   12-22-2011: LBE: Fix sw_pri for when only one record.
;   01-28-2013: LBE: Added erase_gaps keyword.
;-
PRO get_pla_def_spec, sat, prod, class, units, energy, theta, diagn=diagn, bin = bin, erase_gaps = erase_gaps
compile_opt strictarrsubs  
  
COMMON get_error, get_err_no, get_err_msg, default_verbose

dat = get_pla_data(sat, prod, class, erase_gaps = erase_gaps)
IF get_err_no NE 0 THEN RETURN

;------------------------------------------------------------------
; Convert Units
;------------------------------------------------------------------
IF STRUPCASE(units) NE 'COUNTS' THEN BEGIN
    dat = convert_pla_units(dat, units)
ENDIF
;------------------------------------------------------------------

ytitle = 'ST' + STRUPCASE(sat) +'/PLA' + '!C!C'

IF dat.units_name EQ 'Counts' THEN norm = 1. ELSE norm =  dat.nposition * dat.ndeflection

; The enegry range is the actual energy range
get_pla_energies, sat, esa_step
esa_step =  esa_step * 1e3
ien = WHERE(esa_step GE energy(0) AND esa_step LE energy(1), cien)
IF cien GT 0 THEN BEGIN
    elow  = esa_step(ien(cien-1)) * (1.0-0.0489)
    ehigh = esa_step(ien(0)) * (1.0+0.0489)
    erangestr = STRING(elow,  FORMAT = '(i5.5)') + '_' + STRING(ehigh,  FORMAT = '(i5.5)')
ENDIF ELSE BEGIN
    erangestr = '*****'
ENDELSE

prodname = 'ST' + sat + '_PLA_DEFSPEC_' + erangestr + '_' + STRUPCASE(units) + '_' + STRUPCASE(prod)

IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN
    ; limit to when have peak
    data_with_peak = dat.data
    data_with_peak[0, *, *, *] = !values.f_nan
    FOR ii = 1L, dat.ntime-1 DO BEGIN
        IF (prod EQ 'h_alpha' AND dat.energy_peak_i[ii-1] LT (dat.energy_peak_i[ii]-15)) OR $
          ( prod NE 'h_alpha' AND dat.energy_peak_i[ii-1] LT (dat.energy_peak_i[ii]-05)) OR $
          (dat.energy_peak_i    [ii-1] GT (dat.energy_peak_i    [ii]+4)) OR $
          (dat.deflection_peak_i[ii-1] LT (dat.deflection_peak_i[ii]-3)) OR $
          (dat.deflection_peak_i[ii-1] GT (dat.deflection_peak_i[ii]+4)) OR $
          (dat.energy_peak_i    [ii-1] LT 0) OR $
          (dat.deflection_peak_i[ii-1] LT 0) OR $
          (dat.energy_peak_i    [  ii] LT 0) OR $
          (dat.deflection_peak_i[  ii] LT 0) THEN data_with_peak[ii, *, *, *] = !values.f_nan
    ENDFOR 
    
    zdata                = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    schan_data           = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    main_data            = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    schan_with_peak      = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    main_with_peak       = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    temp_data            = dat.data
    temp_schan_data      = dat.data
    temp_main_data       = dat.data
    temp_schan_with_peak = dat.data
    temp_main_with_peak  = dat.data
    
    ; limit to just schan and just main
    IF prod EQ 'h_alpha' THEN BEGIN 
        all_main_i = where(dat.s_chan_i GT dat.energy_peak_i+4, count) ; all main channel
        IF count GT 0 THEN temp_schan_data     [all_main_i, *, *, *] = !values.f_nan
        IF count GT 0 THEN temp_schan_with_peak[all_main_i, *, *, *] = !values.f_nan
        mixed_i = where(dat.s_chan_i GE dat.energy_peak_i-15 AND $
                        dat.s_chan_i LE dat.energy_peak_i+4, count) ; has some of each channel
        IF count GT 0 THEN BEGIN
            FOR ii = 0L, count-1 DO BEGIN
                relative_i = dat.s_chan_i[mixed_i[ii]] - dat.energy_peak_i[mixed_i[ii]] + 15
                IF relative_i GT 0 THEN temp_schan_data     [mixed_i[ii], *, *, 0:relative_i-1] = !values.f_nan
                IF relative_i GT 0 THEN temp_schan_with_peak[mixed_i[ii], *, *, 0:relative_i-1] = !values.f_nan
                temp_main_data     [mixed_i[ii], *, *, relative_i:19] = !values.f_nan
                temp_main_with_peak[mixed_i[ii], *, *, relative_i:19] = !values.f_nan
            ENDFOR
        ENDIF 
        all_schan_i = where(dat.s_chan_i LT dat.energy_peak_i-15, count) ; all s-chan
        IF count GT 0 THEN temp_main_data     [all_schan_i, *, *, *] = !values.f_nan
        IF count GT 0 THEN temp_main_with_peak[all_schan_i, *, *, *] = !values.f_nan
    ENDIF ELSE BEGIN 
        all_main_i = where(dat.s_chan_i GT dat.energy_peak_i+4, count) ; all main channel
        IF count GT 0 THEN IF keyword_set(no_defl) THEN BEGIN
            temp_schan_data     [all_main_i, *, *] = !values.f_nan
            temp_schan_with_peak[all_main_i, *, *] = !values.f_nan
        ENDIF ELSE BEGIN 
            temp_schan_data     [all_main_i, *, *, *] = !values.f_nan
            temp_schan_with_peak[all_main_i, *, *, *] = !values.f_nan
        ENDELSE 
        mixed_i = where(dat.s_chan_i GE dat.energy_peak_i-5 AND $
                        dat.s_chan_i LE dat.energy_peak_i+4, count) ; has some of each channel
        IF count GT 0 THEN BEGIN
            FOR ii = 0L, count-1 DO BEGIN
                IF dat.s_chan_i[mixed_i[ii]] EQ -1 THEN BEGIN
                    IF keyword_set(no_defl) THEN BEGIN 
                        temp_schan_data     [mixed_i[ii], *, *] = !values.f_nan
                        temp_main_data [mixed_i[ii], *, *] = !values.f_nan
                        temp_schan_with_peak[mixed_i[ii], *, *] = !values.f_nan
                        temp_main_with_peak [mixed_i[ii], *, *] = !values.f_nan
                    ENDIF ELSE BEGIN 
                        temp_schan_data     [mixed_i[ii], *, *, *] = !values.f_nan
                        temp_main_data      [mixed_i[ii], *, *, *] = !values.f_nan
                        temp_schan_with_peak[mixed_i[ii], *, *, *] = !values.f_nan
                        temp_main_with_peak [mixed_i[ii], *, *, *] = !values.f_nan
                    ENDELSE 
                ENDIF ELSE BEGIN 
                    IF keyword_set(from_full) THEN relative_i = dat.s_chan_i[mixed_i[ii]] ELSE $
                      relative_i = dat.s_chan_i[mixed_i[ii]] - dat.energy_peak_i[mixed_i[ii]] + 5
                    IF relative_i GT 0 THEN IF keyword_set(no_defl) $
                      THEN BEGIN 
                        temp_schan_data     [mixed_i[ii], *, 0:relative_i-1] = !values.f_nan 
                        temp_schan_with_peak[mixed_i[ii], *, 0:relative_i-1] = !values.f_nan 
                    ENDIF ELSE BEGIN 
                        temp_schan_data     [mixed_i[ii], *, *, 0:relative_i-1] = !values.f_nan
                        temp_schan_with_peak[mixed_i[ii], *, *, 0:relative_i-1] = !values.f_nan
                    ENDELSE 
                    IF keyword_set(no_defl) THEN BEGIN
                        IF relative_i LE 127 THEN temp_main_data     [mixed_i[ii], *, relative_i:127] = !values.f_nan 
                        IF relative_i LE 127 THEN temp_main_with_peak[mixed_i[ii], *, relative_i:127] = !values.f_nan 
                    ENDIF ELSE BEGIN 
                        IF relative_i LE 9 THEN temp_main_data     [mixed_i[ii], *, *, relative_i:9] = !values.f_nan
                        IF relative_i LE 9 THEN temp_main_with_peak[mixed_i[ii], *, *, relative_i:9] = !values.f_nan
                    ENDELSE 
                ENDELSE 
            ENDFOR
        ENDIF 
        all_schan_i = where(dat.s_chan_i LT dat.energy_peak_i-5, count) ; all s-chan
        IF count GT 0 THEN IF keyword_set(no_defl) THEN BEGIN 
            temp_main_data     [all_schan_i, *, *] = !values.f_nan 
            temp_main_with_peak[all_schan_i, *, *] = !values.f_nan 
        ENDIF ELSE BEGIN 
            temp_main_data     [all_schan_i, *, *, *] = !values.f_nan
            temp_main_with_peak[all_schan_i, *, *, *] = !values.f_nan
        ENDELSE 
    ENDELSE 
    ; limit by energy
    FOR ii = 0L, N_ELEMENTS(dat.time)-1 DO BEGIN
        en = dat.energy(ii, *)*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN 
            IF cien EQ 1 THEN BEGIN ; sum over position
                zdata          (ii, *) = REFORM(TOTAL(      temp_data     (ii, *, *, ien), 3, /NaN))
                schan_data     (ii, *) = REFORM(TOTAL(temp_schan_data     (ii, *, *, ien), 3, /NaN))
                main_data      (ii, *) = REFORM(TOTAL( temp_main_data     (ii, *, *, ien), 3, /NaN))
                schan_with_peak(ii, *) = REFORM(TOTAL(temp_schan_with_peak(ii, *, *, ien), 3, /NaN))
                main_with_peak (ii, *) = REFORM(TOTAL( temp_main_with_peak(ii, *, *, ien), 3, /NaN))
            ENDIF ELSE BEGIN  ; sum over pos and energy
                zdata          (ii, *) = REFORM(TOTAL(TOTAL(      temp_data     (ii, *, *, ien), 3, /NaN), 3, /NaN)) 
                schan_data     (ii, *) = REFORM(TOTAL(TOTAL(temp_schan_data     (ii, *, *, ien), 3, /NaN), 3, /NaN))
                main_data      (ii, *) = REFORM(TOTAL(TOTAL( temp_main_data     (ii, *, *, ien), 3, /NaN), 3, /NaN))
                schan_with_peak(ii, *) = REFORM(TOTAL(TOTAL(temp_schan_with_peak(ii, *, *, ien), 3, /NaN), 3, /NaN))
                main_with_peak (ii, *) = REFORM(TOTAL(TOTAL( temp_main_with_peak(ii, *, *, ien), 3, /NaN), 3, /NaN))
            ENDELSE 
            FOR jj = 0,  7 DO BEGIN ; put back in NaN
                IF array_equal(finite(temp_data           [ii, jj, *, ien]),  0) EQ 1 THEN zdata          [ii, jj] = !values.f_nan
                IF array_equal(finite(temp_schan_data     [ii, jj, *, ien]),  0) EQ 1 THEN schan_data     [ii, jj] = !values.f_nan
                IF array_equal(finite(temp_main_data      [ii, jj, *, ien]),  0) EQ 1 THEN main_data      [ii, jj] = !values.f_nan
                IF array_equal(finite(temp_schan_with_peak[ii, jj, *, ien]),  0) EQ 1 THEN schan_with_peak[ii, jj] = !values.f_nan
                IF array_equal(finite(temp_main_with_peak [ii, jj, *, ien]),  0) EQ 1 THEN main_with_peak [ii, jj] = !values.f_nan
            ENDFOR 
        ENDIF ELSE BEGIN
            err_msg, 'No data in energy range selected'
            zdata          (ii, *) = !values.F_NAN
            schan_data     (ii, *) = !values.F_NAN
            main_data      (ii, *) = !values.F_NAN
            schan_with_peak(ii, *) = !values.F_NAN
            main_with_peak (ii, *) = !values.F_NAN
        ENDELSE
    ENDFOR
    ytitle =  ytitle + prod
ENDIF

IF prod EQ 'sw_z>2_h' THEN BEGIN
    ; limit to just schan and just main
    schan_data = FLTARR(N_ELEMENTS(dat.time), dat.nposition)    
    main_data  = FLTARR(N_ELEMENTS(dat.time), dat.nposition)    
    temp_schan_data = dat.data
    temp_main_data  = dat.data
    size = size(dat.data)
    FOR ii = 0L, size[1]-1 DO BEGIN
        temp_schan_data[ii,*, *, 0:dat.s_chan_i[ii]-1] = !values.f_nan
        IF dat.s_chan_i[ii] LT 128 THEN temp_main_data[ii, *, *, dat.s_chan_i[ii]:127] = !values.f_nan
    ENDFOR
    ; limit by energy
    zdata = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    FOR ii = 0L, N_ELEMENTS(dat.time)-1 DO BEGIN
        en = dat.energy(ii, *)*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            IF cien EQ 1 THEN BEGIN ; sum over position
                zdata     (ii, *) = REFORM(TOTAL(       dat.data(ii, *, *, ien), 3, /NaN))
                schan_data(ii, *) = REFORM(TOTAL(temp_schan_data(ii, *, *, ien), 3, /NaN))
                main_data (ii, *) = REFORM(TOTAL( temp_main_data(ii, *, *, ien), 3, /NaN))
            ENDIF ELSE BEGIN        ; sum over position and energy
                zdata     (ii, *) = REFORM(TOTAL(TOTAL(       dat.data(ii, *, *, ien), 3, /NaN), 3, /NaN))
                schan_data(ii, *) = REFORM(TOTAL(TOTAL(temp_schan_data(ii, *, *, ien), 3, /NaN), 3, /NaN))
                main_data (ii, *) = REFORM(TOTAL(TOTAL( temp_main_data(ii, *, *, ien), 3, /NaN), 3, /NaN))
            ENDELSE
        ENDIF ELSE BEGIN
            err_msg, 'No data in energy range selected'
            zdata(ii, *) = !values.F_NAN
            ;RETURN
        ENDELSE
    ENDFOR
    prodname = prodname + '_CL' + STRING(class, FORMAT = '(i2.2)')
    ytitle =  ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
ENDIF

IF prod EQ 'sw_priority' THEN BEGIN
    zdata      = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)
    schan_data = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)    
    main_data  = FLTARR(N_ELEMENTS(dat.time), dat.ndeflection)    
    temp_schan_data = dat.data
    temp_main_data  = dat.data
    size = size(dat.data)
    IF size[0] LT 3 THEN BEGIN  ; only one record
        IF finite(dat.s_chan_i[0]) EQ 1 THEN BEGIN 
            temp_schan_data[*, 0:dat.s_chan_i[0]-1] = !values.f_nan
            IF dat.s_chan_i[0] LT 128 THEN temp_main_data[*, dat.s_chan_i[0]:127] = !values.f_nan
        ENDIF ELSE BEGIN 
            temp_schan_data[*, *] = !values.f_nan
            temp_main_data [*, *] = !values.f_nan
        ENDELSE 
        en = dat.energy(*)*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            zdata     (0, *) = TOTAL(       dat.data(*, ien), 2, /nan)               
            schan_data(0, *) = TOTAL(temp_schan_data(*, ien), 2, /nan)               
            main_data (0, *) = TOTAL( temp_main_data(*, ien), 2, /nan)               
        ENDIF ELSE BEGIN
            err_msg, 'No data in energy range selected'
            zdata     (*) = !values.F_NAN
            schan_data(*) = !values.F_NAN
            main_data (*) = !values.F_NAN
        ENDELSE
    ENDIF ELSE BEGIN 
        FOR ii = 0L, size[1]-1 DO BEGIN
            IF finite(dat.s_chan_i[ii]) EQ 1 THEN BEGIN 
                temp_schan_data[ii, *, 0:dat.s_chan_i[ii]-1] = !values.f_nan
                IF dat.s_chan_i[ii] LT 128 THEN temp_main_data[ii, *, dat.s_chan_i[ii]:127] = !values.f_nan
            ENDIF ELSE BEGIN 
                temp_schan_data[ii, *, *] = !values.f_nan
                temp_main_data [ii, *, *] = !values.f_nan
            ENDELSE 
        ENDFOR
    ; limit by energy
        FOR ii = 0L, N_ELEMENTS(dat.time)-1 DO BEGIN
            en = dat.energy(ii, *)*1.e3
            ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
            IF cien GT 0 THEN BEGIN
                zdata     (ii, *) = TOTAL(REFORM(       dat.data(ii, *, ien)), 2, /nan)               
                schan_data(ii, *) = TOTAL(REFORM(temp_schan_data(ii, *, ien)), 2, /nan)               
                main_data (ii, *) = TOTAL(REFORM( temp_main_data(ii, *, ien)), 2, /nan)               
            ENDIF ELSE BEGIN
                err_msg, 'No data in energy range selected'
                zdata     (ii, *) = !values.F_NAN
                schan_data(ii, *) = !values.F_NAN
                main_data (ii, *) = !values.F_NAN
            ENDELSE
        ENDFOR
    ENDELSE 
    prodname = prodname + '_CL' + STRING(class, FORMAT = '(i2.2)')
    ytitle =  ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
ENDIF

;------------------------------------------------------------------
; Save line spectra in tplot variables
;------------------------------------------------------------------
erangestr = STRING(elow/1e3,  FORMAT = '(f5.2)') + '-' + STRING(ehigh/1e3,  FORMAT = '(f5.2)')
ytitle1 = ytitle + '!C!C' + erangestr + ' (keV)!C!CDef. Angle '

IF keyword_set(bin) THEN ytitle1 = ytitle1+'(bins)' ELSE ytitle1 = ytitle1+'(deg)'
ztitle = STRUPCASE(dat.units_name)
IF keyword_set(bin) THEN yrange = [0, 31] ELSE yrange = [-25, 25]

IF keyword_set(bin) THEN defl_bins = dat.deflection_i ELSE defl_bins = dat.deflection
store_data, prodname, data = {x:REFORM(dat.time), y:zdata, v:defl_bins}, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    yrange:yrange, $
                    zrange:[0.1, 1000], $
                    ytitle:ytitle1, $
                    ztitle:ztitle $
                   }

tplot_var = prodname
tplot, tplot_var, add_var = 999

; Store variables for schan only and main chan only
ytitle1 = ytitle + ' SChan Only!C!C' + erangestr + ' (keV)!C!CDefl. Angle '
IF keyword_set(bin) THEN ytitle1 = ytitle1+'(bins)' ELSE ytitle1 = ytitle1+'(deg)'
store_data, prodname+'_schan_only', data = {x:REFORM(dat.time), y:schan_data, v:defl_bins}, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    zrange:[0.1, 1000], $
                    ytitle:ytitle1, $
                    ztitle:ztitle $
                   }

ytitle1 = ytitle + ' Main Only!C!C' + erangestr + ' (keV)!C!CDefl. Angle '
IF keyword_set(bin) THEN ytitle1 = ytitle1+'(bins)' ELSE ytitle1 = ytitle1+'(deg)'
store_data, prodname+'_main_only', data = {x:REFORM(dat.time), y:main_data, v:defl_bins}, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    zrange:[0.1, 1000], $
                    ytitle:ytitle1, $
                    ztitle:ztitle $
                   }

IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN
    avg_theta_schan_only_with_peak =  TOTAL((schan_with_peak * defl_bins), 2) / TOTAL(schan_with_peak, 2)
    ytitle3 =  ytitle + '!C!C' + erangestr + ' (keV)!C!CAvg. Pos. Angle '
    IF keyword_set(bin) THEN ytitle3 = ytitle3+'(bins)' ELSE ytitle3 = ytitle3+'(deg)'
    temp_name = prodname+'_av_theta_schan_only_with_peak'
    store_data, temp_name, data = {x:REFORM(dat.time), y:avg_theta_schan_only_with_peak}, $
                dlim = {panel_size:1, $
                        ylog:0, $
                        yrange:[-25,  25], $
                        ytitle:ytitle3}

    avg_theta_main_only_with_peak =  TOTAL((main_with_peak * defl_bins), 2) / TOTAL(main_with_peak, 2)
    ytitle3 =  ytitle + '!C!C' + erangestr + ' (keV)!C!CAvg. Pos. Angle '
    IF keyword_set(bin) THEN ytitle3 = ytitle3+'(bins)' ELSE ytitle3 = ytitle3+'(deg)'
    temp_name = prodname+'_av_theta_main_only_with_peak'
    store_data, temp_name, data = {x:REFORM(dat.time), y:avg_theta_main_only_with_peak}, $
                dlim = {panel_size:1, $
                        ylog:0, $
                        yrange:[-25,  25], $
                        ytitle:ytitle3}
ENDIF 

IF KEYWORD_SET(diagn) THEN BEGIN
    
    ytitle2 =  ytitle + '!C!C S-Channel (keV)'
    store_data, prodname+'_s_chan', data = {x:REFORM(dat.time), y:dat.s_chan}, $
                dlim = {panel_size:1, $
                        ylog:1, $
                        yrange:[0.1, 10], $
                        ytitle:ytitle2}
    
    avg_theta = TOTAL((zdata * defl_bins), 2) / TOTAL(zdata, 2)
    ytitle3 =  ytitle + '!C!C' + erangestr + ' (keV)!C!CAvg. Def. Angle '
    IF keyword_set(bin) THEN ytitle3 = ytitle3+'(bins)' ELSE ytitle3 = ytitle3+'(deg)'
    store_data, prodname+'_av_theta', data = {x:REFORM(dat.time), y:avg_theta}, $
                dlim = {panel_size:1, $
                        ylog:0, $
                        yrange:[-25,  25], $
                        ytitle:ytitle3}
    
ENDIF


END
