; 08/22/2012 Edit largely.

PRO get_pla_browse_mom, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'browsemom', filesfound
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch1'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_density, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Bulk_Speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_velocity_inst, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Vr_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vr_hertn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Vt_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vt_hertn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Vn_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vn_hertn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'N_S_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ns_hertn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'E_W_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ew_hertn, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Temperature_Inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_temperature_inst, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Pressure_Inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_pressure_inst, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'SChannel_switch'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_s_chan, rec_count = epochinfo.maxrec+1, /zvariable
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch    = REFORM(time_double(epoch, /epoch))
                stop
                density            = REFORM(cdf_density)
                velocity_inst      = REFORM(cdf_velocity_inst)
                vr_hertn           = REFORM(cdf_vr_hertn)
                vt_hertn           = REFORM(cdf_vt_hertn)
                vn_hertn           = REFORM(cdf_vn_hertn)
                ns_hertn           = REFORM(cdf_ns_hertn)
                ew_hertn           = REFORM(cdf_ew_hertn)
                temperature_inst   = REFORM(cdf_temperature_inst)
                pressure_inst      = REFORM(cdf_pressure_inst)
                s_chan             = REFORM(cdf_s_chan)
            ENDIF ELSE BEGIN
                converted_epoch    = [converted_epoch,   REFORM(time_double(epoch, /epoch))]
                stop
                density            = [density,           REFORM(cdf_density         )]
                s_chan             = [s_chan,            REFORM(cdf_s_chan          )]
                velocity_inst      = [velocity_inst,     REFORM(cdf_velocity_inst   )]
                vr_hertn           = [vr_hertn,          REFORM(cdf_vr_hertn        )]
                vt_hertn           = [vt_hertn,          REFORM(cdf_vt_hertn        )]
                vn_hertn           = [vn_hertn,          REFORM(cdf_vn_hertn        )]
                ns_hertn           = [ns_hertn,          REFORM(cdf_ns_hertn        )]
                ew_hertn           = [ew_hertn,          REFORM(cdf_ew_hertn        )]
                temperature_inst   = [temperature_inst,  REFORM(cdf_temperature_inst)]
                pressure_inst      = [pressure_inst,     REFORM(cdf_pressure_inst   )]
                
            ENDELSE
            
            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN

    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN

ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

chkind = WHERE(density EQ -1e-31, cchkind)
IF cchkind GT 0 THEN density(chkind) = !VALUES.F_NAN
chkind = WHERE(velocity_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN velocity_inst(chkind) = !VALUES.F_NAN
chkind = WHERE(vr_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN vr_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(vt_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN vt_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(vn_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN vn_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(ns_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN ns_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(ew_hertn EQ -1e+31, cchkind)
IF cchkind GT 0 THEN ew_hertn(chkind) = !VALUES.F_NAN
chkind = WHERE(temperature_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN temperature_inst(chkind) = !VALUES.F_NAN
chkind = WHERE(pressure_inst EQ -1e+31, cchkind)
IF cchkind GT 0 THEN pressure_inst(chkind) = !VALUES.F_NAN

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_browse_mom_'
store_data, varstr+'density', $
            data = {x:converted_epoch, y:density}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'ST' + sat + '!C!Cn (cm!U-3!N)'}

store_data, varstr+'bulk_speed', $
            data = {x:converted_epoch, y:velocity_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST' + sat + '!C!CV!LT!N (km s!U-1!N)'}

store_data, varstr+'schan', $
            data = {x:converted_epoch, y:s_chan}
store_data, varstr+'vr_hertn', $
            data = {x:converted_epoch, y:vr_hertn}
store_data, varstr+'vt_hertn', $
            data = {x:converted_epoch, y:vt_hertn}
store_data, varstr+'vn_hertn', $
            data = {x:converted_epoch, y:vn_hertn}
store_data, varstr+'ns_hertn', $
            data = {x:converted_epoch, y:ns_hertn}
store_data, varstr+'ew_hernt', $
            data = {x:converted_epoch, y:ew_hertn}
store_data, varstr+'temperature', $
            data = {x:converted_epoch, y:temperature_inst}
store_data, varstr+'pressure', $
            data = {x:converted_epoch, y:pressure_inst}

END
