; Lorna Ellis
; 06/16/2014
; get_ple_beacon_raw_mom.pro

; This reads our internal raw_MOM cdfs.

PRO get_pla_beacon_raw_mom, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'beacon_raw', filesfound
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN
        cdf_id = cdf_open(filesfound(jj))
        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable
        IF epochinfo.maxrec GE 0 THEN BEGIN
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'density_raw'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_den, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'velocity_raw'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vel, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'temperature_raw'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_tem, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'heat_flux_raw'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_hfl, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'moment_array'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_arr, rec_count = epochinfo.maxrec+1, /zvariable

            IF ifwd EQ 0 THEN BEGIN
                converted_epoch    = REFORM(time_double(epoch, /epoch))
                arr_d              =        cdf_arr
                den_m              = REFORM(cdf_den[   0, *])
                den_s              = REFORM(cdf_den[   1, *])
                vel_m              = REFORM(cdf_vel[*, 0, *])
                vel_s              = REFORM(cdf_vel[*, 1, *])
                vel_x_m            = REFORM(cdf_vel[0, 0, *])
                vel_x_s            = REFORM(cdf_vel[0, 1, *])
                vel_y_m            = REFORM(cdf_vel[1, 0, *])
                vel_y_s            = REFORM(cdf_vel[1, 1, *])
                vel_z_m            = REFORM(cdf_vel[2, 0, *])
                vel_z_s            = REFORM(cdf_vel[2, 1, *])
                tem_m              = REFORM(cdf_tem[*, 0, *])
                tem_s              = REFORM(cdf_tem[*, 1, *])
                tem_xx_m           = REFORM(cdf_tem[0, 0, *])
                tem_xx_s           = REFORM(cdf_tem[0, 1, *])
                tem_xy_m           = REFORM(cdf_tem[1, 0, *])
                tem_xy_s           = REFORM(cdf_tem[1, 1, *])
                tem_xz_m           = REFORM(cdf_tem[2, 0, *])
                tem_xz_s           = REFORM(cdf_tem[2, 1, *])
                tem_yy_m           = REFORM(cdf_tem[3, 0, *])
                tem_yy_s           = REFORM(cdf_tem[3, 1, *])
                tem_yz_m           = REFORM(cdf_tem[4, 0, *])
                tem_yz_s           = REFORM(cdf_tem[4, 1, *])
                tem_zz_m           = REFORM(cdf_tem[5, 0, *])
                tem_zz_s           = REFORM(cdf_tem[5, 1, *])
                hfl_m              = REFORM(cdf_hfl[*, 0, *])
                hfl_s              = REFORM(cdf_hfl[*, 1, *])
                hfl_x_m            = REFORM(cdf_hfl[0, 0, *])
                hfl_x_s            = REFORM(cdf_hfl[0, 1, *])
                hfl_y_m            = REFORM(cdf_hfl[1, 0, *])
                hfl_y_s            = REFORM(cdf_hfl[1, 1, *])
                hfl_z_m            = REFORM(cdf_hfl[2, 0, *])
                hfl_z_s            = REFORM(cdf_hfl[2, 1, *])
            ENDIF ELSE BEGIN
                converted_epoch    = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                arr_d              = [arr_d,                  cdf_arr              ]
                den_m              = [den_m,           REFORM(cdf_den[   0, *]    )]
                den_s              = [den_s,           REFORM(cdf_den[   1, *]    )]
                vel_m              = [[vel_m],        [REFORM(cdf_vel[*, 0, *]    )]]
                vel_s              = [[vel_s],        [REFORM(cdf_vel[*, 1, *]    )]]
                vel_x_m            = [vel_x_m,         REFORM(cdf_vel[0, 0, *]    )]
                vel_x_s            = [vel_x_s,         REFORM(cdf_vel[0, 1, *]    )]
                vel_y_m            = [vel_y_m,         REFORM(cdf_vel[1, 0, *]    )]
                vel_y_s            = [vel_y_s,         REFORM(cdf_vel[1, 1, *]    )]
                vel_z_m            = [vel_z_m,         REFORM(cdf_vel[2, 0, *]    )]
                vel_z_s            = [vel_z_s,         REFORM(cdf_vel[2, 1, *]    )]
                tem_m              = [[tem_m],        [REFORM(cdf_tem[*, 0, *]    )]]
                tem_s              = [[tem_s],        [REFORM(cdf_tem[*, 1, *]    )]]
                tem_xx_m           = [tem_xx_m,        REFORM(cdf_tem[0, 0, *]    )]
                tem_xx_s           = [tem_xx_s,        REFORM(cdf_tem[0, 1, *]    )]
                tem_xy_m           = [tem_xy_m,        REFORM(cdf_tem[1, 0, *]    )]
                tem_xy_s           = [tem_xy_s,        REFORM(cdf_tem[1, 1, *]    )]
                tem_xz_m           = [tem_xz_m,        REFORM(cdf_tem[2, 0, *]    )]
                tem_xz_s           = [tem_xz_s,        REFORM(cdf_tem[2, 1, *]    )]
                tem_yy_m           = [tem_yy_m,        REFORM(cdf_tem[3, 0, *]    )]
                tem_yy_s           = [tem_yy_s,        REFORM(cdf_tem[3, 1, *]    )]
                tem_yz_m           = [tem_yz_m,        REFORM(cdf_tem[4, 0, *]    )]
                tem_yz_s           = [tem_yz_s,        REFORM(cdf_tem[4, 1, *]    )]
                tem_zz_m           = [tem_zz_m,        REFORM(cdf_tem[5, 0, *]    )]
                tem_zz_s           = [tem_zz_s,        REFORM(cdf_tem[5, 1, *]    )]
                hfl_m              = [[hfl_m],        [REFORM(cdf_hfl[*, 0, *]    )]]
                hfl_s              = [[hfl_s],        [REFORM(cdf_hfl[*, 1, *]    )]]
                hfl_x_m            = [hfl_x_m,         REFORM(cdf_hfl[0, 0, *]    )]
                hfl_x_s            = [hfl_x_s,         REFORM(cdf_hfl[0, 1, *]    )]
                hfl_y_m            = [hfl_y_m,         REFORM(cdf_hfl[1, 0, *]    )]
                hfl_y_s            = [hfl_y_s,         REFORM(cdf_hfl[1, 1, *]    )]
                hfl_z_m            = [hfl_z_m,         REFORM(cdf_hfl[2, 0, *]    )]
                hfl_z_s            = [hfl_z_s,         REFORM(cdf_hfl[2, 1, *]    )]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

get_timespan, tt
good_i = where(converted_epoch GE tt[0] AND converted_epoch LE tt[1], good_count)
IF good_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[   good_i]
    arr_d           = arr_d          [   good_i]
    den_m           = den_m          [   good_i]
    den_s           = den_s          [   good_i]
    vel_m           = vel_m          [*, good_i]
    vel_s           = vel_s          [*, good_i]
    vel_x_m         = vel_x_m        [   good_i]
    vel_x_s         = vel_x_s        [   good_i]
    vel_y_m         = vel_y_m        [   good_i]
    vel_y_s         = vel_y_s        [   good_i]
    vel_z_m         = vel_z_m        [   good_i]
    vel_z_s         = vel_z_s        [   good_i]
    tem_m           = tem_m          [*, good_i]
    tem_s           = tem_s          [*, good_i]
    tem_xx_m        = tem_xx_m       [   good_i]
    tem_xx_s        = tem_xx_s       [   good_i]
    tem_xy_m        = tem_xy_m       [   good_i]
    tem_xy_s        = tem_xy_s       [   good_i]
    tem_xz_m        = tem_xz_m       [   good_i]
    tem_xz_s        = tem_xz_s       [   good_i]
    tem_yy_m        = tem_yy_m       [   good_i]
    tem_yy_s        = tem_yy_s       [   good_i]
    tem_yz_m        = tem_yz_m       [   good_i]
    tem_yz_s        = tem_yz_s       [   good_i]
    tem_zz_m        = tem_zz_m       [   good_i]
    tem_zz_s        = tem_zz_s       [   good_i]
    hfl_m           = hfl_m          [*, good_i]
    hfl_s           = hfl_s          [*, good_i]
    hfl_x_m         = hfl_x_m        [   good_i]
    hfl_x_s         = hfl_x_s        [   good_i]
    hfl_y_m         = hfl_y_m        [   good_i]
    hfl_y_s         = hfl_y_s        [   good_i]
    hfl_z_m         = hfl_z_m        [   good_i]
    hfl_z_s         = hfl_z_s        [   good_i]

    bad_arr_d_i    = where(arr_d    LE -1E+30, bad_arr_d_count   )
    bad_den_m_i    = where(den_m    LE -1E+30, bad_den_m_count   )
    bad_den_s_i    = where(den_s    LE -1E+30, bad_den_s_count   )
    bad_vel_m_i    = where(vel_m    LE -1E+30, bad_vel_m_count   )
    bad_vel_s_i    = where(vel_s    LE -1E+30, bad_vel_s_count   )
    bad_vel_x_m_i  = where(vel_x_m  LE -1E+30, bad_vel_x_m_count )
    bad_vel_x_s_i  = where(vel_x_s  LE -1E+30, bad_vel_x_s_count )
    bad_vel_y_m_i  = where(vel_y_m  LE -1E+30, bad_vel_y_m_count )
    bad_vel_y_s_i  = where(vel_y_s  LE -1E+30, bad_vel_y_s_count )
    bad_vel_z_m_i  = where(vel_z_m  LE -1E+30, bad_vel_z_m_count )
    bad_vel_z_s_i  = where(vel_z_s  LE -1E+30, bad_vel_z_s_count )
    bad_tem_m_i    = where(tem_m    LE -1E+30, bad_tem_m_count   )
    bad_tem_s_i    = where(tem_s    LE -1E+30, bad_tem_s_count   )
    bad_tem_xx_m_i = where(tem_xx_m LE -1E+30, bad_tem_xx_m_count)
    bad_tem_xx_s_i = where(tem_xx_s LE -1E+30, bad_tem_xx_s_count)
    bad_tem_xy_m_i = where(tem_xy_m LE -1E+30, bad_tem_xy_m_count)
    bad_tem_xy_s_i = where(tem_xy_s LE -1E+30, bad_tem_xy_s_count)
    bad_tem_xz_m_i = where(tem_xz_m LE -1E+30, bad_tem_xz_m_count)
    bad_tem_xz_s_i = where(tem_xz_s LE -1E+30, bad_tem_xz_s_count)
    bad_tem_yy_m_i = where(tem_yy_m LE -1E+30, bad_tem_yy_m_count)
    bad_tem_yy_s_i = where(tem_yy_s LE -1E+30, bad_tem_yy_s_count)
    bad_tem_yz_m_i = where(tem_yz_m LE -1E+30, bad_tem_yz_m_count)
    bad_tem_yz_s_i = where(tem_yz_s LE -1E+30, bad_tem_yz_s_count)
    bad_tem_zz_m_i = where(tem_zz_m LE -1E+30, bad_tem_zz_m_count)
    bad_tem_zz_s_i = where(tem_zz_s LE -1E+30, bad_tem_zz_s_count)
    bad_hfl_m_i    = where(hfl_m    LE -1E+30, bad_hfl_m_count   )
    bad_hfl_s_i    = where(hfl_s    LE -1E+30, bad_hfl_s_count   )
    bad_hfl_x_m_i  = where(hfl_x_m  LE -1E+30, bad_hfl_x_m_count )
    bad_hfl_x_s_i  = where(hfl_x_s  LE -1E+30, bad_hfl_x_s_count )
    bad_hfl_y_m_i  = where(hfl_y_m  LE -1E+30, bad_hfl_y_m_count )
    bad_hfl_y_s_i  = where(hfl_y_s  LE -1E+30, bad_hfl_y_s_count )
    bad_hfl_z_m_i  = where(hfl_z_m  LE -1E+30, bad_hfl_z_m_count )
    bad_hfl_z_s_i  = where(hfl_z_s  LE -1E+30, bad_hfl_z_s_count )

    IF bad_arr_d_count    GT 0 THEN arr_d   (bad_arr_d_i   ) = !values.f_nan
    IF bad_den_m_count    GT 0 THEN den_m   (bad_den_m_i   ) = !values.f_nan
    IF bad_den_s_count    GT 0 THEN den_s   (bad_den_s_i   ) = !values.f_nan
    IF bad_vel_m_count    GT 0 THEN vel_m   (bad_vel_m_i   ) = !values.f_nan
    IF bad_vel_s_count    GT 0 THEN vel_s   (bad_vel_s_i   ) = !values.f_nan
    IF bad_vel_x_m_count  GT 0 THEN vel_x_m (bad_vel_x_m_i ) = !values.f_nan
    IF bad_vel_x_s_count  GT 0 THEN vel_x_s (bad_vel_x_s_i ) = !values.f_nan
    IF bad_vel_y_m_count  GT 0 THEN vel_y_m (bad_vel_y_m_i ) = !values.f_nan
    IF bad_vel_y_s_count  GT 0 THEN vel_y_s (bad_vel_y_s_i ) = !values.f_nan
    IF bad_vel_z_m_count  GT 0 THEN vel_z_m (bad_vel_z_m_i ) = !values.f_nan
    IF bad_vel_z_s_count  GT 0 THEN vel_z_s (bad_vel_z_s_i ) = !values.f_nan
    IF bad_tem_m_count    GT 0 THEN tem_m   (bad_tem_m_i   ) = !values.f_nan
    IF bad_tem_s_count    GT 0 THEN tem_s   (bad_tem_s_i   ) = !values.f_nan
    IF bad_tem_xx_m_count GT 0 THEN tem_xx_m(bad_tem_xx_m_i) = !values.f_nan
    IF bad_tem_xx_s_count GT 0 THEN tem_xx_s(bad_tem_xx_s_i) = !values.f_nan
    IF bad_tem_xy_m_count GT 0 THEN tem_xy_m(bad_tem_xy_m_i) = !values.f_nan
    IF bad_tem_xy_s_count GT 0 THEN tem_xy_s(bad_tem_xy_s_i) = !values.f_nan
    IF bad_tem_xz_m_count GT 0 THEN tem_xz_m(bad_tem_xz_m_i) = !values.f_nan
    IF bad_tem_xz_s_count GT 0 THEN tem_xz_s(bad_tem_xz_s_i) = !values.f_nan
    IF bad_tem_yy_m_count GT 0 THEN tem_yy_m(bad_tem_yy_m_i) = !values.f_nan
    IF bad_tem_yy_s_count GT 0 THEN tem_yy_s(bad_tem_yy_s_i) = !values.f_nan
    IF bad_tem_yz_m_count GT 0 THEN tem_yz_m(bad_tem_yz_m_i) = !values.f_nan
    IF bad_tem_yz_s_count GT 0 THEN tem_yz_s(bad_tem_yz_s_i) = !values.f_nan
    IF bad_tem_zz_m_count GT 0 THEN tem_zz_m(bad_tem_zz_m_i) = !values.f_nan
    IF bad_tem_zz_s_count GT 0 THEN tem_zz_s(bad_tem_zz_s_i) = !values.f_nan
    IF bad_hfl_m_count    GT 0 THEN hfl_m   (bad_hfl_m_i   ) = !values.f_nan
    IF bad_hfl_s_count    GT 0 THEN hfl_s   (bad_hfl_s_i   ) = !values.f_nan
    IF bad_hfl_x_m_count  GT 0 THEN hfl_x_m (bad_hfl_x_m_i ) = !values.f_nan
    IF bad_hfl_x_s_count  GT 0 THEN hfl_x_s (bad_hfl_x_s_i ) = !values.f_nan
    IF bad_hfl_y_m_count  GT 0 THEN hfl_y_m (bad_hfl_y_m_i ) = !values.f_nan
    IF bad_hfl_y_s_count  GT 0 THEN hfl_y_s (bad_hfl_y_s_i ) = !values.f_nan
    IF bad_hfl_z_m_count  GT 0 THEN hfl_z_m (bad_hfl_z_m_i ) = !values.f_nan
    IF bad_hfl_z_s_count  GT 0 THEN hfl_z_s (bad_hfl_z_s_i ) = !values.f_nan

    vel_m = transpose(vel_m)
    vel_s = transpose(vel_s)
    tem_m = transpose(tem_m)
    tem_s = transpose(tem_s)
    hfl_m = transpose(hfl_m)
    hfl_s = transpose(hfl_s)

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
    varstr = sat + '_beacon_raw_mom_'

    store_data, varstr+'array',                    data = {x:converted_epoch, y:arr_d   }
    store_data, varstr+'density_raw_main',         data = {x:converted_epoch, y:den_m   }
    store_data, varstr+'density_raw_schan',        data = {x:converted_epoch, y:den_s   }
    store_data, varstr+'velocity_raw_main',        data = {x:converted_epoch, y:vel_m   }
    store_data, varstr+'velocity_raw_schan',       data = {x:converted_epoch, y:vel_s   }
    store_data, varstr+'velocity_x_raw_main',      data = {x:converted_epoch, y:vel_x_m }
    store_data, varstr+'velocity_x_raw_schan',     data = {x:converted_epoch, y:vel_x_s }
    store_data, varstr+'velocity_y_raw_main',      data = {x:converted_epoch, y:vel_y_m }
    store_data, varstr+'velocity_y_raw_schan',     data = {x:converted_epoch, y:vel_y_s }
    store_data, varstr+'velocity_z_raw_main',      data = {x:converted_epoch, y:vel_z_m }
    store_data, varstr+'velocity_z_raw_schan',     data = {x:converted_epoch, y:vel_z_s }
    store_data, varstr+'temperature_raw_main',     data = {x:converted_epoch, y:tem_m   }
    store_data, varstr+'temperature_raw_schan',    data = {x:converted_epoch, y:tem_s   }
    store_data, varstr+'temperature_xx_raw_main',  data = {x:converted_epoch, y:tem_xx_m}
    store_data, varstr+'temperature_xx_raw_schan', data = {x:converted_epoch, y:tem_xx_s}
    store_data, varstr+'temperature_xy_raw_main',  data = {x:converted_epoch, y:tem_xy_m}
    store_data, varstr+'temperature_xy_raw_schan', data = {x:converted_epoch, y:tem_xy_s}
    store_data, varstr+'temperature_xz_raw_main',  data = {x:converted_epoch, y:tem_xz_m}
    store_data, varstr+'temperature_xz_raw_schan', data = {x:converted_epoch, y:tem_xz_s}
    store_data, varstr+'temperature_yy_raw_main',  data = {x:converted_epoch, y:tem_yy_m}
    store_data, varstr+'temperature_yy_raw_schan', data = {x:converted_epoch, y:tem_yy_s}
    store_data, varstr+'temperature_yz_raw_main',  data = {x:converted_epoch, y:tem_yz_m}
    store_data, varstr+'temperature_yz_raw_schan', data = {x:converted_epoch, y:tem_yz_s}
    store_data, varstr+'temperature_zz_raw_main',  data = {x:converted_epoch, y:tem_zz_m}
    store_data, varstr+'temperature_zz_raw_schan', data = {x:converted_epoch, y:tem_zz_s}
    store_data, varstr+'heat_flux_raw_main',       data = {x:converted_epoch, y:hfl_m   }
    store_data, varstr+'heat_flux_raw_schan',      data = {x:converted_epoch, y:hfl_s   }
    store_data, varstr+'heat_flux_x_raw_main',     data = {x:converted_epoch, y:hfl_x_m }
    store_data, varstr+'heat_flux_x_raw_schan',    data = {x:converted_epoch, y:hfl_x_s }
    store_data, varstr+'heat_flux_y_raw_main',     data = {x:converted_epoch, y:hfl_y_m }
    store_data, varstr+'heat_flux_y_raw_schan',    data = {x:converted_epoch, y:hfl_y_s }
    store_data, varstr+'heat_flux_z_raw_main',     data = {x:converted_epoch, y:hfl_z_m }
    store_data, varstr+'heat_flux_z_raw_schan',    data = {x:converted_epoch, y:hfl_z_s }
ENDIF 
END
