; Lorna Ellis
; 05/01/2014
; get_pla_beacon_hk

; Reads hk data from beacon cdfs and makes tplot variables.

PRO get_pla_beacon_hk, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'beacon', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch1'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            check_name      = 'Checksum'
            error_name      = 'Error_Flag'
            hkflag_name     = 'HK_flag'
            pac_vm_raw_name = 'PAC_VM_Raw'
            pac_vm_eng_name = 'PAC_VM_Conv'
            mcp_vm_raw_name = 'MCP_VM_Raw'
            mcp_vm_eng_name = 'MCP_VM_Conv'
            cdf_varget, cdf_id, check_name,      cdf_check,      rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, error_name,      cdf_error,      rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, hkflag_name,     cdf_hkflag,     rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pac_vm_raw_name, cdf_pac_vm_raw, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pac_vm_eng_name, cdf_pac_vm_eng, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, mcp_vm_raw_name, cdf_mcp_vm_raw, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, mcp_vm_eng_name, cdf_mcp_vm_eng, rec_count = epochinfo.maxrec+1, /zvariable
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                check           = float(reform(cdf_check))
                error           = float(reform(cdf_error))
                hkflag          = float(reform(cdf_hkflag))
                pac_vm_raw      = float(reform(cdf_pac_vm_raw))
                pac_vm_eng      = float(reform(cdf_pac_vm_eng))
                mcp_vm_raw      = float(reform(cdf_mcp_vm_raw))
                mcp_vm_eng      = float(reform(cdf_mcp_vm_eng))
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, float(reform(time_double(epoch, /epoch)))]
                check           = [check,           float(reform(cdf_check))]
                error           = [error,           float(reform(cdf_error))]
                hkflag          = [hkflag,          float(reform(cdf_hkflag))]
                pac_vm_raw      = [pac_vm_raw,      float(reform(cdf_pac_vm_raw))]
                pac_vm_eng      = [pac_vm_eng,      float(reform(cdf_pac_vm_eng))]
                mcp_vm_raw      = [mcp_vm_raw,      float(reform(cdf_mcp_vm_raw))]
                mcp_vm_eng      = [mcp_vm_eng,      float(reform(cdf_mcp_vm_eng))]
            ENDELSE

            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
;icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
;                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
;IF cicepoch GT 0 THEN STOP

; outside timerange
get_timespan, tt
bad_i = where(converted_epoch LT tt[0] OR converted_epoch GT tt[1], bad_count, complement = good_i, ncomplement = good_count)
IF good_count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF ELSE IF bad_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[good_i]
    check           = check          [good_i]
    error           = error          [good_i]
    hkflag          = hkflag         [good_i]
    pac_vm_raw      = pac_vm_raw     [good_i]
    pac_vm_eng      = pac_vm_eng     [good_i]
    mcp_vm_raw      = mcp_vm_raw     [good_i]
    mcp_vm_eng      = mcp_vm_eng     [good_i]
ENDIF 

; check for fill values
bad_check      = where(check      LT 0, check_count     )
bad_error      = where(error      LT 0, error_count     )
bad_hkflag     = where(hkflag     LT 0, hkflag_count    )
bad_pac_vm_raw = where(pac_vm_raw LT 0, pac_vm_raw_count)
bad_mcp_vm_raw = where(mcp_vm_raw LT 0, mcp_vm_raw_count)
IF check_count      GT 0 THEN check     [bad_check     ] = !values.f_nan
IF error_count      GT 0 THEN error     [bad_error     ] = !values.f_nan
IF hkflag_count     GT 0 THEN hkflag    [bad_hkflag    ] = !values.f_nan
IF pac_vm_raw_count GT 0 THEN pac_vm_raw[bad_pac_vm_raw] = !values.f_nan
IF mcp_vm_raw_count GT 0 THEN mcp_vm_raw[bad_mcp_vm_raw] = !values.f_nan

; check for bad data
bad_i = where(check GT 0 OR error GT 0, bad_count)
IF bad_count GT 0 THEN BEGIN 
    pac_vm_raw[bad_i] = !values.f_nan
    pac_vm_eng[bad_i] = !values.f_nan
    mcp_vm_raw[bad_i] = !values.f_nan
    mcp_vm_eng[bad_i] = !values.f_nan
ENDIF 

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_beacon_'

store_data, varstr+'checksum_flag', $
            data = {x:converted_epoch, y:check}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cchecksum flag'}
store_data, varstr+'error', $
            data = {x:converted_epoch, y:error}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cerror flag'}
store_data, varstr+'hk_flag', $
            data = {x:converted_epoch, y:hkflag}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Chk flag'}
store_data, varstr+'pac_vm_raw', $
            data = {x:converted_epoch, y:pac_vm_raw}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpac_vm_raw'}
store_data, varstr+'pac_vm_eng', $
            data = {x:converted_epoch, y:pac_vm_eng}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpac_vm_eng'}
store_data, varstr+'mcp_vm_raw', $
            data = {x:converted_epoch, y:mcp_vm_raw}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cmcp_vm_raw'}
store_data, varstr+'mcp_vm_eng', $
            data = {x:converted_epoch, y:mcp_vm_eng}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cmcp_vm_eng'}
END
