;+
; FUNCTION: get_pla_class
;
; PURPOSE: To create the data structure of the 'class' product
;
; INPUT: sat: S/C id - 'A' or 'B'
;
; OUTPUT: the data structure is returned
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;   05-15-2007: CM
;               Actual maxrec is epochinfo.maxrec+1
;   09-27-2012: LBE: Added set_to_beg keyword.
;
;-

FUNCTION get_pla_class, sat, set_to_beg = set_to_beg
compile_opt strictarrsubs

prod = 'class'
nenergy = 1
nposition = 1
ndeflection = 1

seek_files, sat, 'cl', filesfound ; find files that correspond to time interval
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN, 0
ENDIF

get_pla_energies, sat, esa_step             ; get energy bin values range


data = FLTARR(1440, 32,  32,  64)
time = DBLARR(1440)
energy = FLTARR(1440, 64)
;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    cdf_id = cdf_open(filesfound(jj))

    prod_name = 'epoch_classifier'
    cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable
    cdf_varget, cdf_id, prod_name, epoch_classifier, rec_count = epochinfo.maxrec+1, /zvariable
    
    prod_name = 'block_id_classifier'
    cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
    cdf_varget, cdf_id, prod_name, cdf_block_id_classifier, rec_count = epochinfo.maxrec+1, /zvariable
    
    prod_name = 'esa_step'
    cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
    cdf_varget, cdf_id, prod_name, cdf_esa_step, rec_count = epochinfo.maxrec+1, /zvariable

    prod_name = 'classifier_data'
    cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
    cdf_varget, cdf_id, prod_name, cdf_classifier_data, rec_count = epochinfo.maxrec+1, /zvariable


    
    converted_epoch =  time_double(epoch_classifier,  /epoch)
    s_chan =  cdf_esa_step GT 128
    cdf_esa_step =  cdf_esa_step - (s_chan * 128)

    kk =  0l
    FOR it =  0l, 25431 DO BEGIN

        time(kk) =  converted_epoch(it)

        en_ind =  cdf_esa_step(it) - 64
        ;energy(kk, en_ind) =  esa_step(cdf_esa_step(it))
        energy(kk, *) =  esa_step(64:127)
        po_ind =  cdf_block_id_classifier(it) * 4
        data(kk, *, po_ind+0, en_ind) =  cdf_classifier_data(0:31, it)
        data(kk, *, po_ind+1, en_ind) =  cdf_classifier_data(32:63, it)
        data(kk, *, po_ind+2, en_ind) =  cdf_classifier_data(64:95, it)
        data(kk, *, po_ind+3, en_ind) =  cdf_classifier_data(96:127, it)
        
        IF converted_epoch(it+1) GT converted_epoch(it) THEN BEGIN
            kk =  kk + 1

        ENDIF

    ENDFOR

    cdf_close, cdf_id
    
ENDFOR

;------------------------------------------------------------------
; Construct the dara structure
;------------------------------------------------------------------
retdata = {$
          project:    'STEREO PLASTIC', $
          prod_name:  prod, $
          ntime:       N_ELEMENTS(converted_epoch), $
          time:       time, $
          units_name:  'Counts', $
          data:       data, $
          energy:     energy, $
          s_chan:     s_chan $

          }

RETURN, retdata


END
