;+
;PROCEDURE: find_peak
;PURPOSE:
;  Find ESA/defl with peak count rate for each time step.
;
;PARAMETERS:   in:  sat        : 'A' or 'B'
;                   files      : Array of file paths to read from (strings)
;                   which_epoch: 0(for variable), 1, or 5 minute resolution
;				
;
;CREATED BY: K. Simunac -- a modification of L. Ellis' pl_read_cdf
;
;LAST MODIFICATION: 01/23/2008
;
;MODIFICATION HISTORY:
;    01/18/2008: Created 
;	01/23/2008:  added routine to store output as tplot variables
;       01/23/2008: LBE: changed loop variable to long
;
;-

PRO read_product_full_peak, cdf_id, prod_name, data_var, data_index, epoch_maxrec
compile_opt strictarrsubs

; prod_name: string with cdf variable name 
; data_var: the common variable in which to put the data
; data_index: the start index for records in the data_var
; epoch_maxrec: number of records we expect 

cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable

IF varinfo.maxrec+1 GE epoch_maxrec THEN maxrec = varinfo.maxrec ELSE maxrec = epoch_maxrec


IF maxrec GT 0 THEN BEGIN 
	cdf_varget, cdf_id, prod_name, temp_data, rec_count = maxrec+1, /zvariable
	num_dim = size(data_var, /n_dimensions)

	CASE num_dim OF 
    	1: BEGIN
        	FOR kk = 0L,n_elements(data_index)-2 DO BEGIN ; changed to -2 17 October, 2007
	 		data_var[data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	2: BEGIN
        	FOR kk = 0L,n_elements(data_index)-2 DO BEGIN 
			data_var[*, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	3: BEGIN
      		FOR kk = 0L, n_elements(data_index)-2 DO BEGIN 
			data_var[*, *, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, *, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	ELSE: BEGIN 
        	print, "Lorna: Add more dimensions"
        	stop
    	END
	ENDCASE 
ENDIF ELSE BEGIN
	data_index = -1
ENDELSE
END 

PRO remove_fill_full_peak, fill_val, data
compile_opt strictarrsubs

; fill_val: fill_value to be replaced by NaN
; data: array of data values
indice = where(data EQ fill_val, count)
FOR ii = 0L, count-1 DO BEGIN
    data[indice[ii]] = !values.f_nan ; changed to float from double 17 January, 2008
ENDFOR 

END 


PRO init_full_peak, sat, num_records1, full_peak_initialized
compile_opt strictarrsubs

; initialize all the rate variables (in com_full_peak)

COMMON com_full_peak

CASE sat OF
    'A': BEGIN 
	s_chan1_a	= intarr(num_records1) ; channel of s-channel switch
	s_chan1_a[*]	= -1 
	error1_a	= intarr(num_records1) ; error flag
	error1_a[*]	= -1	
	sf0_a_full	= fltarr(128,32,num_records1) 
	sf0_a_full[*,*,*]	= !values.f_nan
	ra_trig_a_full	= fltarr(128,32,num_records1) ; 15
	ra_trig_a_full[*,*,*]	= !values.f_nan
	data_matrix_A = fltarr(128,  FIX(num_records1/10))
	data_matrix_A[*,*] = !values.f_nan
		
    END 
    'B': BEGIN 
	s_chan1_b	= intarr(num_records1)
	s_chan1_b[*]	= -1
	error1_b	= intarr(num_records1) ; error flag
	error1_b[*]	= -1	
	sf0_b_full	= fltarr(128,32,num_records1) ; 12
	sf0_b_full[*,*,*]	= !values.f_nan	
	ra_trig_b_full	= fltarr(128,32,num_records1) ; 15
	ra_trig_b_full[*,*,*]	= !values.f_nan
	data_matrix_B = fltarr(128,  FIX(num_records1/10))
	data_matrix_B[*,*] = !values.f_nan
	END
ENDCASE 
full_peak_initialized = 1

END 

PRO read_full_peak, cdf_id, sat, full_peak_read, data1_index, epoch1maxrec
compile_opt strictarrsubs

COMMON com_full_peak
CASE sat OF 
    'A': BEGIN
	
	read_product_full_peak, cdf_id, 'error1', error1_a, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, error1_a
	IF (TOTAL(error1_a, /NAN) GT 0) THEN print, 'ERROR1 FLAG SET'

	read_product_full_peak, cdf_id, 's_chan1', s_chan1_a, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, s_chan1_a

	read_product_full_peak, cdf_id, 'sf0_full', sf0_a_full, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, sf0_a_full
	read_product_full_peak, cdf_id, 'ra_trig_full', ra_trig_a_full, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, ra_trig_a_full


    END
    'B': BEGIN

	read_product_full_peak, cdf_id, 'error1', error1_b, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, error1_b
	IF (TOTAL(error1_b, /NAN) GT 0) THEN print, 'ERROR1 FLAG SET'

	read_product_full_peak, cdf_id, 's_chan1', s_chan1_b, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, s_chan1_b

	read_product_full_peak, cdf_id, 'sf0_full', sf0_b_full, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, sf0_b_full
	read_product_full_peak, cdf_id, 'ra_trig_full', ra_trig_b_full, data1_index, epoch1maxrec
	remove_fill_full_peak, -1, ra_trig_b_full
	
	END

    ENDCASE
    full_peak_read = 1
END 

PRO check_indices_full_peak, index, epoch, resolution, file_num
compile_opt strictarrsubs

; checks for missing records from the cdf epoch variable
; index: array of pairs [start_index,num_records] (could be [0,10,15,2] for times 0-9,15-16)
; epoch: array of time values read from cdf (and converted)
; resolution: 1 for 1 minute
; file_num: index of this file in the file array


first_index=0L
first_index = LONG(file_num*(1440/resolution))

num_records = 0L
in_valid_area = 0
ii = 0L
index = [-1L]
in_synch = 1 ; needed for when duplicate time-stamps -- only takes first

CASE resolution OF 
    1: BEGIN 
        FOR hour = 0, 23 DO BEGIN 
            FOR min = 0, 59 DO BEGIN
		;stop
		WHILE in_synch EQ 1 DO BEGIN 
                	IF ii LT n_elements(epoch) THEN BEGIN
                    		time = time_struct(epoch[ii])
                    		IF hour EQ time.hour AND min EQ time.min THEN BEGIN 
                        		IF in_valid_area EQ 0 THEN BEGIN
			    		start_index_time = first_index + (hour*60) + min
                            		start_index_cdf = ii
                            		num_records = 1
                            		in_valid_area = 1
					;stop
					ENDIF ELSE BEGIN ; already in valid area
                            			num_records = num_records+1
						IF ii EQ n_elements(epoch)-1 THEN BEGIN
							
							IF index[0] EQ -1 THEN BEGIN
							index = [start_index_time, start_index_cdf, num_records]
							ENDIF ELSE BEGIN
							index = [index, start_index_time, start_index_cdf, num_records]
							ENDELSE
						ENDIF
                        		ENDELSE 
                        	ii = ii+1
		        	in_synch = 0
					
                    		ENDIF ELSE BEGIN
					
                        		IF in_valid_area EQ 1 THEN BEGIN
                            		in_valid_area = 0
                            		IF index[0] EQ -1 THEN index = [start_index_time, start_index_cdf, num_records] $
                            		ELSE index = [index, start_index_time,start_index_cdf, num_records]
                        		ENDIF
					IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN BEGIN
						ii = ii+1
					ENDIF ELSE BEGIN
						in_synch = 0
                    			ENDELSE
				ENDELSE 
                	ENDIF ELSE BEGIN 
                    		IF in_valid_area EQ 1 THEN BEGIN
                        		in_valid_area = 0
                        		IF index[0] EQ -1 THEN index = [start_index_time,start_index_cdf, num_records] $
                        		ELSE index = [index, start_index_time, start_index_cdf, num_records]
					ii = ii+1
					;stop                
                    		ENDIF 
		    	in_synch = 0
                	ENDELSE 
	    	ENDWHILE
	    	in_synch = 1
            ENDFOR 
        ENDFOR 
	;stop
    END

    ELSE: BEGIN
        print, "Lorna -- add variable resolution"
        stop
    END 
ENDCASE 
;stop
END 


PRO find_peak, sat, files, which_epoch, time, output_dir
compile_opt strictarrsubs

COMMON share1_full_peak
COMMON com_full_peak
; check if there are any files to read
IF n_elements(products) GT 0 AND n_elements(files) EQ 0 THEN print, "No Data Files in this Time Range for Satellite ", sat

; initialize output variables (from common block)
need_epoch1 = 0

FOR ii = 0L, n_elements(which_epoch)-1 DO BEGIN 
    CASE which_epoch[ii] OF 
        1: BEGIN 
            num_records1 = LONG(n_elements(files)*1441)
            epoch1 = dblarr(num_records1)
            epoch1(*) = !values.d_nan
            need_epoch1 = 1
        END 
        ELSE: BEGIN
            print, "Invalid indication of which epoch is needed: ", which_epoch
            stop
        END
    ENDCASE 
ENDFOR 

full_peak_initialized = 0
IF full_peak_initialized EQ 0 THEN init_full_peak, sat, num_records1, full_peak_initialized
    
; read data
FOR ii = 0L, n_elements(files)-1 DO BEGIN 
    IF strcmp(files[ii], '') NE 1 THEN BEGIN 
        cdf_id = cdf_open(files[ii])
                                ; get epochs
        FOR jj = 0L, n_elements(which_epoch)-1 DO BEGIN 
            CASE which_epoch[jj] OF 
                1: BEGIN 
                    cdf_control, cdf_id, get_var_info = epoch1info, var = 'epoch1', /zvariable
                    IF epoch1info.maxrec GE 0 THEN BEGIN 
                        cdf_varget, cdf_id, 'epoch1', temp_epoch, rec_count = epoch1info.maxrec+1, /zvariable
		
			;changed rec_count to +1 so that last record of day will be included 15 August, 2007
			
                        converted_epoch = time_double(temp_epoch, /epoch)
                        check_indices_full_peak, data1_index, converted_epoch, which_epoch, ii
                     	converted_index=0L

			; below modified 17 January, 2008 to fix problem with repeated time stamps

                        FOR kk = 0L, n_elements(data1_index)-2 DO BEGIN ; modified 17 January, 2008 
			 converted_index = data1_index[kk+1]
			 epoch1[data1_index[kk]:(data1_index[kk]+data1_index[kk+2]-1)] = $
                              	converted_epoch[converted_index:(converted_index+data1_index[kk+2]-1)]
				;stop
				
                            kk = kk+2
                        ENDFOR
			;stop
		   ENDIF ELSE files[ii] = ''
		remove_fill_full_peak, -1E31, epoch1
                  END 
                ELSE: BEGIN
                    print, "Invalid indication of which epoch is needed: ", which_epoch
                    stop
                END
            ENDCASE 
        ENDFOR 
        IF sat EQ 'A' THEN BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_a = epoch1 
        ENDIF ELSE BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_b = epoch1 
        ENDELSE 

        ; get other data
        full_peak_read = 0
	IF full_peak_read EQ 0 THEN read_full_peak, cdf_id, sat, full_peak_read, data1_index, epoch1info.maxrec+1;, num_records1
	;changed to maxrec + 1 so that last record of day will be read 15 August, 2007
    ENDIF 
ENDFOR 


IF sat EQ 'A' THEN BEGIN 
    IF need_epoch1 EQ 1 THEN data1_index_a = data1_index 
ENDIF ELSE BEGIN
    IF need_epoch1 EQ 1 THEN data1_index_b = data1_index
ENDELSE 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;							  ;
; Below is a routine to find the ESA/defl combination     ;
; with the peak number of counts for each time step.      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


IF sat EQ 'A' THEN BEGIN

; Check that there is actually data in the files.  If not, then stop.

IF TOTAL(sf0_a_full, /nan) LE 0 AND TOTAL(ra_trig_a_full, /nan) LE 0 THEN BEGIN
PRINT, 'No SF0 or RA_trig data for this time.'
STOP
ENDIF

full_data = intarr(128,32,num_records1) ; changed from float to integer to save memory 28 Sept, 2007
rate_name = ' '


; Check to see if there are RA_Trig counts.  If so, continue.  
; If not, assume the full resolution rate is SF0.
;
; RA_Trig was set as the full resolution rate on 14 February, 2007 for A
; and on 1 March, 2007 for B.

IF TOTAL(ra_trig_a_full, /nan) GT 0 THEN BEGIN
	full_data = FIX(ra_trig_a_full) ; convert to integers
	;stop
	ra_trig_a_full = 0	; added 27 Sept, 2007 to reduce memory usage
	rate_name = '_RA_Trig'
ENDIF ELSE BEGIN
	full_data = FIX(sf0_a_full) ; convert to integers
	sf0_a_full = 0	; added 27 Sept, 2007 to reduce memory usage
	rate_name = '_SF0'
ENDELSE

ENDIF ELSE BEGIN ; STEREO B

; Check that there is actually data in the files.  If not, then stop.

IF TOTAL(sf0_b_full, /nan) LE 0 AND TOTAL(ra_trig_b_full, /nan) LE 0 THEN BEGIN
PRINT, 'No SF0 or RA_trig data for this time.'
STOP
ENDIF

full_data = intarr(128,32,num_records1) ; changed from float to integer to save memory 28 Sept, 2007
rate_name = ' '


; Check to see if there are RA_Trig counts.  If so, continue.  
; If not, assum SF0 is the full resolution rate.
;
; RA_Trig was set as the full resolution rate on 14 February, 2007 on A
; and on 1 March, 2007 on B.

IF TOTAL(ra_trig_b_full, /nan) GT 0 THEN BEGIN
	full_data = FIX(ra_trig_b_full) ; convert to integers
	ra_trig_b_full = 0	; added 27 Sept, 2007 to reduce memory usage
	rate_name = '_RA_Trig'
	
ENDIF ELSE BEGIN
	full_data = FIX(sf0_b_full) ; convert to integers
	sf0_b_full = 0	; added 27 Sept, 2007 to reduce memory usage
	rate_name = '_SF0'
	
ENDELSE

ENDELSE


; Get the time associated with the first file to label stack plots
; and out put files

start_time=' '
start_time=strmid(time,0,10)


; Remove the fill value of -1 from the files.
remove_fill_full_peak, -1, full_data
print, 'Removed fill values.'


; Here is the output file.			
outfile_1=output_dir+sat+rate_name+'_'+start_time+'_peaks.txt'		
											
openw, out_lun, outfile_1, /GET_LUN
line = ','
printf,out_lun, 'rec #,','year,','DOY,','hour,','min,','sec,','peak_counts,','ESA_step,','DEFL_step'

max_counts = intarr(num_records1)
max_counts(*) = -1
esa_index = intarr(num_records1)
esa_index(*) = -1
defl_index = intarr(num_records1)
defl_index(*) = -1

epoch1_copy = epoch1


FOR j = 0L, num_records1-1 DO BEGIN

	time = time_struct(epoch1(j))
	year = STRING(time.year,FORMAT='(I04)')
	doy = STRING(time.doy,FORMAT='(I03)')
	hour = STRING(time.hour,FORMAT='(I02)')
	min = STRING(time.min,FORMAT='(I02)')
	sec = STRING(time.sec,FORMAT='(I02)')
	max_counts(j) = MAX(full_data(*,*,j),address,/NAN)
	esa_index(j) = address MOD 128
	defl_index(j) = (address-esa_index(j))/128

IF year NE 1970 THEN BEGIN
printf,out_lun, j,',',year,',',doy,',',hour,',',min,',',sec,',',max_counts(j),',',esa_index(j),',',defl_index(j)
ENDIF

IF year EQ 1970 THEN BEGIN
epoch1_copy(j) = !values.d_nan
ENDIF

ENDFOR

close, out_lun
free_lun, out_lun

labels = ' '
store_data, 'count_max',data={x:epoch1_copy,y:max_counts},dlim={ylog:0,labels:labels,panel_size:2.}
store_data, 'esa_max',data={x:epoch1_copy,y:esa_index},dlim={ylog:0,labels:labels,panel_size:2.}
ylim,'esa_max',64,128,0
store_data, 'defl_max',data={x:epoch1_copy,y:defl_index},dlim={ylog:0,labels:labels,panel_size:2.}
ylim,'defl_max',0,32,0
tplot,['count_max','esa_max','defl_max']

print, 'Program complete.'

close, /all

END 
