;+
; FUNCTION: convert_plastic_units
;
; PURPOSE: to convert data units for the stereo/plastic instrument
;
; INPUT: dat:   data structure
;        units: A string telling the procedure which units to convert to, such
;		as ncounts,rate,nrate,eflux,flux
;
; KEYWORDS:
;
; CREATED BY:
;
; LAST MODIFIED:
;
; MODIFICATION HISTORY:
;   03/25/2008 LBE: Added adj_c/s
;
;-

FUNCTION convert_plastic_units, dat, units
compile_opt strictarrsubs
  
npac = dat.ntime
nene = dat.nenergy
npos = dat.nposition
ndef = dat.ndeflection

;scale_all_packets = REFORM(DBLARR(npac, ndef, npos, nene))

dt =  dat.integ_t

FOR ii = 0L,  npac - 1 DO BEGIN

    CASE STRUPCASE(units) OF

        'COUNTS'   : scale = 1.
        'C/S'      : scale = 1.
        'ADJ_C/S'  : scale = 1.
        'DIFFFLUX' : scale = 1. / ((dt * sf * eff * (gf)) * energy)
        'EFLUX'    : scale = 1. / (dt * sf * eff * rc * (gf))
        'DISTFUNC' : scale = REFORM(FLTARR(ndef, npos, nene)) + 1.
        
        ELSE: BEGIN
            err_msg, 'Undefined units: ' + units
        END

    ENDCASE


ENDFOR

scale =  1. / dt
;scale_all_packets = DOUBLE(scale)
dat.data =  dat.data * scale
dat.units_name =  units
  
RETURN, dat
  
END
