; Lorna Ellis
; 03/13/2013
; check_proton_outliers_b.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

PRO check_proton_outliers_b, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2008-01-01/00:00:00' THEN BEGIN
    IF temp_epoch LT '2007-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-03-01/00:33:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:34:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:35:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:36:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:37:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:38:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:39:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:40:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:41:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:42:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:43:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:44:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:45:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:46:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/00:47:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/06:25:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/11:25:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/11:26:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-01/12:50:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-03/12:40:42') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-05/02:02:41') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-05/09:21:41') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-06/16:21:41') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-06/16:23:41') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-07/14:57:40') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-07/15:05:40') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2007-03-07/15:26:40') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-03-14/17:15:38'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-04-03/02:15:31') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-04-03/02:17:31') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-04-09/10:29:29') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-04-23/08:13:24'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-05-07/10:57:17') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-07/10:58:17') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-07/20:41:17') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-07/20:54:17') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-23/11:15:10') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-23/11:16:10') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-05-23/11:24:10'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-06-02/15:12:05') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-06-09/10:50:02') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-06-14/07:04:59') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-06-17/23:04:57'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-07-05/22:24:09') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-11/00:53:07') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-11/01:08:07') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-11/01:11:07') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-11/01:31:07') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-13/14:01:05') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-07-20/05:06:02'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-08-06/17:03:54') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-10/16:33:52') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-18/16:55:47') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2007-08-18/16:57:47') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-18/16:58:47') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2007-08-18/17:08:47') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-18/17:10:47') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-18/17:11:47') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-19/16:46:47') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-31/06:03:40') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-08-31/23:33:39'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-09-10/07:09:34') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-09-13/17:19:32') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2007-09-14/17:32:32') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-09-26/20:53:26'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-10-09/00:55:21') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-10-17/10:36:17') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-10-25/04:44:14') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-10-26/03:43:13'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-11-09/16:21:06') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-11-09/17:12:06') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-11-09/17:13:06') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-11-15/18:01:04') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-11-15/23:29:04'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2007-12-09/23:04:57') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-12-11/08:15:57') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-12-16/13:47:55') OR $ ; KDCS 07/19/2011
                      (epoch_st EQ '2007-12-22/11:49:53'), $ ; KDCS 07/19/2011
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2009-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2008-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-01-06/05:21:49') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-06/21:55:49') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-11/07:38:47') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/10:09:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/10:10:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/11:26:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/14:06:44'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-02-09/13:35:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-09/15:20:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-09/18:09:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-27/21:35:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-27/21:36:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/06:52:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/09:26:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/09:49:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/10:35:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-29/01:09:37'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-03-07/06:09:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-03-07/06:13:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-03-28/15:13:32'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-04-01/03:03:31') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-01/03:07:31') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-02/20:54:30') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2009-04-18/17:19:43') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2008-04-23/01:47:24') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-23/01:48:24'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-05-20/00:54:17') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-20/10:42:17') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-27/18:06:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-29/08:50:15'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-06-07/19:27:11') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-07/19:33:11') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-13/18:18:09') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-13/18:20:09') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-27/00:16:03'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-07-03/15:08:00') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-11/01:48:58') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-19/14:27:55') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-21/10:20:54'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-08-16/08:39:43') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-08-16/08:50:43') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-08-16/09:26:43'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-09-01/11:47:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-09-28/23:10:26') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-09-29/02:23:26'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-10-22/19:18:16') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-25/16:45:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-25/16:46:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-25/16:49:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-28/06:15:14') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-28/06:16:14') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-29/06:59:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-29/08:02:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-30/13:45:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-30/15:39:13'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-11-22/05:58:05') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-11-22/06:11:05'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2008-12-01/03:18:04') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-02/10:29:03') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-02/10:31:03') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-09/02:57:02') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-09/02:58:02') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-17/22:05:59') OR $ ; KDCS 08/11/2011
                      (epoch_st EQ '2008-12-17/22:29:59'), $ ; KDCS 08/11/2011
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2010-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2009-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-01-01/18:31:54') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-01-14/12:56:52') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-01-14/13:33:52') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-01-27/20:01:51'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-02-03/04:25:50') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-02-11/06:47:49') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-02-12/09:44:49') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-02-18/20:28:48'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-03-03/00:33:46') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-10/07:58:46') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-10/14:46:46') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-17/19:15:46') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-17/19:16:46') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-31/07:13:45') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-03-31/08:50:45'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-04-30/12:17:42') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-04-30/12:18:42'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-05-08/15:22:40'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-06-02/00:16:00') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-06-06/04:32:00') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-06-09/00:43:59'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-07-17/19:39:48') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-17/20:19:48') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-18/23:57:48') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-31/16:38:44') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-31/16:39:44') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-31/16:40:44') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-31/16:41:44') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-07-31/16:42:44'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-08-14/04:28:39') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-08-15/10:53:39') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-08-15/10:54:39') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-08-27/12:03:34') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-08-30/16:35:33'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-09-28/14:29:23'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-10-26/23:54:13') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-10-27/01:35:13') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-10-27/12:58:12'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-11-04/06:51:10') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-11-17/16:10:06') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-11-27/12:35:03') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-11-30/15:25:02') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-11-30/18:38:02'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2009-12-22/07:17:57') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-12-30/09:36:55') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-12-31/07:19:55') OR $ ; KDCS 07/21/2011
                      (epoch_st EQ '2009-12-31/08:04:55'), $ ; KDCS 07/21/2011
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2011-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2010-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-01-06/15:31:54') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-06/15:47:54') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-07/02:17:54') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-07/03:35:54') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-14/12:12:52') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-14/12:13:52') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-14/13:18:52') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-16/04:56:52') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-25/16:27:50') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-01-28/14:09:50'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-02-12/07:58:49') OR $ ; KDCS 08/11/2011
                      (epoch_st EQ '2010-02-13/20:06:49') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-13/20:27:49') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-13/22:42:49') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-14/12:28:48') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-14/18:24:48') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-15/03:07:48') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-15/03:51:48') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-15/03:52:48') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-25/03:05:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-27/03:45:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-27/06:46:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-02-28/03:04:47'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-03-01/03:53:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:20:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:21:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:23:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:24:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:27:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:30:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:32:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:34:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:36:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:37:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-02/22:39:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-03/01:16:47') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:20:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:27:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:28:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:30:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:33:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:34:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:47:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:48:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:50:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:54:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/03:58:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/04:01:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/04:06:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/04:07:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/04:10:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/04:49:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:04:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:10:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:11:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:28:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:37:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:41:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:48:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:51:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/05:52:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/06:02:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/06:18:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/06:33:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/06:37:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/06:40:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:02:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:31:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:41:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:49:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:50:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:51:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/07:58:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/08:05:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/08:30:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-11/08:42:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-03-20/01:44:47'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-04-27/20:08:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:12:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:13:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:14:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:15:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:16:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:17:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:18:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:19:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:21:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:22:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:24:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:25:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:26:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:39:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/20:52:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:11:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:12:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:14:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:17:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:18:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:19:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-04-27/21:20:46'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-05-02/09:52:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-06/17:19:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-06/18:30:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-06/22:24:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-06/23:45:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-07/03:23:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-07/04:33:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-07/04:35:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-15/04:30:46') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-05-15/04:46:46'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-06-12/02:00:44') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-06-12/04:29:44') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-06-21/20:45:43') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-06-21/21:43:43'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-07-02/05:00:42') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-07-05/08:23:41') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-07-09/05:47:40'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-08-03/06:32:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:11:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:22:36') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-08-03/10:25:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:27:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:30:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:34:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/10:35:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/12:07:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/12:09:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/13:25:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/14:59:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/15:13:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/16:09:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/16:16:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/17:49:36') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-08-03/17:56:36') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-08-03/18:56:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-03/22:08:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/01:34:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/05:05:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/08:58:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/12:43:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/19:15:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-04/20:21:36') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-08-11/09:32:34'), $ ; KDCS 07/22/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-09-16/08:04:25') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-16/08:19:25') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-16/08:20:25') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-16/08:30:25') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-16/11:25:25') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-09-16/12:07:25') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-16/14:01:25') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-09-19/18:31:24') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-09-19/18:32:24'), $ ; KDCS 07/22/2011
                      bad_count)
        ENDIF ELSE IF temp_epoch LT '2010-11-01/00:00:00' THEN BEGIN 
            bad_i = where((epoch_st EQ '2010-10-05/06:21:19') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-05/20:31:19') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-06/08:36:19') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-06/08:40:19') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-08/01:10:18') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-14/10:21:16') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-15/03:57:16') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-17/11:58:15') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-10-24/19:34:14'), $ ; KDCS 07/22/2011
                          bad_count)
        ENDIF ELSE IF temp_epoch LT '2010-12-01/00:00:00' THEN BEGIN 
            bad_i = where((epoch_st EQ '2010-11-08/01:24:11') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:08:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:40:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:46:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:49:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:51:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:53:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:54:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:56:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/17:59:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:00:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:01:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:11:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:12:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:14:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:15:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:16:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:18:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:21:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:22:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:23:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:24:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:26:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:27:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:30:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:31:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:32:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:34:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:36:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:41:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:45:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:47:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:51:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:55:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:56:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:57:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:58:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/18:59:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:00:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:02:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:04:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:09:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:16:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:21:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:22:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-09/19:24:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-11/21:27:10') OR $ ; KDCS 07/22/2011
                          (epoch_st EQ '2010-11-14/15:40:09'), $ ; KDCS 07/22/2011
                          bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2010-12-22/02:17:01') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2010-12-27/14:52:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/00:56:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/01:08:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/05:33:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/05:39:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/05:40:00') OR $ ; KDCS 07/22/2011
                      (epoch_st EQ '2010-12-28/05:47:00'), $ ; KDCS 07/22/2011                 
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2011-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-01-02/12:37:59') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-01-12/02:16:14') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-01-12/02:36:14') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-01-24/19:38:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-01-26/11:40:12'), $ ; KDCS 08/01/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-02-02/22:16:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-09/19:33:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-18/04:09:11') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-18/06:47:11') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-22/08:46:11') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-23/15:33:10') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-23/21:00:10') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-24/03:28:10') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-26/08:52:10') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-02-28/21:08:10'), $ ; KDCS 08/01/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-03-15/22:03:11') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-23/01:11:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-23/03:05:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/08:26:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/08:28:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/08:35:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/08:44:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/16:11:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-24/16:23:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-03-28/11:35:12'), $ ; KDCS 08/01/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-04-01/02:50:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-10/20:34:12') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/19:48:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/19:49:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/20:56:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/21:25:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/22:43:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/22:49:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/23:11:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/23:50:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-18/23:59:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-19/00:41:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-19/01:01:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-19/01:14:13') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-24/10:14:14') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-04-30/09:59:15'), $ ; KDCS 08/01/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-05-01/04:52:15') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-16/22:23:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/09:25:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/14:11:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/14:12:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/21:26:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/21:28:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/21:33:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-21/21:36:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-22/03:46:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-22/09:28:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-22/15:04:16') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-23/04:51:16') OR $ ; KDCS 08/03/2011
                      (epoch_st EQ '2011-05-31/15:58:17') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-31/16:00:17') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-31/16:02:17') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-31/16:04:17') OR $ ; KDCS 08/01/2011
                      (epoch_st EQ '2011-05-31/16:05:17'), $ ; KDCS 08/01/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-06-01/07:27:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-01/07:59:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-01/08:42:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-01/08:53:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-01/08:54:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-02/11:37:17') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/07:32:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-10/15:15:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-10/15:18:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-10/15:19:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-10/15:34:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-10/15:56:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-16/23:58:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-18/01:41:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-27/01:24:18') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-27/03:12:18'), $ ; KDCS 08/12/2011                  
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-07-14/17:11:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-20/02:29:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-20/03:03:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-20/03:28:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-20/03:35:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-20/07:28:39') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-24/16:04:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-24/16:05:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-30/02:50:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-30/02:59:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-30/03:29:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-30/03:30:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/06:04:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/06:09:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/13:39:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/13:55:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/14:52:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/15:06:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/15:08:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/15:11:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/15:17:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/15:58:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/16:03:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/18:42:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/20:17:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/20:29:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/20:34:38') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-31/21:30:38'), $ ; KDCS 09/08/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-08-04/06:22:37') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-08-21/13:47:35'), $ ; KDCS 10/06/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-09-14/01:22:31') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-14/01:54:31') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-21/21:41:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/00:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/00:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/00:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/01:01:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/01:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/01:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/01:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/01:19:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/02:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/05:16:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/08:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/13:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/13:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/13:50:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/15:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/16:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/18:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-22/23:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-23/00:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-24/20:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:25:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/01:59:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:19:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/02:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:13:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:16:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:21:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:29:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:36:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:42:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:47:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:50:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/03:59:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:01:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:06:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:13:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:16:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:17:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:21:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:27:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:29:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:36:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:48:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:49:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/04:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:13:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:18:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:23:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:27:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:36:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:45:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:48:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:49:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/05:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:11:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:16:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:19:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:27:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:42:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:46:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/06:59:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:06:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:13:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:18:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:40:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:43:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:45:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:48:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:49:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/07:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/08:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/08:01:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/08:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/08:47:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/10:43:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:36:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:45:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:46:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:49:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:50:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/11:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:16:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:19:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:50:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/12:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:06:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:21:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:39:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/13:59:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:01:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:11:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:17:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:18:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:23:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:29:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:30:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:39:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:40:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:42:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:45:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:47:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:48:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:50:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/14:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:01:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:13:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:21:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:23:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:27:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:35:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:39:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:40:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:48:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:54:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/15:59:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:09:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:11:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:21:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:22:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:25:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:27:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:39:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:40:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:44:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:49:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:51:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:57:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/16:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:06:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:12:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:17:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:18:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:34:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:40:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:43:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:46:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:52:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:53:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/17:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:03:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:05:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:14:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:17:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:18:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:19:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:23:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:24:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:26:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:32:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:33:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/18:39:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:08:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:11:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:20:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:31:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:37:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:55:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/19:56:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/20:02:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/20:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/20:06:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/20:38:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/21:15:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/21:17:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/21:29:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/21:58:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/22:00:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/22:07:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/22:10:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/22:47:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/23:04:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-25/23:28:29') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/03:32:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/05:14:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/05:59:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/06:24:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/06:57:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/08:55:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/10:59:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/11:02:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/11:38:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-26/11:54:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/05:22:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/05:28:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/05:46:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/15:58:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/16:34:28') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-27/16:44:28'), $ ; KDCS 11/10/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-10-03/22:26:27') OR $ ; KDCS 12/07/2011
                      (epoch_st EQ '2011-10-21/08:12:24') OR $ ; KDCS 12/07/2011
                      (epoch_st EQ '2011-10-28/16:32:22'), $ ; KDCS 12/07/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-11-05/13:23:20') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-10/02:53:19') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-10/03:09:19') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-25/10:08:16'), $ ; KDCS 01/09/2012
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2011-12-01/11:25:15') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-01/11:32:15') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-01/12:09:14') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-01/17:49:14') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-02/16:27:14'), $ ; KDCS 02/09/2012
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2012-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-01-07/16:43:07') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-08/08:27:07') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-13/17:45:06') OR $ ; KDCS 03/07/2012
                      (epoch_st EQ '2012-01-17/07:31:05') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-20/08:26:05') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-20/14:31:05') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-20/17:01:05') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-20/19:19:05') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-21/13:54:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/13:55:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/13:56:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/15:34:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/17:17:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/17:18:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/18:17:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/18:19:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/18:20:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/18:44:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/18:56:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-21/19:30:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-22/00:24:05') OR $ ; KDCS 03/06/2012
                      (epoch_st EQ '2012-01-26/18:59:04'), $ ; KDCS 03/05/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-02-10/04:19:04') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-10/04:58:04') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-10/05:10:04') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-10/06:28:04') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-11/05:16:04'), $ ; KDCS 04/11/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-03-05/00:06:03') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-08/14:09:03') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-08/15:49:03') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-08/17:34:03') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-13/05:02:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-23/18:18:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-30/01:53:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-30/02:17:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-31/18:15:05'), $ ; KDCS 05/08/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-04-05/23:36:05') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/06:16:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/07:10:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/07:14:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/07:45:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/08:12:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-15/08:28:06') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-16/20:40:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-16/20:41:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-17/05:30:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-17/06:43:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-17/08:42:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-19/23:09:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-20/16:53:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-20/21:08:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-22/09:25:07') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-26/21:30:08'), $ ; KDCS 06/08/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-05-08/22:07:09') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-19/11:43:11') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-19/20:07:11') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-24/19:44:12') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-28/08:32:01') OR $ ; KDCS 11/20/2012
                      (epoch_st EQ '2012-05-28/08:34:01') OR $ ; KDCS 11/20/2012
                      (epoch_st EQ '2012-05-28/08:35:01') OR $ ; KDCS 11/20/2012
                      (epoch_st EQ '2012-05-28/08:36:01') OR $ ; KDCS 11/20/2012
                      (epoch_st EQ '2012-05-28/08:46:01') OR $ ; KDCS 11/20/2012
                      (epoch_st EQ '2012-05-28/08:48:01'), $ ; KDCS 11/20/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-06-15/12:43:15') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-15/14:03:15') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-15/15:46:15') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-27/13:26:17'), $ ; KDCS 08/06/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-07-16/22:41:17') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-16/22:42:17') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-18/04:56:18') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-18/04:57:18') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-18/04:58:18'), $ ; KDCS 09/21/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-08-12/22:55:19') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-16/11:04:19') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-25/08:26:19') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-25/14:06:19') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-25/14:11:19'), $ ; KDCS 10/16/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-09-02/21:42:19') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-03/17:23:19') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-03/18:02:19') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-03/19:06:19') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-24/21:38:17') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-25/22:47:17') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-29/06:08:17') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-29/06:53:17'), $ ; KDCS 11/04/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-11-01/00:00:00' THEN BEGIN 
        bad_i = where(((epoch_st GE '2012-10-09/09:47:16') AND $ ; KDCS 12/12/2012
                       (epoch_st LE '2012-10-09/14:10:16')) OR $ ; KDCS 12/12/2012
                      (epoch_st EQ '2012-10-09/15:29:16') OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-10-09/17:55:16') OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-10-09/17:58:16') OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-10-09/18:31:16') OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-10-22/17:22:13') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-25/05:53:13') OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-10-25/23:48:13') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-26/00:40:13') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-26/00:43:13') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-26/00:44:13') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-26/00:50:13'), $ ; KDCS 12/10/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-11-04/03:30:36') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-05/03:23:36') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-09/16:49:36') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-09/16:55:36') OR $ ; KDCS 01/16/2013
                      (epoch_st EQ '2012-11-09/18:57:36') OR $ ; KDCS 01/16/2013
                      (epoch_st EQ '2012-11-12/18:24:36') OR $ ; KDCS 01/16/2013
                      (epoch_st EQ '2012-11-21/00:00:35'), $ ; KDCS 01/15/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2012-12-03/18:56:33') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-07/03:49:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-07/13:13:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-14/03:21:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/16:17:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/16:18:32') OR $ ; KDCS 02/18/2013
                      (epoch_st EQ '2012-12-25/16:19:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/16:28:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/17:07:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/17:40:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/17:42:32') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-28/13:59:31'), $ ; KDCS 02/12/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2013-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-01-01/02:54:31') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-01/03:20:31') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-11/07:22:30') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-12/03:41:30') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-24/08:36:29') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-24/08:37:29') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-24/08:56:29') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-27/00:22:29'), $ ; KDCS 03/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-02-11/02:03:30') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-18/14:00:30') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-18/14:13:30') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-18/14:45:30') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-24/04:37:30') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2013-02-28/11:51:30') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-28/12:05:30'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-03-07/17:14:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-07/20:57:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-08/23:32:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-09/01:57:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/08:56:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/08:57:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/12:31:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/13:01:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/14:06:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/17:26:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/20:36:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-09/20:44:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-10/11:14:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-10/11:18:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-10/11:20:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-10/15:20:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-10/15:21:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-14/09:24:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/06:19:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/06:23:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/08:00:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/08:31:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/08:32:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/09:02:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/10:14:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/10:47:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/11:13:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/11:16:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:28:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:31:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:34:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:36:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/11:38:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:40:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/11:51:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/11:55:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/12:17:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/13:14:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/13:23:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/18:42:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/19:04:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-18/19:44:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/22:46:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-18/22:50:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/00:14:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/06:36:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-19/06:55:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-19/06:58:31') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2013-03-19/07:00:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/07:02:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/07:06:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/15:53:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/16:34:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/16:36:31') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-28/22:47:33') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-29/00:40:33') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-31/14:32:34') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-31/15:19:34') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-31/15:28:34'), $ ; KDCS 05/14/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-04-03/19:30:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-10/06:43:35') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-13/17:21:36') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-13/18:39:36') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-19/16:41:37') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-23/22:22:37'), $ ; KDCS 06/12/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-05-01/01:28:39') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-08/19:20:42') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-12/11:54:42') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-13/02:53:43') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-14/08:36:43') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-14/09:59:43') OR $ ; KDCS 09/03/2013
                      (epoch_st EQ '2013-05-18/01:47:44') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-18/06:01:44') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-19/23:51:44') OR $ ; KDCS 09/03/2013
                      (epoch_st EQ '2013-05-23/06:27:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/06:29:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/07:00:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/07:01:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/07:58:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/08:15:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/08:16:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/10:51:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/12:29:45') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-23/17:40:45'), $ ; KDCS 08/29/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-06-08/08:27:50') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-10/13:31:51') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-18/01:48:53') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-18/03:11:53') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-20/09:58:54'), $ ; KDCS 08/29/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-07-02/07:32:57') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-02/07:34:57') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-08/18:38:59') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-08/18:42:59') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-09/12:24:59') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-11/07:33:00') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-11/07:47:00') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-11/09:33:00') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-11/09:36:00') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-16/19:32:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-16/19:37:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-16/19:45:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-16/21:16:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-16/21:28:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-17/00:49:02') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-20/16:13:03') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-20/16:14:03') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-20/16:51:03') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/06:39:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/06:47:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/06:49:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/06:50:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:03:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:15:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:21:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:41:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:42:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:47:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/07:48:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/08:02:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/08:03:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/08:04:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/08:16:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/08:45:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/09:47:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/09:53:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/09:54:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:05:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:08:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:20:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:22:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:29:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:31:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/10:54:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/11:11:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-26/11:36:04') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-29/16:21:05'), $ ; KDCS 10/24/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-08-07/09:47:06') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/00:12:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/01:43:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/01:49:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/01:50:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/01:56:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/02:16:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/02:48:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/02:54:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:00:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:08:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:12:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:21:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:26:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:28:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:30:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:31:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/03:49:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/05:35:07') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-11/14:20:08') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-16/09:48:09') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-16/19:32:09') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/01:57:09') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/07:37:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/08:23:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/08:40:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/09:07:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/09:19:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/16:46:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-21/17:35:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-22/02:18:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-22/03:29:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-23/07:26:10') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-23/07:31:10'), $ ; KDCS 10/24/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-09-01/22:11:11') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-03/21:40:11') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-03/21:43:11') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-09/22:24:12') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-09/22:44:12') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-21/06:41:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-21/08:38:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-21/09:35:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-23/19:27:14'), $ ; KDCS 12/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-10-01/23:56:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-10-02/01:19:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-10-06/20:50:14') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-10-14/09:44:15') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-10-22/04:12:15'), $ ; KDCS 12/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-11-06/02:42:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/04:55:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/06:04:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/06:05:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:44:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:45:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:48:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:49:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:50:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/16:52:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:05:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/17:06:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:07:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:08:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:11:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:13:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/17:14:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/17:16:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:17:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:18:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:19:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:21:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:22:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:23:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:29:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:30:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:31:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:40:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:43:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:44:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:48:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:52:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:56:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/17:57:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:01:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:02:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:07:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:10:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:11:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:16:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:17:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:18:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:19:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:23:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:29:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/18:33:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:37:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:39:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:40:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:42:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/18:44:15') OR $ ; KDCS 01/16/2014
                      ((epoch_st GE '2013-11-07/18:45:00') AND (epoch_st LT '2013-11-07/21:11:00')) OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/21:11:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/21:17:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/21:18:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/21:21:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-07/21:26:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:36:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/00:38:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/00:39:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/00:41:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:44:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:45:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:46:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:47:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:48:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:49:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:50:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:52:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/00:55:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/01:16:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/01:58:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/02:09:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/02:10:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/03:11:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/03:23:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/03:33:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/03:59:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/04:00:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/04:05:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/04:10:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/04:11:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/04:15:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/04:20:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/04:21:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/04:33:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/04:36:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/05:27:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/05:56:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/05:57:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:11:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:12:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:16:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:29:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:41:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/06:42:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:10:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:12:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:19:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:21:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:22:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:30:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:34:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:37:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:38:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:39:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:41:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:42:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:46:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:49:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/07:57:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/07:59:15') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-08/14:06:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/14:18:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/14:38:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/14:40:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/14:46:15') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-08/14:50:15') OR $ ; KDCS 01/14/2014
                      ((epoch_st GE '2013-11-08/15:00:00') AND (epoch_st LE '2013-11-09/09:00:00')) OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-13/14:47:14') OR $ ; KDCS 01/16/2014
                      (epoch_st EQ '2013-11-20/20:53:14') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-25/15:14:14'), $ ; KDCS 01/14/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-01-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-12-08/19:09:13') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-08/21:54:13') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-09/00:29:13') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/10:08:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/11:25:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/11:32:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/11:38:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/11:43:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/12:05:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/12:11:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/12:53:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/13:34:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/13:36:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/13:55:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/14:10:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/14:22:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-21/14:33:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-28/21:46:12') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-30/12:29:12'), $ ; KDCS 02/19/2014
                      bad_count)
    ENDIF 
ENDIF ELSE BEGIN                ; 2014
    IF temp_epoch LT '2014-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-01-13/10:56:10') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-18/17:53:09') OR $ ; KDCS 03/24/2014
                      (epoch_st EQ '2014-01-24/23:22:08') OR $ ; KDCS 03/24/2014
                      (epoch_st EQ '2014-01-25/01:12:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/01:28:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/02:11:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/02:31:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/02:32:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/07:15:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/11:13:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-25/11:21:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-26/09:18:08') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-26/09:22:08'), $ ; KDCS 03/17/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-02-01/11:34:07') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-01/11:36:07') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-01/11:38:07') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-05/12:33:06') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-05/12:36:06') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-05/19:04:06') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-07/01:41:06') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-13/01:06:05') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-13/01:23:05') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-13/13:38:05') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/03:24:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/08:08:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/09:23:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/10:25:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/10:30:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/10:49:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/10:59:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/13:12:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-21/22:11:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-22/10:00:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-22/10:03:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-22/10:04:04') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-23/02:39:03') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-23/02:43:03') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-23/19:39:03') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-23/19:44:03') OR $ KCDS 04/08/2014
                      (epoch_st EQ '2014-02-23/19:55:03'), $ KCDS 04/08/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-03-02/23:40:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-03/22:27:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-03/22:56:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/00:26:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/00:28:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/00:29:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/03:02:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/03:46:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/03:55:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/04:26:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/06:48:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-05/13:05:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-08/09:28:58') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/21:56:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/22:31:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/22:32:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/22:45:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/22:46:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-12/00:15:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-12/04:36:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-12/05:41:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-13/21:03:57') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-21/23:34:56'), $ ; KDCS 06/02/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-04-03/04:10:56') OR $ ; KDCS 06/03/2014
                      (epoch_st EQ '2014-04-19/06:00:57') OR $ ; KDCS 06/03/2014
                      (epoch_st EQ '2014-04-25/17:23:58'), $ ; KDCS 06/03/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-05-15/08:40:01') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-17/07:09:01') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-19/14:53:01') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-20/12:15:01') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-22/10:26:02') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-26/16:20:02') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/14:00:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/14:01:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/15:36:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/15:42:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/19:54:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/21:32:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/23:26:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-31/02:20:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-31/18:12:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-31/19:51:03') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-31/20:59:03'), $ ; KDCS 07/09/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-06-01/02:14:03') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-06/10:28:04') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-06/17:01:04') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-06/21:23:04') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-07/02:07:04') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-13/04:19:06') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-16/21:19:07') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-16/21:22:07') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-16/21:31:07') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-16/21:36:07') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-16/21:50:07') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-19/05:46:07') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/04:53:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/04:54:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/05:22:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/06:26:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-25/06:28:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/07:06:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/07:11:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/09:32:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-25/09:55:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/10:28:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/11:55:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/13:51:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-25/16:27:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/16:33:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/16:43:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/17:15:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-25/18:02:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/18:05:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/18:13:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-25/21:50:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-26/02:11:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-26/03:42:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-26/04:00:08') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-27/11:40:08') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-27/21:06:09'), $ ; KDCS 11/02/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-07-01/20:29:09') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-03/03:24:10') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-09/03:35:12') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-22/09:42:14') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-22/10:37:14') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-22/10:50:14') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-22/16:52:14') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-23/18:41:15') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-23/20:18:15') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-26/03:54:15') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/08:03:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/10:45:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/11:04:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/12:22:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/12:36:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/13:07:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/13:14:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/13:45:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-27/13:50:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-30/22:51:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-30/23:37:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-31/00:19:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-31/00:21:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-31/00:42:16') OR $ ; KDCS 10/21/2014
                      (epoch_st EQ '2014-07-31/00:49:16'), $ ; KDCS 10/21/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-08-06/22:28:18') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-16/05:14:20') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-16/20:55:20') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-17/03:11:20') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-18/01:37:20') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-18/09:51:20') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-18/13:42:20') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-22/00:26:20') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-23/08:29:21') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-24/19:03:21') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-25/22:51:21') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-26/10:25:21') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-27/11:31:22') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-30/04:24:22') OR $ ; KDCS 10/16/2014
                      (epoch_st EQ '2014-08-31/21:55:22'), $ ; KDCS 10/16/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-09-01/14:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:42:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:51:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:57:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/14:59:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:12:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:50:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:51:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/15:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:09:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:16:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:25:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:35:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:44:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:51:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/16:57:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:03:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:10:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/17:57:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:09:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:14:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:22:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:30:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:38:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:39:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:53:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/18:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/19:01:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/19:20:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/19:44:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:13:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:40:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:58:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/20:59:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/21:01:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/21:06:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/21:07:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-01/21:15:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/00:02:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/00:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:03:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:04:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:07:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:13:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:16:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:39:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/01:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/02:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/02:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:01:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:03:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:13:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:22:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:38:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:41:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/03:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:01:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:25:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:26:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:34:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:42:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:44:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:48:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/04:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:09:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:19:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:20:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:28:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:38:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:41:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:48:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:51:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/05:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:06:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:07:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:12:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:20:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:28:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:30:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:38:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:53:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/06:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:02:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:06:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:09:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:20:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:25:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:27:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:32:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:53:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/07:59:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/08:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/08:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/08:27:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/08:52:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:03:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:10:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:40:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/09:58:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/10:16:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/10:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/10:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:13:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:15:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:23:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:27:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:32:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/11:44:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:04:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:10:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:20:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:43:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/12:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/13:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/13:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/16:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-02/18:19:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/07:50:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/08:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:05:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:22:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:30:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:33:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:45:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/09:49:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:16:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:32:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:41:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/10:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:04:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:10:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:11:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:15:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:36:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:48:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:52:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:53:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:55:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:58:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/11:59:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:09:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:31:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:40:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:46:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/12:57:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:34:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:42:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:52:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/13:58:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:14:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:18:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:29:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:30:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:36:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:39:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:47:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:54:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/14:56:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/15:05:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/15:08:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/15:14:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/15:43:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:01:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:05:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:24:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:36:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:43:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:44:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:48:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/16:58:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:00:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:07:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:21:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:32:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:34:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/17:59:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/18:10:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/18:37:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-03/18:42:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-07/07:07:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-08/05:04:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-08/07:17:23') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-11/17:50:24') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-12/22:36:24') OR $ ; KDCS 12/15/2014
                      (epoch_st EQ '2014-09-15/12:14:24') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-16/03:23:24') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-25/20:35:25'), $ ; KDCS 12/08/2014
                      bad_count)
    ENDIF 
ENDELSE 

END 
