; Lorna Ellis
; 03/13/2013
; check_proton_outliers_a.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

PRO check_proton_outliers_a, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2008-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2007-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-02-14/16:10:37') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-21/16:51:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/05:22:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/06:32:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/07:19:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/09:20:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/09:31:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/09:44:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/10:21:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/10:39:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/10:48:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/11:30:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/18:59:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-26/19:02:35') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-02-27/20:05:35'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-03-11/16:34:33') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-03-11/21:59:33') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-03-13/20:55:32') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-03-19/22:20:31') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-03-19/22:21:31') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-03-19/22:22:31'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-04-02/09:09:28') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-13/07:15:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-13/07:16:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-13/07:40:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-17/09:21:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-23/03:47:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-29/11:03:25') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-04-29/11:13:25'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-05-07/18:36:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/18:57:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/19:12:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/19:19:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/19:23:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/19:28:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-07/19:43:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-16/01:58:22') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-17/12:15:22') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2007-05-19/00:28:21') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-22/05:26:21') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-05-22/05:59:21'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-06-02/13:37:20') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2007-06-03/11:44:20') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-03/11:54:20') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-03/11:55:20') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-08/12:29:20') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-08/21:34:20') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-14/03:57:18') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-14/04:07:18') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-19/10:40:18') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-22/18:48:17') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/10:47:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/15:16:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/15:45:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/15:49:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/16:07:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/16:09:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-06-30/17:18:55'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-07-11/13:35:54') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-07-11/13:47:54') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-07-11/14:35:54') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-07-11/14:36:54') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-07-11/16:04:54'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-08-07/07:16:50') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-08-21/03:49:49') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-08-21/03:51:49') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-08-21/03:52:49') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-08-21/04:08:49'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-09-15/06:46:45') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-09-15/14:53:45') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2007-09-26/02:21:43') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-09-26/02:22:43'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-10-19/01:11:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-10-19/09:29:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-10-20/07:10:40'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-11-02/19:00:37') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-11-14/11:02:36') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-11-21/06:54:36'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2007-12-12/18:51:31') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-12/18:52:31') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-18/23:52:30') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-18/23:55:30') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-19/00:21:30') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-19/00:22:30') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2007-12-29/14:35:29'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2009-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2008-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-01-06/05:21:49') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-06/21:55:49') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-06/23:12:28') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-06/23:13:28') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-07/06:28:28') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-09/02:31:27') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-09/15:03:27') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-11/07:38:47') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-16/20:11:26') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-30/00:15:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-01-30/10:09:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/10:10:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/11:26:44') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-01-30/14:06:44'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-02-06/10:53:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-02-06/12:18:23') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-02-09/13:35:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-09/15:20:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-09/18:09:42') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-27/21:35:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-27/21:36:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/06:52:38') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/09:26:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/09:49:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-28/10:35:37') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-02-29/01:09:37'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-03-01/05:24:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-01/07:27:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/15:39:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/15:49:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/16:09:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:23:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:24:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:36:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:39:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:40:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/17:41:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/18:52:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/21:00:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-02/21:01:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-03/00:33:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-03/07:32:19') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-07/06:09:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-03-07/06:13:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-03-09/16:22:17') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-03-28/15:13:32'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-04-01/03:03:31') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-01/03:07:31') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-02/20:54:30') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-07/06:05:15') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-04-10/08:27:14') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-04-23/01:47:24') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-23/01:48:24') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-04-24/18:55:11') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-04-24/19:30:11') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-04-24/21:33:11'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-05-07/19:49:09') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-05-07/19:50:09') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-05-09/00:03:09') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2008-05-16/23:17:09') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-05-20/00:54:17') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-20/10:42:17') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-21/19:17:08') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-05-21/20:19:08') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-05-27/18:06:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-05-29/08:50:15'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-06-06/01:17:05') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-06-06/01:18:05') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-06-07/19:27:11') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-07/19:33:11') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-13/02:59:04') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-06-13/18:18:09') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-13/18:20:09') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-06-17/10:30:03') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-06-27/00:16:03'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-07-02/19:15:02') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-07-02/19:32:02') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-07-02/19:34:02') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-07-03/15:08:00') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-03/22:49:02') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-07-04/02:10:02') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-07-11/01:48:58') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-19/14:27:55') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-07-21/10:20:54'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-08-04/02:18:57') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-04/02:22:57') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-14/14:30:56') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-15/19:52:56') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-16/08:39:43') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-08-16/08:50:43') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-08-16/09:26:43') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-08-21/08:45:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-21/09:09:55') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-08-21/09:11:55'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-09-01/11:47:35') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-09-05/00:49:52') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-06/20:38:52') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-08/15:25:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-09/09:00:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-13/20:45:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-17/01:49:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-20/06:35:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-20/06:57:51') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-09-28/23:10:26') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-09-29/02:23:26'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-10-12/14:32:47') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-12/14:36:47') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-12/14:41:47') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-13/06:44:47') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-13/08:39:47') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-19/04:32:46') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-22/19:18:16') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-23/13:21:45') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-10-25/16:45:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-25/16:46:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-25/16:49:15') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-28/06:15:14') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-28/06:16:14') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-29/06:59:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-29/08:02:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-30/13:45:13') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-10-30/15:39:13'), $ ; KDCS 07/20/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-11-02/01:05:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-02/01:13:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-02/07:11:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-09/14:05:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-09/14:07:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-09/14:19:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-09/14:30:44') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-22/05:58:05') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-11-22/06:11:05') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-11-29/02:55:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-29/04:59:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-29/11:35:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-29/11:36:40') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-11-29/11:37:40'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2008-12-01/03:18:04') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-02/10:29:03') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-02/10:31:03') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-04/16:47:39') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-12-09/02:57:02') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-09/02:58:02') OR $ ; KDCS 07/20/2011
                      (epoch_st EQ '2008-12-12/16:12:38') OR $ ; KDCS 07/09/2010
                      (epoch_st EQ '2008-12-27/04:26:37'), $ ; KDCS 07/09/2010
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2010-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2009-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-01-02/20:07:35') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-06/19:51:34') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-12/17:32:33') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-12/17:33:33') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-18/15:19:31') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-18/16:21:31') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-18/16:23:31') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-18/18:49:31') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-01-18/19:01:31'), $ ; KDCS 08/04/2010		
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-02-03/17:17:30') OR $ ; KDCS 08/04/2010		
                      (epoch_st EQ '2009-02-05/11:35:30') OR $ ; KDCS 08/04/2010	
                      (epoch_st EQ '2009-02-05/17:55:30') OR $ ; KDCS 08/04/2010	
                      (epoch_st EQ '2009-02-05/17:56:30') OR $ ; KDCS 08/04/2010	
                      (epoch_st EQ '2009-02-17/19:11:28') OR $ ; KDCS 08/04/2010	
                      (epoch_st EQ '2009-02-17/19:12:28') OR $ ; KDCS 08/04/2010	
                      (epoch_st EQ '2009-02-18/00:55:28') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-23/04:37:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-23/09:06:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:06:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:07:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:08:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:09:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:17:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:22:27') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-02-24/09:23:27'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-03-10/13:03:24') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-10/13:04:24') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-16/02:24:24') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/10:09:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/10:12:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/10:13:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/10:14:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/13:34:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-19/13:40:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-03-24/12:37:23'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-04-01/04:10:23') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-05/19:36:22') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-06/00:45:22') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-06/00:46:22') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-20/00:47:20') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-21/01:26:19') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-22/20:35:19') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-22/20:38:19') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-04-28/18:42:18'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-05-09/11:10:17') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-05-10/20:06:17') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-05-31/16:52:15') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-05-31/16:54:15'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-06-01/09:19:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-06-05/04:44:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-06-05/06:24:14'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-07-05/04:35:10') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-07-31/07:05:06'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-08-07/20:09:29') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-08-07/20:57:29') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-08-12/02:15:28') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-08-23/13:24:27'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-09-05/10:41:26') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-09-09/01:41:25') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2009-09-10/18:47:25') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-09-26/16:12:22') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-09-26/22:07:22') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-09-26/22:08:22'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-10-06/20:01:21') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2009-10-15/23:22:20') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-10-16/07:01:20') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-10-16/07:38:20') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-10-16/07:40:20') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-10-16/07:43:20'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-11-01/17:22:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:23:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:30:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:32:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:37:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:38:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/17:39:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/19:06:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-01/19:27:18') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/01:45:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/01:49:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/01:52:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/02:11:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/02:26:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/02:30:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/03:30:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-11-26/03:36:14'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2009-12-03/15:21:14') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-12-11/14:01:13') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-12-20/22:04:12') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-12-20/22:11:12') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-12-25/07:54:11') OR $ ; KDCS 08/04/2010
                      (epoch_st EQ '2009-12-25/08:02:11'), $ ; KDCS 08/04/2010
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2011-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2010-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-01-04/08:48:09') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-04/08:53:09') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-06/06:14:09') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-16/13:52:08') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-17/01:49:08') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-25/01:22:07') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-25/01:23:07') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-01-29/02:51:07'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-02-12/20:08:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-12/20:09:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-12/21:26:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-12/21:27:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-12/21:28:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-12/21:29:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-13/16:27:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/03:51:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/06:07:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/10:37:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/10:41:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/11:25:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/11:52:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/13:49:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/13:55:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-14/14:36:04') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-22/00:44:03') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-22/05:25:03') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-22/05:28:03') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-22/05:37:03') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-02-25/15:05:02'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-03-12/01:01:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/01:02:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/02:59:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/04:29:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/04:38:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/05:14:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/05:43:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/05:50:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/07:24:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/07:25:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/07:39:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-12/07:59:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-17/04:41:01') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-22/22:27:00') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-23/06:27:00') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-23/06:44:00') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/17:28:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/20:51:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/21:47:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/22:38:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/23:31:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-30/23:55:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-03-31/02:31:59'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-04-01/02:48:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-01/15:43:59') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-04/10:17:58') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-04/10:20:58') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-05/12:50:58') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-05/12:51:58') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-09/22:51:57') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-04-19/07:35:56'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-05-02/11:41:56') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-02/11:42:56') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-04/20:53:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-08/06:20:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-08/06:21:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-08/06:22:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-08/06:23:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-08/06:24:55') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-12/12:51:54') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-19/16:20:53') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-05-19/17:59:53') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2010-05-19/18:00:53'), $ ; KDCS 09/10/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-06-04/02:48:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/02:49:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/02:50:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/15:49:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/15:50:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/15:52:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/15:55:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/15:58:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:01:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:02:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:12:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:13:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:20:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:21:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:23:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:24:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:34:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:39:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:40:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:51:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:53:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:54:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/16:55:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/17:03:51') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2010-06-04/17:13:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/18:33:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/19:53:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/20:28:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-04/20:35:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/05:42:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/05:44:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/05:51:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/05:53:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:05:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:26:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:30:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:40:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:48:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/06:50:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-05/07:21:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/03:21:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/03:25:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/03:33:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/04:23:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/06:12:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/06:13:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/06:14:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/09:15:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/09:16:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/11:24:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-15/23:30:51') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-06-21/05:58:50'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-07-01/11:15:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-01/11:27:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-01/11:28:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-01/11:55:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-01/12:42:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-05/12:01:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-06/00:09:48') OR $ ; KDCS 08/20/2010
                      (epoch_st EQ '2010-07-07/02:52:48'), $ ; KDCS 08/20/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-08-11/21:33:44') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2010-08-20/18:01:42') OR $ ; KDCS 09/10/2010
                      (epoch_st EQ '2010-08-20/18:16:42'), $ ; KDCS 09/10/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-09-11/07:48:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/07:51:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/07:52:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/08:05:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/08:21:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/10:20:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:08:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:09:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:10:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:11:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:13:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/18:14:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:40:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:41:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:42:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:43:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:44:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:45:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/19:46:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/20:15:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/20:16:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-11/20:17:41') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-15/22:21:40') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-18/11:04:40') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-18/17:39:40') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/11:56:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/12:22:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/12:48:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/13:17:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/13:49:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/13:50:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/14:03:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/14:18:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/14:42:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/15:34:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/16:23:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/16:28:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/16:29:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/16:38:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/16:48:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/17:03:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/17:08:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/17:39:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/17:49:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/18:35:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/18:54:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/19:09:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/19:14:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/19:21:39') OR $ ; KDCS 11/12/2010
                      (epoch_st EQ '2010-09-25/19:35:39'), $ ; KDCS 11/12/2010
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-10-29/23:20:36') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-29/23:21:36') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-29/23:36:36') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-29/23:38:36') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-31/03:17:35') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-31/04:10:35') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-31/04:52:35') OR $ ; KDCS 01/03/2011
                      (epoch_st EQ '2010-10-31/06:46:35'), $ ; KDCS 01/03/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-11-07/17:03:34') OR $ ; KDCS 01/14/2011
                      (epoch_st EQ '2010-11-14/17:06:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-14/17:22:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-16/02:14:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-16/07:25:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-16/10:48:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-16/19:24:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-19/05:28:33') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/15:14:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/16:42:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/16:59:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/17:06:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/17:07:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/17:11:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/18:54:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/19:03:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/19:53:32') OR $ ; KDCS 01/14/2011
                      (epoch_st EQ '2010-11-21/19:59:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/20:00:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/20:01:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/20:05:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-21/21:33:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-22/02:26:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-22/02:28:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-22/02:35:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-22/03:14:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-22/03:15:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-26/15:48:32') OR $ ; KDCS 01/06/2011
                      (epoch_st EQ '2010-11-26/16:58:32'), $ ; KDCS 01/06/2011       
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2010-12-15/16:05:31') OR $ ; KDCS 02/17/2011
                      (epoch_st EQ '2010-12-23/00:15:30'), $ ; KDCS 02/17/2011
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2011-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-01-05/02:30:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/22:29:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/22:31:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/22:46:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/22:56:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/23:06:28') OR $ ; KDCS 03/14/2011
                      (epoch_st EQ '2011-01-12/23:09:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/23:10:28') OR $ ; KDCS 03/14/2011
                      (epoch_st EQ '2011-01-12/23:13:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/23:21:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/23:24:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-12/23:35:28') OR $ ; KDCS 03/14/2011
                      (epoch_st EQ '2011-01-12/23:37:28') OR $ ; KDCS 03/14/2011
                      (epoch_st EQ '2011-01-13/00:04:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-13/00:05:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-13/14:08:28') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-17/10:23:27') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-17/10:44:27') OR $ ; KDCS 03/09/2011
                      (epoch_st EQ '2011-01-17/13:12:27'), $ ; KDCS 03/09/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-02-02/01:39:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/01:44:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/01:48:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/01:52:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/01:55:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/01:57:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/02:20:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-02/02:28:27') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-09/02:50:26') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-09/04:29:26') OR $ ; KDCS 04/11/2011
                      (epoch_st EQ '2011-02-26/10:34:24'), $ ; KDCS 04/11/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-03-04/05:14:24') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-04/14:05:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-08/04:02:24') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-03-08/04:03:24') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-03-09/08:08:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-10/00:19:23') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-03-10/00:20:23') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-03-14/20:25:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-14/23:25:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-14/23:34:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-14/23:38:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/02:21:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/02:31:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/02:47:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/04:15:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/04:17:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/04:28:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-15/09:08:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-20/12:53:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-22/20:37:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-22/21:54:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-22/23:19:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-22/23:23:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-22/23:25:23') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/15:30:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/15:31:22') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-03-30/15:51:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/18:09:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/21:11:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/22:04:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-30/22:59:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-31/00:44:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-31/00:52:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-31/01:07:22') OR $ ; KDCS 05/06/2011
                      (epoch_st EQ '2011-03-31/07:01:22'), $ ; KDCS 05/06/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-04-06/00:42:21') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-06/16:26:21') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-06/16:27:21') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-11/19:36:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/03:18:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/03:20:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/03:55:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/03:59:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/04:15:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/04:16:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/06:24:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/06:27:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/07:26:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-12/11:31:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-26/05:40:20') OR $ ; KDCS 06/08/2011
                      (epoch_st EQ '2011-04-26/20:33:20'), $ ; KDCS 06/08/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-05-01/05:08:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-01/05:19:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-01/05:43:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-01/05:45:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-01/05:51:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-01/06:19:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-07/07:10:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-07/07:19:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-07/07:28:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-07/07:29:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-07/07:49:19') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-13/14:12:18') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-23/00:55:17') OR $ ; KDCS 10/06/2011
                      (epoch_st EQ '2011-05-23/01:05:17'), $ ; KDCS 10/06/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-06-01/14:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-01/14:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-04/09:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-04/14:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-04/17:57:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-04/18:04:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-04/18:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/13:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:49:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/14:57:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:22:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/15:54:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:04:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:13:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:22:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/16:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/19:04:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/19:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/21:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/22:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-05/23:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/00:07:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/01:40:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/01:52:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:30:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:40:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:43:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:48:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/02:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/03:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/03:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/03:25:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/03:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/05:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/06:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/08:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/08:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/08:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/08:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:04:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:12:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:20:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:22:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:28:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:33:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:39:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/09:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/10:00:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:16:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:52:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/11:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:12:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:28:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:30:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:33:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:39:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/12:58:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:07:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:23:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:25:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:28:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:33:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/13:59:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:00:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:04:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:07:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:12:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:28:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:40:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:43:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/14:52:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:15:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:28:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/15:59:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:01:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:16:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:20:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:33:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:39:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:40:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:43:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:49:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/16:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:01:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:07:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:13:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:15:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:16:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:20:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:39:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:48:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:49:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:54:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/17:58:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:16:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:19:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:22:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:24:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:25:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:31:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:54:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/18:59:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:13:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:16:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:17:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:20:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:23:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:36:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:39:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:40:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:43:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:52:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:54:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:55:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/19:58:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:10:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:15:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:25:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:29:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:30:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:33:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:43:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:47:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/20:56:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:02:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:09:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:11:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:13:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:14:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:15:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:20:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:21:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:22:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:34:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:44:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/21:50:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:01:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:13:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:18:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:25:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:27:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:30:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:32:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:38:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:41:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:46:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:48:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/22:57:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:01:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:03:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:05:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:06:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:07:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:08:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:26:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:30:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:35:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:37:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:42:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:45:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:51:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:52:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:53:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-06/23:57:16') OR $ ; KDCS 08/12/2011
                      (epoch_st EQ '2011-06-07/00:01:16'), $ ; KDCS 08/12/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-07-09/13:17:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/13:18:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/13:50:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/14:26:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/14:31:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/14:50:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/15:01:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/15:09:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/15:13:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/15:19:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/16:56:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/18:10:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/18:26:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/18:30:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:02:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:10:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:22:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:24:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:27:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:30:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:31:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:43:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:45:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:46:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:49:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/19:56:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:15:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:30:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:39:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:54:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:57:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/20:58:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/21:01:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/21:06:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/21:15:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/21:52:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/22:12:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-09/22:41:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-10/05:53:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-16/10:48:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-16/14:19:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-16/15:40:15') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/16:41:14') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/16:49:14') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/16:52:14') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/16:55:14') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/17:10:14') OR $ ; KDCS 09/08/2011
                      (epoch_st EQ '2011-07-26/17:18:14'), $ ; KDCS 09/08/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-08-03/07:16:13'), $ ; KDCS 10/06/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-09-08/17:13:10') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-08/17:26:10') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-10/17:38:10') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-14/15:48:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:22:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:27:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:34:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:35:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:42:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:43:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:44:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/19:57:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:01:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:09:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:14:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:15:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:23:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:31:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:34:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:38:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:52:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/20:54:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/21:00:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-17/21:22:09') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-20/22:29:17') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-24/09:47:16') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-28/04:06:16') OR $ ; KDCS 11/10/2011
                      (epoch_st EQ '2011-09-28/22:37:16'), $ ; KDCS 11/10/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-10-19/14:00:15') OR $ ; KDCS 12/07/2011
                      (epoch_st EQ '2011-10-30/10:44:13'), $ ; KDCS 12/07/2011
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-11-06/07:16:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-06/07:17:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-06/07:18:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-06/07:23:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-06/07:58:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-06/08:57:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-20/11:18:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-20/12:44:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-20/16:26:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-20/18:16:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-22/00:31:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-22/05:17:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-23/06:03:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-23/06:17:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-23/06:48:12') OR $ ; KDCS 01/09/2012
                      (epoch_st EQ '2011-11-23/06:49:12'), $ ; KDCS 01/09/2012
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2011-12-01/14:05:11') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-15/03:40:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-20/04:03:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/10:56:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/10:59:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/11:12:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/11:23:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/11:37:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/12:00:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/12:04:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/12:41:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/13:09:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/13:25:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/13:31:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/13:43:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:04:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:12:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:32:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:44:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:45:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:47:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:50:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/14:53:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/15:12:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/15:45:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/16:54:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/17:26:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/17:53:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/18:01:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/18:14:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/18:35:09') OR $ ; KDCS 02/09/2012
                      (epoch_st EQ '2011-12-28/19:00:09'), $ ; KDCS 02/09/2012
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2012-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-01-05/04:44:08') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-05/05:02:08') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-08/14:12:08') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-23/10:07:06') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-29/19:15:06') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-29/21:49:06') OR $ ; KDCS 03/05/2012
                      (epoch_st EQ '2012-01-29/21:55:06'), $ ; KDCS 03/05/2012                 
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-02-20/05:59:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/07:00:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/07:41:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/08:07:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/08:11:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/08:53:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-20/09:23:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/09:25:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:10:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:17:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:30:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:38:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:41:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/13:45:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/14:29:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/14:34:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/14:36:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/14:56:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/14:59:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:03:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:04:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:06:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:12:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:22:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/15:23:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/17:00:05') OR $ ; KDCS 04/11/2012
                      (epoch_st EQ '2012-02-21/17:30:05'), $ ; KDCS 04/11/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-03-10/05:04:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-16/08:07:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-19/02:40:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-20/02:01:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-20/02:02:04') OR $ ; KDCS 05/08/2012
                      (epoch_st EQ '2012-03-20/02:03:04'), $ ; KDCS 05/08/2012 
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-04-10/17:23:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-17/16:54:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/05:10:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/05:26:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/05:27:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/05:48:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/05:49:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/08:22:02') OR $ ; KDCS 06/08/2012
                      (epoch_st EQ '2012-04-30/09:30:02'), $ ; KDCS 06/08/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-05-11/18:29:01') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-14/16:22:01') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-16/08:01:01') OR $ ; KDCS 07/13/2012
                      (epoch_st EQ '2012-05-28/08:34:01') OR $ ; KDCS 02/14/2013
                      (epoch_st EQ '2012-05-28/08:36:01') OR $ ; KDCS 02/14/2013
                      (epoch_st EQ '2012-05-28/08:46:01') OR $ ; KDCS 11/26/2012
                      (epoch_st EQ '2012-05-28/08:48:01') OR $ ; KDCS 02/14/2013
                      (epoch_st EQ '2012-05-28/08:57:01') OR $ ; KDCS 11/26/2012
                      (epoch_st EQ '2012-05-28/09:00:01') OR $ ; KDCS 02/14/2013
                      ((epoch_st GE '2012-05-28/09:01:01') AND $ ; KDCS 12/13/2012
                       (epoch_st LE '2012-05-28/12:33:01')) OR $ ; KDCS 12/13/2012
                      (epoch_st EQ '2012-05-28/12:49:01') OR $ ; KDCS 11/26/2012
                      (epoch_st EQ '2012-05-28/16:24:01') OR $ ; KDCS 11/26/2012
                      (epoch_st EQ '2012-05-28/15:05:01'), $ ; KDCS 11/26/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-06-02/00:51:01') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-14/01:05:01') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-21/13:48:00') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-21/14:19:00') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-21/15:13:00') OR $ ; KDCS 08/06/2012
                      (epoch_st EQ '2012-06-21/17:15:00'), $ ; KDCS 08/06/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-07-09/21:25:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-11/02:23:58') OR $ ; KDCS 10/01/2012
                      (epoch_st EQ '2012-07-15/23:07:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-15/23:23:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-16/16:24:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-16/17:05:58') OR $ ; KDCS 10/01/2012
                      (epoch_st EQ '2012-07-20/16:51:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/09:49:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:04:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:21:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:28:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:30:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:33:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:34:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/10:42:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:02:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:20:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:32:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:37:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:39:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:57:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/12:58:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:00:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:09:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:18:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:22:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:24:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:25:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:28:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/13:35:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/14:31:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/14:34:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:06:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:11:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:13:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:35:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:40:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:45:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:47:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/15:51:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/16:03:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/16:08:58') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-23/16:25:58') OR $ ; KDCS 09/21/2012
                      ((epoch_st GE '2012-07-23/16:52:58') AND $ ; KDCS 09/21/2012
                       (epoch_st LE '2012-07-25/03:38:57')) OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/06:46:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:38:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:39:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:43:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:45:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:50:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:52:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:54:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:57:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:58:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/07:59:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:04:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:06:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:11:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:12:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:16:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:18:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:20:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:23:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:26:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:33:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:34:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:38:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:43:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:44:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:45:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:50:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:51:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/08:54:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:01:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:04:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:09:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:10:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:16:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:17:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:23:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:24:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:27:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:29:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:33:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:34:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:37:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:40:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/09:59:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:08:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:10:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:11:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:12:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:14:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:15:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:20:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:21:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:23:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:25:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:26:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:27:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:32:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:42:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:49:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:53:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:55:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:57:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/10:58:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:25:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:26:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:27:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:33:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:37:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:38:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:43:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:45:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:46:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/11:57:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:01:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:02:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:06:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:11:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:14:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:15:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:17:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:18:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:21:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:24:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:25:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:29:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/12:34:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:08:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:29:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:32:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:37:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:39:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:40:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:41:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:46:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:47:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:48:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:53:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:57:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/13:59:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:04:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:07:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:08:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:12:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:19:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:24:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:32:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:42:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:50:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:51:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/14:53:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:14:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:21:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:24:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:53:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/15:59:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:05:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:06:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:09:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:11:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:18:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:25:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:28:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:34:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:39:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/16:42:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:02:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:12:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:34:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/17:48:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/18:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/18:27:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/18:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/18:43:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/18:55:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:01:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:05:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:07:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:11:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:13:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:35:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:38:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:39:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:40:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:42:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:44:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:48:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:53:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/19:56:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:10:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:17:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:18:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:20:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:22:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:24:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:26:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:35:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:45:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:47:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:48:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/20:52:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:08:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:15:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:25:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:31:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:32:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:50:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:51:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:52:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/21:58:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:01:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:06:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:08:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:09:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:10:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:15:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:26:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/22:40:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-25/23:18:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/00:02:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/00:03:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/00:19:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/00:30:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/00:36:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/01:00:57') OR $ ; KDCS 09/21/2012
                      (epoch_st EQ '2012-07-26/01:34:57'), $ ; KDCS 09/21/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-08-22/12:22:54') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-22/12:23:54') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-22/21:16:54') OR $ ; KDCS 10/16/2012
                      (epoch_st EQ '2012-08-22/22:15:54'), $ ; KDCS 10/16/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-09-03/04:37:53') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-05/13:53:53') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-09/20:54:52') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-09/21:00:52') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-09/23:05:52') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-12/16:50:52') OR $ ; KDCS 11/04/2012
                      (epoch_st EQ '2012-09-30/19:20:50'), $ ; KDCS 11/04/2012
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-10-01/06:16:50') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-01/08:58:50') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-14/00:06:49') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-19/05:32:48') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-19/06:46:48') OR $ ; KDCS 12/10/2012
                      (epoch_st EQ '2012-10-19/09:15:48'), $ ; KDCS 12/10/2012                 
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-11-05/01:18:47') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-06/15:42:47') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-23/21:45:45') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-26/09:14:44') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-26/09:15:44') OR $ ; KDCS 01/15/2013
                      (epoch_st EQ '2012-11-26/09:16:44'), $ ; KDCS 01/15/2013                 
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2012-12-01/05:31:44') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-01/07:20:44') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-01/07:26:44') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-01/07:41:44') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-10/12:01:43') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-12/05:54:43') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-12/05:55:43') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-12/05:56:43') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-12/05:57:43') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-24/11:42:42') OR $ ; KDCS 02/18/2013
                      (epoch_st EQ '2012-12-25/04:49:42') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/04:54:42') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/04:56:42') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/04:57:42') OR $ ; KDCS 02/12/2013
                      (epoch_st EQ '2012-12-25/05:09:42'), $ ; KDCS 02/12/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2014-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2013-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-01-06/15:19:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:30:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:36:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:39:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:45:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:47:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:54:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:56:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:59:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/16:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/16:35:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:02:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/17:04:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:06:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:08:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:09:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:19:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:20:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:22:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/18:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/22:23:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-16/22:50:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-27/16:44:39'), $ ; KDCS 03/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-02-12/02:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/06:08:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/14:36:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/13:54:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/14:50:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:03:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:18:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:33:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:41:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2013-02-19/15:45:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:53:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:56:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:02:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:20:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:22:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-20/12:34:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:47:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:50:37'), $ ; KDCS 04/16/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-03-01/01:40:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-01/01:41:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-01/22:34:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/04:06:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/04:18:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/04:32:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/12:05:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/12:11:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/12:12:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-02/15:30:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-04/13:41:37') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-05/07:55:36') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-08/04:40:36') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-19/05:06:35') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2013-03-24/05:24:35'), $ ; KDCS 05/14/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-04-08/01:19:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:22:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:24:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:25:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:33:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:39:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:44:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/01:54:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/02:18:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/02:53:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/03:17:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/03:42:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/03:44:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/03:58:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/05:07:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-08/07:27:34') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-17/15:07:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-17/23:12:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-17/23:19:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-17/23:41:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-17/23:54:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/00:47:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/00:52:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/00:58:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/01:06:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/01:43:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/01:45:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/01:52:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/01:56:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/02:16:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/02:33:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/02:38:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/02:59:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/03:33:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/04:01:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/04:15:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/05:13:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/05:33:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/11:51:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/11:56:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/11:57:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:09:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:13:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:37:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:40:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:41:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/12:52:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-18/14:53:33') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-19/11:28:32') OR $ ; KDCS 06/12/2013
                      (epoch_st EQ '2013-04-23/08:23:32'), $ ; KDCS 06/12/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-05-04/19:47:32') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-04/20:21:32') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/14:41:31') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/16:34:31') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/17:02:31') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/17:31:31') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/18:32:31') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-05-16/20:57:31'), $ ; KDCS 08/29/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-06-03/04:29:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/04:44:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/05:52:29') OR $ ; KDCS 09/03/2013
                      (epoch_st EQ '2013-06-03/06:05:29') OR $ ; KDCS 09/03/2013
                      (epoch_st EQ '2013-06-03/08:06:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/08:20:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/10:24:29') OR $ ; KDCS 09/03/2013
                      (epoch_st EQ '2013-06-03/14:07:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/15:24:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-03/16:35:29') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-20/04:24:28') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-27/20:35:27') OR $ ; KDCS 08/29/2013
                      (epoch_st EQ '2013-06-28/10:10:27'), $ ; KDCS 08/29/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-07-03/18:49:27') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-03/18:51:27') OR $ ; KDCS 10/29/2013
                      (epoch_st EQ '2013-07-03/20:29:27') OR $ ; KDCS 10/29/2013
                      (epoch_st EQ '2013-07-03/20:32:27') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-14/23:20:26') OR $ ; KDCS 10/29/2013
                      (epoch_st EQ '2013-07-14/23:21:26') OR $ ; KDCS 10/29/2013
                      (epoch_st EQ '2013-07-15/00:00:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-15/00:02:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-15/04:18:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-19/00:13:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-19/00:29:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-19/04:50:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-19/07:04:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-20/02:10:26') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-21/15:36:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-21/21:02:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-25/07:29:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-25/10:37:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-25/11:21:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-25/12:16:25') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-07-28/00:19:25') OR $ ; KDCS 10/29/2013
                      (epoch_st EQ '2013-07-29/09:39:25'), $ ; KDCS 10/24/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-08-23/02:28:23') OR $ ; KDCS 10/24/2013
                      (epoch_st EQ '2013-08-28/17:47:23'), $ ; KDCS 10/29/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-09-02/16:13:22') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-02/16:38:22') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-12/03:44:21') OR $ ; KDCS 12/13/2013
                      (epoch_st EQ '2013-09-29/11:20:19'), $ ; KDCS 12/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-10-31/20:43:14'), $ ; KDCS 12/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-11-04/16:04:13') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/03:39:13') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/07:51:13') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/15:03:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-06/15:05:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/11:28:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/11:47:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/12:16:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/12:20:12') OR $ ; KDCS 01/14/2014
                      (epoch_st EQ '2013-11-07/12:21:12'), $ ; KDCS 01/14/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-01-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-12-02/01:48:09') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-02/01:49:09') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/04:49:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/12:40:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:26:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:28:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:33:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:44:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:47:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/14:59:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/15:35:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/16:00:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/16:13:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/17:32:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/17:35:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/18:12:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-13/19:05:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-14/02:24:07') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-20/22:49:06') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-23/04:32:06') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-23/04:38:06') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-25/16:32:05') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-25/16:51:05') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-25/17:07:05') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-30/08:18:04') OR $ ; KDCS 02/19/2014
                      (epoch_st EQ '2013-12-30/14:29:04'), $ ; KDCS 02/19/2014
                      bad_count)
    ENDIF 
ENDIF ELSE IF temp_epoch LT '2015-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2014-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-01-01/12:04:04') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-03/09:06:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-03/13:16:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-03/13:17:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-03/13:18:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-06/01:49:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-06/01:25:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/01:40:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/01:48:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/01:51:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/04:01:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/05:25:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/05:49:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/05:58:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/06:09:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/06:11:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/06:13:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/06:35:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/06:50:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/11:34:03') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-06/11:42:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/11:58:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/12:51:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/14:19:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/17:17:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-06/17:18:03') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-09/13:17:02') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-14/13:06:02') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-16/09:03:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-20/22:47:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/01:30:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/01:31:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/01:32:01') OR $ ; KDCS 04/01/2014
                      (epoch_st EQ '2014-01-22/01:34:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/01:35:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/01:36:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/02:41:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/02:56:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-22/03:05:01') OR $ ; KDCS 03/17/2014
                      (epoch_st EQ '2014-01-27/14:46:01'), $ ; KDCS 03/17/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-02-03/17:22:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/17:47:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/19:12:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/19:38:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/19:58:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/20:12:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/20:27:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/21:21:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/21:32:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/21:35:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/21:37:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-03/21:40:59') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/04:40:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/04:42:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/06:22:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/07:46:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/10:27:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-16/11:48:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-17/12:42:57') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-22/18:35:57') OR $ ; KDCS 04/08/2014
                      ;(epoch_st EQ '2014-02-28/01:30:56') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-28/01:32:56') OR $ ; KDCS 04/08/2014
                      (epoch_st EQ '2014-02-28/01:45:56'), $ ; KDCS 04/08/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-03-04/04:17:56') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/04:56:56') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-04/05:16:56') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-08/00:23:55') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-08/12:59:55') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-08/22:03:55') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:13:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:26:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:35:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:36:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:51:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/13:53:54') OR $ ; KDCS 06/06/2014
                      (epoch_st EQ '2014-03-11/13:54:54') OR $ ; KDCS 06/06/2014
                      (epoch_st EQ '2014-03-11/14:06:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-11/14:21:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/18:13:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/18:46:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/19:57:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/19:58:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/20:00:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/21:05:54') OR $ ; KDCS 06/06/2014
                      (epoch_st EQ '2014-03-14/21:14:54') OR $ ; KDCS 06/06/2014
                      (epoch_st EQ '2014-03-14/21:24:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/21:35:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/22:52:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-14/23:20:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/00:26:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/00:35:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/01:14:54') OR $ ; KDCS 06/06/2014
                      (epoch_st EQ '2014-03-15/01:48:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/10:49:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/13:02:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/13:10:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/13:32:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-15/13:36:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-16/14:17:54') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-27/00:29:52') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-27/00:35:52') OR $ ; KDCS 06/02/2014
                      (epoch_st EQ '2014-03-30/23:56:52'), $ ; KDCS 06/06/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-04-11/11:29:51') OR $ ; KDCS 06/03/2014
                      (epoch_st EQ '2014-04-12/03:14:50') OR $ ; KDCS 06/03/2014
                      (epoch_st EQ '2014-04-24/18:50:48'), $ ; KDCS 06/03/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-05-05/01:47:48') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-05/08:27:48') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-05/12:44:48') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-06/10:58:48') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-08/20:20:47') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-09/19:32:47') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-09/21:44:47') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-11/14:56:47') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-16/14:17:46') OR $ ; KDCS 07/09/2014
                      (epoch_st EQ '2014-05-30/06:59:44'), $ ; KDCS 07/09/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-06-03/18:29:44') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-04/03:00:44') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-04/06:26:44') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-04/12:16:44') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-10/03:20:43') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-14/09:18:42') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-15/03:48:42') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-15/03:49:42') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-24/15:51:40') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-24/16:15:40') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-26/16:46:40') OR $ ; KDCS 11/02/2014
                      (epoch_st EQ '2014-06-29/01:43:39') OR $ ; KDCS 08/26/2014
                      (epoch_st EQ '2014-06-29/02:01:39'), $ ; KDCS 08/26/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-07-05/11:14:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/11:22:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/11:48:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/11:59:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/12:11:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/12:38:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/12:45:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/13:17:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/13:29:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/13:35:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/13:49:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/14:35:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/14:36:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/14:37:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/14:43:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/14:48:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:03:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:05:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:15:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:16:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:44:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/15:49:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/16:15:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/16:23:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/16:53:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/16:58:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/17:13:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:04:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:08:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:14:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:17:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:19:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:21:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:24:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:25:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:28:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/18:30:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-05/20:26:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-19/05:45:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-20/11:20:39') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/20:02:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/20:33:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/20:34:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/20:40:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/20:42:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/21:13:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-27/21:17:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/00:43:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/01:00:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/01:53:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/06:33:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/08:53:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-28/16:05:38') OR $ ; KDCS 11/10/2014
                      (epoch_st EQ '2014-07-30/00:44:38'), $ ; KDCS 11/10/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-08-02/19:02:38') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-04/19:26:38') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-07/09:02:37') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-07/16:10:37') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-10/13:51:37') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-10/13:52:37') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-14/00:21:37') OR $ ; KDCS 12/15/2014
                      (epoch_st EQ '2014-08-16/14:57:36') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-18/07:47:36') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-31/06:44:35') OR $ ; KDCS 12/03/2014
                      (epoch_st EQ '2014-08-31/06:48:35'), $ ; KDCS 12/03/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-09-09/22:28:35') OR $ ; KDCS 12/15/2014
                      (epoch_st EQ '2014-09-21/10:12:33') OR $ ; KDCS 12/15/2014
                      (epoch_st EQ '2014-09-21/10:19:33') OR $ ; KDCS 12/08/2014
                      (epoch_st EQ '2014-09-23/08:37:33'), $ ; KDCS 12/08/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-10-03/10:55:33'), $ ; KDCS 12/15/2014
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2014-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2014-11-04/19:53:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-05/21:39:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-07/22:03:29') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-08/20:31:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-08/20:48:29') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-09/19:48:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-09/19:55:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-09/20:17:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-10/06:07:29') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/19:47:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/19:48:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/19:49:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/20:50:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/20:58:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/21:09:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/21:39:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/21:41:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/22:21:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/22:35:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/22:40:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-14/23:07:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/23:20:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-14/23:30:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-15/00:20:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-15/00:30:28') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-15/00:37:28') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-22/22:46:27') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-22/23:47:27') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-23/22:33:26') OR $ ; KDCS 02/20/2015
                      (epoch_st EQ '2014-11-28/22:51:26') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-29/02:11:26') OR $ ; KDCS 02/13/2015
                      (epoch_st EQ '2014-11-29/15:52:25'), $ ; KDCS 02/13/2015
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2014-12-05/10:11:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-05/10:12:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-05/20:08:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-05/21:01:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-06/10:18:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-07/20:53:25') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-12/05:37:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/05:41:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/05:43:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/06:08:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/06:11:24') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-12/06:20:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/06:23:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/06:52:24') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-12/06:59:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/07:09:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/07:13:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-12/20:58:24') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-12/21:00:24') OR $ ; KDCS 02/24/2015
                      (epoch_st EQ '2014-12-13/20:38:24') OR $ ; KDCS 02/15/2015
                      (epoch_st EQ '2014-12-15/05:38:24'), $ ; KDCS 02/15/2015
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2016-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2015-08-26/18:04:30') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-08-26/18:54:30') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-09-24/23:05:27') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-09-24/23:06:27') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-10-03/23:34:27') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-10-31/18:04:24') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-10-31/18:05:24') OR $ ; KDCS 12/11/2015
                  (epoch_st EQ '2015-11-06/00:11:24') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-06/01:21:24') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-17/14:10:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-18/12:17:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-18/12:18:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-18/13:34:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-18/13:40:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-18/17:37:23') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/02:31:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/02:33:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/03:45:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/06:44:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/06:45:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/06:47:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/13:42:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-22/17:29:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-23/15:26:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-11-25/02:30:22') OR $ ; KDCS 01/22/2016
                  (epoch_st EQ '2015-12-01/14:52:21') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-03/02:54:21') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-03/02:55:21') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-03/02:56:21') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-12/13:52:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-13/06:39:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-13/06:50:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-21/04:45:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-21/20:09:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-22/05:26:20') OR $ ; KDCS 02/15/2016
                  (epoch_st EQ '2015-12-22/13:26:20'), $ ; KDCS 02/15/2016
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2017-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2016-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2016-01-01/10:28:20') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-04/17:38:19') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-16/06:13:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-18/01:37:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-18/01:45:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-18/02:33:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-26/20:01:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-27/00:44:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-27/00:48:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-27/17:20:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-30/06:34:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-30/09:32:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-01-30/09:41:18') OR $ ; KDCS 03/25/2016
                      (epoch_st EQ '2016-02-02/19:59:17') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-10/10:30:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-14/10:54:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-15/12:41:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-21/06:04:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-23/05:57:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-23/08:37:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-23/14:12:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-23/16:12:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-02-27/21:38:16') OR $ ; KDCS 04/22/2016
                      (epoch_st EQ '2016-03-01/14:33:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/15:07:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/15:09:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/15:17:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/15:23:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/15:34:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/17:38:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/17:50:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-01/21:54:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-02/07:54:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-02/08:04:16') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-11/05:36:15') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-17/01:41:14') OR $ ; KDCS 05/12/2016
                      (epoch_st EQ '2016-03-26/01:05:14') OR $ ; KDCS 05/12/2016
                      (epoch_st EQ '2016-03-29/03:28:14') OR $ ; KDCS 05/11/2016
                      (epoch_st EQ '2016-03-29/03:31:14'), $ ; KDCS 05/11/2016
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2016-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2016-04-07/19:04:13') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-08/00:04:13') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-10/12:21:13') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-17/03:02:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-23/03:27:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-27/10:57:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-28/11:24:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-28/15:47:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-04-29/15:38:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-04/16:28:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-05/01:10:12') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-13/13:22:11') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-15/13:52:11') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-15/16:10:11') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-15/16:13:11') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-20/02:51:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-23/18:27:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-24/01:16:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-24/02:49:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-25/05:15:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-29/15:45:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-05-31/11:06:10') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/11:06:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/15:14:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/15:21:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/16:27:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/17:37:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-12/22:19:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-14/02:07:09') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-27/08:16:07') OR $ ; KDCS 10/07/2016
                      (epoch_st EQ '2016-06-29/19:33:07'), $ ; KDCS 10/07/2016
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2016-08-01/00:00:00' THEN BEGIN 
       bad_i = where((epoch_st EQ '2016-07-05/13:36:07') OR $ ; KDCS 09/12/2016
                     (epoch_st EQ '2016-07-22/20:05:06') OR $ ; KDCS 09/12/2016
                     (epoch_st EQ '2016-07-22/21:27:06'), $    ; KDCS 09/12/2016
                      bad_count)
    ENDIF 
ENDIF 

END 
