; Lorna Ellis
; 05/16/2013
; check_ns_outliers_b0.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

PRO check_ns_outliers_b, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2008-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2009-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2010-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2011-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2014-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2013-03-09/04:12:31') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2013-03-09/04:55:31') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2013-03-09/17:23:31') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2013-03-10/05:39:31') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2013-09-29/20:44:14') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2013-11-07/19:42:15') OR $ ; KDCS 01/14/2014
                  (epoch_st EQ '2013-11-07/19:43:15') OR $ ; KDCS 01/14/2014
                  (epoch_st EQ '2013-11-07/20:10:15') OR $ ; KDCS 01/14/2014
                  (epoch_st EQ '2013-11-08/14:59:15'), $ ; KDCS 01/14/2014
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2014-08-08/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2014-06-25/06:08:08') OR $ ; KDCS 11/02/2014
                  (epoch_st EQ '2014-06-27/23:51:09') OR $ ; KDCS 11/02/2014
                  (epoch_st EQ '2014-08-07/04:59:18'), $ ; KDCS 12/03/2014
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2014-10-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2014-09-02/05:02:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-02/06:34:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-02/07:48:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/10:50:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/12:54:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/13:16:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/13:24:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/13:30:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/13:37:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/15:32:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/16:42:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/17:06:23') OR $ ; KDCS 12/08/2014
                  (epoch_st EQ '2014-09-03/17:14:23'), $ ; KDCS 12/08/2014
                  bad_count)
ENDIF 
END 
