; Lorna Ellis
; June 25, 2007
; calculate_svalid_ratrig_ratio_b.pro

; This program reads a Level1 CDF and creates a daily ratio of
; s_valid/ra_trig. It removes cases where either rate is saturated. It
; only uses science mode data. 

; Input: satellite ('A' or 'B')
; Output: ratio (array of 32 values)

; 11/07/2007 Added check for if only one record.
; 05/26/2009 Put in splat environment. Changed input to sat
; 05/27/2015 Add closed_entrance keyword.
; 07/30/2015 Remove ESA steps where not enough peak in deflection.
; 11/02/2015 Changed to calculate_svalid_ratrig_b (added _b)

PRO calculate_svalid_ratrig_ratio_b, sat, ratio, closed_entrance = closed_entrance 
compile_opt strictarrsubs

pla_plot_mon_spec, sat, ['s_valid', 'ra_trig'], 'counts'

get_data, 's_valid_norm_science_full_array', svalid_t, s_valid
get_data, 'ra_trig_norm_science_full_array', ratrig_t, ra_trig
;stop
; remove fill values
invalid = where(ra_trig EQ -1, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(s_valid EQ -1, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(finite(ra_trig) EQ 0, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(finite(s_valid) EQ 0, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count

; remove saturated values
invalid = where(ra_trig EQ 507904, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(s_valid EQ 507904, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count

IF keyword_set(closed_entrance) THEN BEGIN 
    IF closed_entrance EQ 1 THEN BEGIN 
        esa_cm_dc = 'ST'+sat+'_Analog_HK_esa_cm_dc'
        get_data, esa_cm_dc, hk_t, hk_d
        bad_i = where(hk_d LT 50, bad_count)
        FOR ii = 0L, bad_count-1 DO BEGIN
            index = bad_i[ii]
            invalid = where((hk_t[index] GE ratrig_t) AND (hk_t[index] LT (ratrig_t+300)), count)
            IF count GT 0 THEN BEGIN 
                ra_trig[invalid, *, *] = 0
                s_valid[invalid, *, *] = 0
            ENDIF 
        ENDFOR 
    ENDIF 
ENDIF 
;stop

; Remove ESA steps where not enough peak in defl
s_sumtime = total(s_valid, 1, /nan) ; sum over time [time, defl, esa]
FOR esa_i = 0, 31 DO BEGIN 
    peak_val = max(s_sumtime[*, esa_i], /nan)
    IF (peak_val LE (s_sumtime[0, esa_i]*10)) AND (peak_val LE (s_sumtime[7, esa_i]*10)) THEN BEGIN
        s_valid[*, *, esa_i] = 0
        ra_trig[*, *, esa_i] = 0
    ENDIF 
ENDFOR 

; sum each
ra_trig = total(ra_trig, 2, /nan) ; sum over deflection
s_valid = total(s_valid, 2, /nan) ; sum over deflection
IF n_elements(ra_trig) GT 32 THEN ra_trig = total(ra_trig, 1, /nan) ; sum over time
IF n_elements(s_valid) GT 32 THEN s_valid = total(s_valid, 1, /nan)

; divide
ratio = s_valid/ra_trig

END 
