; Lorna Ellis
; June 25, 2007
; calculate_svalid_ratrig_ratio_a.pro

; This program reads a Level1 CDF and creates a daily ratio of
; s_valid/ra_trig. It removes cases where either rate is saturated. It
; only uses science mode data. 

; Input: satellite ('A' or 'B')
; Output: ratio (array of 32 values)

; 11/07/2007 Added check for if only one record.
; 05/26/2009 Put in splat environment. Changed input to sat
; 05/27/2015 Add closed_entrance keyword.
; 11/02/2015 Changed to calculate_svalid_ratrig_ratio_a.
; 04/10/2020 Change so use dacm_esa_ctl == 0xFF for closed_entrance (instead of esa_cm_dc < 50)

PRO calculate_svalid_ratrig_ratio_a, sat, ratio, closed_entrance = closed_entrance 
compile_opt strictarrsubs

pla_plot_mon_spec, sat, ['s_valid', 'ra_trig'], 'counts'

get_data, 's_valid_norm_science_full_array', svalid_t, s_valid
get_data, 'ra_trig_norm_science_full_array', ratrig_t, ra_trig
;stop
; remove fill values
invalid = where(ra_trig EQ -1, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(s_valid EQ -1, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(finite(ra_trig) EQ 0, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(finite(s_valid) EQ 0, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count

; remove saturated values
invalid = where(ra_trig EQ 507904, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count
invalid = where(s_valid EQ 507904, count)
IF count GT 0 THEN BEGIN
    ra_trig[invalid] = 0
    s_valid[invalid] = 0
ENDIF 
print, count

IF keyword_set(closed_entrance) THEN BEGIN 
    IF closed_entrance EQ 1 THEN BEGIN 
        dacm_esa_ctl = 'ST'+sat+'_Digital_HK_dacm_esa_ctl'
        get_data, dacm_esa_ctl, hk_t, hk_d
        bad_i = where(hk_d NE 0xFF, bad_count)
        FOR ii = 0L, bad_count-1 DO BEGIN
            index = bad_i[ii]
            invalid = where((hk_t[index] GE ratrig_t) AND (hk_t[index] LT (ratrig_t+300)), count)
            IF count GT 0 THEN BEGIN 
                ra_trig[invalid, *, *] = 0
                s_valid[invalid, *, *] = 0
            ENDIF 
        ENDFOR 
    ENDIF 
ENDIF 
;stop
; sum each
ra_trig = total(ra_trig, 2) ; sum over deflection
s_valid = total(s_valid, 2) ; sum over deflection
IF n_elements(ra_trig) GT 32 THEN ra_trig = total(ra_trig, 1) ; sum over time
IF n_elements(s_valid) GT 32 THEN s_valid = total(s_valid, 1)

; divide
ratio = s_valid/ra_trig
;stop
END 
