;+
;PROCEDURE: calc_proton_fit_maxwellian_norm
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  Proton distribution functions are
; fit with a maxwellian in order to obtain density, speed, and temperature.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 23 November 2009
;
;MODIFICATION HISTORY:
;    November 2009:  created
;
;-



 PRO calc_proton_fit_maxwellian_norm, sat, num_records5, coeff, density, avg_v, temp_K, v_th, good_fit, $
	peak_dist, dist_funct, delta_dist_funct, v_main, v_S, std_error, error5, s_chan, epoch5

; Fit the distribution function versus velocity data to a 1-D Gaussian.

k=0L
m=0L

FOR n=0L, num_records5-1 DO BEGIN
	v = fltarr(32)
	v(*) = !values.f_nan
	temp = dblarr(3)
	temp(*) = -1.0
	guess_0 = dblarr(3)
	guess_0(*) = !values.d_nan
	red_chi = !values.f_nan
	
	FOR p = 0, 31 DO BEGIN
		IF p GE s_chan(n) THEN v(p) = v_S(p) ELSE v(p) = v_main(p)
	ENDFOR


IF s_chan(n) LT (peak_dist(n)-2) THEN BEGIN ; usual case when peak is in the small channel
	; increased range of points to fit when measure_errors term added on 19 November, 2007
	; added measure_errors term 19 November, 2007
	IF (peak_dist(n) LT 28) AND (peak_dist(n) GE 2) THEN BEGIN ; changed from 119 to 123 by KDCS, 12 October 2009
        	k = 32*n+peak_dist(n)-2 ; 1
        	m = 32*n+peak_dist(n)+1 ; 2
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-2:peak_dist(n)+1)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi		

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) OR FINITE(good_fit(n) EQ 0) THEN BEGIN ; modify the fit range
        	k = 32*n+peak_dist(n)-1 ; 
		m = 32*n+peak_dist(n)+2 ; 
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:peak_dist(n)+2)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) OR FINITE(good_fit(n) EQ 0) THEN BEGIN ; modify the fit range
        	k = 32*n+peak_dist(n)-2 ; 
		m = 32*n+peak_dist(n)+2 ; 
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-2:peak_dist(n)+2)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) THEN BEGIN ; add another point to the fit range
        	k = 32*n+peak_dist(n)-1 ; 1
		m = 32*n+peak_dist(n)+3 ; 3
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:peak_dist(n)+3)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) THEN BEGIN ; add another point to the fit range
        	k = 32*n+peak_dist(n)-1 ; 2
		m = 32*n+peak_dist(n)+4 ; 3
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:peak_dist(n)+4)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF
	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6 
        	ENDIF


    	ENDIF

    	IF peak_dist(n) GE 28 AND peak_dist(n) LT 30 THEN BEGIN
	       	k = 32*n+peak_dist(n)-2 ; changed from 4 07/24/2012	
        	m = 32*n+30
		;delta_dist_funct(k:m) = 0.05*MAX(dist_funct(k:m),/NaN) ; commented 07/25/2012
        	FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-2:30)), double(dist_funct(k:m)), double(temp), $
                              nterms = 3, measure_errors = delta_dist_funct(k:m),chisq=red_chi)
        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

	        density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
        
        	IF error5(n) GT 0 THEN std_error(n) = 2

	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6 ; added Feb 2009
        	ENDIF
    	ENDIF

    	IF (peak_dist(n) GE 30 OR peak_dist(n) LT 0) AND std_error(n) NE 3  THEN BEGIN	
        	density(n) = !values.f_nan
        	avg_v(n) = !values.f_nan
        	temp_K(n) = !values.f_nan
        	v_th(n) = !values.f_nan
        	std_error(n) = 5
    	ENDIF

ENDIF ELSE BEGIN ; proton peak is in the main channel or very near it
	IF (peak_dist(n) LT 28) AND (peak_dist(n) GE 2) THEN BEGIN ; changed from 119 to 123 by KDCS, 12 October 2009
        	k = 32*n+peak_dist(n)-1 ;
        	m = 32*n+peak_dist(n)+2 ;
		;delta_dist_funct(k:m) = 0.05*MAX(dist_funct(k:m),/NaN)
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:peak_dist(n)+2)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) OR FINITE(good_fit(n) EQ 0) THEN BEGIN ; modify the fit range
        	k = 32*n+peak_dist(n)-2 ; 
		m = 32*n+peak_dist(n)+1 ; 
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-2:peak_dist(n)+1)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF

		IF (good_fit(n) LT 0.25 OR good_fit(n) GT 10) OR FINITE(good_fit(n) EQ 0) THEN BEGIN ; modify the fit range
        	k = 32*n+peak_dist(n)-1 ; 
		m = 32*n+peak_dist(n)+3 ; 
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:peak_dist(n)+3)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		ENDIF
	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6 
        	ENDIF
    	ENDIF

    	IF peak_dist(n) GE 28 AND peak_dist(n) LT 30 THEN BEGIN
	       	k = 32*n+peak_dist(n)-1 ; changed from 4 07/24/2012	
        	m = 32*n+31
		;delta_dist_funct(k:m) = 0.05*MAX(dist_funct(k:m),/NaN) ; commented 07/25/2012
        	FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-1:31)), double(dist_funct(k:m)), double(temp), $
                              nterms = 3, measure_errors = delta_dist_funct(k:m),chisq=red_chi)
        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

	        density(n) = coeff(3*n)*((2.0*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2.0)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
        
        	IF error5(n) GT 0 THEN std_error(n) = 2

	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 AND std_error(n) NE 3 THEN std_error(n) = 6 ; added Feb 2009
        	ENDIF
    	ENDIF

    	IF (peak_dist(n) GE 30 OR peak_dist(n) LT 0) AND std_error(n) NE 3  THEN BEGIN	
        	density(n) = !values.f_nan
        	avg_v(n) = !values.f_nan
        	temp_K(n) = !values.f_nan
        	v_th(n) = !values.f_nan
        	std_error(n) = 5
    	ENDIF

ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Uncomment below to list and plot distribution functions and fit ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
now_time = time_struct(epoch5(n))
IF now_time.year EQ 2011 AND $
		now_time.month EQ 11 AND $
		now_time.date EQ 8 AND $
		now_time.hour GE 0 AND $
		now_time.min GE 14 THEN BEGIN
		print, now_time.year, now_time.month, now_time.date, now_time.hour, now_time.min

	v_km = FLTARR(32)
	v_km(*) = !values.f_nan
	
	FOR l=0,31 DO BEGIN
		v_km(l) = v(l)/1000.0
		PRINT, v(l)
	ENDFOR
	PRINT, ' '
	PRINT, s_chan(n)
        ;STOP

	FOR i = 0, 31 DO BEGIN
		PRINT, dist_funct(32*n+i)
	ENDFOR
	;STOP

	PRINT, ' '
	FOR j = 0, 31 DO BEGIN
		PRINT, delta_dist_funct(32*n+j)
	ENDFOR
	;STOP

;;;	PRINT, ' '
;;;	PRINT, coeff(3*n)
;;;	PRINT, coeff(3*n+1)
;;;	PRINT, coeff(3*n+2)

	now_fit = fltarr(32)
	now_fit(*) = !values.f_nan
	FOR tt = 0, 31 DO BEGIN
		z = !values.f_nan
		z = (v(tt)-coeff(3*n+1))/coeff(3*n+2)
		now_fit(tt) = coeff(3*n+0)*EXP(-0.5*z^2.0)
	ENDFOR
	FOR kk = 0, 31 DO BEGIN
		PRINT, now_fit(kk)
	ENDFOR
	
	LOADCT, 39, NCOLORS = 256
	!P.BACKGROUND = 0
	PLOT, v_km(0:31), dist_funct(32*n:32*n+31), PSYM = 4, COLOR = 255, $
		XTITLE = 'Proton Speed [km/s]', YTITLE = 'f(v)', SYMSIZE = 1, XRANGE = [0,1000], XSTYLE=1;, $
		;YLOG = 1, /YNOZERO, YRANGE=[1E4,1E8], YSTYLE=1 
	OPLOTERR, v_km(0:31), dist_funct(32*n:32*n+31), delta_dist_funct(32*n:32*n+31)
	OPLOT, v_km(0:31),now_fit(0:31), COLOR = 150

	PRINT, ' '
	print, now_time.year, now_time.month, now_time.date, now_time.hour, now_time.min
	print, 'density ',density(n)
	print, 'speed ',avg_v(n)
	print, 'v_thermal ',v_th(n)
	print, 'reducted chi^2 ',good_fit(n)
	;STOP
ENDIF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ENDFOR

END
