;+
;PROCEDURE: calc_proton_defl_peak
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  Gaussians are fit to the
;	deflection count distribution in both the main and small channels.
;
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 23 November 2009
;
;MODIFICATION HISTORY:
;    November 2009:  created
;
;-



PRO calc_proton_defl_peak_norm, num_records5, full_data_no_bkgd2, s_chan, S_MAX, MAIN_MAX, epoch5, sat
;, S_width, Main_width, epoch1, sat

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Find the deflection count peak
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

s_count = FLTARR(8, num_records5)
s_count(*,*) = 0.0
main_count = FLTARR(8, num_records5)
main_count(*,*) = 0.0
defl_steps = INTARR(8)

FOR z=0,7 DO BEGIN
    defl_steps(z) = z
ENDFOR

temp = DBLARR(3)
temp_2=DBLARR(3)
temp(*) = -1.0
temp_2(*) = -1.0

FOR j=0,7 DO BEGIN ; DEFL Steps
    FOR i = 0, 31 DO BEGIN ; ESA Steps
        FOR k = 0L, num_records5-1 DO BEGIN ; Time Steps
	zz = FINITE(full_data_no_bkgd2(i,j,k))
            IF zz EQ 1 THEN BEGIN
                IF i LT s_chan(k) THEN main_count(j, k) = main_count(j, k) + full_data_no_bkgd2(i, j, k)
                IF i GE s_chan(k) THEN s_count(j, k) = s_count(j, k) + full_data_no_bkgd2(i, j, k)
            ENDIF
        ENDFOR	
    ENDFOR
ENDFOR

S_width = FLTARR(num_records5)
S_width(*) = !values.f_nan
Main_width = FLTARR(num_records5)
Main_width(*) = !values.f_nan

FOR l = 0L, num_records5-1 DO BEGIN
    FOR m = 0, 7 DO BEGIN
        IF main_count(m, l) GT main_count(MAIN_MAX(l), l) THEN MAIN_MAX(l) = m
        IF s_count(m, l) GT s_count(S_MAX(l), l) THEN S_MAX(l) = m
    ENDFOR

    IF S_MAX(l) GE 2 AND S_MAX(l) LE 5 THEN BEGIN
        yy = S_MAX(l) - 2
        zz = S_MAX(l) + 2
        result = gaussfit(double(defl_steps(yy:zz)), double(s_count(l*8+yy:l*8+zz)), double(temp), nterms = 3)
        S_MAX(l) = temp(1)
	S_width(l) = 2.0*SQRT(2.0*ALOG(2.0))*temp(2)
    ENDIF ELSE BEGIN
        S_MAX(l) = !values.f_nan
	S_width(l) = !values.f_nan
    ENDELSE
    IF MAIN_MAX(l) GE 2 AND MAIN_MAX(l) LE 5 THEN BEGIN
        aa = MAIN_MAX(l) - 2
        bb = MAIN_MAX(l) + 2
        result = gaussfit(double(defl_steps(aa:bb)), double(main_count(l*8+aa:l*8+bb)), double(temp_2), nterms = 3)
        MAIN_MAX(l) = temp_2(1)
	Main_width(l) = 2.0*SQRT(2.0*ALOG(2.0))*temp_2(2)
    ENDIF ELSE BEGIN
        MAIN_MAX(l) = !values.f_nan
	Main_width(l) = !values.f_nan
    ENDELSE
ENDFOR

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Uncomment to create a file with the peak and width of the distributions versus time.;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;TAB = STRING(9B)
;label_time = time_struct(epoch5(0))
;label_year = STRING(label_time.year, FORMAT = '(I04)')
;label_month = STRING(label_time.month, FORMAT = '(I02)')
;label_day = STRING(label_time.date, FORMAT = '(I02)')
;outfile_1 = '/home/ksimunac/Output/'+'PLA_ST'+sat+'_'+label_year+label_month+label_day+'_defl.txt'
;openw, out_lun_1, outfile_1, /GET_LUN
;line = ' '
;temp_string = 'YEAR'+TAB+'DOY'+TAB+'HOUR'+TAB+'MIN'+TAB+'SEC'+TAB+'DATE AND TIME'+TAB+$
;	'ST'+sat+' S_peak'+TAB+'ST'+sat+' S_FWHM'+TAB+'ST'+sat+' Main_peak'+TAB+'ST'+sat+' Main_FWHM'
;printf, out_lun_1, temp_string
;
;FOR ii = 0, num_records5-1 DO BEGIN
;	apid_time = time_struct(epoch5(ii))
;	YEAR = STRING(apid_time.year, FORMAT = '(I04)')
;	DOY = STRING(apid_time.doy, FORMAT = '(I03)')
;	HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
;	MIN = STRING(apid_time.min, FORMAT = '(I02)')
;	SEC = STRING(apid_time.sec, FORMAT = '(I2.2)')
;	S_peak = STRING(S_MAX(ii), FORMAT = '(F0.2)')
;	S_FWHM = STRING(S_width(ii), FORMAT = '(F0.2)')
;	Main_peak = STRING(MAIN_MAX(ii), FORMAT = '(F0.2)')
;	Main_FWHM = STRING(Main_width(ii), FORMAT = '(F0.2)')
;
;	temp_string = YEAR+TAB+DOY+TAB+HOUR+TAB+MIN+TAB+SEC+TAB+STRING(apid_time.month, format = '(I2.2)')+'/'+$
;	STRING(apid_time.date, format = '(I2.2)')+'/'+STRING(apid_time.year, format = '(I4.4)')+' '+$
;	STRING(apid_time.hour, format = '(I2.2)')+':'+STRING(apid_time.min, format = '(I2.2)')+':'+$
;	STRING(apid_time.sec, format = '(I2.2)')+TAB+S_peak+TAB+S_FWHM+TAB+Main_peak+TAB+Main_FWHM
;
;	IF apid_time.year NE 1970 THEN printf, out_lun_1, temp_string
;
;ENDFOR
;
;CLOSE, out_lun_1
;FREE_LUN, out_lun_1
;
;STOP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

END

