;+
;PROCEDURE: calc_proton_alpha_data
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  The proton distribution function is subtracted off
;	the full resolution rate data, and the remained is fit with another gaussian to obtain alpha
;	bulk parameter data.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 25 November 2009
;
;MODIFICATION HISTORY:
;	19 November 2009:  created
;	25 November 2009:  added check to see if expected alpha
;			peak is in the main or small channel
;
;
;-




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO calc_proton_alpha_data, v, avg_v, dist_funct, delta_dist_funct, coeff_alpha, $
	density_alpha, avg_v_alpha, temp_K_alpha, v_th_alpha, good_fit_alpha, $
	coeff, num_records1, expected_peak_channel, s_chan
compile_opt strictarrsubs

dist_funct_alpha = dblarr(num_records1,128)
dist_funct_alpha(*,*) = !values.d_nan
peak_dist_alpha = intarr(num_records1)
peak_dist_alpha(*) = -1

v_alpha = fltarr(128)
v_alpha(*) = !values.f_nan
v_alpha = v/SQRT(2.0)
FOR n=0L, num_records1-1 DO BEGIN
	diff_min = 1.0E10
	FOR ll=64,127 DO BEGIN
		z = -1.0
		z = (v(ll)-coeff(3*n+1))/coeff(3*n+2)
	
		; multiply by factor of two to account for difference in v_p^2 and v_alpha^2

		dist_funct_alpha(128*n+ll) = 2.0*(dist_funct(128*n+ll)-(coeff(3*n+0)*Exp(-0.5*z^2.0)))
		IF dist_funct_alpha(128*n+ll) LT 0 THEN dist_funct_alpha(128*n+ll) = 0.0
		; find the ESA step where the peak is expected, IF v_proton is about equatl to v_alpha
		diff_v = v_alpha(ll) - 1000.0*avg_v(n) ; factor of 1000 accounts for difference in units (km/s and m/s)
		IF ABS(diff_v) LE ABS(diff_min) THEN BEGIN
			diff_min = diff_v
			peak_dist_alpha(n) = ll
		ENDIF

	ENDFOR

; Check to see if the expected alpha peak is in the small or main channel
IF peak_dist_alpha(n) GT (s_chan(n)+3) THEN expected_peak_channel(n) = 0 ; small channel
IF (peak_dist_alpha(n) LE (s_chan(n)+3)) AND (peak_dist_alpha(n) GE (s_chan(n)-3)) THEN expected_peak_channel(n) = 1 ; mixed small and main
IF peak_dist_alpha(n) LT (s_chan(n)-3) THEN expected_peak_channel(n) = 2 ; main channel


	temp_alpha = dblarr(3)
	temp_alpha(*) = -1.0
	;guess_0 = dblarr(3)
	;guess_0(*) = !values.d_nan
	red_chi_alpha = !values.f_nan


	IF (peak_dist_alpha(n) LT 123) AND (peak_dist_alpha(n) GE 66) THEN BEGIN ; changed from 119 to 123 by KDCS, 12 October 2009
        	k = 128*n+peak_dist_alpha(n)-4 ;2 
        	m = 128*n+peak_dist_alpha(n)+4 ;4
		;delta_dist_funct(k:m) = 2.0*MAX(delta_dist_funct(k:m)) ; see factor of 2 in alpha distribution function 
		delta_dist_funct(k:m) =0.05*MAX(dist_funct(k:m))
			FIT_MATRIX = GAUSSFIT(double(v_alpha(peak_dist_alpha(n)-4:peak_dist_alpha(n)+4)), double(dist_funct_alpha(k:m)), double (temp_alpha), $
				nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi_alpha)
			coeff_alpha(3*n) = temp_alpha(0)
			coeff_alpha(3*n+1) = temp_alpha(1)
			coeff_alpha(3*n+2) = temp_alpha(2)
		
        		density_alpha(n) = coeff_alpha(3*n)*((2*!PI)^(0.5))*coeff_alpha(3*n+2)*1.0E-11 ; 1/cc ; changed from 2 pi ^ 1/2 which gave a result of 1 (13 August, 2007)
        		avg_v_alpha(n) = coeff_alpha(3*n+1)*1.0E-3 ; km/s
        		temp_K_alpha(n) = (coeff_alpha(3*n+2)^2)*(4*1.67E-27)/(1.38E-23) ;deg K
        		v_th_alpha(n) = SQRT(2)*(coeff_alpha(3*n+2))*1.0E-3 ; km/s
			good_fit_alpha(n) = red_chi_alpha
			y = 0.0
			y = avg_v_alpha(n) - avg_v(n)

			IF (y GE 100) OR (y LE -20) OR (avg_v_alpha(n) LT 230) OR (avg_v_alpha(n) GT 625) OR (density_alpha(n) LE 0) THEN BEGIN
				avg_v_alpha(n) = !values.f_nan
				density_alpha(n) = !values.f_nan
				temp_K_alpha(n) = !values.f_nan
				v_th_alpha(n) = !values.f_nan
				good_fit_alpha(n) = !values.f_nan
			ENDIF

	ENDIF

;IF bkgd EQ 2 AND n EQ 2089 THEN BEGIN
;	FOR i = 64, 127 DO BEGIN
;		PRINT, dist_funct_alpha(128*n+i)
;	ENDFOR
;	STOP
;
;	FOR j = 64, 127 DO BEGIN
;		PRINT, delta_dist_funct(128*n+j)
;	ENDFOR
;	PRINT, ' '
;	PRINT, temp_alpha(0)
;	PRINT, temp_alpha(1)
;	PRINT, temp_alpha(2)
;	PRINT, avg_v_alpha(n)
;	PRINT, density_alpha(n)
;	STOP
;ENDIF

ENDFOR

END
