;+
;PROCEDURE: calc_proton_raw_ascii_1hour
;PURPOSE: A subroutine of calc_proton_bulk_v2.  Raw results are printed to an ascii file.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 25 November 2009
;
;MODIFICATION HISTORY:
;	23 November 2009:  created
;	25 November 2009:  added column to alpha output indicating likely s or main channel data 
;       09/24/2020: LBE: Remove reference to Kristin's directory. Now prints in current directory.
;
;-



PRO calc_alpha_raw_ascii_1hour, sat, hour_start_time, k, hour_n_alpha, hour_v_alpha, hour_vth_alpha, hour_NatoNp, hour_Va_Vp, hour_count, hour_count_v, hour_count_NatoNp

	TAB = STRING(9B)
	label_time = time_struct(hour_start_time(0))
	label_year = STRING(label_time.year, FORMAT = '(I04)')
	label_month = STRING(label_time.month, FORMAT = '(I02)')
	label_day = STRING(label_time.date, FORMAT = '(I02)')
	outfile_5 = 'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_raw_1hour_alpha.txt'
	openw, out_lun_5, outfile_5, /GET_LUN
	line = ' '
	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'date and time'+tab+$
		'ST'+sat+'Va [km/s]'+tab+'Na [1/cc]'+tab+'Vtha [km/s]'+tab+'Na/Np'+tab+'Va-Vp [km/s]'+tab+$
		'Alpha Cycles'+tab+'Speed Cycles'+tab+'Na/Np cycles'
	printf, out_lun_5, temp_string

	FOR nn=0L, k-1 DO BEGIN
           apid_time = time_struct(hour_start_time(nn))
           YEAR = STRING(apid_time.year, FORMAT = '(I04)')
           DOY = STRING(apid_time.doy, FORMAT = '(I03)')
           HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
           MIN = STRING (apid_time.min, FORMAT = '(I02)')
           if finite(hour_v_alpha[nn]) then V_alpha = STRING(round(hour_v_alpha(nn)), FORMAT ='(I4)') $
              else V_alpha = 'NaN'
           Na = STRING(hour_n_alpha(nn), FORMAT = '(F0.4)')
           Vtha = STRING(hour_vth_alpha(nn), FORMAT = '(F0.1)')
           Na_Np = STRING(hour_NatoNp(nn), FORMAT = '(F0.4)')
           if finite(hour_Va_Vp[nn]) then V_diff = STRING(round(hour_Va_Vp(nn)), FORMAT = '(I3)') $
           else V_diff = 'NaN'
           cycles = STRING(hour_count(nn), FORMAT = '(I3)')
           v_cycles = STRING(hour_count_v(nn), FORMAT = '(I3)')
           NaNp_cycles=STRING(hour_count_NatoNp(nn), FORMAT = '(I3)')
		
           temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+STRING(apid_time.month, format ='(I2.2)')+'/'+$
                         STRING(apid_time.date, format = '(I2.2)')+'/'+$
                         string(apid_time.year, format = '(I4.4)')+' '+$
                         STRING(apid_time.hour, format = '(I2.2)')+':'+$
                         STRING(apid_time.min, format = '(I2.2)')+tab+$
                         V_alpha+tab+Na+tab+Vtha+tab+Na_Np+tab+V_diff+$
                         tab+cycles+tab+v_cycles+tab+NaNp_cycles

           IF apid_time.year NE 1970 THEN printf, out_lun_5, temp_string
	ENDFOR

	CLOSE, out_lun_5
	FREE_LUN, out_lun_5

END


