;+
;PROCEDURE: calc_alpha_data
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  The proton distribution function is subtracted off
;	the full resolution rate data, and the remained is fit with another gaussian to obtain alpha
;	bulk parameter data.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION:  September 2011
;
;MODIFICATION HISTORY:
;	19 November 2009:  created
;	25 November 2009:  added check to see if expected alpha
;			peak is in the main or small channel
;	June - July 2011: added main channel speeds and efficiencies
;			also changed valid limit on v_thermal_alpha
;			 from 1.25*v_th_proton to 1.50*v_th_proton 
;
;	September 2011: added calculation of Na/Np and Va - Vp for
;			easier averaging later
;       09/24/2020: LBE: Add argument table_location	
;
;-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;PRO gaussfunct, X, A, F;, pder
;Z = (X-A(1))/A(2)
;F = A(0)*EXP(-0.5*(Z^2.0))
;pder= [F/A(0),F*((X - A(1))/(A(2)^2.0)),F*((X - A(1))^2.0/A(2))]
;END

PRO calc_alpha_data, v_S, v_main, avg_v, density, v_th, dist_funct, delta_dist_funct, coeff_alpha, $
	density_alpha, avg_v_alpha, temp_K_alpha, v_th_alpha, good_fit_alpha, $
	coeff, num_records1, expected_peak_channel, s_chan, sat, epoch1, std_error, caution_flag, $
	Na_to_Np, Va_Vp, alpha_caution, table_location



;X_init = !values.f_nan
;A_init = fltarr(3)
;A_init(*) = !values.f_nan
;F_init = !values.f_nan
;pder_init = fltarr(3)
;pder_init(*) = !values.f_nan
;gaussfunct, X_init, A_init, F_init;, pder_init

dist_funct_alpha = dblarr(num_records1,128)
dist_funct_alpha(*,*) = !values.d_nan
peak_dist_alpha = intarr(num_records1)
peak_dist_alpha(*) = -1
peak_dist_alpha_main = intarr(num_records1)
peak_dist_alpha_main(*) = -1
peak_dist_alpha_S = intarr(num_records1)
peak_dist_alpha_S(*) = -1

v_alpha = fltarr(128)
v_alpha(*) = !values.f_nan

v_alpha_S = fltarr(128)
v_alpha_S(*) = !values.f_nan
v_alpha_S = v_S/SQRT(2.0)

eff_alpha = fltarr(128)
eff_alpha(*) = !values.f_nan
eff_alpha_main = fltarr(128)
eff_alpha_main(*) = !values.f_nan


; Read in main channel ESA table
v_alpha_main = fltarr(128)
v_alpha_main(*) = !values.f_nan
v_alpha_main = v_main/SQRT(2.0)

; Read in small channel alpha efficiency table 

IF sat EQ 'B' THEN alpha_eff = table_location+'B_alpha_table_v7.txt'
;IF sat EQ 'B' THEN alpha_eff = '/home/ksimunac/Tables/B_alpha_table_v7.txt'
IF sat EQ 'A' THEN alpha_eff = table_location+'A_alpha_table_v7c.txt'
OPENR, IN_LUN_1, alpha_eff, /GET_LUN
LINE = ','
READF, IN_LUN_1, LINE ; READ THE HEADER LINE

FOR jj = 0,63 DO BEGIN
	READF, IN_LUN_1, LINE
	PARTS = STRSPLIT(LINE, ',', /EXTRACT)
	eff_alpha(64+jj) = parts(1)
ENDFOR

CLOSE, IN_LUN_1
FREE_LUN, IN_LUN_1


; Read in main channel alpha efficiency table 
IF sat EQ 'B' THEN alpha_eff = table_location+'B_alpha_table_main_v2b.txt'; 2b
IF sat EQ 'A' THEN alpha_eff = table_location+'A_alpha_table_main_v3c.txt'
OPENR, IN_LUN_1, alpha_eff, /GET_LUN
LINE = ','
READF, IN_LUN_1, LINE ; READ THE HEADER LINE

FOR jj = 0,127 DO BEGIN
	READF, IN_LUN_1, LINE
	PARTS = STRSPLIT(LINE, ',', /EXTRACT)
	eff_alpha_main(jj) = parts(1)
ENDFOR

CLOSE, IN_LUN_1
FREE_LUN, IN_LUN_1


FOR n=0L, num_records1-1 DO BEGIN
	diff_min_S = 1.0E10
	diff_min_main = 1.0E10
	v = fltarr(128)
	v(*) = !values.f_nan
	FOR ll=64,127 DO BEGIN
		IF ll GE s_chan(n) THEN v(ll) = v_S(ll) ELSE v(ll) = v_main(ll)
		z = -1.0
		z = (v(ll)-coeff(3*n+1))/coeff(3*n+2)
	
		; multiply by factor of two to account for difference in v_p^2 and v_alpha^2
		; and subtract off the proton distribution found earlier (coeff and z are from
		; proton fitting)	
		dist_funct_alpha(128*n+ll) = 2.0*(dist_funct(128*n+ll)-(coeff(3*n+0)*Exp(-0.5*z^2.0)))
		delta_dist_funct(128*n+ll) = 2.0*delta_dist_funct(128*n+ll)
	
		; divide through by another empirically determined higher order efficiency correction 
			IF ll GE s_chan(n) THEN BEGIN
				dist_funct_alpha(128*n+ll) = dist_funct_alpha(128*n+ll)/eff_alpha(ll)
				delta_dist_funct(128*n+ll) = delta_dist_funct(128*n+ll)/eff_alpha(ll)
			ENDIF ELSE BEGIN
				dist_funct_alpha(128*n+ll) = dist_funct_alpha(128*n+ll)/eff_alpha_main(ll)/2.0 
				delta_dist_funct(128*n+ll) = delta_dist_funct(128*n+ll)/eff_alpha_main(ll)/2.0
			ENDELSE

		; If BEHIND, remove the data point at the s channel switch
			IF (sat EQ 'B') AND (ll EQ s_chan(n)) THEN dist_funct_alpha(128*n+ll) = !values.f_nan

		; Remove any values that are less than 0		
		IF dist_funct_alpha(128*n+ll) LT 0 THEN dist_funct_alpha(128*n+ll) = 0.0

		; find the ESA step where the peak is expected, IF v_proton is about equatl to v_alpha
		diff_v_S = v_alpha_S(ll) - 1000.0*avg_v(n) ; factor of 1000 accounts for difference in units (km/s and m/s)
		IF ABS(diff_v_S) LE ABS(diff_min_S) THEN BEGIN
			diff_min_S = diff_v_S
			peak_dist_alpha_S(n) = ll
		ENDIF

		diff_v_main = v_alpha_main(ll) - 1000.0*avg_v(n) ; factor of 1000 accounts for difference in units (km/s and m/s)
		IF ABS(diff_v_main) LE ABS(diff_min_main) THEN BEGIN
			diff_min_main = diff_v_main
			peak_dist_alpha_main(n) = ll
		ENDIF
	ENDFOR



	; Check to see if the expected alpha peak is in the small or main channel
		IF peak_dist_alpha_S(n) GT (s_chan(n)+3) THEN BEGIN
			expected_peak_channel(n) = 0 ; small channel
			peak_dist_alpha(n) = peak_dist_alpha_S(n)
		ENDIF

		IF (peak_dist_alpha_S(n) LE (s_chan(n)+3)) AND (peak_dist_alpha_S(n) GE (s_chan(n)-3)) THEN BEGIN
			expected_peak_channel(n) = 1 ; mixed small and main
			IF (peak_dist_alpha_S(n) LE s_chan(n)) THEN peak_dist_alpha(n) = peak_dist_alpha_S(n) ELSE peak_dist_alpha(n) = peak_dist_alpha_main(n)
		ENDIF

		IF peak_dist_alpha_S(n) LT (s_chan(n)-3) THEN BEGIN
			expected_peak_channel(n) = 2 ; main channel
			peak_dist_alpha(n) = peak_dist_alpha_main(n)
		ENDIF

        ;  Get rid of any proton counts that didn't get subtracted out by eliminating points
	;  more than 3  ESA steps beyond the expected peak ; changed from 2 to 3 01/30/2012 
        mm = 128*n+peak_dist_alpha(n)+3 
	IF (mm+1) LT (128*n+127) THEN dist_funct_alpha(mm+1:128*n+127) = !values.f_nan

 
	; Now find the peak of the remaining data -- it should be within a few ESA steps of the expected peak
	; Also set the alpha velocity to either the main or s channel value
	peak_count = 0.0
	real_peak = -1
		FOR nn=64, 127 DO BEGIN
			IF dist_funct_alpha(128*n+nn) GT peak_count THEN peak_count = dist_funct_alpha(128*n+nn)
			IF dist_funct_alpha(128*n+nn) GE peak_count THEN real_peak = nn
			IF nn GE s_chan(n) THEN v_alpha(nn) = v_alpha_S(nn) ELSE v_alpha(nn) = v_alpha_main(nn)
		ENDFOR

	temp_alpha = dblarr(3)
	temp_alpha(*) = -1.0
	guess_0 = dblarr(3)
	guess_0(*) = !values.d_nan
	red_chi_alpha = !values.f_nan
	loops = -1
	success = -1

;	IF (real_peak LT 124) AND (real_peak GE 67) AND (std_error(n) NE 1) AND (std_error(n) NE 5) AND (avg_v(n) LT 620) THEN BEGIN ; changed from 119 to 123 by KDCS, 12 October 2009
;       	k = 128*n+real_peak-3 ; changed from 2 to 3 01/31/2012
;	      	m = 128*n+real_peak+3 ; changed from 2 to 3 01/31/2012
;		IF (sat EQ 'B') AND (real_peak GE s_chan(n)) THEN delta_dist_funct(k:m) = 0.1*MAX(dist_funct_alpha(k:m),/NAN); calculated error bars can be on the order of 30%!			


IF (peak_dist_alpha(n) LT 124) AND (peak_dist_alpha(n) GE 67) AND (std_error(n) NE 1) AND (std_error(n) NE 5) AND (avg_v(n) LT 620) THEN BEGIN
	 jj = -1
	IF avg_v(n) GE 450 THEN jj = 3
	IF avg_v(n) LT 450 THEN jj = 2
        	k = 128*n+peak_dist_alpha(n)-jj;2 
        	m = 128*n+peak_dist_alpha(n)+jj;3 
		IF (sat EQ 'B') AND (peak_dist_alpha(n) GE s_chan(n)) THEN delta_dist_funct(k:m) = 0.1*MAX(dist_funct_alpha(k:m),/NAN); calculated error bars can be on the order of 30%!			
			guess_0(0) = 0.04*density(n)*1.0E8/(SQRT(!PI))/v_th(n)
			guess_0(1) = avg_v(n)*1.0E3
			guess_0(2) = 0.0
			;IF avg_v(n) LT 400 THEN BEGIN
			;	guess_0(2) = 0.5*v_th(n)*1.0E3/SQRT(2.0)
			;ENDIF ELSE BEGIN
			;	guess_0(2) = v_th(n)*1.0E3/SQRT(2.0)
			;ENDELSE
			temp_alpha = guess_0
			;FIT_MATRIX = CURVEFIT(v_alpha(real_peak-2:real_peak+2), dist_funct_alpha(k:m), 1.0, temp_alpha, $
			;/DOUBLE, chisq=red_chi_alpha, iter = loops, itmax = 50, status = success, FUNCTION_NAME = 'gaussfunct', /NODERIVATIVE)

			FIT_MATRIX = GAUSSFIT(double(v_alpha(peak_dist_alpha(n)-jj:peak_dist_alpha(n)+jj)), double(dist_funct_alpha(k:m)), double (temp_alpha), $
				nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi_alpha, estimates = guess_0)
			coeff_alpha(3*n) = temp_alpha(0)
			coeff_alpha(3*n+1) = temp_alpha(1)
			coeff_alpha(3*n+2) = temp_alpha(2)
		
        		density_alpha(n) = coeff_alpha(3*n)*((2.0*!PI)^(0.5))*coeff_alpha(3*n+2)*1.0E-11 ; 1/cc
        		avg_v_alpha(n) = coeff_alpha(3*n+1)*1.0E-3 ; km/s
        		temp_K_alpha(n) = (coeff_alpha(3*n+2)^2)*(4*1.67E-27)/(1.38E-23) ;deg K
        		v_th_alpha(n) = SQRT(2.0)*(coeff_alpha(3*n+2))*1.0E-3 ; km/s
			good_fit_alpha(n) = red_chi_alpha
			y = 0.0
			y = avg_v_alpha(n) - avg_v(n)
			Va_Vp(n) = y
			Na_to_Np(n) = density_alpha(n)/density(n)
			IF (density_alpha(n) GT 2.0) OR (density(n) LT 1.0) THEN BEGIN
				alpha_caution(n)=2
				Na_to_Np(n) = !values.f_nan
			ENDIF
			IF ((density_alpha(n) LT 2.0) AND (density_alpha(n) GT 1.0)) OR ((density(n) GE 1.0) AND (density(n) LT 1.5)) OR $
				(density_alpha(n) LT 0.01) THEN BEGIN
					IF alpha_caution(n) NE 2 THEN alpha_caution(n) = 1
			ENDIF


;;;;Plot distribution function and fit.
now_time = time_struct(epoch1(n))
IF now_time.year EQ 2020 AND $
	now_time.month EQ 12 AND $
	now_time.date EQ 26 THEN BEGIN; AND $
; 	now_time.hour EQ 9 THEN BEGIN ; AND $
;	(now_time.min MOD 10) EQ 0 THEN BEGIN
	
	print, 'Year, Month, Day, Hour, Minute:',  now_time.year,now_time.month,now_time.date, now_time.hour, now_time.min
	print, ' '
	FOR l=64, 127 DO BEGIN
		PRINT, v_alpha(l)
	ENDFOR
	PRINT, ' '
	PRINT, s_chan(n)
	STOP

	FOR i = 64, 127 DO BEGIN
		PRINT, dist_funct_alpha(128*n+i)
	ENDFOR
	STOP
	
	FOR j = 64, 127 DO BEGIN
		PRINT, delta_dist_funct(128*n+j)
	ENDFOR
	PRINT, ' '
	STOP

	now_fit = fltarr(128)
	now_fit(*) = !values.f_nan
	FOR tt=0, 127 DO BEGIN
		z = !values.f_nan
		z = (v_alpha(tt)-coeff_alpha(3*n+1))/coeff_alpha(3*n+2)
		now_fit(tt) = coeff_alpha(3*n+0)*EXP(-0.5*z^2.0)
	ENDFOR

	FOR k = 64, 127 DO BEGIN
		PRINT, now_fit(k)
	ENDFOR
	STOP
	
	LOADCT, 39, NCOLORS = 256
	!P.BACKGROUND = 0
	PLOT, v_alpha(0:127), dist_funct_alpha(128*n:128*n+127), PSYM = 4, COLOR = 255, XTITLE = 'Alpha Speed [m/s]', YTITLE = 'f(v)', $
		XRANGE = [2E5, 8E5], YLOG = 1, /YNOZERO, YRANGE = [1000, 1e8]
	OPLOTERR, v_alpha(0:127), dist_funct_alpha(128*n:128*n+127), delta_dist_funct(128*n:128*n+127)
	;OPLOT, v_alpha(real_peak-jj:real_peak+jj), dist_funct_alpha(k:m), PSYM = 4, COLOR = 50
	OPLOT, v_alpha(0:127), now_fit(0:127), COLOR = 150 

	print, 'Year, Month, Day, Hour, Minute:',  now_time.year,now_time.month,now_time.date, now_time.hour, now_time.min
	print, ' '
	PRINT, 'Alpha speed:',avg_v_alpha(n)
	PRINT, 'Alpha density:',density_alpha(n)
	PRINT, 'Alpha v_thermal:', v_th_alpha(n)
	PRINT, 'Reduced Chi Sqare:',good_fit_alpha(n)
	PRINT, ' '
	PRINT, 'Proton Speed:',avg_v(n)

	STOP


ENDIF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

			IF (y GE 100) OR (y LE -20) OR (avg_v_alpha(n) LT 230) OR (avg_v_alpha(n) GE 620) OR (density_alpha(n) LT 0.001) $
			 OR (v_th_alpha(n) GE 200) OR (v_th_alpha(n) LT 1) OR (v_th_alpha(n) GT 2.0*v_th(n)) OR (v_th_alpha(n) LT 0.25*v_th(n)) $
			 OR (good_fit_alpha(n) GT 25) OR (FINITE(good_fit_alpha(n)) EQ 0) THEN BEGIN ; changed limit on v_thermal to 2.0*v_th_protons
				density_alpha(n) = !values.f_nan
				avg_v_alpha(n) = !values.f_nan
				temp_K_alpha(n) = !values.f_nan
				v_th_alpha(n) = !values.f_nan
				good_fit_alpha(n) = !values.f_nan
				Na_to_Np(n) = !values.f_nan
				Va_Vp(n) = !values.f_nan
				alpha_caution(n) = -1
			ENDIF

			IF (caution_flag(n) NE 0) THEN BEGIN
				density_alpha(n) = !values.f_nan
				temp_K_alpha(n) = !values.f_nan
				v_th_alpha(n) = !values.f_nan
				Na_to_Np(n) = !values.f_nan
				alpha_caution(n) = 2
			ENDIF

	ENDIF ELSE BEGIN
			y = !values.f_nan
			alpha_caution(n) = -1
	ENDELSE
ENDFOR

END
