;+
;PROCEDURE: calc_alpha_background_subtract
;PURPOSE:  A subroutine called by calc_alpha_bulk.  
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 01 November 2010 
;
;MODIFICATION HISTORY:
;    01 November 2010:  KDCS created
;-


PRO calc_alpha_background_subtract, full_data, caution_flag, num_records1, full_data_no_bkgd2, delta_counts_less_bkgd, sat

; define arrays to store the number of background counts
; this is the second background subtraction technique from the proton code, but modified
; so that the minimum background subtraction is 2 if the spacecraft is B
bkgd1 = fltarr(num_records1)
bkgd1(*) = !values.f_nan
bkgd2 = fltarr(128, num_records1)
bkgd2(*,*) = !values.f_nan

; define arrays to store the data after the background has been subtracted
full_data_no_bkgd1 = fltarr(128,32,num_records1)
full_data_no_bkgd1(*,*,*) = !values.f_nan


; define arrays to store the uncertainties (deltas)
delta_counts = fltarr(128,32,num_records1)
delta_counts(*,*,*) = !values.f_nan
delta_bkgd = fltarr(128,num_records1)
delta_bkgd(*,*) = !values.f_nan

;; Background Subtraction 1
;;-------------------------------------------------------------------------
;; See how many background counts there are.  Average the counts in ESA step
;; 127, DEFL steps 0, 1, 30, and 31.
    
       FOR mm = 0L, num_records1-1 DO BEGIN
        bkgd1[mm] = ((full_data(mm*4096+127)+full_data(mm*4096+255)+full_data(mm*4096+3967)+full_data(mm*4096+4095))/4.0)
        IF (bkgd1(mm)) LT 1 THEN bkgd1(mm) = 1.0 ; modified January 2010
          ; Subtract out background
        	FOR nn = 0,127 DO BEGIN
			FOR oo = 0,31 DO BEGIN
			full_data_no_bkgd1[nn, oo, mm] = full_data(nn, oo, mm) - bkgd1(mm)
			; We don't want a negative count rate, so check for negative result.
			IF full_data_no_bkgd1[nn,oo,mm] LT 0 THEN full_data_no_bkgd1[nn,oo,mm] = 0.0	
			ENDFOR
		ENDFOR
    ENDFOR
;; Background Subtraction 2
;;---------------------------------------------------------------------------------
;; Subtract out different background level for each ESA step -- added 31 August, 2007
;; to see if this removes contamination from WAP
       
    delta_counts = SQRT(full_data)
        FOR mm = 0L, num_records1-1 DO BEGIN
        	FOR nn = 0, 127 DO BEGIN
            	bkgd2[nn, mm] = ((full_data(nn, 31, mm)+full_data(nn, 0, mm))/2.0)
	    	delta_bkgd[nn,mm] = 0.5*SQRT(full_data(nn, 31, mm)+full_data(nn, 0, mm))

		; !!! THIS MINIMUM BACKGROUND MAY BE DIFFERENT FROM THE PROTON CODE !!!
		IF sat EQ 'A' THEN IF (bkgd2(nn, mm)) LT 1 THEN bkgd2(nn, mm) = 1.0 ; 
		IF sat EQ 'B' THEN IF (bkgd2(nn, mm)) LT 1 THEN bkgd2(nn, mm) = 2.0 ; changed from 1 to 2 July 2013

	; Subtract out background
            full_data_no_bkgd2[nn, *, mm] = full_data(nn, *, mm)- bkgd2(nn, mm)
	    delta_counts_less_bkgd[nn,*,mm]=SQRT(delta_counts(nn,*,mm)^2.0+delta_bkgd[nn,mm]^2.0)
		FOR oo = 0,31 DO BEGIN
			; We don't want a negative count rate, so check for negative result.
			IF full_data_no_bkgd2[nn,oo,mm] LT 0 THEN full_data_no_bkgd2[nn,oo,mm] = 0.0	
		ENDFOR
        ENDFOR
    ENDFOR


;; Compare the results of the background subtraction.  Density is proportional to the integral
;; of the distribution function.  The integral is like a summation of the counts.  So, we 
;; compare the total number of counts for each time step resulting from the two background
;; subtraction techniques to see how much they differ.


count_ratio = fltarr(num_records1)
count_ratio(*) = !values.f_nan
count2 = fltarr(num_records1)
count2(*) = !values.f_nan
count1 = fltarr(num_records1)
count1(*) = !values.f_nan

FOR i = 0L, num_records1-1 DO BEGIN

	count2(i) = TOTAL(full_data_no_bkgd2(*,*,i), /NAN)
	count1(i) = TOTAL(full_data_no_bkgd1(*,*,i), /NAN)
	count_ratio(i) = count2(i)/count1(i)
	IF count_ratio(i) GT 0.95 AND count_ratio(i) LT 1.05 THEN caution_flag(i) = 0
	IF (count_ratio(i) GT 0.90 AND count_ratio(i) LE 0.95) OR $
		(count_ratio(i) GE 1.05 AND count_ratio(i) LT 1.10) THEN caution_flag(i) = 1
	IF count_ratio(i) LE 0.90 OR count_ratio(i) GE 1.10 THEN caution_flag(i) = 2
ENDFOR  


;; reduce memory usage by setting arrays to 0 that will not be used further
full_data = 0               
delta_counts = 0
bkgd2 = 0


print, 'Background has been subtracted out.'

END




