; 10/14/2008 LBE: Created -- NB: There are many other variables that could be added!

PRO get_wind_swe_alphas
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

WIND_SWE_PATH = GETENV('WINDDATA')+'/swe/'
wind_file = wind_swe_path+'ap.mission.selected.2007_2010.sav'

found = file_test(wind_file)
IF found EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

; read data
restore, wind_file

doys = data.doy
doy_to_month_date, data.year, doys, months, dates
day_parts = doys - fix(doys)    ; find partial days
num_secs = round(day_parts * 86400) ; not worrying about milliseconds
hours = num_secs / 3600
mins = (num_secs - (hours * 3600)) / 60
secs = (num_secs - (hours * 3600) - (mins * 60)) 
time_strings = string(data.year, format = '(I4.4)')+'-'+string(months, format = '(I2.2)')+'-'+string(dates, format = '(I2.2)')+$
  '/'+string(hours, format = '(I2.2)')+':'+string(mins, format = '(I2.2)')+':'+string(secs, format = '(I2.2)')
full_times = time_double(time_strings)
    
get_timespan, ts
wanted_i = where(full_times GE ts[0] AND full_times LE ts[1], count)
IF count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for this time'
    RETURN
ENDIF
times = full_times[wanted_i]

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'wind_swe_'

store_data, varstr+'alpha_density', $
            data = {x:times, y:data.na[wanted_i]}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'alpha!C!Cn (cm!U-3!N)'}
bulk_speed = sqrt(data.vxa[wanted_i]^2 + data.vya[wanted_i]^2 + data.vza[wanted_i]^2)
store_data, varstr+'alpha_bulk_speed', $
            data = {x:times, y:bulk_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'proton_density', $
            data = {x:times, y:data.np[wanted_i]}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'proton!C!Cn (cm!U-3!N)'}
bulk_speed = sqrt(data.vxp[wanted_i]^2 + data.vyp[wanted_i]^2 + data.vzp[wanted_i]^2)
store_data, varstr+'proton_bulk_speed', $
            data = {x:times, y:bulk_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'proton!C!CV (km s!U-1!N)'}

; raw data
store_data, varstr+'DOY', $
            data = {x:times, y:data.doy[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'DOY'}
store_data, varstr+'YEAR', $
            data = {x:times, y:data.year[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'YEAR'}
store_data, varstr+'FYEAR', $
            data = {x:times, y:data.fyear[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'FYEAR'}
store_data, varstr+'JD', $
            data = {x:times, y:data.jd[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'JD'}
store_data, varstr+'JD_SOURCE', $
            data = {x:times, y:data.jd_source[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'JD_SOURCE'}
store_data, varstr+'CR_SOURCE', $
            data = {x:times, y:data.cr_source[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'CR_SOURCE'}
store_data, varstr+'VXP', $
            data = {x:times, y:data.vxp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VXP'}
store_data, varstr+'VYP', $
            data = {x:times, y:data.vyp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VYP'}
store_data, varstr+'VZP', $
            data = {x:times, y:data.vzp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VZP'}
store_data, varstr+'NP', $
            data = {x:times, y:data.np[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'NP'}
store_data, varstr+'WPERP', $
            data = {x:times, y:data.wperp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'WPERP'}
store_data, varstr+'WPARP', $
            data = {x:times, y:data.wparp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'WPARP'}
store_data, varstr+'TP', $
            data = {x:times, y:data.tp[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'TP'}
store_data, varstr+'VXA', $
            data = {x:times, y:data.vxa[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VXA'}
store_data, varstr+'VYA', $
            data = {x:times, y:data.vya[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VYA'}
store_data, varstr+'VZA', $
            data = {x:times, y:data.vza[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'VZA'}
store_data, varstr+'NA', $
            data = {x:times, y:data.na[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'NA'}
store_data, varstr+'WPERA', $
            data = {x:times, y:data.wpera[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'WPERA'}
store_data, varstr+'WPARA', $
            data = {x:times, y:data.wpara[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'WPARA'}
store_data, varstr+'TA', $
            data = {x:times, y:data.ta[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'TA'}
store_data, varstr+'DVAP', $
            data = {x:times, y:data.dvap[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'DVAP'}
store_data, varstr+'DNL', $
            data = {x:times, y:data.dnl[wanted_i, *]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'DNL'}
store_data, varstr+'BX', $
            data = {x:times, y:data.bx[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'BX'}
store_data, varstr+'BY', $
            data = {x:times, y:data.by[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'BY'}
store_data, varstr+'BZ', $
            data = {x:times, y:data.bz[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'BZ'}
store_data, varstr+'CHISQ', $
            data = {x:times, y:data.chisq[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'CHISQ'}
store_data, varstr+'FIT', $
            data = {x:times, y:data.fit[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'FIT'}
store_data, varstr+'XGSE', $
            data = {x:times, y:data.xgse[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'XGSE'}
store_data, varstr+'YGSE', $
            data = {x:times, y:data.ygse[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'YGSE'}
store_data, varstr+'ZGSE', $
            data = {x:times, y:data.zgse[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ZGSE'}
store_data, varstr+'HGLAT', $
            data = {x:times, y:data.hglat[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'HGLAT'}
store_data, varstr+'HGRAD', $
            data = {x:times, y:data.hgrad[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'HGRAD'}
store_data, varstr+'HGLON', $
            data = {x:times, y:data.hglon[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'HGLON'}
store_data, varstr+'HGILON', $
            data = {x:times, y:data.hgilon[wanted_i]}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'HGILON'}

END
