; Lorna Ellis
; 11/06/2009
; get_wind_orbit.pro

; This reads the wind radial distance. Reads one data point per hour.

PRO get_wind_rad
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

path = getenv('WINDDATA')+'/orbit/'

get_timespan, ts
ts_st      = time_struct(ts)
start_year = ts_st[0].year
stop_year  = ts_st[1].year
start_doy  = ts_st[0].doy
stop_doy   = ts_st[1].doy
IF ts_st[1].doy EQ 1 AND ts_st[1].hour EQ 0 THEN temp_stop_year = stop_year-1 ELSE temp_stop_year = stop_year

IF start_year EQ stop_year THEN num_days = stop_doy-start_doy+1 ELSE BEGIN
    temp_year = start_year
    IF temp_year EQ 2008 OR temp_year EQ 2012 OR temp_year EQ 2016 OR temp_year EQ 2020 THEN num_days = 366-start_doy+1 $
      ELSE num_days = 365-start_doy+1
    temp_year = temp_year + 1
    WHILE temp_year LT stop_year DO BEGIN
        IF temp_year EQ 2008 OR temp_year EQ 2012 OR temp_year EQ 2016 OR temp_year EQ 2020 THEN num_days = num_days + 366 $
          ELSE num_days = num_days + 365
        temp_year = temp_year + 1
    ENDWHILE
    num_days = num_days + stop_doy - 1
ENDELSE 

wind_rad  = dblarr(num_days*24)
wind_time = strarr(num_days*24)

line = ''
done      = 0
ii        = 0
temp_hour = 0
temp_doy  = start_doy
temp_year = start_year
old_hour  = -1
old_doy   = -1
old_year  = -1
WHILE done EQ 0 DO BEGIN 
    finished_year = 0
    file = path+'wind_rad_'+string(temp_year, format = '(I4.4)')+'.txt'
    found = file_test(file)
    IF found EQ 0 THEN BEGIN
        get_err_no =  1
        get_err_msg =  'No files found for year '+string(temp_year, format = '(I4.4)')
        finished_year = 1
        IF temp_year EQ stop_year THEN done = 1
    ENDIF
    IF done EQ 0 THEN BEGIN 
        openr, in_lun, file, /get_lun
        found = 0
        WHILE found EQ 0 DO BEGIN
            readf, in_lun, line
            parts = strsplit(line, /extract)
            IF n_elements(parts) GT 1 THEN IF parts[0] EQ 'yyyy' THEN found = 1
        ENDWHILE
        readf, in_lun, line     ; read blank line
        
        WHILE eof(in_lun) EQ 0 AND finished_year EQ 0 DO BEGIN 
            readf, in_lun, line
            parts = strsplit(line, /extract)
            year = fix(parts[0])
            doy  = fix(parts[1])
            hour = fix(strmid(parts[2], 0, 2))
            IF old_hour NE hour OR old_doy NE doy OR old_year NE year THEN BEGIN 
                WHILE temp_year LT year DO BEGIN ; missing data
                    wind_rad [ii] = !values.f_nan
                    doy_to_month_date, temp_year, temp_doy, month, date
                    wind_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                                    string(date, format = '(I2.2)')+'/'+string(temp_hour, format = '(I2.2)')+':00:00'
                    ii       =       ii + 1
                    temp_hour = temp_hour + 1
                    IF temp_hour EQ 24 THEN BEGIN
                        temp_doy  = temp_doy + 1
                        temp_hour = 0
                    ENDIF 
                    IF (((temp_year EQ 2008  OR temp_year EQ 2012  OR temp_year EQ 2016  OR temp_year EQ 2020) AND doy EQ 367) OR $
                        ((temp_year NE 2008 AND temp_year NE 2012 AND temp_year NE 2016 AND temp_year NE 2020) AND doy EQ 366)) THEN BEGIN 
                        temp_year = temp_year + 1
                        temp_doy  = 1
                        temp_hour = 0
                    ENDIF 
                ENDWHILE
                IF temp_year EQ year THEN BEGIN 
                    WHILE temp_doy LT doy DO BEGIN ; missing data
                        wind_rad [ii] = !values.f_nan
                        doy_to_month_date, temp_year, temp_doy, month, date
                        wind_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                                        string(date, format = '(I2.2)')+'/'+string(temp_hour, format = '(I2.2)')+':00:00'
                        ii        =       ii + 1
                        temp_hour = temp_hour + 1
                        IF temp_hour EQ 24 THEN BEGIN
                            temp_doy  = temp_doy + 1
                            temp_hour = 0
                        ENDIF 
                    ENDWHILE
                ENDIF 
                IF temp_year EQ year AND temp_doy EQ doy THEN BEGIN
                    WHILE temp_hour LT hour DO BEGIN ; missing data
                        wind_rad [ii] = !values.f_nan
                        doy_to_month_date, temp_year, temp_doy, month, date
                        wind_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                                        string(date, format = '(I2.2)')+'/'+string(temp_hour, format = '(I2.2)')+':00:00'
                        ii        =       ii + 1
                        temp_hour = temp_hour + 1
                    ENDWHILE
                    wind_rad [ii] = double(parts[3])
                    doy_to_month_date, temp_year, temp_doy, month, date
                    wind_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                                    string(date, format = '(I2.2)')+'/'+string(hour, format = '(I2.2)')+':00:00'
                    IF temp_year EQ stop_year AND temp_doy EQ stop_doy AND temp_hour EQ 24 THEN done = 1 ELSE BEGIN
                        ii = ii + 1
                        temp_hour = temp_hour + 1
                        IF temp_hour EQ 24 THEN BEGIN 
                            temp_doy = temp_doy + 1
                            temp_hour = 0
                        ENDIF 
                        IF (((temp_year EQ 2008  OR temp_year EQ 2012  OR temp_year EQ 2016  OR temp_year EQ 2020) AND temp_doy EQ 367) OR $
                            ((temp_year NE 2008 AND temp_year NE 2012 AND temp_year NE 2016 AND temp_year NE 2020) AND temp_doy EQ 366)) THEN $
                          BEGIN 
                            temp_year = temp_year + 1
                            temp_doy  = 1
                            finished_year = 1
                        ENDIF ELSE finished_year = 0
                    ENDELSE 
                ENDIF 
                old_hour  = hour
                old_doy   = doy
                old_year  = year
            ENDIF 
        ENDWHILE 
    ENDIF 
ENDWHILE 

IF ii NE (num_days*24) THEN stop

wind_rad = wind_rad * 6378 ; convert from RE to km
time = time_double(wind_time)
store_data, 'wind_rad', data = {x:time, y: wind_rad}
END

            
