; 11/03/2008 LBE: Created
; 02/04/2009 LBE: Changed pm to 3dp
; 05/14/2009 LBE: Changed pm to 3dp
; 11/17/2009 LBE: Added A_TEMP
; 11/08/2010 LBE: Convert P_TEMP

PRO get_wind_3dp
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'W', 'wind_3dp', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'P_DENS'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_p_dens, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'P_VELS'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_p_vels, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'P_TEMP'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_p_temp, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'A_DENS'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_a_dens, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'A_VELS'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_a_vels, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'A_TEMP'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_a_temp, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'VALID'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_valid, rec_count = epochinfo.maxrec+1, /zvariable
                                    
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch    = REFORM(time_double(epoch, /epoch))
                p_dens             = TRANSPOSE(cdf_p_dens)
                p_vels             = cdf_p_vels
                p_temp             = TRANSPOSE(cdf_p_temp)
                a_dens             = TRANSPOSE(cdf_a_dens)
                a_vels             = cdf_a_vels
                a_temp             = TRANSPOSE(cdf_a_temp)
                valid              = TRANSPOSE(cdf_valid)
            ENDIF ELSE BEGIN
                converted_epoch    = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                p_dens             = [p_dens,           TRANSPOSE(cdf_p_dens)]
                p_vels             = TRANSPOSE([TRANSPOSE(p_vels), TRANSPOSE(cdf_p_vels)])
                p_temp             = [p_temp,           TRANSPOSE(cdf_p_temp)]
                a_dens             = [a_dens,           TRANSPOSE(cdf_a_dens)]
                a_vels             = TRANSPOSE([TRANSPOSE(a_vels), TRANSPOSE(cdf_a_vels)])
                a_temp             = [a_temp,           TRANSPOSE(cdf_a_temp)]
                valid              = [valid,           TRANSPOSE(cdf_valid)]
            ENDELSE
            
            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

; find bulk velocity
p_bulk = reform(sqrt((p_vels[0, *]^2)+(p_vels[1, *]^2)+(p_vels[2, *]^2)))
a_bulk = reform(sqrt((a_vels[0, *]^2)+(a_vels[1, *]^2)+(a_vels[2, *]^2)))
p_temp = p_temp * 1.16E4 ; convert from eV to K
a_temp = a_temp * 1.16E4 ; convert from eV to K
a_vth  = 1.0E-3 * sqrt(2.0 * 1.38E-23 * a_temp / (4.0 * 1.67E-27)) ; sqrt(2kT/m)

IF ifwd EQ 0 THEN BEGIN

    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN

ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

chkind = WHERE(valid NE 1, cchkind)
IF cchkind GT 0 THEN BEGIN 
    p_dens(chkind)    = !VALUES.F_NAN
    p_vels[*, chkind] = !VALUES.F_NAN
    p_bulk(chkind)    = !VALUES.F_NAN
    p_temp(chkind)    = !VALUES.F_NAN
    a_dens(chkind)    = !VALUES.F_NAN
    a_vels[*, chkind] = !VALUES.F_NAN
    a_bulk(chkind)    = !VALUES.F_NAN
    a_temp(chkind)    = !VALUES.F_NAN
    a_vth(chkind)     = !VALUES.F_NAN
ENDIF 


;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'wind_3dp_'

store_data, varstr+'proton_density', $
            data = {x:converted_epoch, y:p_dens}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'proton!C!Cn (cm!U-3!N)'}
store_data, varstr+'proton_velocity', $
            data = {x:converted_epoch, y:p_vels}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'proton!C!CV (km s!U-1!N)'}
store_data, varstr+'proton_bulk_velocity', $
            data = {x:converted_epoch, y:p_bulk}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'proton!C!CV (km s!U-1!N)'}
store_data, varstr+'proton_temperature', $
            data = {x:converted_epoch, y:p_temp}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'proton!C!CT (K)'}
store_data, varstr+'alpha_density', $
            data = {x:converted_epoch, y:a_dens}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'alpha!C!Cn (cm!U-3!N)'}
store_data, varstr+'alpha_velocity', $
            data = {x:converted_epoch, y:a_vels}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_bulk_velocity', $
            data = {x:converted_epoch, y:a_bulk}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_temperature', $
            data = {x:converted_epoch, y:a_temp}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CT (K)'}
store_data, varstr+'alpha_v_therm', $
            data = {x:converted_epoch, y:a_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!Cv_therm (km/s)'}
END
