; 08/03/2011 LBE: Created
; 12/17/2020 LBE: Expect every 20 seconds, not 30
; 12/17/2020 LBE: Fix bug where Bt was going into Br
; 01/08/2021 LBE: Check for empty files.

PRO get_swea_mom, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'swea_mom', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read ASCII files for the specific product related parameters
;------------------------------------------------------------------
line = ''
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        ; set up data arrays
        times_day  = dblarr(5000) ; round up -- expect every 20 seconds
        den_day    = fltarr(5000)
        tpar_day   = fltarr(5000)
        tper1_day  = fltarr(5000)
        tper2_day  = fltarr(5000)
        qr_rtn_day = fltarr(5000)
        qt_rtn_day = fltarr(5000)
        qn_rtn_day = fltarr(5000)
        br_rtn_day = fltarr(5000)
        bt_rtn_day = fltarr(5000)
        bn_rtn_day = fltarr(5000)
        qpar_day   = fltarr(5000)
        qper_day   = fltarr(5000)

        openr, in_lun, filesfound[jj], /get_lun
        readf, in_lun, line
        WHILE (strmid(line, 0, 10) NE 'DATA_UNTIL') and (eof(in_lun) eq 0) DO BEGIN 
            readf, in_lun, line
        ENDWHILE
        kk   = 0
        WHILE eof(in_lun) EQ 0 DO BEGIN
            readf, in_lun, line
            parts = strsplit(line, ',', /extract)
            temp_time = strmid(parts[00], 0, 19)
            strput, temp_time, '/', 10
            times_day [kk] = time_double(temp_time)
            den_day   [kk] = float(parts[03])
            tpar_day  [kk] = float(parts[04])
            tper1_day [kk] = float(parts[05])
            tper2_day [kk] = float(parts[06])
            qr_rtn_day[kk] = float(parts[07])
            qt_rtn_day[kk] = float(parts[08])
            qn_rtn_day[kk] = float(parts[09])
            br_rtn_day[kk] = float(parts[10])
            bt_rtn_day[kk] = float(parts[11])
            bn_rtn_day[kk] = float(parts[12])
            qpar_day  [kk] = float(parts[13])
            qper_day  [kk] = float(parts[14])
            kk = kk+1
        ENDWHILE 

        IF jj EQ 0 THEN BEGIN
            times  = times_day [0:kk-1]
            den    = den_day   [0:kk-1]
            tpar   = tpar_day  [0:kk-1]
            tper1  = tper1_day [0:kk-1]
            tper2  = tper2_day [0:kk-1]
            qr_rtn = qr_rtn_day[0:kk-1]
            qt_rtn = qr_rtn_day[0:kk-1]
            qn_rtn = qn_rtn_day[0:kk-1]
            br_rtn = br_rtn_day[0:kk-1]
            bt_rtn = bt_rtn_day[0:kk-1]
            bn_rtn = bn_rtn_day[0:kk-1]
            qpar   = qpar_day  [0:kk-1]
            qper   = qper_day  [0:kk-1]
        ENDIF ELSE BEGIN
            times  = [ times,  times_day[0:kk-1]]
            den    = [   den,    den_day[0:kk-1]]
            tpar   = [  tpar,   tpar_day[0:kk-1]]
            tper1  = [ tper1,  tper1_day[0:kk-1]]
            tper2  = [ tper2,  tper2_day[0:kk-1]]
            qr_rtn = [qr_rtn, qr_rtn_day[0:kk-1]]
            qt_rtn = [qr_rtn, qr_rtn_day[0:kk-1]]
            qn_rtn = [qn_rtn, qn_rtn_day[0:kk-1]]
            br_rtn = [br_rtn, br_rtn_day[0:kk-1]]
            bt_rtn = [bt_rtn, bt_rtn_day[0:kk-1]]
            bn_rtn = [bn_rtn, bn_rtn_day[0:kk-1]]
            qpar   = [  qpar,   qpar_day[0:kk-1]]
            qper   = [  qper,   qper_day[0:kk-1]]
        ENDELSE 
        close, in_lun
        free_lun, in_lun
    ENDIF 
ENDFOR

; check for fill (-1.0E+31)
bad_den_i    = where(   den LT -1E30, bad_den_count)
bad_tpar_i   = where(  tpar LT -1E30, bad_tpar_count)
bad_tper1_i  = where( tper1 LT -1E30, bad_tper1_count)
bad_tper2_i  = where( tper2 LT -1E30, bad_tper2_count)
bad_qr_rtn_i = where(qr_rtn LT -1E30, bad_qr_rtn_count)
bad_qt_rtn_i = where(qt_rtn LT -1E30, bad_qt_rtn_count)
bad_qn_rtn_i = where(qn_rtn LT -1E30, bad_qn_rtn_count)
bad_br_rtn_i = where(br_rtn LT -1E30, bad_br_rtn_count)
bad_bt_rtn_i = where(bt_rtn LT -1E30, bad_bt_rtn_count)
bad_bn_rtn_i = where(bn_rtn LT -1E30, bad_bn_rtn_count)
bad_qpar_i   = where(  qpar LT -1E30, bad_qpar_count)
bad_qper_i   = where(  qper LT -1E30, bad_qper_count)
IF bad_den_count    GT 0 THEN    den[   bad_den_i] = !values.f_nan
IF bad_tpar_count   GT 0 THEN   tpar[  bad_tpar_i] = !values.f_nan
IF bad_tper1_count  GT 0 THEN  tper1[ bad_tper1_i] = !values.f_nan
IF bad_tper2_count  GT 0 THEN  tper2[ bad_tper2_i] = !values.f_nan
IF bad_qr_rtn_count GT 0 THEN qr_rtn[bad_qr_rtn_i] = !values.f_nan
IF bad_qt_rtn_count GT 0 THEN qt_rtn[bad_qt_rtn_i] = !values.f_nan
IF bad_qn_rtn_count GT 0 THEN qn_rtn[bad_qn_rtn_i] = !values.f_nan
IF bad_br_rtn_count GT 0 THEN br_rtn[bad_br_rtn_i] = !values.f_nan
IF bad_bt_rtn_count GT 0 THEN bt_rtn[bad_bt_rtn_i] = !values.f_nan
IF bad_bn_rtn_count GT 0 THEN bn_rtn[bad_bn_rtn_i] = !values.f_nan
IF bad_qpar_count   GT 0 THEN   qpar[  bad_qpar_i] = !values.f_nan
IF bad_qper_count   GT 0 THEN   qper[  bad_qper_i] = !values.f_nan

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'ST'+sat+'_swea_mom_'

; with error included
store_data, varstr+'Den', $
            data = {x:times, y:den}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Density (cm-3)'}
store_data, varstr+'Tpar', $
            data = {x:times, y:tpar}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Tpar along B (eV)'}
store_data, varstr+'Tper1', $
            data = {x:times, y:tper1}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Tper1 perp B (eV)'}
store_data, varstr+'Tper2', $
            data = {x:times, y:tper2}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Tper2 perp B (eV)'}
store_data, varstr+'Qr', $
            data = {x:times, y:qr_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Qr (erg.sec-1.cm-2)'}
store_data, varstr+'Qt', $
            data = {x:times, y:qt_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Qt (erg.sec-1.cm-2)'}
store_data, varstr+'Qn', $
            data = {x:times, y:qn_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Qn (erg.sec-1.cm-2)'}
store_data, varstr+'Br', $
            data = {x:times, y:br_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Br (nT)'}
store_data, varstr+'Bt', $
            data = {x:times, y:bt_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Bt (nT)'}
store_data, varstr+'Bn', $
            data = {x:times, y:bn_rtn}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Bn (nT)'}
store_data, varstr+'Qpar', $
            data = {x:times, y:qpar}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Qpar (erg.sec-1.cm-2)'}
store_data, varstr+'Qper', $
            data = {x:times, y:qper}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Qper (erg.sec-1.cm-2)'}

END
