; 07/20/2020 LBE: Created data is [time, energy, angle] = [time, 16, 80]

FUNCTION get_swea_dist, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'swea_dist', filesfound
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN, 0
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Distribution'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_dist, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'SWEADistInterval'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_dist_int, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'SWEAModeID'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_mode_id, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'Angle_Bins'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_angles, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Energy'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_energy, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'V0'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_v0, rec_count = epochinfo.maxrec+1, /zvariable

            IF ifwd EQ 0 THEN BEGIN
                converted_epoch    = REFORM(time_double(epoch, /epoch))
                dist               = TRANSPOSE(cdf_dist)
                dist_int           = REFORM(cdf_dist_int)
                mode_id            = transpose(cdf_mode_id)
                angles             = transpose(cdf_angles)
                energy             = transpose(cdf_energy)
                v0                 = transpose(cdf_v0)
            ENDIF ELSE BEGIN
               converted_epoch    = [converted_epoch, REFORM(time_double(epoch, /epoch))]
               dist               = [dist,    TRANSPOSE(cdf_dist)    ]
               dist_int           = [dist_int,   REFORM(cdf_dist_int)]
               mode_id            = [mode_id, transpose(cdf_mode_id) ]
               angles             = [angles,  transpose(cdf_angles)  ]
               energy             = [energy,  transpose(cdf_energy)  ]
               v0                 = [v0,      transpose(cdf_v0)      ]
            ENDELSE
            
            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN, 0
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Construct the data structure
;------------------------------------------------------------------
retdata = {$
          project:           'STEREO/SWEA', $
          prod_name:         'swea_dist', $
          units_name:        'Counts', $
          ntime:             N_ELEMENTS(converted_epoch), $
          time:              converted_epoch, $
          interval:          dist_int, $
          data:              dist, $
          valid:             1, $
          mode_id:           mode_id, $
          angles:            angles, $
          energy:            energy, $
          v0:                v0 $
          } 

RETURN, retdata

END
