; 06/08/2010 LBE: Created

PRO get_soho_mtof_ele
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'A_S', 'soho', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'EPOCH'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'O/H'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_o_h, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Mg/H'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_mg_h, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Fe/H'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_fe_h, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'Fe/O'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_fe_o, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'Mg/Fe'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_mg_fe, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'Vsw'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vsw, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'GSE_POS'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_gse_pos, rec_count = epochinfo.maxrec+1, /zvariable

            IF ifwd EQ 0 THEN BEGIN 
                times   = REFORM(time_double(epoch, /epoch))
                o_h     = REFORM(cdf_o_h)
                mg_h    = REFORM(cdf_mg_h)
                fe_h    = REFORM(cdf_fe_h)
                fe_o    = REFORM(cdf_fe_o)
                mg_fe   = REFORM(cdf_mg_fe)
                vsw     = REFORM(cdf_vsw)
                gse_pos = TRANSPOSE(cdf_gse_pos)
            ENDIF ELSE BEGIN
                times   = [times,   REFORM(time_double(epoch, /epoch))]
                o_h     = [o_h,     REFORM(cdf_o_h)]
                mg_h    = [mg_h,    REFORM(cdf_mg_h)]
                fe_h    = [fe_h,    REFORM(cdf_fe_h)]
                fe_o    = [fe_o,    REFORM(cdf_fe_o)]
                mg_fe   = [mg_fe,   REFORM(cdf_mg_fe)]
                vsw     = [vsw,     REFORM(cdf_vsw)]
                gse_pos = [gse_pos, TRANSPOSE(cdf_gse_pos)]
            ENDELSE
            
            ifwd =  ifwd + 1
            
        ENDIF

        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
ENDIF

; Check for bad data
bad_o_h_i   = where(o_h   LT 0, bad_o_h_count)
bad_mg_h_i  = where(mg_h  LT 0, bad_mg_h_count)
bad_fe_h_i  = where(fe_h  LT 0, bad_fe_h_count)
bad_fe_o_i  = where(fe_o  LT 0, bad_fe_o_count)
bad_mg_fe_i = where(mg_fe LT 0, bad_mg_fe_count)
bad_vsw_i   = where(vsw   LT 0, bad_vsw_count)
IF bad_o_h_count   GT 0 THEN o_h[bad_o_h_i] = !values.f_nan
IF bad_mg_h_count  GT 0 THEN mg_h [bad_mg_h_i] = !values.f_nan
IF bad_fe_h_count  GT 0 THEN fe_h [bad_fe_h_i] = !values.f_nan
IF bad_fe_o_count  GT 0 THEN fe_o [bad_fe_o_i] = !values.f_nan
IF bad_mg_fe_count GT 0 THEN mg_fe[bad_mg_fe_i] = !values.f_nan
IF bad_vsw_count   GT 0 THEN vsw  [bad_vsw_i] = !values.f_nan

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(times LT (time_double('1958-01-01')) OR $
                 times GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'soho_mtof_'

; with error included
store_data, varstr+'O_H', $
            data = {x:times, y:o_h}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'O/H'}
store_data, varstr+'Mg_H', $
            data = {x:times, y:mg_h}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Mg/H'}
store_data, varstr+'Fe_H', $
            data = {x:times, y:fe_h}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Fe/H'}
store_data, varstr+'Fe_O', $
            data = {x:times, y:fe_o}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Fe/O'}
store_data, varstr+'Mg_Fe', $
            data = {x:times, y:mg_fe}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Mg/Fe'}
store_data, varstr+'Vsw', $
            data = {x:times, y:vsw}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Vsw'}
store_data, varstr+'GSE_Pos', $
            data = {x:times, y:gse_pos}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'GSE Pos'}

END
