PRO get_beacon_mag, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'beacon_mag', filesfound
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch_MAG'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'MAGBField'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_mag, rec_count = epochinfo.maxrec+1, /zvariable
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                mag_x           = REFORM(cdf_mag[0, *])
                mag_y           = REFORM(cdf_mag[1, *])
                mag_z           = REFORM(cdf_mag[2, *])
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                mag_x           = [mag_x,           REFORM(cdf_mag[0, *]             )]
                mag_y           = [mag_y,           REFORM(cdf_mag[1, *]             )]
                mag_z           = [mag_z,           REFORM(cdf_mag[2, *]             )]
            ENDELSE
            
            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN

    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN

ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_beacon_mag_'
store_data, varstr+'x', $
            data = {x:converted_epoch, y:mag_x}
store_data, varstr+'y', $
            data = {x:converted_epoch, y:mag_y}
store_data, varstr+'z', $
            data = {x:converted_epoch, y:mag_z}

END
